/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.SnmpTimeticks;
import java.io.Serializable;
import java.util.Date;

public class Timestamp
implements Serializable {
    private long sysUpTime;
    private long crtime;
    private Date dateCache = null;
    private SnmpTimeticks uptimeCache = null;

    public Timestamp() {
        this.crtime = System.currentTimeMillis();
    }

    public Timestamp(long l2, long l3) {
        this.sysUpTime = l2;
        this.crtime = l3;
    }

    public Timestamp(long l2) {
        this.sysUpTime = l2;
        this.crtime = System.currentTimeMillis();
    }

    public final synchronized SnmpTimeticks getTimeTicks() {
        if (this.uptimeCache == null) {
            this.uptimeCache = new SnmpTimeticks((int)this.sysUpTime);
        }
        return this.uptimeCache;
    }

    public final long getSysUpTime() {
        return this.sysUpTime;
    }

    public final synchronized Date getDate() {
        if (this.dateCache == null) {
            this.dateCache = new Date(this.crtime);
        }
        return this.dateCache;
    }

    public final long getDateTime() {
        return this.crtime;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{SysUpTime = " + SnmpTimeticks.printTimeTicks(this.sysUpTime));
        stringBuffer.append("} {Timestamp = " + this.getDate().toString() + "}");
        return stringBuffer.toString();
    }
}

