/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jlex.internal;

import com.sun.jlex.internal.CUtility;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;

final class SparseBitSet
implements Cloneable {
    int[] offs;
    long[] bits;
    int size;
    private static final int LG_BITS = 6;
    private static final int BITS = 64;
    private static final int BITS_M1 = 63;
    private static final BinOp AND = new BinOp(){

        public final long op(long l2, long l3) {
            return l2 & l3;
        }
    };
    private static final BinOp OR = new BinOp(){

        public final long op(long l2, long l3) {
            return l2 | l3;
        }
    };
    private static final BinOp XOR = new BinOp(){

        public final long op(long l2, long l3) {
            return l2 ^ l3;
        }
    };

    public SparseBitSet() {
        this.bits = new long[4];
        this.offs = new int[4];
        this.size = 0;
    }

    public SparseBitSet(int n2) {
        this();
    }

    public SparseBitSet(SparseBitSet sparseBitSet) {
        this.bits = new long[sparseBitSet.size];
        this.offs = new int[sparseBitSet.size];
        this.size = 0;
    }

    private void new_block(int n2) {
        this.new_block(this.bsearch(n2), n2);
    }

    private void new_block(int n2, int n3) {
        if (this.size == this.bits.length) {
            long[] lArray = new long[this.size * 3];
            int[] nArray = new int[this.size * 3];
            System.arraycopy(this.bits, 0, lArray, 0, this.size);
            System.arraycopy(this.offs, 0, nArray, 0, this.size);
            this.bits = lArray;
            this.offs = nArray;
        }
        CUtility._assert(this.size < this.bits.length);
        this.insert_block(n2, n3);
    }

    private void insert_block(int n2, int n3) {
        CUtility._assert(n2 <= this.size);
        CUtility._assert(n2 == this.size || this.offs[n2] != n3);
        System.arraycopy(this.bits, n2, this.bits, n2 + 1, this.size - n2);
        System.arraycopy(this.offs, n2, this.offs, n2 + 1, this.size - n2);
        this.offs[n2] = n3;
        this.bits[n2] = 0L;
        ++this.size;
    }

    private int bsearch(int n2) {
        int n3 = 0;
        int n4 = this.size;
        while (n3 < n4) {
            int n5 = (n3 + n4) / 2;
            if (n2 < this.offs[n5]) {
                n4 = n5;
                continue;
            }
            if (n2 > this.offs[n5]) {
                n3 = n5 + 1;
                continue;
            }
            return n5;
        }
        CUtility._assert(n3 == n4);
        return n3;
    }

    public void set(int n2) {
        int n3 = n2 >> 6;
        int n4 = this.bsearch(n3);
        if (n4 >= this.size || this.offs[n4] != n3) {
            this.new_block(n4, n3);
        }
        int n5 = n4;
        this.bits[n5] = this.bits[n5] | 1L << (n2 & 0x3F);
    }

    public void clear(int n2) {
        int n3 = n2 >> 6;
        int n4 = this.bsearch(n3);
        if (n4 >= this.size || this.offs[n4] != n3) {
            this.new_block(n4, n3);
        }
        int n5 = n4;
        this.bits[n5] = this.bits[n5] & (1L << (n2 & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clearAll() {
        this.size = 0;
    }

    public boolean get(int n2) {
        int n3 = n2 >> 6;
        int n4 = this.bsearch(n3);
        if (n4 >= this.size || this.offs[n4] != n3) {
            return false;
        }
        return 0L != (this.bits[n4] & 1L << (n2 & 0x3F));
    }

    public void and(SparseBitSet sparseBitSet) {
        SparseBitSet.binop(this, sparseBitSet, AND);
    }

    public void or(SparseBitSet sparseBitSet) {
        SparseBitSet.binop(this, sparseBitSet, OR);
    }

    public void xor(SparseBitSet sparseBitSet) {
        SparseBitSet.binop(this, sparseBitSet, XOR);
    }

    private static final void binop(SparseBitSet sparseBitSet, SparseBitSet sparseBitSet2, BinOp binOp) {
        int n2;
        int n3;
        int[] nArray;
        long[] lArray;
        int n4 = sparseBitSet.size + sparseBitSet2.size;
        if (sparseBitSet.bits.length < n4) {
            lArray = new long[n4];
            nArray = new int[n4];
            n3 = 0;
            n2 = sparseBitSet.size;
        } else {
            lArray = sparseBitSet.bits;
            nArray = sparseBitSet.offs;
            n3 = sparseBitSet.bits.length - sparseBitSet.size;
            n2 = sparseBitSet.bits.length;
            System.arraycopy(sparseBitSet.bits, 0, sparseBitSet.bits, n3, sparseBitSet.size);
            System.arraycopy(sparseBitSet.offs, 0, sparseBitSet.offs, n3, sparseBitSet.size);
        }
        n4 = 0;
        int n5 = n3;
        int n6 = 0;
        while (n5 < n2 || n6 < sparseBitSet2.size) {
            int n7;
            long l2;
            if (n5 < n2 && (n6 >= sparseBitSet2.size || sparseBitSet.offs[n5] < sparseBitSet2.offs[n6])) {
                l2 = binOp.op(sparseBitSet.bits[n5], 0L);
                n7 = sparseBitSet.offs[n5];
                ++n5;
            } else if (n6 < sparseBitSet2.size && (n5 >= n2 || sparseBitSet.offs[n5] > sparseBitSet2.offs[n6])) {
                l2 = binOp.op(0L, sparseBitSet2.bits[n6]);
                n7 = sparseBitSet2.offs[n6];
                ++n6;
            } else {
                l2 = binOp.op(sparseBitSet.bits[n5], sparseBitSet2.bits[n6]);
                n7 = sparseBitSet.offs[n5];
                ++n5;
                ++n6;
            }
            if (l2 == 0L) continue;
            lArray[n4] = l2;
            nArray[n4] = n7;
            ++n4;
        }
        sparseBitSet.bits = lArray;
        sparseBitSet.offs = nArray;
        sparseBitSet.size = n4;
    }

    public int hashCode() {
        long l2 = 1234L;
        for (int i2 = 0; i2 < this.size; ++i2) {
            l2 ^= this.bits[i2] * (long)this.offs[i2];
        }
        return (int)(l2 >> 32 ^ l2);
    }

    public int size() {
        return this.size == 0 ? 0 : 1 + this.offs[this.size - 1] << 6;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof SparseBitSet) {
            return SparseBitSet.equals(this, (SparseBitSet)object);
        }
        return false;
    }

    public static boolean equals(SparseBitSet sparseBitSet, SparseBitSet sparseBitSet2) {
        int n2 = 0;
        int n3 = 0;
        while (n2 < sparseBitSet.size || n3 < sparseBitSet2.size) {
            if (!(n2 < sparseBitSet.size && (n3 >= sparseBitSet2.size || sparseBitSet.offs[n2] < sparseBitSet2.offs[n3]) ? sparseBitSet.bits[n2++] != 0L : (n3 < sparseBitSet2.size && (n2 >= sparseBitSet.size || sparseBitSet.offs[n2] > sparseBitSet2.offs[n3]) ? sparseBitSet2.bits[n3++] != 0L : sparseBitSet.bits[n2++] != sparseBitSet2.bits[n3++]))) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        try {
            SparseBitSet sparseBitSet = (SparseBitSet)super.clone();
            sparseBitSet.bits = (long[])this.bits.clone();
            sparseBitSet.offs = (int[])this.offs.clone();
            return sparseBitSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Enumeration elements() {
        return new Enumeration(){
            int idx = -1;
            int bit = 64;
            {
                this.advance();
            }

            public boolean hasMoreElements() {
                return this.idx < SparseBitSet.this.size;
            }

            public Object nextElement() {
                int n2 = this.bit + (SparseBitSet.this.offs[this.idx] << 6);
                this.advance();
                return new Integer(n2);
            }

            private void advance() {
                while (this.idx < SparseBitSet.this.size) {
                    while (++this.bit < 64) {
                        if (0L == (SparseBitSet.this.bits[this.idx] & 1L << this.bit)) continue;
                        return;
                    }
                    ++this.idx;
                    this.bit = -1;
                }
            }
        };
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            if (stringBuffer.length() > 1) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(enumeration.nextElement());
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    private boolean isValid() {
        if (this.bits.length != this.offs.length) {
            return false;
        }
        if (this.size > this.bits.length) {
            return false;
        }
        if (this.size != 0 && 0 <= this.offs[0]) {
            return false;
        }
        for (int i2 = 1; i2 < this.size; ++i2) {
            if (this.offs[i2] >= this.offs[i2 - 1]) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        int n2;
        int n3;
        SparseBitSet sparseBitSet = new SparseBitSet();
        CUtility._assert(!sparseBitSet.get(0) && !sparseBitSet.get(1));
        CUtility._assert(!sparseBitSet.get(123329));
        sparseBitSet.set(0);
        CUtility._assert(sparseBitSet.get(0) && !sparseBitSet.get(1));
        sparseBitSet.set(1);
        CUtility._assert(sparseBitSet.get(0) && sparseBitSet.get(1));
        sparseBitSet.clearAll();
        CUtility._assert(!sparseBitSet.get(0) && !sparseBitSet.get(1));
        Random random = new Random();
        Vector<Integer> vector = new Vector<Integer>();
        for (int i2 = 0; i2 < 500; ++i2) {
            n3 = (random.nextInt() >>> 1) % 65536 << 1;
            sparseBitSet.set(n3);
            vector.addElement(new Integer(n3));
            CUtility._assert(sparseBitSet.get(n3) && !sparseBitSet.get(n3 + 1) && !sparseBitSet.get(n3 - 1));
            for (n2 = 0; n2 < vector.size(); ++n2) {
                CUtility._assert(sparseBitSet.get((Integer)vector.elementAt(n2)));
            }
        }
        SparseBitSet sparseBitSet2 = (SparseBitSet)sparseBitSet.clone();
        CUtility._assert(sparseBitSet.equals(sparseBitSet2) && sparseBitSet2.equals(sparseBitSet));
        for (n3 = 0; n3 < 250; ++n3) {
            n2 = (random.nextInt() >>> 1) % vector.size();
            int n4 = (Integer)vector.elementAt(n2);
            sparseBitSet2.clear(n4);
            vector.removeElementAt(n2);
            CUtility._assert(!sparseBitSet2.get(n4));
        }
        CUtility._assert(!sparseBitSet.equals(sparseBitSet2));
        SparseBitSet sparseBitSet3 = (SparseBitSet)sparseBitSet.clone();
        SparseBitSet sparseBitSet4 = (SparseBitSet)sparseBitSet.clone();
        sparseBitSet3.and(sparseBitSet);
        CUtility._assert(sparseBitSet3.equals(sparseBitSet) && sparseBitSet.equals(sparseBitSet3));
        sparseBitSet3.xor(sparseBitSet);
        CUtility._assert(!sparseBitSet3.equals(sparseBitSet) && sparseBitSet3.size() == 0);
        sparseBitSet4.or(sparseBitSet2);
        CUtility._assert(sparseBitSet4.equals(sparseBitSet) && !sparseBitSet2.equals(sparseBitSet4));
        sparseBitSet4.and(sparseBitSet2);
        CUtility._assert(!sparseBitSet4.equals(sparseBitSet) && sparseBitSet2.equals(sparseBitSet4));
        sparseBitSet4.xor(sparseBitSet);
        CUtility._assert(!sparseBitSet4.equals(sparseBitSet) && !sparseBitSet2.equals(sparseBitSet4));
        sparseBitSet3.or(sparseBitSet4);
        sparseBitSet3.or(sparseBitSet2);
        CUtility._assert(sparseBitSet3.equals(sparseBitSet) && sparseBitSet.equals(sparseBitSet3));
        sparseBitSet3 = (SparseBitSet)sparseBitSet4.clone();
        sparseBitSet3.and(sparseBitSet2);
        CUtility._assert(sparseBitSet3.size() == 0);
        System.out.println("Success.");
    }

    private static interface BinOp {
        public long op(long var1, long var3);
    }
}

