/*  xfce
 *  Copyright (C) 2004 Olivier Fourdan (fourdan@xfce.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib.h>
#include <gdk/gdk.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "xinerama.h"

/**
 * xineramaInit:
 * @dpy : A pointer to a Display structure.
 *
 * Initialize xinerama support.
 *
 * Return value: TRUE if xinerama is supported, or %FALSE otherwise.
 * This functions does nothing in xfce 4.2
 *
 * @Deprecated: Use GdkScreen functions instead.
 *
 * Since: 4.0
 **/
gboolean
xineramaInit (Display * dpy)
{
    return TRUE;
}


/**
 * xineramaFree:
 *
 * Does nothing
 *
 * @Deprecated: Use GdkScreen functions instead.
 *
 * Since: 4.0
 **/
void
xineramaFree (void)
{
    /* void */;
}

/**
 * xineramaGetHeads:
 *
 * Returns the actual number of monitors.
 *
 * Return value: the actual number of monitors connected to the default screen.
 *
 * @Deprecated: Use GdkScreen functions instead.
 *
 * Since: 4.0
 **/
gint
xineramaGetHeads (void)
{
    GdkScreen *gscr = gdk_screen_get_default ();
    g_return_val_if_fail (gscr, 0);
    return (gdk_screen_get_n_monitors (gscr));
}

/**
 * MyDisplayFullHeight:
 * @dpy : A pointer to a Display structure.
 * @screen : the screen number.
 *
 * Returns the height of the default screen in pixels.
 *
 * Return value: the height of the default screen in pixels.
 *
 * @Deprecated: Use GdkScreen functions instead.
 *
 * Since: 4.0
 **/
gint
MyDisplayFullHeight (Display * dpy, int screen)
{
    GdkScreen *gscr = gdk_screen_get_default ();
    g_return_val_if_fail (gscr, 0);
    return (gdk_screen_get_height (gscr));
}

/**
 * MyDisplayFullWidth:
 * @dpy : A pointer to a Display structure.
 * @screen : the screen number.
 *
 * Returns the width of the default screen in pixels.
 *
 * Return value: the width of the default screen in pixels.
 *
 * @Deprecated: Use GdkScreen functions instead.
 *
 * Since: 4.0
 **/
gint
MyDisplayFullWidth (Display * dpy, int screen)
{
    GdkScreen *gscr = gdk_screen_get_default ();
    g_return_val_if_fail (gscr, 0);
    return (gdk_screen_get_width (gscr));
}


static gboolean
getGeometry (gint x, gint y, GdkRectangle *rect)
{
    GdkScreen *gscr = gdk_screen_get_default ();
    gint monitor_nbr;
    g_return_val_if_fail (gscr, FALSE);
    monitor_nbr = gdk_screen_get_monitor_at_point (gscr, x, y);
    gdk_screen_get_monitor_geometry (gscr, monitor_nbr, rect);
    return TRUE;
}

/**
 * MyDisplayHeight:
 * @dpy : A pointer to a Display structure.
 * @screen : the screen number.
 * @x: the x coordinate in the screen.
 * @y: the y coordinate in the screen.
 *
 * Returns the height of the monitor in pixels at point (x,y).
 *
 * Return value: the height of the monitor in pixels at point (x,y).
 *
 * @Deprecated: Use GdkScreen functions instead.
 *
 * Since: 4.0
 **/
gint
MyDisplayHeight (Display * dpy, int screen, gint x, gint y)
{
    GdkRectangle rect;
    gboolean success;
    success = getGeometry (x, y, &rect);
    g_return_val_if_fail (success, 0);
    return (rect.height);
}

/**
 * MyDisplayWidth:
 * @dpy : A pointer to a Display structure.
 * @screen : the screen number.
 * @x: the x coordinate in the screen.
 * @y: the y coordinate in the screen.
 *
 * Returns the width of the monitor in pixels at point (x,y).
 *
 * Return value: the width of the monitor in pixels at point (x,y).
 *
 * @Deprecated: Use GdkScreen functions instead.
 *
 * Since: 4.0
 **/
gint
MyDisplayWidth (Display * dpy, int screen, gint x, gint y)
{
    GdkRectangle rect;
    gboolean success;
    success = getGeometry (x, y, &rect);
    g_return_val_if_fail (success, 0);
    return (rect.width);
}

/**
 * MyDisplayX:
 * @x: the x coordinate in the screen.
 * @y: the y coordinate in the screen.
 *
 * Returns the x coordinate of the monitor at point (x,y).
 *
 * Return value: the x coordinate of the monitor at point (x,y).
 *
 * @Deprecated: Use GdkScreen functions instead.
 *
 * Since: 4.0
 **/
gint
MyDisplayX (gint x, gint y)
{
    GdkRectangle rect;
    gboolean success;
    success = getGeometry (x, y, &rect);
    g_return_val_if_fail (success, 0);
    return (rect.x);
}

/**
 * MyDisplayY:
 * @x: the x coordinate in the screen.
 * @y: the y coordinate in the screen.
 *
 * Returns the y coordinate of the monitor at point (x,y).
 *
 * Return value: the y coordinate of the monitor at point (x,y).
 *
 * @Deprecated: Use GdkScreen functions instead.
 *
 * Since: 4.0
 **/
gint
MyDisplayY (gint x, gint y)
{
    GdkRectangle rect;
    gboolean success;
    success = getGeometry (x, y, &rect);
    g_return_val_if_fail (success, 0);
    return (rect.y);
}

/**
 * MyDisplayMaxX:
 * @dpy : A pointer to a Display structure.
 * @screen : the screen number.
 * @x: the x coordinate in the screen.
 * @y: the y coordinate in the screen.
 *
 * Returns the maximum x value of the monitor in pixels at point (x,y).
 *
 * Return value: the maximum x value of the monitor in pixels at point (x,y).
 *
 * @Deprecated: Use GdkScreen functions instead.
 *
 * Since: 4.0
 **/
gint
MyDisplayMaxX (Display * dpy, int screen, gint x, gint y)
{
    GdkRectangle rect;
    gboolean success;
    success = getGeometry (x, y, &rect);
    g_return_val_if_fail (success, 0);
    return (rect.x + rect.width);
}

/**
 * MyDisplayMaxY:
 * @dpy : A pointer to a Display structure.
 * @screen : the screen number.
 * @x: the x coordinate in the screen.
 * @y: the y coordinate in the screen.
 *
 * Returns the maximum y value of the monitor in pixels at point (x,y).
 *
 * Return value: the maximum y value of the monitor in pixels at point (x,y).
 *
 * @Deprecated: Use GdkScreen functions instead.
 *
 * Since: 4.0
 **/
gint
MyDisplayMaxY (Display * dpy, int screen, gint x, gint y)
{
    GdkRectangle rect;
    gboolean success;
    success = getGeometry (x, y, &rect);
    g_return_val_if_fail (success, 0);
    return (rect.y + rect.height);
}

/**
 * isRightMostHead:
 * @dpy : A pointer to a Display structure.
 * @screen : the screen number.
 * @x: the x coordinate in the screen.
 * @y: the y coordinate in the screen.
 *
 * Tells if the monitor at (x,y) is the right most monitor.
 *
 * Return value: %TRUE if the screen at point (x,y) is the right most monitor,
 * %FALSE otherwise.
 *
 * @Deprecated: Use GdkScreen functions instead.
 *
 * Since: 4.0
 **/
gboolean
isRightMostHead (Display * dpy, int screen, gint x, gint y)
{
    return (MyDisplayMaxX (dpy, screen, x, y) 
            == MyDisplayFullWidth (dpy, screen));
}

/**
 * isLeftMostHead:
 * @dpy : A pointer to a Display structure.
 * @screen : the screen number.
 * @x: the x coordinate in the screen.
 * @y: the y coordinate in the screen.
 *
 * Tells if the monitor at (x,y) is the left most monitor.
 *
 * Return value: %TRUE if the screen at point (x,y) is the left most monitor,
 * %FALSE otherwise.
 *
 * @Deprecated: Use GdkScreen functions instead.
 *
 * Since: 4.0
 **/
gboolean
isLeftMostHead (Display * dpy, int screen, gint x, gint y)
{
    return (MyDisplayX (x, y) == 0);
}

/**
 * isTopMostHead:
 * @dpy : A pointer to a Display structure.
 * @screen : the screen number.
 * @x: the x coordinate in the screen.
 * @y: the y coordinate in the screen.
 *
 * Tells if the monitor at (x,y) is the top most monitor.
 *
 * Return value: %TRUE if the screen at point (x,y) is the top most monitor,
 * %FALSE otherwise.
 *
 * @Deprecated: Use GdkScreen functions instead.
 *
 * Since: 4.0
 **/
gboolean
isTopMostHead (Display * dpy, int screen, gint x, gint y)
{
    return (MyDisplayY (x, y) == 0);
}

/**
 * isBottomMostHead:
 * @dpy : A pointer to a Display structure.
 * @screen : the screen number.
 * @x: the x coordinate in the screen.
 * @y: the y coordinate in the screen.
 *
 * Tells if the monitor at (x,y) is the bottom most monitor.
 *
 * Return value: %TRUE if the screen at point (x,y) is the bottom most monitor,
 * %FALSE otherwise.
 *
 * @Deprecated: Use GdkScreen functions instead.
 *
 * Since: 4.0
 **/
gboolean
isBottomMostHead (Display * dpy, int screen, gint x, gint y)
{
    return (MyDisplayMaxY (dpy, screen, x, y) 
            == MyDisplayFullHeight (dpy, screen));
}
