
  

#include <qcstring.h>
#include <qimage.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <qcanvas.h>
#include "qcanvaspolygonalitem_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

QCanvasPolygonalItemImp::QCanvasPolygonalItemImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

QCanvasPolygonalItemImp::~QCanvasPolygonalItemImp()
{
}

/**
 * Adds bindings for static methods and enum constants to the specified Object.
 */
void QCanvasPolygonalItemImp::addStaticBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

	{ 0, 0 }
    };

    int idx = 0;
    QCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QCanvasPolygonalItemImp *meth = new QCanvasPolygonalItemImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


}

/**
 * Adds bindings for instance methods to the specified Object.
 */
void QCanvasPolygonalItemImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

        { Method_collidesWith_3, "collidesWith" },
        { Method_setPen_4, "setPen" },
        { Method_setBrush_5, "setBrush" },
        { Method_pen_6, "pen" },
        { Method_brush_7, "brush" },
        { Method_areaPoints_8, "areaPoints" },
        { Method_areaPointsAdvanced_9, "areaPointsAdvanced" },
        { Method_boundingRect_10, "boundingRect" },
        { Method_rtti_11, "rtti" },
	{ 0, 0 }
    };

    int idx = 0;
    QCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QCanvasPolygonalItemImp *meth = new QCanvasPolygonalItemImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }
}

/**
 * Extract a QCanvasPolygonalItem pointer from an Object.
 */
QCanvasPolygonalItem *QCanvasPolygonalItemImp::toQCanvasPolygonalItem( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        QObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<QCanvasPolygonalItem *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;

    if ( op->typeName() != "QCanvasPolygonalItem" )
        return 0;

    return (QCanvasPolygonalItem *)( op->toVoidStar() );
}

/**
 * Select and invoke the correct constructor.
 */
KJS::Object QCanvasPolygonalItemImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         case Constructor_QCanvasPolygonalItem_1:
             return QCanvasPolygonalItem_1( exec, args );
             break;
    
         default:
             break;
    }

    QString msg = i18n("QCanvasPolygonalItemCons has no constructor with id '%1'.").arg(id);
    KJS::Object err = KJS::Error::create( exec, KJS::ReferenceError, msg.utf8() );
    exec->setException( err );
    return err;
}


KJS::Object QCanvasPolygonalItemImp::QCanvasPolygonalItem_1( KJS::ExecState *exec, const KJS::List &args )
{
    
#if 0 // This constructor has been disabled by the XSL template
    
    // Unsupported parameter QCanvas *
    return KJS::Object();
    
    QCanvas * arg0; // Dummy
        

    // We should now create an instance of the QCanvasPolygonalItem object

    QCanvasPolygonalItem *ret = new QCanvasPolygonalItem(
       
          arg0 );

    
#endif // This constructor has been disabled by the XSL template
    
}
    
KJS::Value QCanvasPolygonalItemImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = QCanvasPolygonalItemImp::toQCanvasPolygonalItem( self );

    switch( id ) {

    case Method_collidesWith_3:
        return collidesWith_3( exec, self, args );
        break;
    
    case Method_setPen_4:
        return setPen_4( exec, self, args );
        break;
    
    case Method_setBrush_5:
        return setBrush_5( exec, self, args );
        break;
    
    case Method_pen_6:
        return pen_6( exec, self, args );
        break;
    
    case Method_brush_7:
        return brush_7( exec, self, args );
        break;
    
    case Method_areaPoints_8:
        return areaPoints_8( exec, self, args );
        break;
    
    case Method_areaPointsAdvanced_9:
        return areaPointsAdvanced_9( exec, self, args );
        break;
    
    case Method_boundingRect_10:
        return boundingRect_10( exec, self, args );
        break;
    
    case Method_rtti_11:
        return rtti_11( exec, self, args );
        break;
    
    default:
        break;
    }

    QString msg = i18n( "QCanvasPolygonalItemImp has no method with id '%1'." ).arg( id );
    KJS::Object err = KJS::Error::create( exec, KJS::ReferenceError, msg.utf8() );
    exec->setException( err );
    return err;
}


KJS::Value QCanvasPolygonalItemImp::collidesWith_3( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    // Unsupported parameter const QCanvasItem *
    return KJS::Value();
    
    const QCanvasItem * arg0; // Dummy
        
      bool ret;
      ret = instance->collidesWith( 
       arg0 );
      return KJS::Boolean( ret );
      
}
    
KJS::Value QCanvasPolygonalItemImp::setPen_4( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    // Unsupported parameter QPen
    return KJS::Value();
    
    QPen arg0; // Dummy
        
      instance->setPen( 
       arg0 );
      return KJS::Value(); // Returns void
      
}
    
KJS::Value QCanvasPolygonalItemImp::setBrush_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    // Unsupported parameter QBrush
    return KJS::Value();
    
    QBrush arg0; // Dummy
        
      instance->setBrush( 
       arg0 );
      return KJS::Value(); // Returns void
      
}
    
KJS::Value QCanvasPolygonalItemImp::pen_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    QPen ret;
      ret = instance->pen(  );

       return convertToValue( exec, ret );
      
}
    
KJS::Value QCanvasPolygonalItemImp::brush_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    QBrush ret;
      ret = instance->brush(  );

       return convertToValue( exec, ret );
      
}
    
KJS::Value QCanvasPolygonalItemImp::areaPoints_8( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      instance->areaPoints(  );
      return KJS::Value(); // Returns 'QPointArray'
      
}
    
KJS::Value QCanvasPolygonalItemImp::areaPointsAdvanced_9( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      instance->areaPointsAdvanced(  );
      return KJS::Value(); // Returns 'QPointArray'
      
}
    
KJS::Value QCanvasPolygonalItemImp::boundingRect_10( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    QRect ret;
      ret = instance->boundingRect(  );

       return convertToValue( exec, ret );
      
}
    
KJS::Value QCanvasPolygonalItemImp::rtti_11( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      int ret;
      ret = instance->rtti(  );
      return KJS::Number( ret );
      
}
    

} // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:


