config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

config etc/rc.d/rc.modules.new

# A good idea whenever kernel modules are added or changed:
if [ -x sbin/depmod ]; then
  chroot . /sbin/depmod -a 1> /dev/null 2> /dev/null
fi

( cd lib/modules/2.4.29 ; rm -rf build )
( cd lib/modules/2.4.29 ; ln -sf /usr/src/linux-2.4.29 build )
( cd lib/modules/2.4.29/pcmcia ; rm -rf nsp_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/scsi/pcmcia/nsp_cs.o.gz nsp_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf 3c589_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/net/pcmcia/3c589_cs.o.gz 3c589_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf ds.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/pcmcia/ds.o.gz ds.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf pcmcia_core.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/pcmcia/pcmcia_core.o.gz pcmcia_core.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf com20020_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/net/pcmcia/com20020_cs.o.gz com20020_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf ray_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/net/pcmcia/ray_cs.o.gz ray_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf netwave_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/net/pcmcia/netwave_cs.o.gz netwave_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf synclink_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/char/pcmcia/synclink_cs.o.gz synclink_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf yenta_socket.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/pcmcia/yenta_socket.o.gz yenta_socket.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf i82092.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/pcmcia/i82092.o.gz i82092.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf fdomain_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/scsi/pcmcia/fdomain_cs.o.gz fdomain_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf nmclan_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/net/pcmcia/nmclan_cs.o.gz nmclan_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf wavelan_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/net/pcmcia/wavelan_cs.o.gz wavelan_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf aironet4500_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/net/pcmcia/aironet4500_cs.o.gz aironet4500_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf qlogic_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/scsi/pcmcia/qlogic_cs.o.gz qlogic_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf pcnet_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/net/pcmcia/pcnet_cs.o.gz pcnet_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf fmvj18x_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/net/pcmcia/fmvj18x_cs.o.gz fmvj18x_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf aha152x_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/scsi/pcmcia/aha152x_cs.o.gz aha152x_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf xirc2ps_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/net/pcmcia/xirc2ps_cs.o.gz xirc2ps_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf serial_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/char/pcmcia/serial_cs.o.gz serial_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf i82365.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/pcmcia/i82365.o.gz i82365.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf smc91c92_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/net/pcmcia/smc91c92_cs.o.gz smc91c92_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf xircom_cb.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/net/pcmcia/xircom_cb.o.gz xircom_cb.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf 3c574_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/net/pcmcia/3c574_cs.o.gz 3c574_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf ibmtr_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/net/pcmcia/ibmtr_cs.o.gz ibmtr_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf tcic.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/pcmcia/tcic.o.gz tcic.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf axnet_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/net/pcmcia/axnet_cs.o.gz axnet_cs.o.gz )
( cd lib/modules/2.4.29/pcmcia ; rm -rf xircom_tulip_cb.o.gz )
( cd lib/modules/2.4.29/pcmcia ; ln -sf ../kernel/drivers/net/pcmcia/xircom_tulip_cb.o.gz xircom_tulip_cb.o.gz )
