// systray.h
//
// Copyright (C) 2000 Neil Stevens <multivac@fcmail.com>
// Copyright (C) 1999 Charles Samuels <charles@kde.org>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#ifndef SYSTRAY_H
#define SYSTRAY_H

#include <noatun/plugin.h>
#include <noatun/app.h>
#include <kmainwindow.h>

#include <qtimer.h>

class KAction;
class KPopupMenu;
class KToggleAction;
class KitSystemTray;
class Player;
class QTimer;

class KPassivePopup;

class NoatunSystray : public KMainWindow, public Plugin
{
Q_OBJECT
public:
	enum Blink { BlinkIcon = 0, ShowIcon = 1, Neither = 2 };
	NoatunSystray();
	virtual ~NoatunSystray();
	void load(const QString& url);
	virtual void init();

	void setBlink(Blink);
	void setTip(bool);
	void setPassivePopup(bool pop);
	void setShowCovers(bool);

	static NoatunSystray *jasonkb;

protected:
	virtual void closeEvent(QCloseEvent *);

public slots:
	void slotPlaying();
	void slotStopped();
	void slotPaused();

private slots:
	void changeTray(const QString &);

	void slotBlinkTimer();
	void showPassivePopup();
	QPixmap *renderIcon(const QString &, const QString &) const;

private:
	QTimer *mBlinkTimer;
	QPixmap *trayStatus, *trayBase;
	bool showingTrayStatus;
	Blink blink;
	KitSystemTray *mTray;

	void setTipText(const QString&);
	bool tip;
	QString tipText;

	void updateCover();
	void removeCover();
	QString tmpCoverPath;
	bool mShowCovers;

	KAction *mBack, *mStop, *mPlay, *mForward;
	KToggleAction *mPlaylist;
	KPopupMenu *menu;
	KXMLGUIFactory *factory;
	KPassivePopup *mPassivePopup;
};

#endif
