/* genmap.c - text to hex translation program for speakupmap.map.
 * This program converts speakupmap.map with text strings for speakup
 * functions such as SAY_CURR_WORD to hex strings loadable by
 * loadkeys.
 * 
 * author: David Borowski <davidb@opentext.com>

    Copyright (C) 2002 David Borowski.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Kirk Reiser <kirk@braille.uwo.ca>
    261 Trott dr. London, Ontario, Canada. N6G 1B6 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#define MAXKEYS 128
char *key_names[MAXKEYS];
char key_vals[MAXKEYS][4];
int numkeys = 0, kt_spkup = 0,kt_dead = 0, i;
char buffer[256];
FILE *infile;
char include_dir[] = "../../../include/linux";
char delims[] = "\t\n ";
char *def_name, *def_val, *cp;

void open_input( char *dir, char *name ) {
	char filename[256];
	sprintf(filename,"%s/%s",dir,name);
	if ((infile = fopen( filename, "r" )) == 0) {
		fprintf(stderr,"can't open %s\n",filename);
		exit(1);
	}
}

int get_define( ) {
	while (fgets(buffer,250,infile)) {
		if (strncmp(buffer,"#define",7)) continue;
		strtok(buffer,delims);
		def_name = strtok(0,delims);
		def_val = strtok(0,delims);
		if (def_val != NULL ) return 1;
	}
	fclose(infile);
	infile = 0;
	return 0;
}

main( int argc, char *argv[] ) {
	bzero(key_names,sizeof(key_names));
	if ( argc < 2 ) {
		fputs( "usage: genmap filename\n",stderr);
		exit(1);
	}
	open_input( include_dir,"keyboard.h" );
	while (get_define() ) {
		if (!strcmp(def_name,"KT_DEAD")) {
			kt_dead = atoi(def_val);
		} else if (!strcmp(def_name,"KT_SPKUP")) {
			kt_spkup = atoi(def_val);
		}
	}
	if ( kt_dead == 0 ) {
		fputs("KT_DEAD not found in keyboard.h\n",stderr);
		exit(1);
	}
	if ( kt_spkup == 0 ) {
		fputs("KT_SPKUP not found in keyboard.h\n",stderr);
		exit(1);
	}
	open_input( include_dir,"speakup.h" );
	while (get_define() ) {
		if (strlen(def_val) > 5 || strncmp(def_val,"0x",2)) continue;
		key_names[numkeys] = strdup(def_name);
		strcpy( key_vals[numkeys++],def_val+2 );
		if ( numkeys >= MAXKEYS) {
			fprintf(stderr,"enlarge MAXKEYS define in genmap.c."
				"currently %d\n",MAXKEYS);
			exit(2);
		}
	}
	open_input(".",argv[1]);
	while (fgets(buffer,250,infile)) {
		cp = strchr(buffer,'=');
		if ( *buffer == '#' || !cp ) {
			fputs(buffer,stdout);
			continue;
		}
		cp++;
		*cp++ = '\0';
		fputs(buffer,stdout);
		cp = strtok(cp,delims);
		while ( cp ) {
			for ( i = 0; i < numkeys; i++ )
				if ( !strcmp(cp,key_names[i])) break;
			if ( i < numkeys) printf(" 0x%02x%s",kt_spkup,key_vals[i]);
			else printf(" %s", cp);
			cp = strtok(0,delims);
		}
		putc('\n',stdout);
	}
	fclose(infile);
}
