/*
 *  Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <glib/gi18n.h>
#include "gul-glade.h"
#include "bookmarks-single-editor-small.h"
#include "gul-gobject-misc.h"
#include "gul-string.h"
#include "eel-gconf-extensions.h"
#include "prefs-strings.h"
#include <gtk/gtkspinbutton.h>
#include <gtk/gtkbutton.h>
#include <libgnomeui/gnome-pixmap-entry.h>

/**
 * Private data
 */
struct _GbSingleEditorSmallPrivate {
	GtkWidget *pane;
};

/**
 * Private functions, only availble from this file
 */
static void		gb_single_editor_small_class_init		(GbSingleEditorSmallClass *klass);
static void		gb_single_editor_small_init			(GbSingleEditorSmall *e);
static void		gb_single_editor_small_init_widgets_impl	(GbSingleEditor *e);
static void		gb_single_editor_small_finalize_impl		(GObject *o);
static void		gb_single_editor_small_more_properties_clicked_cb (GtkButton *b, GbSingleEditorSmall *e);


static gpointer gb_single_editor_class;

/**
 * SingleEditorSmall object
 */

MAKE_GET_TYPE (gb_single_editor_small, "GbSingleEditorSmall", GbSingleEditorSmall, gb_single_editor_small_class_init, 
	       gb_single_editor_small_init, GB_TYPE_SINGLE_EDITOR);

static void
gb_single_editor_small_class_init (GbSingleEditorSmallClass *klass)
{
	G_OBJECT_CLASS (klass)->finalize = gb_single_editor_small_finalize_impl;
	GB_SINGLE_EDITOR_CLASS (klass)->init_widgets = gb_single_editor_small_init_widgets_impl;

	gb_single_editor_class = g_type_class_peek_parent (klass);
}

static void 
gb_single_editor_small_init (GbSingleEditorSmall *e)
{
	GbSingleEditorSmallPrivate *p = g_new0 (GbSingleEditorSmallPrivate, 1);
	e->priv = p;
	
	gb_single_editor_set_disable_policy (GB_SINGLE_EDITOR (e), GB_SINGLE_EDITOR_DISABLE_POLICY_DISABLE);
}

static void
gb_single_editor_small_finalize_impl (GObject *o)
{
	GbSingleEditorSmall *e = GB_SINGLE_EDITOR_SMALL (o);
	GbSingleEditorSmallPrivate *p = e->priv;

	g_free (p);
	
	G_OBJECT_CLASS (gb_single_editor_class)->finalize (o);
}

static void
gb_single_editor_small_init_widgets_impl (GbSingleEditor *e)
{
	GbSingleEditorSmallPrivate *p = GB_SINGLE_EDITOR_SMALL (e)->priv;
	WidgetLookup lookups[] = {
		{ "bookmarks_properties_pane", &p->pane },
		{ "bookmarks_properties_more_properties", &e->more_properties_button },
		{ "bookmarks_properties_name_label", &e->name_label },
		{ "bookmarks_properties_name_entry", &e->name_entry },
		{ "bookmarks_properties_smarturl_label", &e->smarturl_label },
		{ "bookmarks_properties_smarturl_entry", &e->smarturl_entry },
		{ "bookmarks_properties_location_label", &e->location_label },
		{ "bookmarks_properties_location_entry", &e->location_entry },
		{ "bookmarks_properties_notes_label", &e->notes_label },
		{ "bookmarks_properties_notes_textview", &e->notes_textview },
		{ "bookmarks_properties_nicks_label", &e->nicks_label },
		{ "bookmarks_properties_nicks_entry", &e->nicks_entry },
		{ NULL, NULL }
	};
	GladeXML *gxml = gul_glade_widget_new ("bookmarks-editor-small.glade", "bookmarks_properties_pane",
					       NULL, e);
	gul_glade_lookup_widgets (gxml, lookups);
	g_object_unref (gxml);

	g_signal_connect (e->more_properties_button, "clicked",
			  G_CALLBACK (gb_single_editor_small_more_properties_clicked_cb), e);
}

GbSingleEditorSmall *
gb_single_editor_small_new (void)
{
	GbSingleEditorSmall *ret = g_object_new (GB_TYPE_SINGLE_EDITOR_SMALL, NULL);
	return ret;
}

GtkWidget *
gb_single_editor_small_get_widget (GbSingleEditorSmall *e)
{
	gb_single_editor_init_widgets_and_signals (GB_SINGLE_EDITOR (e));
	return e->priv->pane;
}

static void
gb_single_editor_small_more_properties_clicked_cb (GtkButton *b, GbSingleEditorSmall *e)
{
	GbBookmark *bm = gb_single_editor_get_bookmark (GB_SINGLE_EDITOR (e));
	if (bm)
	{
		GbSingleEditor *se = gb_single_editor_new ();
		gb_single_editor_set_bookmark (se, bm);
		gb_single_editor_show (se);
	}
}
