/*
 * Tlf - contest logging program for amateur radio operators
 * Copyright (C) 2001-2002-2003 Rein Couperus <pa0rct@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

   	/* ------------------------------------------------------------
 	*      add call area to list for one band
 	*
 	*--------------------------------------------------------------*/

#include "addmult.h"

int multcount =0;

int addmult( void)
{
extern char mults[MAX_MULTS][12];
extern char mults_possible[MAX_MULTS][12];
extern int max_multipliers;
extern int mult_bands[MAX_MULTS];
extern int multscore[5];
extern int multarray_nr;
extern int wysiwygmults;
extern int wysiwyg_once;
extern int wysiwyg_multi;
extern char comment[];
extern int bandinx;
extern int shownewmult;
extern int arrlss;
extern char ssexchange[];
extern int serial_section_mult;
extern int sectn_mult;
extern int dx_arrlsections;
extern int countrynr;
extern int w_cty;
extern int ve_cty;

int n, found = 0;
int i, j, addarea = 0, ismult, multlen = 0;
int inxes[9] = {32,16,8,0,4,0,2,0,1} ;




if (arrlss ==1){   // mult for all bands   --------------------- arrlss ----------------

	ismult = 0;
	found = 0;

	for ( i =0 ; i < max_multipliers-1; i++) {

			if ((strstr(ssexchange, mults_possible[i]) != NULL) && (strlen(mults_possible[i]) > 1) && mults_possible[i][0] != ' ') {

				ismult = 1;

				multlen = strlen(mults_possible[i]);
				break;
			} else if (mults_possible[i][0] == '\0') {
				ismult = 0;
				break;
			} else ismult = 0;
	}
	if (ismult != 0) {
		  	for (j = 0; j <= multcount; j++) {
					if (strncmp(mults[j] , strstr(ssexchange, mults_possible[i]) , multlen) == 0)  {
						found = 1;
						break;
					}
			}

			if (found == 0) {
				multcount++;
				strncpy(mults[multcount], strstr(ssexchange, mults_possible[i]) , multlen) ;
			}

	}

}

// -------------------------------serial + section ----------------------------

if ((serial_section_mult == 1) || (sectn_mult == 1)){
			
	char *ptr;		// local pointer

	ismult = 0;
	found = 0;

	for ( i =0 ; i < max_multipliers; i++) {      // check if valid mult....

			ptr = strstr(ssexchange, mults_possible[i]);

			if (ptr != NULL) {

				ismult = 1;

				multlen = strlen(mults_possible[i]);

				if (strlen(mults_possible[i]) == strlen(ptr)) break;

			} else if (mults_possible[i][0] == '\0') {
				ismult = 0;
				break;
			} else ismult = 0;
	}

	if (ismult != 0) {

 	 	found = 0;

		for (n = 0; n < multarray_nr; n++){     // did we work it somewhere?

      			if ((strcmp(mults[n], mults_possible[i]) == 0) && (strlen(mults_possible[i]) == strlen(mults[n]))) {
      				found = 1;
      	 			break;
       	 		}
      		}

		if (found == 0) {

				// no, store it.
       			strcpy(mults[multarray_nr], mults_possible[i]);
       			mult_bands[multarray_nr] = mult_bands[multarray_nr] | inxes[bandinx];
        			multarray_nr++;
        			 addarea= 1;
        			shownewmult = multarray_nr-1;

      		} else if ((found == 1) && ((mult_bands[n] & inxes[bandinx]) == 0)) {       // yes, mark it...
       			mult_bands[n] = mult_bands[n] | inxes[bandinx];
        			addarea=1;
        			shownewmult = n;

      		} else  {
      			 addarea= 0;                                                                           // don't count it, worked already on this band...

		}

	}

}

// ------------------------------- section ----------------------------

if ((dx_arrlsections == 1) && ((countrynr == w_cty)||(countrynr == ve_cty))){

	char *ptr;		// local pointer

	ismult = 0;
	found = 0;


	for ( i =0 ; i < max_multipliers; i++) {      // check if valid mult....

			ptr = strstr(ssexchange, mults_possible[i]);

			if (ptr != NULL) {

				ismult = 1;

				multlen = strlen(mults_possible[i]);

				if (strlen(mults_possible[i]) == strlen(ptr)) break;

			} else if (mults_possible[i][0] == '\0') {
				ismult = 0;
				break;
			} else ismult = 0;
	}

	if (ismult != 0) {

 	 	found = 0;

		for (n = 0; n < multarray_nr; n++){     // did we work it somewhere?

      			if ((strcmp(mults[n], mults_possible[i]) == 0) && (strlen(mults_possible[i]) == strlen(mults[n]))) {
      				found = 1;
      	 			break;
       	 		}
      		}

		if (found == 0) {

				// no, store it.
       			strcpy(mults[multarray_nr], mults_possible[i]);
       			mult_bands[multarray_nr] = mult_bands[multarray_nr] | inxes[bandinx];
        			multarray_nr++;
        			 addarea= 1;
        			shownewmult = multarray_nr-1;

      		} else if ((found == 1) && ((mult_bands[n] & inxes[bandinx]) == 0)) {       // yes, mark it...
       			mult_bands[n] = mult_bands[n] | inxes[bandinx];
        			addarea=1;
        			shownewmult = n;

      		} else  {
      			 addarea= 0;                                                                           // don't count it, worked already on this band...

		}

	}

}


if (wysiwyg_once == 1) {               // -----------------------------wysiwyg----------------

     for (n = 0; n <= multarray_nr; n++){
      	if (strcmp(mults[n], comment) == 0) {
      		found = 1;
      	 	break;
        }
      }
         if (found == 0){

         	strcpy(mults[multarray_nr], comment);
         	multarray_nr++;
         	wysiwygmults++;
         	 addarea= 1;
         	shownewmult = n;
         }else {
          	shownewmult = 0;
          	 addarea= 0;
         }

}
if (wysiwyg_multi == 1 && strlen(comment) > 0) {
 	
 	 found = 0;

	for (n = 0; n <= multarray_nr; n++){
      		if ((strcmp(mults[n], comment) == 0) && (strlen(comment) > 0)) {
      			found = 1;
      	 		break;
       	 	}
      	}

	if (found == 0) {
       		strcpy(mults[multarray_nr], comment);
       		mult_bands[multarray_nr] = mult_bands[multarray_nr] | inxes[bandinx];
        		multarray_nr++;
        		 addarea= 1;
        		shownewmult = multarray_nr-1;
      	} else if ((found == 1) && ((mult_bands[n] & inxes[bandinx]) == 0)) {
       		mult_bands[n] = mult_bands[n] | inxes[bandinx];
        		addarea=1;
        		shownewmult = n;

      	} else  {
      		 addarea= 0;

	}
}


if ( addarea == 1) {
	
	 addarea= 0;
	
            switch ( bandinx) {

            	case BANDINDEX_160:{
            		multscore[0]++;
            		break;
            	}
            	case BANDINDEX_80:{
            		multscore[1]++;
            		break;
            	}
            	case BANDINDEX_40:{
            		multscore[2]++;
            		break;
            	}
            	case BANDINDEX_20:{
            		multscore[3]++;
            		break;
            	}
            	case BANDINDEX_15:{
            		multscore[4]++;
            		break;
            	}
            	case BANDINDEX_10:{
            		multscore[5]++;
            		break;
            	}

            }
}

 	   return(found);
}

/* -------------------------------------------------------------------*/

int addmult2( void)
{
extern char mults[MAX_MULTS][12];
extern char mults_possible[MAX_MULTS][12];
extern int max_multipliers;
extern int mult_bands[MAX_MULTS];
extern int multscore[5];
extern int multarray_nr;
extern int wysiwygmults;
extern int wysiwyg_once;
extern int wysiwyg_multi;
extern char comment[];
extern int bandinx;
extern int shownewmult;
extern int arrlss;
extern char  lan_logline[];

int n,  addarea = 0, found = 0;
int i, j, ismult, multlen = 0;
int inxes[9] = {32,16,8,0,4,0,2,0,1} ;
char ssexchange[21];

if (arrlss ==1){                     // mult for all bands

	ismult = 0;
	found = 0;

	strncpy (ssexchange, lan_logline + 54, 20);

	for ( i =0 ; i < max_multipliers-1; i++) {

			if ((strstr(ssexchange, mults_possible[i]) != NULL) && (strlen(mults_possible[i]) > 1) && mults_possible[i][0] != ' ') {

				ismult = 1;

				multlen = strlen(mults_possible[i]);
				break;
			} else if (mults_possible[i][0] == '\0') {
				ismult = 0;
				break;
			} else ismult = 0;
	}
	if (ismult != 0) {
		  	for (j = 0; j <= multcount; j++) {
					if (strncmp(mults[j] , strstr(ssexchange, mults_possible[i]) , multlen) == 0)  {
						found = 1;
						break;
					}
			}

			if (found == 0) {
				multcount++;
				strncpy(mults[multcount], strstr(ssexchange, mults_possible[i]) , multlen) ;
				if (strlen(mults[multcount]) == 2) strcat (mults[multcount], " ");
			}

	}

}

if (wysiwyg_once == 1) {

     for (n = 0; n <= multarray_nr; n++){
      	if (strcmp(mults[n], comment) == 0) {
      		found = 1;
      	 	break;
        }
      }
         if (found == 0){

         	strcpy(mults[multarray_nr], comment);
         	multarray_nr++;
         	wysiwygmults++;
         	 addarea= 1;
         	shownewmult = n;
         }else {
          	shownewmult = 0;
          	 addarea= 0;
         }

}
if (wysiwyg_multi == 1) {

 	 found = 0;

	 for (n = 0; n <= multarray_nr; n++){
      	if ((strcmp(mults[n], comment) == 0) && (strlen(comment) >= 1)) {
      		found = 1;
      	 	break;
        }
      }
      if (found == 0) {
       		strcpy(mults[multarray_nr], comment);
       		mult_bands[multarray_nr] = mult_bands[multarray_nr] | inxes[bandinx];
        	multarray_nr++;
        	 addarea= 1;
        	shownewmult = multarray_nr-1;
      } else if ((found == 1) && ((mult_bands[n] & inxes[bandinx]) == 0)) {
       		mult_bands[n] = mult_bands[n] | inxes[bandinx];
        	addarea=1;
        	shownewmult = n;

      } else  {
      		 addarea= 0;

		}
}


if ( addarea== 1) {

	 addarea= 0;

            switch ( bandinx) {

            	case BANDINDEX_160:{
            		multscore[0]++;
            		break;
            	}
            	case BANDINDEX_80:{
            		multscore[1]++;
            		break;
            	}
            	case BANDINDEX_40:{
            		multscore[2]++;
            		break;
            	}
            	case BANDINDEX_20:{
            		multscore[3]++;
            		break;
            	}
            	case BANDINDEX_15:{
            		multscore[4]++;
            		break;
            	}
            	case BANDINDEX_10:{
            		multscore[5]++;
            		break;
            	}

            }
}

 	   return(found);
}
