/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.api.FileOptions;
import com.install4j.api.UserCanceledException;
import com.install4j.api.windows.WinAssociations;
import com.install4j.runtime.installer.Installer;
import com.install4j.runtime.installer.InstallerUtil;
import com.install4j.runtime.installer.config.AssociationConfig;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.MenuEntryConfig;
import com.install4j.runtime.installer.config.ServiceConfig;
import com.install4j.runtime.installer.fileinst.FileInstaller;
import com.install4j.runtime.installer.frontend.InstallerFrontend;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.installer.platform.win32.InstallRegistry;
import com.install4j.runtime.installer.platform.win32.Registry;
import com.install4j.runtime.installer.platform.win32.ShellLink;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class Win32SpecificInstaller {
    private static final String QUICK_LAUCH_DIR = "Microsoft\\Internet Explorer\\Quick Launch";
    private static final String UNINSTALL_KEY = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\";
    private static final String DISPLAY_NAME_VALUE_NAME = "DisplayName";
    private static final String UNINSTALL_STRING_VALUE_NAME = "UninstallString";
    private static final String PUBLISHER_VALUE_NAME = "Publisher";
    private static final String URL_INFO_ABOUT_VALUE_NAME = "URLInfoAbout";
    private static final String ASSOC_FILENAME = "associations.prop";

    public static void doUninstallation(File file) throws IOException {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        String string = UNINSTALL_KEY + installerConfig.getApplicationNameWithVersion();
        Registry.deleteKey(3, string, false);
        Win32SpecificInstaller.removeFileAssociations(file);
        InstallRegistry.unregisterApplication(InstallerConfig.getCurrentInstance().getApplicationId());
    }

    private static void removeFileAssociations(File file) throws IOException {
        Properties properties = new Properties();
        File file2 = new File(file, ".install4j");
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(file2, ASSOC_FILENAME)));
        properties.load(bufferedInputStream);
        ((InputStream)bufferedInputStream).close();
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string = (String)entry.getKey();
            if (!string.startsWith(".")) {
                string = "." + string;
            }
            File file3 = new File((String)entry.getValue()).getCanonicalFile();
            String string2 = WinAssociations.getExecutable(string);
            if (string2 == null || !new File(string2).getCanonicalFile().equals(file3)) continue;
            WinAssociations.remove(string);
        }
    }

    public static void doInstallation(File file, Installer installer) throws IOException, UserCanceledException {
        Win32SpecificInstaller.createMenu(file, installer);
        Win32SpecificInstaller.createAdditionalIcons(file, installer);
        Win32SpecificInstaller.createFileAssociations(file);
        if (InstallerConfig.getCurrentInstance().getInstallerType() == 1) {
            Win32SpecificInstaller.createUninstallLink(file);
        }
    }

    private static void createFileAssociations(File file) throws IOException {
        Object object;
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        File file2 = new File(file, ".install4j");
        Properties properties = new Properties();
        File file3 = new File(file2, ASSOC_FILENAME);
        if (file3.exists()) {
            object = new BufferedInputStream(new FileInputStream(new File(file2, ASSOC_FILENAME)));
            properties.load((InputStream)object);
            ((InputStream)object).close();
        }
        object = installerConfig.getAssociations().iterator();
        while (object.hasNext()) {
            String string;
            AssociationConfig associationConfig = (AssociationConfig)object.next();
            if (!associationConfig.isSelected() || !ComponentConfig.isIncludedInSelectedComponents(associationConfig.getLauncherExecutable())) continue;
            File file4 = new File(file, associationConfig.getLauncherExecutable());
            File file5 = null;
            if (associationConfig.getWindowsIcon().trim().length() > 0) {
                file5 = new File(file2, associationConfig.getWindowsIcon());
            }
            if (!(string = associationConfig.getExtension()).startsWith(".")) {
                string = "." + string;
            }
            if (WinAssociations.exists(string)) {
                WinAssociations.remove(string);
            }
            WinAssociations.create(string, associationConfig.getDescription(), file5, file4);
            properties.put(string, file4.getAbsolutePath());
        }
        object = new BufferedOutputStream(new FileOutputStream(file3));
        properties.store((OutputStream)object, "");
        ((OutputStream)object).close();
        FileInstaller.getInstance().registerUninstallFile(file3);
    }

    private static void createAdditionalIcons(File file, Installer installer) throws IOException, UserCanceledException {
        InstallerFrontend installerFrontend = installer.getInstallerFrontend();
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        String string = installerConfig.getDesktopExecutable().trim();
        if (ComponentConfig.isIncludedInSelectedComponents(string) && !string.equals("")) {
            File file2;
            File file3 = new File(file, string);
            if (installerFrontend.isCreateDesktopIcon()) {
                file2 = FolderInfo.getSpecialFolder(1, true);
                Win32SpecificInstaller.installMenu(new File(file2, installerConfig.getApplicationName()), file3, null);
            }
            if (installerFrontend.isCreateQuickLaunchIcon()) {
                file2 = new File(FolderInfo.getSpecialFolder(7, false), QUICK_LAUCH_DIR);
                Win32SpecificInstaller.installMenu(new File(file2, installerConfig.getApplicationName()), file3, null);
            }
        }
    }

    private static void createMenu(File file, Installer installer) throws IOException, UserCanceledException {
        InstallerFrontend installerFrontend = installer.getInstallerFrontend();
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (installerFrontend.isCreateMenu()) {
            File file2 = new File(FolderInfo.getSpecialFolder(3, installerFrontend.isCreateMenuAllUsers()), installerFrontend.getProgramGroup());
            Iterator iterator = installerConfig.getMenuEntries().iterator();
            while (iterator.hasNext()) {
                MenuEntryConfig menuEntryConfig = (MenuEntryConfig)iterator.next();
                if (!ComponentConfig.isIncludedInSelectedComponents(menuEntryConfig.getFile())) continue;
                File file3 = null;
                if (!menuEntryConfig.getIcon().trim().equals("")) {
                    file3 = new File(new File(file, ".install4j"), menuEntryConfig.getIcon());
                }
                Win32SpecificInstaller.installMenu(new File(file2, menuEntryConfig.getName()), new File(file, menuEntryConfig.getFile()), file3);
            }
        }
    }

    private static void createUninstallLink(File file) {
        String string;
        File file2 = new File(file, "uninstall.exe");
        Win32SpecificInstaller.removeUninstallLinks(file2);
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        String string2 = installerConfig.getApplicationNameWithVersion();
        String string3 = UNINSTALL_KEY + string2;
        Registry.setValue(3, string3, DISPLAY_NAME_VALUE_NAME, string2);
        Registry.setValue(3, string3, UNINSTALL_STRING_VALUE_NAME, file2.getAbsolutePath());
        String string4 = installerConfig.getPublisherName();
        if (string4 != null && !string4.trim().equals("")) {
            Registry.setValue(3, string3, PUBLISHER_VALUE_NAME, string4);
        }
        if ((string = installerConfig.getPublisherURL()) != null && !string.trim().equals("")) {
            Registry.setValue(3, string3, URL_INFO_ABOUT_VALUE_NAME, string);
        }
    }

    private static void removeUninstallLinks(File file) {
        String[] stringArray = Registry.enumSubKeys(3, UNINSTALL_KEY);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2;
                String string;
                String string2 = UNINSTALL_KEY + stringArray[i];
                Object object = Registry.getValue(3, string2, UNINSTALL_STRING_VALUE_NAME);
                if (object == null || !(object instanceof String) || !(string = (String)object).endsWith(".exe") || !string.startsWith(file.getAbsolutePath().substring(0, 2)) || !(file2 = new File(string)).exists()) continue;
                try {
                    if (!file2.getCanonicalFile().equals(file.getCanonicalFile())) continue;
                    Registry.deleteKey(3, string2, false);
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private static void installMenu(File file, File file2, File file3) throws IOException, UserCanceledException {
        if (!file2.exists()) {
            return;
        }
        File file4 = File.createTempFile("i4j", ".lnk");
        File file5 = new File(file4.getAbsolutePath().substring(0, file4.getAbsolutePath().length() - 3) + "pif");
        ShellLink.create(file4, file2, file3, null);
        File file6 = new File(file.getAbsolutePath() + ".lnk");
        File file7 = new File(file.getAbsolutePath() + ".pif");
        file6.delete();
        file7.delete();
        if (file4.exists()) {
            FileInstaller.getInstance().install(file4, file6, new FileOptions(file4.lastModified(), 1));
        } else if (file5.exists()) {
            FileInstaller.getInstance().install(file5, file7, new FileOptions(file5.lastModified(), 1));
        }
        ShellLink.changeNotfiy(file6);
        file4.delete();
        file5.delete();
    }

    public static void installService(File file, ServiceConfig serviceConfig) throws IOException {
        if (InstallerUtil.isWindows9X()) {
            return;
        }
        File file2 = new File(file, serviceConfig.getFile());
        if (!file2.exists()) {
            return;
        }
        String string = file2.getAbsolutePath();
        boolean bl = serviceConfig.getStartupType().equals("auto");
        Process process = Runtime.getRuntime().exec(new String[]{string, "/uninstall"});
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        process = Runtime.getRuntime().exec(new String[]{string, bl ? "/install-auto" : "/install-demand"});
        if (bl) {
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Runtime.getRuntime().exec(new String[]{string, "/start"});
        }
    }

    public static void uninstallService(File file, ServiceConfig serviceConfig) throws IOException {
        if (InstallerUtil.isWindows9X()) {
            return;
        }
        File file2 = new File(file, serviceConfig.getFile());
        if (!file2.exists()) {
            return;
        }
        String string = file2.getAbsolutePath();
        Runtime.getRuntime().exec(new String[]{string, "/uninstall"});
    }
}

