/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.components;

import com.install4j.runtime.installer.frontend.components.DirectoryEntry;
import com.install4j.runtime.installer.frontend.components.DirectoryRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.filechooser.FileSystemView;

public class DirectoryDisplay
extends JPanel {
    private File expandedDirectory;
    private JList list;
    private JScrollPane scpList;
    public static final String PROPERTY_DIRECTORY = "directory";
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$javax$swing$filechooser$FileSystemView;

    public DirectoryDisplay(File file) {
        this.setupControl();
        this.setupComponent();
        this.setupEventHandlers();
        this.setExpandedDirectory(file, true);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.list.setEnabled(bl);
        this.scpList.setEnabled(bl);
    }

    public File getExpandedDirectory() {
        return this.expandedDirectory;
    }

    public void setExpandedDirectory(File file, boolean bl) {
        this.expandedDirectory = file;
        JViewport jViewport = this.scpList.getViewport();
        Point point = bl ? null : jViewport.getViewPosition();
        int n = this.fillList(file);
        if (n > -1) {
            this.list.setSelectedIndex(n);
        }
        if (point != null) {
            jViewport.setViewPosition(point);
        } else {
            this.scpList.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
        }
    }

    private void setupControl() {
        this.list = new JList();
        this.list.setCellRenderer(new DirectoryRenderer());
        this.scpList = new JScrollPane(this.list);
    }

    private void setupComponent() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.scpList, "Center");
    }

    private void setupEventHandlers() {
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = DirectoryDisplay.this.list.locationToIndex(mouseEvent.getPoint());
                    if (DirectoryDisplay.this.list.getCellBounds(n, n).contains(mouseEvent.getPoint())) {
                        DirectoryDisplay.this.expandSelectedFolder();
                    }
                }
            }
        });
        this.list.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    DirectoryDisplay.this.expandSelectedFolder();
                }
            }
        });
    }

    private void expandSelectedFolder() {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.list.getSelectedValue();
        if (directoryEntry == null) {
            return;
        }
        File file = directoryEntry.getDirectory();
        if (file.equals(this.expandedDirectory)) {
            return;
        }
        File file2 = this.expandedDirectory;
        this.setExpandedDirectory(file, false);
        this.firePropertyChange(PROPERTY_DIRECTORY, file2, this.expandedDirectory);
    }

    private int fillList(File file) {
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        LinkedList<File> linkedList = new LinkedList<File>();
        File file2 = file;
        while (!this.isFileSystemRoot(fileSystemView, file2)) {
            linkedList.addFirst(file2);
            if ((file2 = file2.getParentFile()) != null) continue;
            return -1;
        }
        linkedList.addFirst(file2);
        DefaultListModel<DirectoryEntry> defaultListModel = new DefaultListModel<DirectoryEntry>();
        Iterator<Object> iterator = linkedList.iterator();
        int n = 0;
        int n2 = -1;
        while (iterator.hasNext()) {
            file2 = (File)iterator.next();
            if (file2.equals(file)) {
                n2 = n;
            }
            defaultListModel.addElement(new DirectoryEntry(file2, n++, true));
        }
        File[] fileArray = file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return new File(file, string).isDirectory();
            }
        });
        if (fileArray != null) {
            List<File> list = Arrays.asList(fileArray);
            Collections.sort(list);
            iterator = list.iterator();
            while (iterator.hasNext()) {
                File file3 = (File)iterator.next();
                defaultListModel.addElement(new DirectoryEntry(file3, n, false));
            }
        }
        this.list.setModel(defaultListModel);
        return n2;
    }

    private boolean isFileSystemRoot(FileSystemView fileSystemView, File file) {
        try {
            Method method = (class$javax$swing$filechooser$FileSystemView == null ? (class$javax$swing$filechooser$FileSystemView = DirectoryDisplay.class$("javax.swing.filechooser.FileSystemView")) : class$javax$swing$filechooser$FileSystemView).getMethod("isFileSystemRoot", class$java$io$File == null ? (class$java$io$File = DirectoryDisplay.class$("java.io.File")) : class$java$io$File);
            return (Boolean)method.invoke((Object)fileSystemView, file);
        }
        catch (Exception exception) {
            return file.getParent() == null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

