/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.install4j.api.CustomAction;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.util.ResourceHelper;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class InstallerUtil {
    private static final String SYSPROP_OS_NAME = "os.name";
    private static final String SYSPROP_OS_ARCH = "os.arch";
    private static final String SYSPROP_PATH_SEPARATOR = "path.separator";
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static URLClassLoader classLoader = null;
    static /* synthetic */ Class class$com$install4j$api$CustomAction;

    public static boolean isSolaris() {
        return OS_NAME.equals("SunOS");
    }

    public static boolean isSolarisSparc() {
        return InstallerUtil.isSolaris() && OS_ARCH.equals("sparc");
    }

    public static boolean isLinux() {
        return OS_NAME.toLowerCase().startsWith("linux");
    }

    public static boolean isLinuxX86() {
        return InstallerUtil.isLinux() && OS_ARCH.indexOf("86") > -1;
    }

    public static boolean isWindows() {
        return OS_NAME.toLowerCase().startsWith("win");
    }

    public static boolean isMacOS() {
        return OS_NAME.toLowerCase().startsWith("mac");
    }

    public static boolean isWindowsMe() {
        return OS_NAME.startsWith("Windows Me");
    }

    public static boolean isWindows9X() {
        return OS_NAME.startsWith("Windows 98") || OS_NAME.startsWith("Windows 95") || OS_NAME.startsWith("Windows Me");
    }

    public static boolean isWindowsNT() {
        return OS_NAME.toLowerCase().startsWith("windows nt") || OS_NAME.toLowerCase().startsWith("windowsnt");
    }

    public static boolean isHpux() {
        return OS_NAME.equals("HP-UX");
    }

    public static String getStandardApplicationsDirectory() {
        if (InstallerUtil.isWindows()) {
            return FolderInfo.getProgramFilesDirectory().getAbsolutePath();
        }
        if (InstallerUtil.isMacOS()) {
            return "/Applications";
        }
        File file = new File("/opt");
        String[] stringArray = file.list();
        if (file.exists() && stringArray != null && stringArray.length > 0) {
            return "/opt";
        }
        return "/usr/local";
    }

    public static Object newUserInstance(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (classLoader == null) {
            File file = InstallerUtil.getInstallerFile("user.jar");
            if (file.exists()) {
                try {
                    classLoader = new URLClassLoader(new URL[]{file.toURL()});
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    throw new ClassNotFoundException();
                }
            } else {
                throw new ClassNotFoundException();
            }
        }
        return classLoader.loadClass(string).newInstance();
    }

    public static CustomAction instantiateAction(String string) throws Exception {
        return (CustomAction)InstallerUtil.instantiateClass(string, "action class", class$com$install4j$api$CustomAction == null ? (class$com$install4j$api$CustomAction = InstallerUtil.class$("com.install4j.api.CustomAction")) : class$com$install4j$api$CustomAction);
    }

    public static Object instantiateClass(String string, String string2, Class clazz) throws Exception {
        if (string != null && string.length() > 0) {
            Object object;
            try {
                object = InstallerUtil.newUserInstance(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Exception("The " + string2 + " " + string + " \ncould not be found. ");
            }
            catch (InstantiationException instantiationException) {
                throw new Exception("The " + string2 + " " + string + " \ncould not be instantiated: " + instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Exception("The " + string2 + " " + string + " \nhas no public constructor: " + illegalAccessException.getMessage());
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                throw new Exception("An exception of type " + exception.getClass().getName() + " \noccurred when instantiating " + string + ":\n" + exception.getMessage());
            }
            if (clazz != null && !clazz.isAssignableFrom(object.getClass())) {
                throw new Exception("The " + string2 + " " + string + " \nis not derived from " + clazz.getName());
            }
            return object;
        }
        return null;
    }

    public static File getInstallerFile(String string) {
        File file = new File(string).getAbsoluteFile();
        if (file.exists()) {
            return file;
        }
        return new File(ResourceHelper.getRuntimeDir(), string);
    }

    public static void checkPropertyPassOn(String string) {
        int n;
        if (string.startsWith("-D") && (n = string.indexOf(61)) > -1 && string.length() > n + 1) {
            String string2 = string.substring(2, n);
            String string3 = string.substring(n + 1);
            System.setProperty(string2, string3);
        }
    }

    public static String getOldApplicationId(File file) {
        File file2;
        if (file.exists() && (file2 = new File(file, ".install4j/i4jparams.conf")).exists()) {
            try {
                InstallerConfig installerConfig = InstallerConfig.getInstanceFromFile(file2);
                if (installerConfig.getApplicationId().indexOf(37) > -1) {
                    return null;
                }
                return installerConfig.getApplicationId();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean checkWritable(File file, Component component) {
        Serializable serializable;
        ArrayList<File> arrayList = new ArrayList<File>();
        for (serializable = file; serializable != null; serializable = ((File)serializable).getParentFile()) {
            arrayList.add((File)serializable);
        }
        serializable = new ArrayList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            File file2 = (File)arrayList.get(i);
            if (!file2.mkdir()) continue;
            serializable.add(file2);
        }
        File file3 = new File(file, "i4j_writeperm_test");
        file3.delete();
        boolean bl = file3.mkdir();
        file3.delete();
        for (int i = serializable.size() - 1; i >= 0; --i) {
            File file4 = (File)serializable.get(i);
            file4.delete();
        }
        if (!bl) {
            GUIHelper.showMessage(component, Messages.getMessages().getString("NoWritePermissions"), 2);
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

