/*
 * Decompiled with CFR 0.152.
 */
import com.install4j.api.CustomScreen;
import com.install4j.api.JVMSelector;
import com.install4j.api.Util;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class SelectJdkScreen
extends CustomScreen {
    private static final long serialVersionUID = 6140544128736292132L;
    private JList jdkList = new JList();

    public SelectJdkScreen() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.anchor = 17;
        this.add(new JLabel("Available JDKs:"), gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.add(new JScrollPane(this.jdkList), gridBagConstraints);
    }

    public String getTitle() {
        return "Which JDK should the EPS use?";
    }

    public String getSubTitle() {
        return "Please select one of the installed JDKs on your computer.";
    }

    public boolean isFillVertical() {
        return true;
    }

    public boolean isFillHorizontal() {
        return true;
    }

    public boolean next() {
        if (this.jdkList.getSelectedIndex() < 0) {
            Util.showMessage((String)"Please select a JDK.", (int)2);
            return false;
        }
        JVMSelector.JVMLocation jVMLocation = (JVMSelector.JVMLocation)this.jdkList.getSelectedValue();
        JVMSelector.setPreferredJVM((String)jVMLocation.getJavaHome().getPath());
        return true;
    }

    public void activated() {
        if (this.jdkList.getModel().getSize() == 0) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            JVMSelector.JVMLocation[] jVMLocationArray = JVMSelector.getJVMLocations();
            this.setCursor(Cursor.getDefaultCursor());
            JVMSelector.JVMLocation[] jVMLocationArray2 = this.filterJDKLocations(jVMLocationArray);
            this.jdkList.setListData(jVMLocationArray2);
        }
    }

    private JVMSelector.JVMLocation[] filterJDKLocations(JVMSelector.JVMLocation[] jVMLocationArray) {
        ArrayList<JVMSelector.JVMLocation> arrayList = new ArrayList<JVMSelector.JVMLocation>();
        for (int i = 0; i < jVMLocationArray.length; ++i) {
            JVMSelector.JVMLocation jVMLocation = jVMLocationArray[i];
            if (!jVMLocation.isJDK()) continue;
            arrayList.add(jVMLocation);
        }
        return arrayList.toArray(new JVMSelector.JVMLocation[arrayList.size()]);
    }
}

