/*
 * Decompiled with CFR 0.152.
 */
package uk.co.argosytelcrest.passwordsafe.configuration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.co.argosytelcrest.dbabstraction.ColumnSpecification;
import uk.co.argosytelcrest.dbabstraction.DALFactory;
import uk.co.argosytelcrest.dbabstraction.DALInterface;
import uk.co.argosytelcrest.dbabstraction.IndexSpecification;
import uk.co.argosytelcrest.dbabstraction.TableSpecification;
import uk.co.argosytelcrest.utils.DatabaseConnectionUtils;

public final class JDBCConfiguration
extends uk.co.argosytelcrest.configuration.JDBCConfiguration {
    static final String[] INITIALISE_INSERT_COMMANDS = new String[]{"insert into application_users( user_id, user_name, user_pass, access_key, admin_access_key, last_login, login_attempts ) values ( '0', 'admin', '21232f297a57a5a743894a0e4a801fc3', '98cca538684f8edced3557a0fb87c901eac3809154794ea0bd6d8e8fb34c1117a9b6ac8a69a312eb', 'bf53bd85a9d3d1d06e80993f88df5e9ca836d389417c7555a808572cd22c72c5ebe4e6cfb60711b0d75386e1d5c36d14', '00000000000000', 0 )", "insert into groups ( group_id, group_name ) values( '0', 'Password Safe Administrators' )", "insert into groups ( group_id, group_name ) values( '1', 'Password Administrators' )", "insert into groups ( group_id, group_name ) values( '2', 'All Users' )", "insert into configuration ( property_name, property_value) values( 'db.schema.version', '20040114' )", "insert into membership ( user_id, group_id, access_key ) values ( '0', '0', '466562f59be02bb836d71ff9504a50dc05114355531ade39ef4be34c12295922914b3e524341bdec865bd7181b6d99d8' )", "insert into membership ( user_id, group_id, access_key ) values ( '0', '1', '466562f59be02bb836d71ff9504a50dc05114355531ade39ef4be34c12295922914b3e524341bdec865bd7181b6d99d8' )", "insert into membership ( user_id, group_id, access_key ) values ( '0', '2', '401d4b2bf2dbb70aa30124002768d13f252291da4fe0342317ea5d2d0f9eafc8914b3e524341bdec865bd7181b6d99d8' )", "insert into configuration(property_value, property_name) VALUES ( 'db.schema.version', '20041114')"};

    protected String[] getInitialisationCommands() {
        return INITIALISE_INSERT_COMMANDS;
    }

    private TableSpecification getPasswordsTableSpecification() {
        TableSpecification tableSpecification = new TableSpecification("passwords");
        tableSpecification.addColumnSpecification(new ColumnSpecification("password_id", ColumnSpecification.TYPE_ID, false, true));
        tableSpecification.addColumnSpecification(new ColumnSpecification("username", ColumnSpecification.TYPE_LONG_STRING));
        tableSpecification.addColumnSpecification(new ColumnSpecification("password", ColumnSpecification.TYPE_LONG_STRING));
        tableSpecification.addColumnSpecification(new ColumnSpecification("location", ColumnSpecification.TYPE_LONG_STRING));
        tableSpecification.addColumnSpecification(new ColumnSpecification("notes", ColumnSpecification.TYPE_LONG_STRING));
        tableSpecification.addColumnSpecification(new ColumnSpecification("expiry", ColumnSpecification.TYPE_LONG_STRING));
        tableSpecification.addColumnSpecification(new ColumnSpecification("enabled", ColumnSpecification.TYPE_CHAR));
        tableSpecification.addColumnSpecification(new ColumnSpecification("audited", ColumnSpecification.TYPE_CHAR));
        tableSpecification.addColumnSpecification(new ColumnSpecification("history_stored", ColumnSpecification.TYPE_CHAR));
        tableSpecification.addColumnSpecification(new ColumnSpecification("longnotes", ColumnSpecification.TYPE_BLOB));
        tableSpecification.addIndexSpecification(new IndexSpecification("pw_pid", "passwords", "password_id"));
        return tableSpecification;
    }

    public void initialiseDatabase() throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(this.getURL(), this.getUsername(), this.getPassword());
            DALInterface dALInterface = DALFactory.getDAL(this.getDBType());
            dALInterface.setConnection(connection);
            dALInterface.createTable(this.getPasswordsTableSpecification());
            super.initialiseDatabase(dALInterface);
        }
        catch (SQLException sQLException) {
            try {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Problem during database creation.", sQLException);
                throw sQLException;
            }
            catch (Throwable throwable) {
                DatabaseConnectionUtils.close(connection);
                throw throwable;
            }
        }
        DatabaseConnectionUtils.close(connection);
    }
}

