/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LogSupport;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.UrlEncoded;

public class URI
implements Cloneable {
    private static Log log = LogFactory.getLog(URI.class);
    public static final String __CHARSET = System.getProperty("org.mortbay.util.URI.charset", "UTF-8");
    public static final boolean __CHARSET_IS_DEFAULT = __CHARSET.equals("UTF-8");
    private String _uri;
    private String _scheme;
    private String _host;
    private int _port;
    private String _path;
    private String _encodedPath;
    private String _query;
    private UrlEncoded _parameters;
    private boolean _dirty;

    public URI(URI uRI) throws IllegalArgumentException {
        this._uri = uRI.toString();
        this._scheme = uRI._scheme;
        this._host = uRI._host;
        this._port = uRI._port;
        this._path = uRI._path;
        this._encodedPath = uRI._encodedPath;
        this._query = uRI._query;
        if (uRI._parameters != null) {
            this._parameters = (UrlEncoded)uRI._parameters.clone();
        }
        this._dirty = false;
    }

    public URI(String string) throws IllegalArgumentException {
        this.setURI(string);
    }

    public void setURI(String string) throws IllegalArgumentException {
        try {
            char c;
            this._uri = string;
            this._scheme = null;
            this._host = null;
            this._port = 0;
            this._path = null;
            this._encodedPath = null;
            this._query = null;
            if (this._parameters != null) {
                this._parameters.clear();
            }
            int n = string.length() - 1;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (n == 0 || string.charAt(0) == '/' && string.charAt(1) != '/') {
                n3 = 3;
                this._scheme = null;
                this._host = null;
                this._port = 0;
            } else {
                block15: for (n4 = 0; n3 < 3 && n4 <= n; ++n4) {
                    c = string.charAt(n4);
                    switch (n3) {
                        case 0: {
                            if (c == ':' && string.charAt(n4 + 1) == '/' && string.charAt(n4 + 2) == '/') {
                                this._scheme = string.substring(n2, n4);
                                n2 = (n4 += 2) + 1;
                                n3 = 1;
                                continue block15;
                            }
                            if (n4 == 0 && c == '/') {
                                n3 = 3;
                                continue block15;
                            }
                            if (n4 != 0 || c != '*') continue block15;
                            n3 = 5;
                            this._path = "*";
                            this._encodedPath = "*";
                            continue block15;
                        }
                        case 1: {
                            if (c == ':') {
                                this._host = string.substring(n2, n4);
                                n2 = n4 + 1;
                                n3 = 2;
                                continue block15;
                            }
                            if (c != '/') continue block15;
                            this._host = string.substring(n2, n4);
                            n2 = n4;
                            n3 = 3;
                            continue block15;
                        }
                        case 2: {
                            if (c != '/') continue block15;
                            this._port = TypeUtil.parseInt(string, n2, n4 - n2, 10);
                            n2 = n4;
                            n3 = 3;
                            continue block15;
                        }
                    }
                }
            }
            this._query = null;
            ++n4;
            while (n4 <= n) {
                c = string.charAt(n4);
                if (c == '?') {
                    this._encodedPath = string.substring(n2, n4);
                    this._path = URI.decodePath(this._encodedPath);
                    n2 = n4 + 1;
                    n3 = 4;
                    break;
                }
                ++n4;
            }
            switch (n3) {
                case 0: {
                    this._dirty = false;
                    this._encodedPath = this._uri;
                    this._path = URI.decodePath(this._encodedPath);
                    break;
                }
                case 1: {
                    this._dirty = true;
                    this._path = this._encodedPath = "/";
                    this._host = string.substring(n2);
                    break;
                }
                case 2: {
                    this._dirty = true;
                    this._path = this._encodedPath = "/";
                    this._port = TypeUtil.parseInt(string, n2, -1, 10);
                    break;
                }
                case 3: {
                    this._dirty = n2 == n;
                    this._encodedPath = string.substring(n2);
                    this._path = URI.decodePath(this._encodedPath);
                    break;
                }
                case 4: {
                    this._dirty = false;
                    if (n2 > n) break;
                    this._query = string.substring(n2);
                    break;
                }
                case 5: {
                    this._dirty = false;
                }
            }
            if (this._query != null && this._query.length() > 0) {
                if (this._parameters == null) {
                    this._parameters = new UrlEncoded();
                } else {
                    this._parameters.clear();
                }
                this._parameters.decode(this._query, __CHARSET);
            } else {
                this._query = null;
            }
        }
        catch (Exception exception) {
            LogSupport.ignore(log, exception);
            throw new IllegalArgumentException("Malformed URI '" + string + "' : " + exception.toString());
        }
    }

    public boolean isAbsolute() {
        return this._scheme != null || this._host != null;
    }

    public String getScheme() {
        return this._scheme;
    }

    public void setScheme(String string) {
        this._scheme = string;
        this._dirty = true;
    }

    public String getHost() {
        return this._host;
    }

    public void setHost(String string) {
        this._host = string;
        this._dirty = true;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int n) {
        this._port = n;
        this._dirty = true;
    }

    public String getPath() {
        return this._path;
    }

    public String getEncodedPath() {
        return this._encodedPath;
    }

    public void setPath(String string) {
        this._path = string;
        this._encodedPath = URI.encodePath(this._path);
        this._dirty = true;
    }

    public String getQuery() {
        if (this._dirty && this._parameters != null) {
            this._query = this._parameters.encode(__CHARSET);
            if (this._query != null && this._query.length() == 0) {
                this._query = null;
            }
        }
        return this._query;
    }

    public void setQuery(String string) {
        this._query = string;
        if (this._parameters != null) {
            this._parameters.clear();
        } else if (string != null) {
            this._parameters = new UrlEncoded();
        }
        if (string != null) {
            this._parameters.decode(string, __CHARSET);
        }
        this.cleanURI();
    }

    public Set getParameterNames() {
        if (this._parameters == null) {
            return Collections.EMPTY_SET;
        }
        return this._parameters.keySet();
    }

    public MultiMap getParameters() {
        if (this._parameters == null) {
            this._parameters = new UrlEncoded();
        }
        this._dirty = true;
        return this._parameters;
    }

    public Map getUnmodifiableParameters() {
        if (this._parameters == null) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(this._parameters);
    }

    public void putParametersTo(MultiMap multiMap) {
        if (this._parameters != null && this._parameters.size() > 0) {
            multiMap.putAll((Map)this._parameters);
        }
    }

    public void clearParameters() {
        if (this._parameters != null) {
            this._dirty = true;
            this._parameters.clear();
        }
    }

    public void put(String string) {
        UrlEncoded urlEncoded = new UrlEncoded(string);
        this.put(urlEncoded);
    }

    public Object put(Object object, Object object2) {
        return this.getParameters().put(object, object2);
    }

    public void put(Map map) {
        this.getParameters().putAll(map);
    }

    public String get(String string) {
        if (this._parameters == null) {
            return null;
        }
        return (String)this._parameters.get(string);
    }

    public List getValues(String string) {
        if (this._parameters == null) {
            return null;
        }
        return this._parameters.getValues(string);
    }

    public void remove(String string) {
        if (this._parameters != null) {
            this._dirty = this._parameters.remove(string) != null;
        }
    }

    public String toString() {
        if (this._dirty) {
            this.getQuery();
            this.cleanURI();
        }
        return this._uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanURI() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(this._uri.length() * 2);
        synchronized (stringBuffer2) {
            if (this._scheme != null) {
                stringBuffer.append(this._scheme);
                stringBuffer.append("://");
                stringBuffer.append(this._host);
                if (this._port > 0) {
                    stringBuffer.append(':');
                    stringBuffer.append(this._port);
                }
            }
            stringBuffer.append(this._encodedPath);
            if (this._query != null && this._query.length() > 0) {
                stringBuffer.append('?');
                stringBuffer.append(this._query);
            }
            this._uri = stringBuffer.toString();
            this._dirty = false;
        }
    }

    public static String encodePath(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = URI.encodePath(null, string);
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer encodePath(StringBuffer stringBuffer, String string) {
        int n;
        if (stringBuffer == null) {
            block13: for (int i = 0; i < string.length(); ++i) {
                n = string.charAt(i);
                switch (n) {
                    case 32: 
                    case 35: 
                    case 37: 
                    case 59: 
                    case 63: {
                        stringBuffer = new StringBuffer(string.length() << 1);
                        break block13;
                    }
                    default: {
                        continue block13;
                    }
                }
            }
            if (stringBuffer == null) {
                return null;
            }
        }
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            block14: for (n = 0; n < string.length(); ++n) {
                char c = string.charAt(n);
                switch (c) {
                    case '%': {
                        stringBuffer.append("%25");
                        continue block14;
                    }
                    case '?': {
                        stringBuffer.append("%3F");
                        continue block14;
                    }
                    case ';': {
                        stringBuffer.append("%3B");
                        continue block14;
                    }
                    case '#': {
                        stringBuffer.append("%23");
                        continue block14;
                    }
                    case ' ': {
                        stringBuffer.append("%20");
                        continue block14;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
            }
        }
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer encodeString(StringBuffer stringBuffer, String string, String string2) {
        int n;
        if (stringBuffer == null) {
            for (int i = 0; i < string.length(); ++i) {
                n = string.charAt(i);
                if (n != 37 && string2.indexOf(n) < 0) continue;
                stringBuffer = new StringBuffer(string.length() << 1);
                break;
            }
            if (stringBuffer == null) {
                return null;
            }
        }
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            for (n = 0; n < string.length(); ++n) {
                char c = string.charAt(n);
                if (c == '%' || string2.indexOf(c) >= 0) {
                    stringBuffer.append('%');
                    StringUtil.append(stringBuffer, (byte)(0xFF & c), 16);
                    continue;
                }
                stringBuffer.append(c);
            }
        }
        return stringBuffer;
    }

    public static String decodePath(String string) {
        int n = string.length();
        byte[] byArray = null;
        int n2 = 0;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byte by = (byte)(0xFF & c);
            if (c == '%' && i + 2 < n) {
                bl = false;
                by = (byte)(0xFF & TypeUtil.parseInt(string, i + 1, 2, 16));
                i += 2;
            } else if (byArray == null) {
                ++n2;
                continue;
            }
            if (byArray == null) {
                bl = false;
                byArray = new byte[n];
                for (int j = 0; j < n2; ++j) {
                    byArray[j] = (byte)(0xFF & string.charAt(j));
                }
            }
            byArray[n2++] = by;
        }
        if (bl) {
            return string;
        }
        try {
            return new String(byArray, 0, n2, __CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.warn((Object)"EXCEPTION ", (Throwable)unsupportedEncodingException);
            return new String(byArray, 0, n2);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        URI uRI = (URI)super.clone();
        if (this._parameters != null) {
            uRI._parameters = (UrlEncoded)this._parameters.clone();
        }
        this._dirty = false;
        return uRI;
    }

    public static String addPaths(String string, String string2) {
        if (string == null || string.length() == 0) {
            if (string2 == null || string2.length() == 0) {
                return string;
            }
            return string2;
        }
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        int n = string.indexOf(59);
        if (n < 0) {
            n = string.indexOf(63);
        }
        if (n == 0) {
            return string2 + string;
        }
        if (n < 0) {
            n = string.length();
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + string2.length() + 2);
        stringBuffer.append(string);
        if (stringBuffer.charAt(n - 1) == '/') {
            if (string2.startsWith("/")) {
                stringBuffer.deleteCharAt(n - 1);
                stringBuffer.insert(n - 1, string2);
            } else {
                stringBuffer.insert(n, string2);
            }
        } else if (string2.startsWith("/")) {
            stringBuffer.insert(n, string2);
        } else {
            stringBuffer.insert(n, '/');
            stringBuffer.insert(n + 1, string2);
        }
        return stringBuffer.toString();
    }

    public static String parentPath(String string) {
        if (string == null || "/".equals(string)) {
            return null;
        }
        int n = string.lastIndexOf(47, string.length() - 2);
        if (n >= 0) {
            return string.substring(0, n + 1);
        }
        return null;
    }

    public static String stripPath(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(59);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String canonicalPath(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        int n = string.length();
        int n2 = string.indexOf(63);
        int n3 = string.lastIndexOf(47, n2 > 0 ? n2 : n);
        block8: while (n > 0) {
            switch (n - n3) {
                case 2: {
                    if (string.charAt(n3 + 1) == '.') break block8;
                    break;
                }
                case 3: {
                    if (string.charAt(n3 + 1) == '.' && string.charAt(n3 + 2) == '.') break block8;
                }
            }
            n = n3;
            n3 = string.lastIndexOf(47, n - 1);
        }
        if (n3 >= n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        block9: while (n > 0) {
            switch (n - n3) {
                case 2: {
                    if (stringBuffer.charAt(n3 + 1) != '.') {
                        if (n6 <= 0 || --n6 != 0) break;
                        int n7 = n4 = n3 >= 0 ? n3 : 0;
                        if (n4 <= 0 || n5 != stringBuffer.length() || stringBuffer.charAt(n5 - 1) != '.') break;
                        ++n4;
                        break;
                    }
                    if (n3 < 0 && stringBuffer.length() > 2 && stringBuffer.charAt(1) == '/' && stringBuffer.charAt(2) == '/') break;
                    if (n5 < 0) {
                        n5 = n;
                    }
                    if ((n4 = n3) < 0 || n4 == 0 && stringBuffer.charAt(n4) == '/') {
                        ++n4;
                        if (n5 >= stringBuffer.length() || stringBuffer.charAt(n5) != '/') break;
                        ++n5;
                        break;
                    }
                    if (n == stringBuffer.length()) {
                        ++n4;
                    }
                    --n3;
                    while (n3 >= 0 && stringBuffer.charAt(n3) != '/') {
                        --n3;
                    }
                    continue block9;
                }
                case 3: {
                    if (stringBuffer.charAt(n3 + 1) != '.' || stringBuffer.charAt(n3 + 2) != '.') {
                        if (n6 <= 0 || --n6 != 0) break;
                        int n8 = n4 = n3 >= 0 ? n3 : 0;
                        if (n4 <= 0 || n5 != stringBuffer.length() || stringBuffer.charAt(n5 - 1) != '.') break;
                        ++n4;
                        break;
                    }
                    n4 = n3;
                    if (n5 < 0) {
                        n5 = n;
                    }
                    ++n6;
                    --n3;
                    while (n3 >= 0 && stringBuffer.charAt(n3) != '/') {
                        --n3;
                    }
                    continue block9;
                }
                default: {
                    if (n6 <= 0 || --n6 != 0) break;
                    int n9 = n4 = n3 >= 0 ? n3 : 0;
                    if (n5 != stringBuffer.length() || stringBuffer.charAt(n5 - 1) != '.') break;
                    ++n4;
                }
            }
            if (n6 <= 0 && n4 >= 0 && n4 >= 0) {
                stringBuffer.delete(n4, n5);
                n5 = -1;
                n4 = -1;
                if (n6 > 0) {
                    n5 = n;
                }
            }
            --n3;
            while (n3 >= 0 && stringBuffer.charAt(n3) != '/') {
                --n3;
            }
        }
        if (n6 > 0) {
            return null;
        }
        if (n5 >= 0) {
            stringBuffer.delete(n4, n5);
        }
        return stringBuffer.toString();
    }

    public static boolean hasScheme(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ':') {
                return true;
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || i > 0 && (c >= '0' && c <= '9' || c == '.' || c == '+' || c == '-'))) break;
        }
        return false;
    }
}

