/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;

public class TestCase {
    private static Log log = LogFactory.getLog(TestCase.class);
    private static Vector tests = new Vector();
    private static final String fail = "FAIL";
    private static final char[] spaces = "                                                                                 ".toCharArray();
    static final String SelfFailTest = "org.mortbay.util.TestCase all fail";
    private String testCase;
    private StringBuffer reportBuf = new StringBuffer(512);
    private boolean passed = true;

    public TestCase(String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Constructed test case: " + string));
        }
        this.testCase = string;
        tests.addElement(this);
    }

    public void check(boolean bl, String string) {
        if (!bl) {
            this.reportBuf.append(this.testCase + " : " + string + " - ");
            this.passed = false;
            this.reportBuf.append(fail);
            this.reportBuf.append('\n');
            this.reportBuf.append(spaces, 0, this.testCase.length() + 3);
            this.reportBuf.append("check!=true");
            if (log.isDebugEnabled()) {
                log.debug((Object)(string + " FAILED"));
            }
        }
        this.reportBuf.append('\n');
    }

    public int checkContains(String string, String string2, String string3) {
        return this.realCheckContains(string, 0, string2, string3);
    }

    public int checkContains(String string, int n, String string2, String string3) {
        return this.realCheckContains(string, n, string2, string3);
    }

    public int realCheckContains(String string, int n, String string2, String string3) {
        int n2 = -1;
        if ((string != null || string2 != null) && (string == null || string2 != null && (n2 = string.indexOf(string2, n)) < 0)) {
            this.reportBuf.append(this.testCase + " : " + string3 + " - ");
            this.passed = false;
            this.reportBuf.append(fail);
            this.reportBuf.append('\n');
            this.reportBuf.append(spaces, 0, this.testCase.length() + 3);
            this.reportBuf.append('\"' + string2 + "\" not contained in \"");
            if (n < string.length()) {
                this.reportBuf.append(string.substring(n));
            } else {
                this.reportBuf.append("string<offset:" + n + ":'" + string + "'");
            }
            this.reportBuf.append("\"");
            if (log.isDebugEnabled()) {
                log.debug((Object)(string3 + " FAILED: " + this.reportBuf.toString()));
            }
            this.reportBuf.append('\n');
        }
        return n2;
    }

    public int checkNotContained(String string, String string2, String string3) {
        return this.checkNotContained(string, 0, string2, string3);
    }

    public int checkNotContained(String string, int n, String string2, String string3) {
        int n2 = -1;
        if (string == null && string2 == null || string != null && (string2 == null || (n2 = string.indexOf(string2, n)) >= 0)) {
            this.reportBuf.append(this.testCase + " : " + string3 + " - ");
            this.passed = false;
            this.reportBuf.append(fail);
            this.reportBuf.append('\n');
            this.reportBuf.append(spaces, 0, this.testCase.length() + 3);
            this.reportBuf.append('\"' + string2 + "\" IS contained in \"" + string.substring(n) + '\"');
            if (log.isDebugEnabled()) {
                log.debug((Object)(string3 + " FAILED"));
            }
            this.reportBuf.append('\n');
        }
        return n2;
    }

    public void checkEquals(Object object, Object object2, String string) {
        this.commonCheckEquals(object, object2, string);
    }

    public void checkEquals(long l, long l2, String string) {
        this.commonCheckEquals(new Long(l), new Long(l2), string);
    }

    public void checkEquals(double d, double d2, String string) {
        this.commonCheckEquals(new Double(d), new Double(d2), string);
    }

    public void checkEquals(char c, char c2, String string) {
        this.commonCheckEquals(new Character(c), new Character(c2), string);
    }

    public void checkEquals(InputStream inputStream, InputStream inputStream2, String string) {
        try {
            int n;
            int n2;
            while ((n2 = inputStream.read()) == (n = inputStream2.read())) {
                if (n2 != -1) continue;
                this.commonCheckEquals(null, null, string);
                return;
            }
            this.commonCheckEquals("" + n2, "" + n, string);
        }
        catch (Exception exception) {
            this.commonCheckEquals(exception.toString(), null, string);
        }
    }

    private void commonCheckEquals(Object object, Object object2, String string) {
        if (!(object == object2 || object != null && object.equals(object2))) {
            this.reportBuf.append(this.testCase + " : " + string + " - ");
            this.passed = false;
            this.reportBuf.append(fail);
            this.reportBuf.append('\n');
            this.reportBuf.append(spaces, 0, this.testCase.length() + 3);
            this.reportBuf.append((object != null ? object.toString() : "null") + " != " + (object2 != null ? object2.toString() : "null"));
            if (log.isDebugEnabled()) {
                log.debug((Object)(3 + string + " FAILED"));
            }
            this.reportBuf.append('\n');
        }
    }

    public static void report() {
        Enumeration enumeration = tests.elements();
        while (enumeration.hasMoreElements()) {
            TestCase testCase = (TestCase)enumeration.nextElement();
            if (testCase.passed) continue;
            System.err.print("\nTest Case: " + testCase.testCase);
            System.err.println("  - FAILED");
            System.err.println(testCase.reportBuf.toString());
        }
        System.err.println("\nTEST SUMMARY:");
        enumeration = tests.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            TestCase testCase = (TestCase)enumeration.nextElement();
            if (testCase.passed || testCase.testCase.equals(SelfFailTest)) continue;
            System.err.print("Test Case: " + testCase.testCase);
            System.err.println("  - FAILED");
            bl = true;
        }
        if (bl) {
            System.exit(1);
        }
        System.exit(0);
    }
}

