/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.Credential;

public class Password
extends Credential {
    private static Log log = LogFactory.getLog(Password.class);
    private String _pw;

    public Password(String string) {
        this._pw = string;
        while (this._pw != null && this._pw.startsWith("OBF:")) {
            this._pw = Password.deobfuscate(this._pw);
        }
    }

    public String toString() {
        return this._pw;
    }

    public String toStarString() {
        return "*****************************************************".substring(0, this._pw.length());
    }

    public boolean check(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Password) {
            return object.equals(this._pw);
        }
        if (object instanceof String) {
            return object.equals(this._pw);
        }
        if (object instanceof Credential) {
            return ((Credential)object).check(this._pw);
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object) {
            return false;
        }
        if (object instanceof Password) {
            Password password = (Password)object;
            return password._pw == this._pw || null != this._pw && this._pw.equals(password._pw);
        }
        if (object instanceof String) {
            return object.equals(this._pw);
        }
        return false;
    }

    public int hashCode() {
        return null == this._pw ? super.hashCode() : this._pw.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String obfuscate(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = string.getBytes();
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            stringBuffer.append("OBF:");
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                byte by2 = byArray[string.length() - (i + 1)];
                int n = by + by2 + 127;
                int n2 = by - by2 + 127;
                int n3 = n * 256 + n2;
                String string2 = Integer.toString(n3, 36);
                switch (string2.length()) {
                    case 1: {
                        stringBuffer.append('0');
                    }
                    case 2: {
                        stringBuffer.append('0');
                    }
                    case 3: {
                        stringBuffer.append('0');
                    }
                }
                stringBuffer.append(string2);
            }
            return stringBuffer.toString();
        }
    }

    public static String deobfuscate(String string) {
        if (string.startsWith("OBF:")) {
            string = string.substring(4);
        }
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        for (int i = 0; i < string.length(); i += 4) {
            String string2 = string.substring(i, i + 4);
            int n2 = Integer.parseInt(string2, 36);
            int n3 = n2 / 256;
            int n4 = n2 % 256;
            byArray[n++] = (byte)((n3 + n4 - 254) / 2);
        }
        return new String(byArray, 0, n);
    }

    public static Password getPassword(String string, String string2, String string3) {
        String string4 = System.getProperty(string, string2);
        if (string4 == null || string4.length() == 0) {
            try {
                System.out.print(string + (string3 != null && string3.length() > 0 ? " [dft]" : "") + " : ");
                System.out.flush();
                byte[] byArray = new byte[512];
                int n = System.in.read(byArray);
                if (n > 0) {
                    string4 = new String(byArray, 0, n).trim();
                }
            }
            catch (IOException iOException) {
                log.warn((Object)"EXCEPTION ", (Throwable)iOException);
            }
            if (string4 == null || string4.length() == 0) {
                string4 = string3;
            }
        }
        return new Password(string4);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1 && stringArray.length != 2) {
            System.err.println("Usage - java org.mortbay.util.Password [<user>] <password>");
            System.err.println("If the password is ?, the user will be prompted for the password");
            System.exit(1);
        }
        String string = stringArray[stringArray.length == 1 ? 0 : 1];
        Password password = "?".equals(string) ? new Password(string) : new Password(string);
        System.err.println(password.toString());
        System.err.println(Password.obfuscate(password.toString()));
        System.err.println(Credential.MD5.digest(string));
        if (stringArray.length == 2) {
            System.err.println(Credential.Crypt.crypt(stringArray[0], password.toString()));
        }
    }
}

