/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpContext;
import org.mortbay.log.LogFactory;
import org.mortbay.util.ComponentEvent;
import org.mortbay.util.ComponentListener;
import org.mortbay.util.EventProvider;
import org.mortbay.util.LazyList;
import org.mortbay.util.LifeCycle;
import org.mortbay.util.LifeCycleEvent;
import org.mortbay.util.LifeCycleListener;

public abstract class Container
implements LifeCycle,
EventProvider,
Serializable {
    private static Log log = LogFactory.getLog(Container.class);
    private Object _eventListeners;
    private Object _components;
    private transient boolean _started;
    private transient boolean _starting;
    private transient boolean _stopping;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void start() throws Exception {
        Object object;
        int n;
        if (this._started || this._starting) {
            return;
        }
        this._starting = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting " + this));
        }
        LifeCycleEvent lifeCycleEvent = new LifeCycleEvent(this);
        for (n = 0; n < LazyList.size(this._eventListeners); ++n) {
            object = (EventListener)LazyList.get(this._eventListeners, n);
            if (!(object instanceof LifeCycleListener)) continue;
            ((LifeCycleListener)object).lifeCycleStarting(lifeCycleEvent);
        }
        try {
            this.doStart();
            this._started = true;
            log.info((Object)("Started " + this));
            for (n = 0; n < LazyList.size(this._eventListeners); ++n) {
                object = (EventListener)LazyList.get(this._eventListeners, n);
                if (!(object instanceof LifeCycleListener)) continue;
                ((LifeCycleListener)object).lifeCycleStarted(lifeCycleEvent);
            }
        }
        catch (Throwable throwable) {
            object = new LifeCycleEvent(this, throwable);
            for (int i = 0; i < LazyList.size(this._eventListeners); ++i) {
                EventListener eventListener = (EventListener)LazyList.get(this._eventListeners, i);
                if (!(eventListener instanceof LifeCycleListener)) continue;
                ((LifeCycleListener)eventListener).lifeCycleFailure(lifeCycleEvent);
            }
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            log.warn((Object)"EXCEPTION ", throwable);
        }
        finally {
            this._starting = false;
        }
    }

    protected abstract void doStart() throws Exception;

    public synchronized boolean isStarted() {
        return this._started;
    }

    protected synchronized boolean isStarting() {
        return this._starting;
    }

    protected synchronized boolean isStopping() {
        return this._stopping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void stop() throws InterruptedException {
        EventListener eventListener;
        int n;
        if (!this._started || this._stopping) {
            return;
        }
        this._stopping = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stopping " + this));
        }
        LifeCycleEvent lifeCycleEvent = new LifeCycleEvent(this);
        for (n = 0; n < LazyList.size(this._eventListeners); ++n) {
            eventListener = (EventListener)LazyList.get(this._eventListeners, n);
            if (!(eventListener instanceof LifeCycleListener)) continue;
            ((LifeCycleListener)eventListener).lifeCycleStopping(lifeCycleEvent);
        }
        try {
            this.doStop();
            this._started = false;
            log.info((Object)("Stopped " + this));
            for (n = 0; n < LazyList.size(this._eventListeners); ++n) {
                eventListener = (EventListener)LazyList.get(this._eventListeners, n);
                if (!(eventListener instanceof LifeCycleListener)) continue;
                ((LifeCycleListener)eventListener).lifeCycleStopped(lifeCycleEvent);
            }
        }
        catch (Throwable throwable) {
            lifeCycleEvent = new LifeCycleEvent(this, throwable);
            for (int i = 0; i < LazyList.size(this._eventListeners); ++i) {
                EventListener eventListener2 = (EventListener)LazyList.get(this._eventListeners, i);
                if (!(eventListener2 instanceof LifeCycleListener)) continue;
                ((LifeCycleListener)eventListener2).lifeCycleFailure(lifeCycleEvent);
            }
            if (throwable instanceof InterruptedException) {
                throw (InterruptedException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            log.warn((Object)"EXCEPTION ", throwable);
        }
        finally {
            this._stopping = false;
        }
    }

    protected abstract void doStop() throws Exception;

    protected void addComponent(Object object) {
        if (!LazyList.contains(this._components, object)) {
            this._components = LazyList.add(this._components, object);
            if (log.isDebugEnabled()) {
                log.debug((Object)("add component: " + object));
            }
            ComponentEvent componentEvent = new ComponentEvent(this, object);
            for (int i = 0; i < LazyList.size(this._eventListeners); ++i) {
                EventListener eventListener = (EventListener)LazyList.get(this._eventListeners, i);
                if (!(eventListener instanceof ComponentListener)) continue;
                ((ComponentListener)eventListener).addComponent(componentEvent);
            }
        }
    }

    protected void removeComponent(Object object) {
        if (LazyList.contains(this._components, object)) {
            this._components = LazyList.remove(this._components, object);
            if (log.isDebugEnabled()) {
                log.debug((Object)("remove component: " + object));
            }
            ComponentEvent componentEvent = new ComponentEvent(this, object);
            for (int i = 0; i < LazyList.size(this._eventListeners); ++i) {
                EventListener eventListener = (EventListener)LazyList.get(this._eventListeners, i);
                if (!(eventListener instanceof ComponentListener)) continue;
                ((ComponentListener)eventListener).removeComponent(componentEvent);
            }
        }
    }

    public void addEventListener(EventListener eventListener) throws IllegalArgumentException {
        if (this._eventListeners == null) {
            this._eventListeners = new ArrayList();
        }
        if (eventListener instanceof ComponentListener || eventListener instanceof LifeCycleListener) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("addEventListener: " + eventListener));
            }
            this._eventListeners = LazyList.add(this._eventListeners, eventListener);
        }
    }

    public void removeEventListener(EventListener eventListener) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeEventListener: " + eventListener));
        }
        this._eventListeners = LazyList.remove(this._eventListeners, eventListener);
    }

    public void destroy() {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        if (this._components != null && this._eventListeners != null) {
            for (int i = 0; i < LazyList.size(this._components); ++i) {
                Object object = LazyList.get(this._components, i);
                if (object instanceof HttpContext) {
                    ((HttpContext)object).destroy();
                }
                ComponentEvent componentEvent = new ComponentEvent(this, object);
                for (int j = 0; j < LazyList.size(this._eventListeners); ++j) {
                    EventListener eventListener = (EventListener)LazyList.get(this._eventListeners, j);
                    if (!(eventListener instanceof ComponentListener)) continue;
                    ((ComponentListener)eventListener).removeComponent(componentEvent);
                }
            }
        }
        this._components = null;
        this._eventListeners = null;
    }

    public Collection getComponents() {
        return LazyList.getList(this._eventListeners, false);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        for (int i = 0; i < LazyList.size(this._components); ++i) {
            Object object = LazyList.get(this._components, i);
            ComponentEvent componentEvent = new ComponentEvent(this, object);
            for (int j = 0; j < LazyList.size(this._eventListeners); ++j) {
                EventListener eventListener = (EventListener)LazyList.get(this._eventListeners, j);
                if (!(eventListener instanceof ComponentListener)) continue;
                ((ComponentListener)eventListener).addComponent(componentEvent);
            }
        }
    }
}

