/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.ByteArrayPool;

public class ByteBufferOutputStream
extends OutputStream {
    private static Log log = LogFactory.getLog(ByteBufferOutputStream.class);
    protected byte[] _buf;
    private int _start;
    private int _end;
    private int _pos;
    private int _preReserve;
    private int _postReserve;
    private boolean _resized;
    private boolean _fixed;

    public ByteBufferOutputStream() {
        this(4096, 0, 0);
    }

    public ByteBufferOutputStream(int n) {
        this(n, 0, 0);
    }

    public ByteBufferOutputStream(int n, int n2) {
        this(n, n2, 0);
    }

    public ByteBufferOutputStream(int n, int n2, int n3) {
        this._buf = ByteArrayPool.getByteArray(n);
        this._end = this._buf.length - n3;
        this._preReserve = n2;
        this._start = n2;
        this._pos = n2;
        this._postReserve = n3;
    }

    public boolean isFixed() {
        return this._fixed;
    }

    public void setFixed(boolean bl) {
        this._fixed = bl;
    }

    public int size() {
        return this._pos - this._start;
    }

    public int bufferSize() {
        return this._buf.length;
    }

    public int capacity() {
        return this._end - this._start;
    }

    public int spareCapacity() {
        return this._end - this._pos;
    }

    public int preReserve() {
        return this._start;
    }

    public int postReserve() {
        return this._buf.length - this._end;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this._buf, this._start, this._pos - this._start);
    }

    public void write(int n) throws IOException {
        this.ensureSpareCapacity(1);
        this._buf[this._pos++] = (byte)n;
    }

    public void write(byte[] byArray) throws IOException {
        this.ensureSpareCapacity(byArray.length);
        System.arraycopy(byArray, 0, this._buf, this._pos, byArray.length);
        this._pos += byArray.length;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.ensureSpareCapacity(n2);
        System.arraycopy(byArray, n, this._buf, this._pos, n2);
        this._pos += n2;
    }

    public void prewrite(int n) {
        this.ensureReserve(1);
        this._buf[--this._start] = (byte)n;
    }

    public void prewrite(byte[] byArray) {
        this.ensureReserve(byArray.length);
        System.arraycopy(byArray, 0, this._buf, this._start - byArray.length, byArray.length);
        this._start -= byArray.length;
    }

    public void prewrite(byte[] byArray, int n, int n2) {
        this.ensureReserve(n2);
        System.arraycopy(byArray, n, this._buf, this._start - n2, n2);
        this._start -= n2;
    }

    public void postwrite(byte[] byArray, int n, int n2) throws IOException {
        System.arraycopy(byArray, n, this._buf, this._pos, n2);
        this._pos += n2;
    }

    public void flush() throws IOException {
    }

    public void resetStream() {
        this._pos = this._preReserve;
        this._start = this._preReserve;
    }

    public void reset(int n) {
        this._pos = this._preReserve = n;
        this._start = this._preReserve;
    }

    public void close() throws IOException {
        this.flush();
    }

    public void destroy() {
        if (!this._resized) {
            ByteArrayPool.returnByteArray(this._buf);
        }
        this._buf = null;
    }

    public void ensureReserve(int n) {
        if (n > this._start) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reserve: " + n + ">" + this._start));
            }
            if (this._pos + n < this._end) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Shift reserve: " + this._pos + "+" + n + "<" + this._end));
                }
                System.arraycopy(this._buf, this._start, this._buf, n, this._pos - this._start);
                this._pos = this._pos + n - this._start;
                this._start = n;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("New reserve: " + this._pos + "+" + n + ">=" + this._end));
                }
                byte[] byArray = new byte[this._buf.length + n - this._start];
                System.arraycopy(this._buf, this._start, byArray, n, this._pos - this._start);
                this._pos = n + this._pos - this._start;
                this._start = n;
                this._buf = byArray;
                this._end = this._buf.length - this._postReserve;
            }
        }
    }

    public void ensureSize(int n) throws IOException {
        this.ensureSize(n, this._preReserve, this._postReserve);
    }

    public void ensureSize(int n, int n2, int n3) throws IOException {
        if (n > this._buf.length || n2 > this._preReserve || n3 > this._postReserve) {
            if (this._fixed) {
                throw new IllegalStateException("Fixed");
            }
            byte[] byArray = this._buf;
            this._buf = ByteArrayPool.getByteArray(n);
            if (this._pos > this._start) {
                System.arraycopy(byArray, this._start, this._buf, n2, this._pos - this._start);
            }
            if (!this._resized) {
                ByteArrayPool.returnByteArray(byArray);
            }
            this._end = this._buf.length - n3;
            this._preReserve = n2;
            this._start = n2;
            this._pos = n2;
            this._postReserve = n3;
        }
    }

    public void ensureSpareCapacity(int n) throws IOException {
        if (n > this.spareCapacity()) {
            if (this._pos > this._start) {
                this.flush();
            }
            this.ensureCapacity(n);
        }
    }

    public void ensureCapacity(int n) throws IOException {
        if (n > this.capacity()) {
            if (this._fixed) {
                throw new IllegalStateException("Fixed");
            }
            int n2 = (n + this._preReserve + this._postReserve + 4095) / 4096 * 4096;
            byte[] byArray = this._buf;
            this._buf = new byte[n2];
            if (this._pos > this._start) {
                System.arraycopy(byArray, this._start, this._buf, this._start, this._pos - this._start);
            }
            if (!this._resized) {
                ByteArrayPool.returnByteArray(byArray);
            }
            this._end = this._buf.length - this._postReserve;
            this._resized = true;
        }
    }
}

