/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.mortbay.html.Page;
import org.mortbay.html.TableForm;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LogSupport;

public class SessionDump
extends HttpServlet {
    private static Log log = LogFactory.getLog(SessionDump.class);
    int redirectCount = 0;
    String pageType;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        HttpSession httpSession = httpServletRequest.getSession(false);
        String string = httpServletRequest.getParameter("Action");
        String string2 = httpServletRequest.getParameter("Name");
        String string3 = httpServletRequest.getParameter("Value");
        String string4 = httpServletRequest.getParameter("MaxAge");
        String string5 = this.getURI(httpServletRequest) + "?R=" + this.redirectCount++;
        if (string.equals("New Session")) {
            httpSession = httpServletRequest.getSession(true);
        } else if (httpSession != null) {
            if (string.equals("Invalidate")) {
                httpSession.invalidate();
            } else if (string.equals("Set")) {
                httpSession.setAttribute(string2, (Object)string3);
                try {
                    int n = Integer.parseInt(string4);
                    httpSession.setMaxInactiveInterval(n);
                }
                catch (Exception exception) {
                    LogSupport.ignore(log, exception);
                }
            } else if (string.equals("Remove")) {
                httpSession.removeAttribute(string2);
            }
        }
        String string6 = httpServletResponse.encodeRedirectURL(string5);
        httpServletResponse.sendRedirect(string6);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        httpServletResponse.setContentType("text/html");
        Page page = new Page();
        HttpSession httpSession = httpServletRequest.getSession(this.getURI(httpServletRequest).indexOf("new") > 0);
        page.title("Session Dump Servlet: ");
        TableForm tableForm = new TableForm(httpServletResponse.encodeURL(this.getURI(httpServletRequest)));
        tableForm.method("POST");
        if (httpSession == null) {
            page.add("<H1>No Session</H1>");
            tableForm.addButton("Action", "New Session");
        } else {
            try {
                tableForm.addText("ID", httpSession.getId());
                tableForm.addText("State", httpSession.isNew() ? "NEW" : "Valid");
                tableForm.addText("Creation", new Date(httpSession.getCreationTime()).toString());
                tableForm.addText("Last Access", new Date(httpSession.getLastAccessedTime()).toString());
                tableForm.addText("Max Inactive", "" + httpSession.getMaxInactiveInterval());
                tableForm.addText("Context", "" + httpSession.getServletContext());
                object = httpSession.getAttributeNames();
                while (object.hasMoreElements()) {
                    String string = (String)object.nextElement();
                    String string2 = httpSession.getAttribute(string).toString();
                    tableForm.addText(string, string2);
                }
                tableForm.addTextField("Name", "Property Name", 20, "name");
                tableForm.addTextField("Value", "Property Value", 20, "value");
                tableForm.addTextField("MaxAge", "MaxAge(s)", 5, "");
                tableForm.addButtonArea();
                tableForm.addButton("Action", "Set");
                tableForm.addButton("Action", "Remove");
                tableForm.addButton("Action", "Invalidate");
                page.add(tableForm);
                tableForm = null;
                if (httpServletRequest.isRequestedSessionIdFromCookie()) {
                    page.add("<P>Turn off cookies in your browser to try url encoding<BR>");
                }
                if (httpServletRequest.isRequestedSessionIdFromURL()) {
                    page.add("<P>Turn on cookies in your browser to try cookie encoding<BR>");
                }
            }
            catch (IllegalStateException illegalStateException) {
                log.debug((Object)"EXCEPTION ", (Throwable)illegalStateException);
                page.add("<H1>INVALID Session</H1>");
                tableForm = new TableForm(this.getURI(httpServletRequest));
                tableForm.addButton("Action", "New Session");
            }
        }
        if (tableForm != null) {
            page.add(tableForm);
        }
        object = httpServletResponse.getWriter();
        page.write((Writer)object);
        ((Writer)object).flush();
    }

    public String getServletInfo() {
        return "Session Dump Servlet";
    }

    private String getURI(HttpServletRequest httpServletRequest) {
        String string = (String)httpServletRequest.getAttribute("javax.servlet.forward.request_uri");
        if (string == null) {
            string = httpServletRequest.getRequestURI();
        }
        return string;
    }
}

