/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpFields;
import org.mortbay.log.LogFactory;
import org.mortbay.util.IO;
import org.mortbay.util.LineInput;
import org.mortbay.util.LogSupport;
import org.mortbay.util.StringUtil;

public class CGI
extends HttpServlet {
    private static Log log = LogFactory.getLog(CGI.class);
    protected File _docRoot;
    protected String _path;
    protected String _cmdPrefix;
    protected EnvList _env;

    public void init() throws ServletException {
        this._env = new EnvList();
        this._cmdPrefix = this.getInitParameter("commandPrefix");
        String string = this.getInitParameter("cgibinResourceBase");
        if (string == null) {
            string = this.getServletContext().getRealPath("/");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CGI: CGI bin " + string));
        }
        if (string == null) {
            log.warn((Object)"CGI: no CGI bin !");
            throw new ServletException();
        }
        File file = new File(string);
        if (!file.exists()) {
            log.warn((Object)("CGI: CGI bin does not exist - " + file));
            throw new ServletException();
        }
        if (!file.canRead()) {
            log.warn((Object)("CGI: CGI bin is not readable - " + file));
            throw new ServletException();
        }
        if (!file.isDirectory()) {
            log.warn((Object)("CGI: CGI bin is not a directory - " + file));
            throw new ServletException();
        }
        try {
            this._docRoot = file.getCanonicalFile();
            if (log.isDebugEnabled()) {
                log.debug((Object)("CGI: CGI bin accepted - " + this._docRoot));
            }
        }
        catch (IOException iOException) {
            log.warn((Object)("CGI: CGI bin failed - " + file));
            iOException.printStackTrace();
            throw new ServletException();
        }
        this._path = this.getInitParameter("Path");
        if (log.isDebugEnabled()) {
            log.debug((Object)("CGI: PATH accepted - " + this._path));
        }
        if (this._path != null) {
            this._env.set("PATH", this._path);
        }
        Enumeration enumeration = this.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2 == null || !string2.startsWith("ENV_")) continue;
            this._env.set(string2.substring(4), this.getInitParameter(string2));
        }
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        String string2 = StringUtil.nonNull(httpServletRequest.getServletPath()) + StringUtil.nonNull(httpServletRequest.getPathInfo());
        if (log.isDebugEnabled()) {
            log.debug((Object)("CGI: req.getContextPath() : " + httpServletRequest.getContextPath()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CGI: req.getServletPath() : " + httpServletRequest.getServletPath()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CGI: req.getPathInfo()    : " + httpServletRequest.getPathInfo()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CGI: _docRoot             : " + this._docRoot));
        }
        String string3 = string = string2;
        String string4 = "";
        File file = new File(this._docRoot, string3);
        while ((string3.endsWith("/") || !file.exists()) && string3.length() >= 0) {
            int n = string3.lastIndexOf(47);
            string3 = string3.substring(0, n);
            string4 = string.substring(n, string.length());
            file = new File(this._docRoot, string3);
        }
        if (string3.length() == 0 || !file.exists() || !file.getCanonicalPath().equals(file.getAbsolutePath()) || file.isDirectory()) {
            httpServletResponse.sendError(404);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("CGI: script is " + file));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("CGI: pathInfo is " + string4));
            }
            this.exec(file, string4, httpServletRequest, httpServletResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec(File file, String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Object object;
        String string2;
        String string3 = file.toString();
        File file2 = file.getParentFile();
        if (log.isDebugEnabled()) {
            log.debug((Object)("CGI: execing: " + string3));
        }
        EnvList envList = new EnvList(this._env);
        envList.set("AUTH_TYPE", httpServletRequest.getAuthType());
        envList.set("CONTENT_LENGTH", Integer.toString(httpServletRequest.getContentLength()));
        envList.set("CONTENT_TYPE", httpServletRequest.getContentType());
        envList.set("GATEWAY_INTERFACE", "CGI/1.1");
        envList.set("PATH_INFO", string);
        envList.set("PATH_TRANSLATED", httpServletRequest.getPathTranslated());
        envList.set("QUERY_STRING", httpServletRequest.getQueryString());
        envList.set("REMOTE_ADDR", httpServletRequest.getRemoteAddr());
        envList.set("REMOTE_HOST", httpServletRequest.getRemoteHost());
        envList.set("REMOTE_USER", httpServletRequest.getRemoteUser());
        envList.set("REQUEST_METHOD", httpServletRequest.getMethod());
        String string4 = httpServletRequest.getRequestURI().substring(0, httpServletRequest.getRequestURI().length() - string.length());
        envList.set("SCRIPT_NAME", string4);
        envList.set("SCRIPT_FILENAME", this.getServletContext().getRealPath(string4));
        envList.set("SERVER_NAME", httpServletRequest.getServerName());
        envList.set("SERVER_PORT", Integer.toString(httpServletRequest.getServerPort()));
        envList.set("SERVER_PROTOCOL", httpServletRequest.getProtocol());
        envList.set("SERVER_SOFTWARE", this.getServletContext().getServerInfo());
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            object = httpServletRequest.getHeader(string2);
            envList.set("HTTP_" + string2.toUpperCase().replace('-', '_'), (String)object);
        }
        envList.set("HTTPS", httpServletRequest.isSecure() ? "ON" : "OFF");
        string2 = string3;
        if (string2.indexOf(" ") >= 0) {
            string2 = "\"" + string2 + "\"";
        }
        if (this._cmdPrefix != null) {
            string2 = this._cmdPrefix + " " + string2;
        }
        object = file2 == null ? Runtime.getRuntime().exec(string2, envList.getEnvArray()) : Runtime.getRuntime().exec(string2, envList.getEnvArray(), file2);
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        OutputStream outputStream = ((Process)object).getOutputStream();
        final int n = httpServletRequest.getContentLength();
        new Thread(new Runnable((InputStream)servletInputStream, outputStream){
            private final /* synthetic */ InputStream val$inFromReq;
            private final /* synthetic */ OutputStream val$outToCgi;
            {
                this.val$inFromReq = inputStream;
                this.val$outToCgi = outputStream;
            }

            public void run() {
                try {
                    if (n > 0) {
                        IO.copy(this.val$inFromReq, this.val$outToCgi, (long)n);
                    }
                    this.val$outToCgi.close();
                }
                catch (IOException iOException) {
                    LogSupport.ignore(log, iOException);
                }
            }
        }).start();
        try {
            LineInput lineInput = new LineInput(((Process)object).getInputStream());
            HttpFields httpFields = new HttpFields();
            httpFields.read(lineInput);
            String string5 = "Status";
            String string6 = httpFields.get("Location");
            String string7 = httpFields.get(string5);
            if (string7 != null) {
                log.debug((Object)"Found a Status header - setting status on response");
                httpFields.remove(string5);
                int n2 = string7.indexOf(32);
                if (n2 > 0) {
                    string7 = string7.substring(0, n2);
                }
                httpServletResponse.setStatus(Integer.parseInt(string7));
            }
            Iterator iterator = httpFields.iterator();
            while (iterator.hasNext()) {
                HttpFields.Entry entry = (HttpFields.Entry)iterator.next();
                httpServletResponse.addHeader(entry.getKey(), entry.getValue());
            }
            if (string7 == null && string6 != null) {
                if (!string6.startsWith("http:/") && !string6.startsWith("https:/")) {
                    httpServletResponse.sendRedirect(string6);
                } else {
                    httpServletResponse.setStatus(302);
                }
            }
            IO.copy(lineInput, (OutputStream)httpServletResponse.getOutputStream());
            ((Process)object).waitFor();
            int n3 = ((Process)object).exitValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("CGI: p.exitValue(): " + n3));
            }
            if (0 != n3) {
                log.warn((Object)("Non-zero exit status (" + n3 + ") from CGI program: " + string3));
                if (!httpServletResponse.isCommitted()) {
                    httpServletResponse.sendError(500, "Failed to exec CGI");
                }
            }
        }
        catch (IOException iOException) {
            log.debug((Object)"CGI: Client closed connection!");
        }
        catch (InterruptedException interruptedException) {
            log.debug((Object)"CGI: interrupted!");
        }
        finally {
            ((Process)object).destroy();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CGI: Finished exec: " + object));
        }
    }

    private static class EnvList {
        private Map envMap;

        EnvList() {
            this.envMap = new HashMap();
        }

        EnvList(EnvList envList) {
            this.envMap = new HashMap(envList.envMap);
        }

        public void set(String string, String string2) {
            this.envMap.put(string, string + "=" + StringUtil.nonNull(string2));
        }

        public String[] getEnvArray() {
            return this.envMap.values().toArray(new String[this.envMap.size()]);
        }
    }
}

