/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpContext;
import org.mortbay.http.PathMap;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.JSR154Filter;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletHttpContext;
import org.mortbay.jetty.servlet.ServletHttpRequest;
import org.mortbay.jetty.servlet.ServletHttpResponse;
import org.mortbay.jetty.servlet.SessionManager;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiException;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;

public class WebApplicationHandler
extends ServletHandler {
    private static Log log = LogFactory.getLog(WebApplicationHandler.class);
    private Map _filterMap = new HashMap();
    private List _pathFilters = new ArrayList();
    private List _filters = new ArrayList();
    private MultiMap _servletFilterMap = new MultiMap();
    private boolean _acceptRanges = true;
    private boolean _filterChainsCached = true;
    private transient WebApplicationContext _webApplicationContext;
    protected transient Object _requestListeners;
    protected transient Object _requestAttributeListeners;
    protected transient Object _sessionListeners;
    protected transient Object _contextAttributeListeners;
    protected transient FilterHolder jsr154FilterHolder;
    protected transient JSR154Filter jsr154Filter;
    protected transient HashMap[] _chainCache;
    protected transient HashMap[] _namedChainCache;

    public boolean isAcceptRanges() {
        return this._acceptRanges;
    }

    public void setAcceptRanges(boolean bl) {
        this._acceptRanges = bl;
    }

    public JSR154Filter getJsr154Filter() {
        return this.jsr154Filter;
    }

    public FilterHolder defineFilter(String string, String string2) {
        FilterHolder filterHolder = this.newFilterHolder(string, string2);
        this.addFilterHolder(filterHolder);
        return filterHolder;
    }

    protected FilterHolder newFilterHolder(String string, String string2) {
        return new FilterHolder(this, string, string2);
    }

    public void addFilterHolder(FilterHolder filterHolder) {
        this._filterMap.put(filterHolder.getName(), filterHolder);
        this._filters.add(filterHolder);
        this.addComponent(filterHolder);
    }

    public FilterHolder getFilter(String string) {
        return (FilterHolder)this._filterMap.get(string);
    }

    public FilterHolder addFilterPathMapping(String string, String string2, int n) {
        FilterHolder filterHolder = (FilterHolder)this._filterMap.get(string2);
        if (filterHolder == null) {
            throw new IllegalArgumentException("unknown filter: " + string2);
        }
        FilterMapping filterMapping = new FilterMapping(string, filterHolder, n);
        this._pathFilters.add(filterMapping);
        return filterHolder;
    }

    public FilterHolder addFilterServletMapping(String string, String string2, int n) {
        FilterHolder filterHolder = (FilterHolder)this._filterMap.get(string2);
        if (filterHolder == null) {
            throw new IllegalArgumentException("Unknown filter :" + string2);
        }
        this._servletFilterMap.add(string, new FilterMapping(null, filterHolder, n));
        return filterHolder;
    }

    public List getFilters() {
        return this._filters;
    }

    public synchronized void addEventListener(EventListener eventListener) throws IllegalArgumentException {
        if (eventListener instanceof HttpSessionActivationListener || eventListener instanceof HttpSessionAttributeListener || eventListener instanceof HttpSessionBindingListener || eventListener instanceof HttpSessionListener) {
            if (this._sessionManager != null) {
                this._sessionManager.addEventListener(eventListener);
            }
            this._sessionListeners = LazyList.add(this._sessionListeners, eventListener);
        }
        if (eventListener instanceof ServletRequestListener) {
            this._requestListeners = LazyList.add(this._requestListeners, eventListener);
        }
        if (eventListener instanceof ServletRequestAttributeListener) {
            this._requestAttributeListeners = LazyList.add(this._requestAttributeListeners, eventListener);
        }
        if (eventListener instanceof ServletContextAttributeListener) {
            this._contextAttributeListeners = LazyList.add(this._contextAttributeListeners, eventListener);
        }
        super.addEventListener(eventListener);
    }

    public synchronized void removeEventListener(EventListener eventListener) {
        if (this._sessionManager != null) {
            this._sessionManager.removeEventListener(eventListener);
        }
        this._sessionListeners = LazyList.remove(this._sessionListeners, eventListener);
        this._requestListeners = LazyList.remove(this._requestListeners, eventListener);
        this._requestAttributeListeners = LazyList.remove(this._requestAttributeListeners, eventListener);
        this._contextAttributeListeners = LazyList.remove(this._contextAttributeListeners, eventListener);
        super.removeEventListener(eventListener);
    }

    public void setSessionManager(SessionManager sessionManager) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        SessionManager sessionManager2 = this.getSessionManager();
        if (this.getHttpContext() != null) {
            EventListener eventListener;
            Iterator iterator;
            if (sessionManager2 != null && sessionManager2 != sessionManager && this._sessionListeners != null) {
                iterator = LazyList.iterator(this._sessionListeners);
                while (iterator.hasNext()) {
                    eventListener = (EventListener)iterator.next();
                    this._sessionManager.removeEventListener(eventListener);
                }
            }
            if (sessionManager != null && sessionManager2 != sessionManager && this._sessionListeners != null) {
                iterator = LazyList.iterator(this._sessionListeners);
                while (iterator.hasNext()) {
                    eventListener = (EventListener)iterator.next();
                    sessionManager.addEventListener(eventListener);
                }
            }
        }
        super.setSessionManager(sessionManager);
    }

    protected synchronized void doStart() throws Exception {
        super.doStart();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Path Filters: " + this._pathFilters));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Servlet Filters: " + this._servletFilterMap));
        }
        if (this.getHttpContext() instanceof WebApplicationContext) {
            this._webApplicationContext = (WebApplicationContext)this.getHttpContext();
        }
        if (this._filterChainsCached) {
            this._chainCache = this.getChainCache();
            this._namedChainCache = this.getChainCache();
        }
    }

    private HashMap[] getChainCache() {
        HashMap[] hashMapArray = new HashMap[9];
        hashMapArray[1] = new HashMap();
        hashMapArray[2] = new HashMap();
        hashMapArray[4] = new HashMap();
        hashMapArray[8] = new HashMap();
        return hashMapArray;
    }

    public void initializeServlets() throws Exception {
        MultiException multiException = new MultiException();
        Iterator iterator = this._filters.iterator();
        while (iterator.hasNext()) {
            FilterHolder filterHolder = (FilterHolder)iterator.next();
            try {
                filterHolder.start();
            }
            catch (Exception exception) {
                multiException.add(exception);
            }
        }
        try {
            super.initializeServlets();
        }
        catch (Exception exception) {
            multiException.add(exception);
        }
        this.jsr154FilterHolder = this.getFilter("jsr154");
        if (this.jsr154FilterHolder != null) {
            this.jsr154Filter = (JSR154Filter)this.jsr154FilterHolder.getFilter();
        }
        log.debug((Object)("jsr154filter=" + this.jsr154Filter));
        if (LazyList.size(this._requestAttributeListeners) > 0 || LazyList.size(this._requestListeners) > 0) {
            if (this.jsr154Filter == null) {
                log.warn((Object)"Filter jsr154 not defined for RequestAttributeListeners");
            } else {
                this.jsr154Filter.setRequestAttributeListeners(this._requestAttributeListeners);
                this.jsr154Filter.setRequestListeners(this._requestListeners);
            }
        }
        multiException.ifExceptionThrow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doStop() throws Exception {
        try {
            super.doStop();
            int n = this._filters.size();
            while (n-- > 0) {
                FilterHolder filterHolder = (FilterHolder)this._filters.get(n);
                filterHolder.stop();
            }
            Object var4_3 = null;
            this._webApplicationContext = null;
            this._sessionListeners = null;
            this._requestListeners = null;
            this._requestAttributeListeners = null;
            this._contextAttributeListeners = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._webApplicationContext = null;
            this._sessionListeners = null;
            this._requestListeners = null;
            this._requestAttributeListeners = null;
            this._contextAttributeListeners = null;
            throw throwable;
        }
    }

    public String getErrorPage(int n, ServletHttpRequest servletHttpRequest) {
        Class<Object> clazz;
        String string = null;
        if (ServletException.class.equals(clazz = (Class)servletHttpRequest.getAttribute("javax.servlet.error.exception_type")) && (string = this._webApplicationContext.getErrorPage(clazz.getName())) == null) {
            Throwable throwable = (Throwable)servletHttpRequest.getAttribute("javax.servlet.error.exception");
            while (throwable instanceof ServletException) {
                throwable = ((ServletException)throwable).getRootCause();
            }
            if (throwable != null) {
                clazz = throwable.getClass();
            }
        }
        if (string == null && clazz != null) {
            while (string == null && clazz != null && this._webApplicationContext != null) {
                string = this._webApplicationContext.getErrorPage(clazz.getName());
                clazz = clazz.getSuperclass();
            }
            if (string == null) {
                // empty if block
            }
        }
        if (string == null && this._webApplicationContext != null) {
            string = this._webApplicationContext.getErrorPage(TypeUtil.toString(n));
        }
        return string;
    }

    protected void dispatch(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletHolder servletHolder, int n) throws ServletException, UnavailableException, IOException {
        Object object;
        if (n == 1) {
            object = (ServletHttpRequest)httpServletRequest;
            ServletHttpResponse servletHttpResponse = (ServletHttpResponse)httpServletResponse;
            if (StringUtil.startsWithIgnoreCase(string, "/web-inf") || StringUtil.startsWithIgnoreCase(string, "/meta-inf")) {
                httpServletResponse.sendError(404);
                return;
            }
            if (!this.getHttpContext().checkSecurityConstraints(string, ((ServletHttpRequest)object).getHttpRequest(), servletHttpResponse.getHttpResponse())) {
                return;
            }
        } else {
            object = this.getHttpContext();
            if (object != null && object instanceof ServletHttpContext && string != null && string.endsWith("j_security_check")) {
                ServletHttpRequest servletHttpRequest = (ServletHttpRequest)((HttpContext)object).getHttpConnection().getRequest().getWrapper();
                ServletHttpResponse servletHttpResponse = servletHttpRequest.getServletHttpResponse();
                ServletHttpContext servletHttpContext = (ServletHttpContext)object;
                if (!servletHttpContext.jSecurityCheck(string, servletHttpRequest.getHttpRequest(), servletHttpResponse.getHttpResponse())) {
                    return;
                }
            }
        }
        object = null;
        object = string != null ? this.getChainForPath(n, string, servletHolder) : this.getChainForName(n, servletHolder);
        if (log.isDebugEnabled()) {
            log.debug((Object)("chain=" + object));
        }
        if (object != null) {
            object.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        } else if (servletHolder != null) {
            servletHolder.handle((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        } else {
            this.notFound(httpServletRequest, httpServletResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilterChain getChainForName(int n, ServletHolder servletHolder) {
        Object object;
        Object object2;
        if (servletHolder == null) {
            throw new IllegalStateException("Named dispatch must be to an explicitly named servlet");
        }
        if (this._filterChainsCached) {
            object2 = this;
            synchronized (object2) {
                if (this._namedChainCache[n].containsKey(servletHolder.getName())) {
                    return (FilterChain)this._namedChainCache[n].get(servletHolder.getName());
                }
            }
        }
        object2 = null;
        if (this.jsr154Filter != null) {
            object2 = LazyList.add(object2, this.jsr154FilterHolder);
        }
        if (this._servletFilterMap.size() > 0) {
            object = this._servletFilterMap.get(servletHolder.getName());
            for (int i = 0; i < LazyList.size(object); ++i) {
                FilterMapping filterMapping = (FilterMapping)LazyList.get(object, i);
                if (!filterMapping.appliesTo(null, n)) continue;
                object2 = LazyList.add(object2, filterMapping.getHolder());
            }
        }
        object = null;
        if (this._filterChainsCached) {
            WebApplicationHandler webApplicationHandler = this;
            synchronized (webApplicationHandler) {
                if (LazyList.size(object2) > 0) {
                    object = new CachedChain(object2, servletHolder);
                }
                this._namedChainCache[n].put(servletHolder.getName(), object);
            }
        } else if (LazyList.size(object2) > 0) {
            object = new Chain(object2, servletHolder);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilterChain getChainForPath(int n, String string, ServletHolder servletHolder) {
        Object object;
        if (this._filterChainsCached) {
            object = this;
            synchronized (object) {
                if (this._chainCache[n].containsKey(string)) {
                    return (FilterChain)this._chainCache[n].get(string);
                }
            }
        }
        object = null;
        for (int i = 0; i < this._pathFilters.size(); ++i) {
            FilterMapping filterMapping = (FilterMapping)this._pathFilters.get(i);
            if (!filterMapping.appliesTo(string, n)) continue;
            object = LazyList.add(object, filterMapping.getHolder());
        }
        if (servletHolder != null && this._servletFilterMap.size() > 0) {
            Object object2 = this._servletFilterMap.get(servletHolder.getName());
            for (int i = 0; i < LazyList.size(object2); ++i) {
                FilterMapping filterMapping = (FilterMapping)LazyList.get(object2, i);
                if (!filterMapping.appliesTo(null, n)) continue;
                object = LazyList.add(object, filterMapping.getHolder());
            }
        }
        Object object3 = null;
        if (this._filterChainsCached) {
            WebApplicationHandler webApplicationHandler = this;
            synchronized (webApplicationHandler) {
                if (LazyList.size(object) > 0) {
                    object3 = new CachedChain(object, servletHolder);
                }
                this._chainCache[n].put(string, object3);
            }
        } else if (LazyList.size(object) > 0) {
            object3 = new Chain(object, servletHolder);
        }
        return object3;
    }

    public synchronized void setContextAttribute(String string, Object object) {
        Object object2 = super.getContextAttribute(string);
        super.setContextAttribute(string, object);
        if (this._contextAttributeListeners != null) {
            ServletContextAttributeEvent servletContextAttributeEvent = new ServletContextAttributeEvent(this.getServletContext(), string, object2 != null ? object2 : object);
            for (int i = 0; i < LazyList.size(this._contextAttributeListeners); ++i) {
                ServletContextAttributeListener servletContextAttributeListener = (ServletContextAttributeListener)LazyList.get(this._contextAttributeListeners, i);
                if (object2 == null) {
                    servletContextAttributeListener.attributeAdded(servletContextAttributeEvent);
                    continue;
                }
                if (object == null) {
                    servletContextAttributeListener.attributeRemoved(servletContextAttributeEvent);
                    continue;
                }
                servletContextAttributeListener.attributeReplaced(servletContextAttributeEvent);
            }
        }
    }

    public synchronized void removeContextAttribute(String string) {
        Object object = super.getContextAttribute(string);
        super.removeContextAttribute(string);
        if (object != null && this._contextAttributeListeners != null) {
            ServletContextAttributeEvent servletContextAttributeEvent = new ServletContextAttributeEvent(this.getServletContext(), string, object);
            for (int i = 0; i < LazyList.size(this._contextAttributeListeners); ++i) {
                ServletContextAttributeListener servletContextAttributeListener = (ServletContextAttributeListener)LazyList.get(this._contextAttributeListeners, i);
                servletContextAttributeListener.attributeRemoved(servletContextAttributeEvent);
            }
        }
    }

    public boolean isFilterChainsCached() {
        return this._filterChainsCached;
    }

    public void setFilterChainsCached(boolean bl) {
        this._filterChainsCached = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addComponent(Object object) {
        if (this._filterChainsCached && this.isStarted()) {
            WebApplicationHandler webApplicationHandler = this;
            synchronized (webApplicationHandler) {
                for (int i = 0; i < this._chainCache.length; ++i) {
                    if (this._chainCache[i] == null) continue;
                    this._chainCache[i].clear();
                }
            }
        }
        super.addComponent(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeComponent(Object object) {
        if (this._filterChainsCached && this.isStarted()) {
            WebApplicationHandler webApplicationHandler = this;
            synchronized (webApplicationHandler) {
                for (int i = 0; i < this._chainCache.length; ++i) {
                    if (this._chainCache[i] == null) continue;
                    this._chainCache[i].clear();
                }
            }
        }
        super.removeComponent(object);
    }

    public void destroy() {
        Iterator iterator = this._filterMap.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            iterator.remove();
            this.removeComponent(v);
        }
    }

    public static void main(String[] stringArray) {
        ServletHandler servletHandler = new ServletHandler();
        ServletHolder servletHolder = servletHandler.addServlet("/mPath", "wicket.protocol.http.WicketServlet");
        servletHolder.getServletContext().setAttribute("webApplication", (Object)"mWebApplication");
        servletHolder.getServletContext().setAttribute("applicationContext", (Object)"mApplicationContext");
        WebApplicationHandler webApplicationHandler = new WebApplicationHandler();
        ServletHolder servletHolder2 = webApplicationHandler.addServlet("/mpath", "wicket.protocol.http.WicketServlet");
        servletHolder2.getServletContext().setAttribute("webApplication", (Object)"mWebApplication");
        servletHolder2.getServletContext().setAttribute("applicationContext", (Object)"mApplicationContext");
    }

    private class CachedChain
    implements FilterChain {
        FilterHolder _filterHolder;
        ServletHolder _servletHolder;
        CachedChain _next;

        CachedChain(Object object, ServletHolder servletHolder) {
            if (LazyList.size(object) > 0) {
                this._filterHolder = (FilterHolder)LazyList.get(object, 0);
                object = LazyList.remove(object, 0);
                this._next = new CachedChain(object, servletHolder);
            } else {
                this._servletHolder = servletHolder;
            }
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
            if (this._filterHolder != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("call filter " + this._filterHolder));
                }
                Filter filter = this._filterHolder.getFilter();
                filter.doFilter(servletRequest, servletResponse, (FilterChain)this._next);
                return;
            }
            if (this._servletHolder != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("call servlet " + this._servletHolder));
                }
                this._servletHolder.handle(servletRequest, servletResponse);
            } else {
                WebApplicationHandler.this.notFound((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
            }
        }

        public String toString() {
            if (this._filterHolder != null) {
                return this._filterHolder + "->" + this._next.toString();
            }
            if (this._servletHolder != null) {
                return this._servletHolder.toString();
            }
            return "null";
        }
    }

    private class Chain
    implements FilterChain {
        int _filter = 0;
        Object _filters;
        ServletHolder _servletHolder;

        Chain(Object object, ServletHolder servletHolder) {
            this._filters = object;
            this._servletHolder = servletHolder;
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("doFilter " + this._filter));
            }
            if (this._filter < LazyList.size(this._filters)) {
                FilterHolder filterHolder = (FilterHolder)LazyList.get(this._filters, this._filter++);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("call filter " + filterHolder));
                }
                Filter filter = filterHolder.getFilter();
                filter.doFilter(servletRequest, servletResponse, (FilterChain)this);
                return;
            }
            if (this._servletHolder != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("call servlet " + this._servletHolder));
                }
                this._servletHolder.handle(servletRequest, servletResponse);
            } else {
                WebApplicationHandler.this.notFound((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < LazyList.size(this._filters); ++i) {
                stringBuffer.append(LazyList.get(this._filters, i).toString());
                stringBuffer.append("->");
            }
            stringBuffer.append(this._servletHolder);
            return stringBuffer.toString();
        }
    }

    private static class FilterMapping {
        private String _pathSpec;
        private FilterHolder _holder;
        private int _dispatches;

        FilterMapping(String string, FilterHolder filterHolder, int n) {
            this._pathSpec = string;
            this._holder = filterHolder;
            this._dispatches = n;
        }

        FilterHolder getHolder() {
            return this._holder;
        }

        boolean appliesTo(String string, int n) {
            boolean bl = ((this._dispatches & n) != 0 || this._dispatches == 0 && n == 1) && (this._pathSpec == null || PathMap.match(this._pathSpec, string, true));
            return bl;
        }
    }
}

