/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpOutputStream;
import org.mortbay.log.LogFactory;
import org.mortbay.util.IO;
import org.mortbay.util.LogSupport;

class ServletWriter
extends PrintWriter {
    private static Log log = LogFactory.getLog(ServletWriter.class);
    String encoding = null;
    OutputStream os = null;
    boolean written = false;

    ServletWriter(OutputStream outputStream) throws IOException {
        super(outputStream instanceof HttpOutputStream ? ((HttpOutputStream)outputStream).getWriter(null) : new OutputStreamWriter(outputStream));
        this.os = outputStream;
    }

    ServletWriter(OutputStream outputStream, String string) throws IOException {
        super(outputStream instanceof HttpOutputStream ? ((HttpOutputStream)outputStream).getWriter(string) : new OutputStreamWriter(outputStream, string));
        this.os = outputStream;
        this.encoding = string;
    }

    public void disable() {
        this.out = IO.getNullWriter();
    }

    public void reset() {
        try {
            this.out = IO.getNullWriter();
            super.flush();
            this.out = new OutputStreamWriter(this.os, this.encoding);
            this.written = false;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.fatal((Object)unsupportedEncodingException);
            System.exit(1);
        }
    }

    public boolean isWritten() {
        return this.written;
    }

    public void print(boolean bl) {
        this.written = true;
        super.print(bl);
    }

    public void print(char c) {
        this.written = true;
        super.print(c);
    }

    public void print(char[] cArray) {
        this.written = true;
        super.print(cArray);
    }

    public void print(double d) {
        this.written = true;
        super.print(d);
    }

    public void print(float f) {
        this.written = true;
        super.print(f);
    }

    public void print(int n) {
        this.written = true;
        super.print(n);
    }

    public void print(long l) {
        this.written = true;
        super.print(l);
    }

    public void print(Object object) {
        this.written = true;
        super.print(object);
    }

    public void print(String string) {
        this.written = true;
        super.print(string);
    }

    public void println() {
        this.written = true;
        super.println();
    }

    public void println(boolean bl) {
        this.written = true;
        super.println(bl);
    }

    public void println(char c) {
        this.written = true;
        super.println(c);
    }

    public void println(char[] cArray) {
        this.written = true;
        super.println(cArray);
    }

    public void println(double d) {
        this.written = true;
        super.println(d);
    }

    public void println(float f) {
        this.written = true;
        super.println(f);
    }

    public void println(int n) {
        this.written = true;
        super.println(n);
    }

    public void println(long l) {
        this.written = true;
        super.println(l);
    }

    public void println(Object object) {
        this.written = true;
        super.println(object);
    }

    public void println(String string) {
        this.written = true;
        super.println(string);
    }

    public void write(int n) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(n);
        }
        catch (IOException iOException) {
            LogSupport.ignore(log, iOException);
            this.setError();
        }
    }

    public void write(char[] cArray, int n, int n2) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            LogSupport.ignore(log, iOException);
            this.setError();
        }
    }

    public void write(char[] cArray) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(cArray, 0, cArray.length);
        }
        catch (IOException iOException) {
            LogSupport.ignore(log, iOException);
            this.setError();
        }
    }

    public void write(String string, int n, int n2) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(string, n, n2);
        }
        catch (IOException iOException) {
            LogSupport.ignore(log, iOException);
            this.setError();
        }
    }

    public void write(String string) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(string, 0, string.length());
        }
        catch (IOException iOException) {
            LogSupport.ignore(log, iOException);
            this.setError();
        }
    }
}

