/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpOutputStream;
import org.mortbay.http.HttpResponse;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletHttpContext;
import org.mortbay.jetty.servlet.ServletHttpRequest;
import org.mortbay.jetty.servlet.ServletOut;
import org.mortbay.jetty.servlet.ServletWriter;
import org.mortbay.jetty.servlet.SessionManager;
import org.mortbay.log.LogFactory;
import org.mortbay.util.IO;
import org.mortbay.util.LogSupport;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.URI;

public class ServletHttpResponse
implements HttpServletResponse {
    private static Log log = LogFactory.getLog(ServletHttpResponse.class);
    public static final int DISABLED = -1;
    public static final int NO_OUT = 0;
    public static final int OUTPUTSTREAM_OUT = 1;
    public static final int WRITER_OUT = 2;
    private static ServletWriter __nullServletWriter;
    private static ServletOut __nullServletOut;
    private HttpResponse _httpResponse;
    private ServletHttpRequest _servletHttpRequest;
    private int _outputState = 0;
    private ServletOut _out = null;
    private ServletWriter _writer = null;
    private HttpSession _session = null;
    private boolean _noSession = false;
    private Locale _locale = null;
    private boolean _charEncodingSetInContentType = false;

    public ServletHttpResponse(ServletHttpRequest servletHttpRequest, HttpResponse httpResponse) {
        this._servletHttpRequest = servletHttpRequest;
        this._servletHttpRequest.setServletHttpResponse(this);
        this._httpResponse = httpResponse;
    }

    void recycle() {
        this._outputState = 0;
        this._out = null;
        this._writer = null;
        this._session = null;
        this._noSession = false;
        this._locale = null;
        this._charEncodingSetInContentType = false;
    }

    int getOutputState() {
        return this._outputState;
    }

    void setOutputState(int n) throws IOException {
        if (n < 0) {
            this._outputState = -1;
            if (this._writer != null) {
                this._writer.disable();
            }
            this._writer = null;
            if (this._out != null) {
                this._out.disable();
            }
            this._out = null;
        } else {
            this._outputState = n;
        }
    }

    HttpResponse getHttpResponse() {
        return this._httpResponse;
    }

    void commit() throws IOException {
        if (this._writer != null && this._writer.isWritten()) {
            this._writer.flush();
        } else {
            this._httpResponse.commit();
        }
    }

    void complete() throws IOException {
        this._httpResponse.completing();
        this.commit();
        this.setOutputState(-1);
    }

    public boolean isCommitted() {
        return this._httpResponse.isCommitted();
    }

    boolean isDirty() {
        return this._httpResponse.isDirty();
    }

    public void setBufferSize(int n) {
        HttpOutputStream httpOutputStream = (HttpOutputStream)this._httpResponse.getOutputStream();
        if (httpOutputStream.isWritten() || this._writer != null && this._writer.isWritten()) {
            throw new IllegalStateException("Output written");
        }
        httpOutputStream.setBufferSize(n);
    }

    public int getBufferSize() {
        return ((HttpOutputStream)this._httpResponse.getOutputStream()).getBufferSize();
    }

    public void flushBuffer() throws IOException {
        if (((HttpOutputStream)this._httpResponse.getOutputStream()).isClosed()) {
            return;
        }
        if (this._writer != null) {
            this._writer.flush();
        }
        if (this._out != null) {
            this._out.flush();
        }
        if (this._writer == null && this._out == null) {
            this._httpResponse.getOutputStream().flush();
        }
        if (!this._httpResponse.isCommitted()) {
            this._httpResponse.commit();
        }
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        ((HttpOutputStream)this._httpResponse.getOutputStream()).resetBuffer();
        if (this._writer != null) {
            this._writer.reset();
        }
    }

    public void reset() {
        this.resetBuffer();
        this._httpResponse.reset();
    }

    public void setLocale(Locale locale) {
        if (locale == null || this.isCommitted()) {
            return;
        }
        this._locale = locale;
        this.setHeader("Content-Language", locale.toString().replace('_', '-'));
        if (this._outputState == 0) {
            String string;
            HttpContext httpContext;
            String string2 = this._httpResponse.getField("Content-Type");
            if (string2 == null) {
                string2 = "application/octet-stream";
            }
            if ((httpContext = this._servletHttpRequest.getServletHandler().getHttpContext()) instanceof ServletHttpContext && (string = ((ServletHttpContext)httpContext).getLocaleEncoding(locale)) != null && string.length() > 0) {
                int n = string2.indexOf(59);
                if (n < 0) {
                    string2 = string2 + "; charset=" + string;
                } else if (!this._charEncodingSetInContentType) {
                    string2 = string2.substring(0, n) + "; charset=" + string;
                }
                this.setHeader("Content-Type", string2);
            }
        }
    }

    public Locale getLocale() {
        if (this._locale == null) {
            return Locale.getDefault();
        }
        return this._locale;
    }

    public void addCookie(Cookie cookie) {
        this._httpResponse.addSetCookie(cookie);
    }

    public boolean containsHeader(String string) {
        return this._httpResponse.containsField(string);
    }

    public String encodeURL(String string) {
        if (this._servletHttpRequest == null || this._servletHttpRequest.isRequestedSessionIdFromCookie() && this._servletHttpRequest.getServletHandler().isUsingCookies()) {
            return string;
        }
        if (this._session == null && !this._noSession) {
            this._session = this._servletHttpRequest.getSession(false);
            boolean bl = this._noSession = this._session == null;
        }
        if (this._session == null || string == null) {
            return string;
        }
        String string2 = this._session.getId();
        if (string2 == null) {
            return string;
        }
        int n = string.indexOf(SessionManager.__SessionUrlPrefix);
        if (n != -1) {
            int n2 = string.indexOf("?", n);
            if (n2 < 0) {
                n2 = string.indexOf("#", n);
            }
            if (n2 <= n) {
                return string.substring(0, n + SessionManager.__SessionUrlPrefix.length()) + string2;
            }
            return string.substring(0, n + SessionManager.__SessionUrlPrefix.length()) + string2 + string.substring(n2);
        }
        int n3 = string.indexOf(63);
        if (n3 < 0) {
            n3 = string.indexOf(35);
        }
        if (n3 < 0) {
            return string + SessionManager.__SessionUrlPrefix + string2;
        }
        return string.substring(0, n3) + SessionManager.__SessionUrlPrefix + string2 + string.substring(n3);
    }

    public String encodeRedirectURL(String string) {
        return this.encodeURL(string);
    }

    public String encodeUrl(String string) {
        return this.encodeURL(string);
    }

    public String encodeRedirectUrl(String string) {
        return this.encodeRedirectURL(string);
    }

    public void sendError(int n, String string) throws IOException {
        String string2 = this._servletHttpRequest.getServletHandler().getErrorPage(n, this._servletHttpRequest);
        this.resetBuffer();
        if (string2 == null) {
            this._httpResponse.sendError(n, string);
        } else {
            ServletHolder servletHolder;
            this._httpResponse.setStatus(n, string);
            if (string == null && (string = (String)HttpResponse.__statusMsg.get(TypeUtil.newInteger(n))) == null) {
                string = "" + n;
            }
            if ((servletHolder = this._servletHttpRequest.getServletHolder()) != null) {
                this._servletHttpRequest.setAttribute("javax.servlet.error.servlet_name", servletHolder.getName());
            }
            this._servletHttpRequest.setAttribute("javax.servlet.error.request_uri", this._servletHttpRequest.getRequestURI());
            this._servletHttpRequest.setAttribute("javax.servlet.error.status_code", new Integer(n));
            this._servletHttpRequest.setAttribute("javax.servlet.error.message", string);
            RequestDispatcher requestDispatcher = this._servletHttpRequest.getServletHandler().getServletContext().getRequestDispatcher(string2);
            try {
                ((Dispatcher)requestDispatcher).error((ServletRequest)this._servletHttpRequest, (ServletResponse)this);
            }
            catch (ServletException servletException) {
                log.warn((Object)"EXCEPTION ", (Throwable)servletException);
                this._httpResponse.sendError(n, string);
            }
        }
        this.complete();
    }

    public void sendError(int n) throws IOException {
        this.sendError(n, null);
    }

    public void sendRedirect(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (!URI.hasScheme(string)) {
            StringBuffer stringBuffer = this._servletHttpRequest.getHttpRequest().getRootURL();
            if (string.startsWith("/")) {
                stringBuffer.append(URI.canonicalPath(string));
            } else {
                String string2 = this._servletHttpRequest.getRequestURI();
                String string3 = string2.endsWith("/") ? string2 : URI.parentPath(string2);
                string = URI.canonicalPath(URI.addPaths(string3, string));
                if (!string.startsWith("/")) {
                    stringBuffer.append('/');
                }
                stringBuffer.append(string);
            }
            string = stringBuffer.toString();
        }
        this.resetBuffer();
        this._httpResponse.setField("Location", string);
        this._httpResponse.setStatus(302);
        this.complete();
    }

    public void setDateHeader(String string, long l) {
        try {
            this._httpResponse.setDateField(string, l);
        }
        catch (IllegalStateException illegalStateException) {
            LogSupport.ignore(log, illegalStateException);
        }
    }

    public void setHeader(String string, String string2) {
        try {
            this._httpResponse.setField(string, string2);
        }
        catch (IllegalStateException illegalStateException) {
            LogSupport.ignore(log, illegalStateException);
        }
    }

    public void setIntHeader(String string, int n) {
        try {
            this._httpResponse.setIntField(string, n);
        }
        catch (IllegalStateException illegalStateException) {
            LogSupport.ignore(log, illegalStateException);
        }
    }

    public void addDateHeader(String string, long l) {
        try {
            this._httpResponse.addDateField(string, l);
        }
        catch (IllegalStateException illegalStateException) {
            LogSupport.ignore(log, illegalStateException);
        }
    }

    public void addHeader(String string, String string2) {
        try {
            this._httpResponse.addField(string, string2);
        }
        catch (IllegalStateException illegalStateException) {
            LogSupport.ignore(log, illegalStateException);
        }
    }

    public void addIntHeader(String string, int n) {
        try {
            this._httpResponse.addIntField(string, n);
        }
        catch (IllegalStateException illegalStateException) {
            LogSupport.ignore(log, illegalStateException);
        }
    }

    public void setStatus(int n) {
        this._httpResponse.setStatus(n);
    }

    public void setStatus(int n, String string) {
        this.setStatus(n);
        this._httpResponse.setReason(string);
    }

    public ServletOutputStream getOutputStream() {
        if (this._outputState == -1) {
            return __nullServletOut;
        }
        if (this._outputState != 0 && this._outputState != 1) {
            throw new IllegalStateException();
        }
        if (this._writer != null) {
            this._writer.flush();
            this._writer.disable();
            this._writer = null;
        }
        if (this._out == null) {
            this._out = new ServletOut(this._servletHttpRequest.getHttpRequest().getOutputStream());
        }
        this._outputState = 1;
        return this._out;
    }

    public PrintWriter getWriter() throws IOException {
        if (this._outputState == -1) {
            return __nullServletWriter;
        }
        if (this._outputState != 0 && this._outputState != 2) {
            throw new IllegalStateException();
        }
        if (this._out != null) {
            this._out.flush();
        }
        if (this._writer == null) {
            String string = this._httpResponse.getCharacterEncoding();
            if (string == null) {
                if (this._servletHttpRequest != null) {
                    String string2 = this._httpResponse.getMimeType();
                    string = this._servletHttpRequest.getServletHandler().getHttpContext().getEncodingByMimeType(string2);
                }
                if (string == null) {
                    string = StringUtil.__ISO_8859_1;
                }
                this._httpResponse.setCharacterEncoding(string, true);
            }
            this._writer = new ServletWriter(this._httpResponse.getOutputStream(), string);
        }
        this._outputState = 2;
        return this._writer;
    }

    public void setContentLength(int n) {
        if (!this.isCommitted()) {
            this.setIntHeader("Content-Length", n);
        }
    }

    public String getContentType() {
        return this._httpResponse.getContentType();
    }

    public void setContentType(String string) {
        if (this.isCommitted() || string == null) {
            return;
        }
        int n = string.indexOf(59);
        if (n > 0) {
            int n2 = string.indexOf("charset=", n);
            if (n2 > 0) {
                if (this._outputState == 2) {
                    int n3 = string.indexOf(32, n2);
                    if (n2 == n + 1 && n3 < 0 || n2 == n + 2 && n3 < 0 && string.charAt(n + 1) == ' ') {
                        this._httpResponse.setContentType(string.substring(0, n));
                    } else if (n3 < 0) {
                        this._httpResponse.setContentType(string.substring(0, n2).trim());
                    } else {
                        this._httpResponse.setContentType(string.substring(0, n2) + string.substring(n3));
                    }
                } else {
                    this._charEncodingSetInContentType = true;
                    this._httpResponse.setContentType(string);
                }
            } else {
                this._httpResponse.setContentType(string);
            }
        } else {
            this._httpResponse.setContentType(string);
        }
        if (this._locale != null) {
            this.setLocale(this._locale);
        }
    }

    public void setCharacterEncoding(String string) {
        if (this._outputState == 0 && !this.isCommitted()) {
            this._charEncodingSetInContentType = true;
            this._httpResponse.setCharacterEncoding(string, true);
        }
    }

    public String getCharacterEncoding() {
        String string = this._httpResponse.getCharacterEncoding();
        return string == null ? StringUtil.__ISO_8859_1 : string;
    }

    public String toString() {
        return this._httpResponse.toString();
    }

    public static ServletHttpResponse unwrap(ServletResponse servletResponse) {
        while (!(servletResponse instanceof ServletHttpResponse)) {
            if (servletResponse instanceof ServletResponseWrapper) {
                ServletResponseWrapper servletResponseWrapper = (ServletResponseWrapper)servletResponse;
                servletResponse = servletResponseWrapper.getResponse();
                continue;
            }
            throw new IllegalArgumentException("Does not wrap ServletHttpResponse");
        }
        return (ServletHttpResponse)servletResponse;
    }

    static {
        try {
            __nullServletWriter = new ServletWriter(IO.getNullStream());
            __nullServletOut = new ServletOut(IO.getNullStream());
        }
        catch (Exception exception) {
            log.fatal((Object)exception);
            System.exit(1);
        }
    }
}

