/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.PathMap;
import org.mortbay.jetty.servlet.AbstractSessionManager;
import org.mortbay.jetty.servlet.JSR154Filter;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletHttpRequest;
import org.mortbay.jetty.servlet.ServletOut;
import org.mortbay.jetty.servlet.ServletWriter;
import org.mortbay.jetty.servlet.SessionManager;
import org.mortbay.jetty.servlet.WebApplicationHandler;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LogSupport;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringMap;
import org.mortbay.util.URI;
import org.mortbay.util.UrlEncoded;
import org.mortbay.util.WriterOutputStream;

public class Dispatcher
implements RequestDispatcher {
    static Log log = LogFactory.getLog(Dispatcher.class);
    public static final int __DEFAULT = 0;
    public static final int __REQUEST = 1;
    public static final int __FORWARD = 2;
    public static final int __INCLUDE = 4;
    public static final int __ERROR = 8;
    public static final int __ALL = 15;
    public static final String __INCLUDE_REQUEST_URI = "javax.servlet.include.request_uri";
    public static final String __INCLUDE_CONTEXT_PATH = "javax.servlet.include.context_path";
    public static final String __INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    public static final String __INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    public static final String __INCLUDE_QUERY_STRING = "javax.servlet.include.query_string";
    public static final String __FORWARD_REQUEST_URI = "javax.servlet.forward.request_uri";
    public static final String __FORWARD_CONTEXT_PATH = "javax.servlet.forward.context_path";
    public static final String __FORWARD_SERVLET_PATH = "javax.servlet.forward.servlet_path";
    public static final String __FORWARD_PATH_INFO = "javax.servlet.forward.path_info";
    public static final String __FORWARD_QUERY_STRING = "javax.servlet.forward.query_string";
    public static final StringMap __managedAttributes = new StringMap();
    ServletHandler _servletHandler;
    ServletHolder _holder = null;
    String _pathSpec;
    String _uriInContext;
    String _pathInContext;
    String _query;

    Dispatcher(ServletHandler servletHandler, String string, String string2, String string3, Map.Entry entry) throws IllegalStateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dispatcher for " + servletHandler + "," + string + "," + string3));
        }
        this._servletHandler = servletHandler;
        this._uriInContext = string;
        this._pathInContext = string2;
        this._query = string3;
        this._pathSpec = (String)entry.getKey();
        this._holder = (ServletHolder)entry.getValue();
    }

    Dispatcher(ServletHandler servletHandler, String string) throws IllegalStateException {
        this._servletHandler = servletHandler;
        this._holder = this._servletHandler.getServletHolder(string);
        if (this._holder == null) {
            throw new IllegalStateException("No named servlet handler in context");
        }
    }

    public boolean isNamed() {
        return this._pathInContext == null;
    }

    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        this.dispatch(servletRequest, servletResponse, 4);
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        this.dispatch(servletRequest, servletResponse, 2);
    }

    void error(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        this.dispatch(servletRequest, servletResponse, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatch(ServletRequest servletRequest, ServletResponse servletResponse, int n) throws ServletException, IOException {
        Object object;
        Object object2;
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        HttpConnection httpConnection = this._servletHandler.getHttpContext().getHttpConnection();
        ServletHttpRequest servletHttpRequest = (ServletHttpRequest)httpConnection.getRequest().getWrapper();
        DispatcherRequest dispatcherRequest = new DispatcherRequest(httpServletRequest, servletHttpRequest, n);
        DispatcherResponse dispatcherResponse = new DispatcherResponse(dispatcherRequest, httpServletResponse);
        if (n == 2) {
            servletResponse.resetBuffer();
        }
        String string = this._query;
        MultiMap multiMap = null;
        if (string != null) {
            object2 = httpServletRequest.getParameterMap();
            multiMap = new MultiMap();
            UrlEncoded.decodeTo(string, multiMap, dispatcherRequest.getCharacterEncoding());
            if (object2 != null && object2.size() > 0) {
                object = object2.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry entry = object.next();
                    String string2 = (String)entry.getKey();
                    String[] stringArray = (String[])entry.getValue();
                    for (int i = 0; i < stringArray.length; ++i) {
                        multiMap.add(string2, stringArray[i]);
                    }
                }
            }
            dispatcherRequest.setParameters(multiMap);
            object = httpServletRequest.getQueryString();
            if (object != null) {
                dispatcherRequest.setQuery(string + "&" + object);
            } else {
                dispatcherRequest.setQuery(string);
            }
        }
        object2 = null;
        try {
            if (dispatcherRequest.crossContext()) {
                object2 = this._servletHandler.getHttpContext().enterContextScope(httpConnection.getRequest(), httpConnection.getResponse());
            }
            if (this.isNamed()) {
                if (this._servletHandler instanceof WebApplicationHandler) {
                    object = ((WebApplicationHandler)this._servletHandler).getJsr154Filter();
                    if (object != null && ((JSR154Filter)object).isUnwrappedDispatchSupported()) {
                        ((JSR154Filter)object).setDispatch(dispatcherRequest, dispatcherResponse);
                        this._servletHandler.dispatch(null, httpServletRequest, httpServletResponse, this._holder, n);
                    } else {
                        this._servletHandler.dispatch(null, (HttpServletRequest)dispatcherRequest, (HttpServletResponse)dispatcherResponse, this._holder, n);
                    }
                } else {
                    this._servletHandler.dispatch(null, (HttpServletRequest)dispatcherRequest, (HttpServletResponse)dispatcherResponse, this._holder, n);
                }
            } else {
                dispatcherRequest.setPaths(this._servletHandler.getHttpContext().getContextPath(), PathMap.pathMatch(this._pathSpec, this._pathInContext), PathMap.pathInfo(this._pathSpec, this._pathInContext));
                if (this._servletHandler instanceof WebApplicationHandler) {
                    object = ((WebApplicationHandler)this._servletHandler).getJsr154Filter();
                    if (object != null && ((JSR154Filter)object).isUnwrappedDispatchSupported()) {
                        ((JSR154Filter)object).setDispatch(dispatcherRequest, dispatcherResponse);
                        this._servletHandler.dispatch(this._pathInContext, httpServletRequest, httpServletResponse, this._holder, n);
                    } else {
                        this._servletHandler.dispatch(this._pathInContext, (HttpServletRequest)dispatcherRequest, (HttpServletResponse)dispatcherResponse, this._holder, n);
                    }
                } else {
                    this._servletHandler.dispatch(this._pathInContext, (HttpServletRequest)dispatcherRequest, (HttpServletResponse)dispatcherResponse, this._holder, n);
                }
                if (n != 4) {
                    dispatcherResponse.close();
                } else if (dispatcherResponse.isFlushNeeded()) {
                    dispatcherResponse.flushBuffer();
                }
            }
            Object var19_18 = null;
            if (dispatcherRequest.crossContext()) {
                this._servletHandler.getHttpContext().leaveContextScope(httpConnection.getRequest(), httpConnection.getResponse(), object2);
            }
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            if (dispatcherRequest.crossContext()) {
                this._servletHandler.getHttpContext().leaveContextScope(httpConnection.getRequest(), httpConnection.getResponse(), object2);
            }
            throw throwable;
        }
    }

    public String toString() {
        return "Dispatcher[" + this._pathSpec + "," + this._holder + "]";
    }

    public static int type(String string) {
        if ("request".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("forward".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("include".equalsIgnoreCase(string)) {
            return 4;
        }
        if ("error".equalsIgnoreCase(string)) {
            return 8;
        }
        throw new IllegalArgumentException(string);
    }

    static {
        __managedAttributes.put(__INCLUDE_REQUEST_URI, (Object)__INCLUDE_REQUEST_URI);
        __managedAttributes.put(__INCLUDE_CONTEXT_PATH, (Object)__INCLUDE_CONTEXT_PATH);
        __managedAttributes.put(__INCLUDE_SERVLET_PATH, (Object)__INCLUDE_SERVLET_PATH);
        __managedAttributes.put(__INCLUDE_PATH_INFO, (Object)__INCLUDE_PATH_INFO);
        __managedAttributes.put(__INCLUDE_QUERY_STRING, (Object)__INCLUDE_QUERY_STRING);
        __managedAttributes.put(__FORWARD_REQUEST_URI, (Object)__FORWARD_REQUEST_URI);
        __managedAttributes.put(__FORWARD_CONTEXT_PATH, (Object)__FORWARD_CONTEXT_PATH);
        __managedAttributes.put(__FORWARD_SERVLET_PATH, (Object)__FORWARD_SERVLET_PATH);
        __managedAttributes.put(__FORWARD_PATH_INFO, (Object)__FORWARD_PATH_INFO);
        __managedAttributes.put(__FORWARD_QUERY_STRING, (Object)__FORWARD_QUERY_STRING);
    }

    private class DontCloseServletOut
    extends ServletOut {
        DontCloseServletOut(ServletOutputStream servletOutputStream) {
            super((OutputStream)servletOutputStream);
        }

        public void close() throws IOException {
        }
    }

    private class DontCloseWriter
    extends PrintWriter {
        DontCloseWriter(PrintWriter printWriter) {
            super(printWriter);
        }

        public void close() {
        }
    }

    class DispatcherResponse
    extends HttpServletResponseWrapper {
        DispatcherRequest _request;
        private ServletOutputStream _out;
        private PrintWriter _writer;
        private boolean _flushNeeded;
        private boolean _include;

        DispatcherResponse(DispatcherRequest dispatcherRequest, HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
            this._out = null;
            this._writer = null;
            this._flushNeeded = false;
            this._request = dispatcherRequest;
            dispatcherRequest._response = this;
            this._include = this._request._filterType == 4;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this._writer != null) {
                throw new IllegalStateException("getWriter called");
            }
            if (this._out == null) {
                try {
                    this._out = super.getOutputStream();
                }
                catch (IllegalStateException illegalStateException) {
                    LogSupport.ignore(log, illegalStateException);
                    this._flushNeeded = true;
                    this._out = new ServletOut(new WriterOutputStream(super.getWriter()));
                }
            }
            if (this._include) {
                this._out = new DontCloseServletOut(this._out);
            }
            return this._out;
        }

        public PrintWriter getWriter() throws IOException {
            if (this._out != null) {
                throw new IllegalStateException("getOutputStream called");
            }
            if (this._writer == null) {
                try {
                    this._writer = super.getWriter();
                }
                catch (IllegalStateException illegalStateException) {
                    LogSupport.ignore(log, illegalStateException);
                    this._flushNeeded = true;
                    this._writer = new ServletWriter((OutputStream)super.getOutputStream(), this.getCharacterEncoding());
                }
            }
            if (this._include) {
                this._writer = new DontCloseWriter(this._writer);
            }
            return this._writer;
        }

        boolean isFlushNeeded() {
            return this._flushNeeded;
        }

        public void flushBuffer() throws IOException {
            if (this._writer != null) {
                this._writer.flush();
            }
            if (this._out != null) {
                this._out.flush();
            }
            super.flushBuffer();
        }

        public void close() throws IOException {
            if (this._writer != null) {
                this._writer.close();
            }
            if (this._out != null) {
                this._out.close();
            }
        }

        public void setLocale(Locale locale) {
            if (!this._include) {
                super.setLocale(locale);
            }
        }

        public void sendError(int n, String string) throws IOException {
            if (this._request._filterType != 8 && !this._include) {
                super.sendError(n, string);
            }
        }

        public void sendError(int n) throws IOException {
            if (this._request._filterType != 8 && !this._include) {
                super.sendError(n);
            }
        }

        public void sendRedirect(String string) throws IOException {
            if (!this._include) {
                if (!string.startsWith("http:/") && !string.startsWith("https:/")) {
                    StringBuffer stringBuffer = this._request.getRootURL();
                    if (string.startsWith("/")) {
                        stringBuffer.append(URI.canonicalPath(string));
                    } else {
                        stringBuffer.append(URI.canonicalPath(URI.addPaths(URI.parentPath(this._request.getRequestURI()), string)));
                    }
                    string = stringBuffer.toString();
                }
                super.sendRedirect(string);
            }
        }

        public void setDateHeader(String string, long l) {
            if (!this._include) {
                super.setDateHeader(string, l);
            }
        }

        public void setHeader(String string, String string2) {
            if (!this._include) {
                super.setHeader(string, string2);
            }
        }

        public void setIntHeader(String string, int n) {
            if (!this._include) {
                super.setIntHeader(string, n);
            }
        }

        public void addHeader(String string, String string2) {
            if (!this._include) {
                super.addHeader(string, string2);
            }
        }

        public void addDateHeader(String string, long l) {
            if (!this._include) {
                super.addDateHeader(string, l);
            }
        }

        public void addIntHeader(String string, int n) {
            if (!this._include) {
                super.addIntHeader(string, n);
            }
        }

        public void setStatus(int n) {
            if (this._request._filterType != 8 && !this._include) {
                super.setStatus(n);
            }
        }

        public void setStatus(int n, String string) {
            if (this._request._filterType != 8 && !this._include) {
                super.setStatus(n, string);
            }
        }

        public void setContentLength(int n) {
            if (!this._include) {
                super.setContentLength(n);
            }
        }

        public void setContentType(String string) {
            if (!this._include) {
                super.setContentType(string);
            }
        }

        public void addCookie(Cookie cookie) {
            if (!this._include) {
                super.addCookie(cookie);
            }
        }
    }

    class DispatcherRequest
    extends HttpServletRequestWrapper {
        DispatcherResponse _response;
        int _filterType;
        String _contextPath;
        String _servletPath;
        String _pathInfo;
        MultiMap _parameters;
        HashMap _attributes;
        boolean _xContext;
        HttpSession _xSession;
        ServletHttpRequest _servletHttpRequest;
        String _query;

        DispatcherRequest(HttpServletRequest httpServletRequest, ServletHttpRequest servletHttpRequest, int n) {
            super(httpServletRequest);
            this._servletHttpRequest = servletHttpRequest;
            this._filterType = n;
            boolean bl = this._xContext = servletHttpRequest.getServletHandler() != Dispatcher.this._servletHandler;
            if (this._xContext) {
                String string;
                HttpSession httpSession = httpServletRequest.getSession(false);
                String string2 = string = httpSession == null ? httpServletRequest.getRequestedSessionId() : httpSession.getId();
                if (string != null) {
                    this._xSession = Dispatcher.this._servletHandler.getHttpSession(string);
                    if (this._xSession != null) {
                        ((SessionManager.Session)this._xSession).access();
                    }
                }
            }
        }

        boolean crossContext() {
            return this._xContext;
        }

        void setPaths(String string, String string2, String string3) {
            this._contextPath = string.length() == 1 && string.charAt(0) == '/' ? "" : string;
            this._servletPath = string2;
            this._pathInfo = string3;
        }

        void setQuery(String string) {
            this._query = string;
        }

        int getFilterType() {
            return this._filterType;
        }

        String getPathInContext() {
            if (Dispatcher.this._pathInContext != null) {
                return Dispatcher.this._pathInContext;
            }
            return URI.addPaths(this.getServletPath(), this.getPathInfo());
        }

        public String getRequestURI() {
            if (this._filterType == 4 || Dispatcher.this.isNamed()) {
                return super.getRequestURI();
            }
            return URI.addPaths(this._contextPath, Dispatcher.this._uriInContext);
        }

        public StringBuffer getRequestURL() {
            if (this._filterType == 4 || Dispatcher.this.isNamed()) {
                return super.getRequestURL();
            }
            StringBuffer stringBuffer = this.getRootURL();
            if (this._contextPath.length() > 0) {
                stringBuffer.append(this._contextPath);
            }
            stringBuffer.append(Dispatcher.this._uriInContext);
            return stringBuffer;
        }

        public String getPathTranslated() {
            String string = this.getPathInfo();
            if (string == null) {
                return null;
            }
            return this.getRealPath(string);
        }

        StringBuffer getRootURL() {
            StringBuffer stringBuffer = super.getRequestURL();
            int n = 3;
            for (int i = 0; i < stringBuffer.length(); ++i) {
                if (stringBuffer.charAt(i) != '/' || --n != 0) continue;
                stringBuffer.setLength(i);
                break;
            }
            return stringBuffer;
        }

        public String getContextPath() {
            return this._filterType == 4 || Dispatcher.this.isNamed() ? super.getContextPath() : this._contextPath;
        }

        public String getServletPath() {
            return this._filterType == 4 || Dispatcher.this.isNamed() ? super.getServletPath() : this._servletPath;
        }

        public String getPathInfo() {
            return this._filterType == 4 || Dispatcher.this.isNamed() ? super.getPathInfo() : this._pathInfo;
        }

        public String getQueryString() {
            if (this._query == null) {
                return super.getQueryString();
            }
            return this._query;
        }

        void setParameters(MultiMap multiMap) {
            this._parameters = multiMap;
        }

        public Enumeration getParameterNames() {
            if (this._parameters == null) {
                return super.getParameterNames();
            }
            return Collections.enumeration(this._parameters.keySet());
        }

        public String getParameter(String string) {
            if (this._parameters == null) {
                return super.getParameter(string);
            }
            return (String)this._parameters.getValue(string, 0);
        }

        public String[] getParameterValues(String string) {
            if (this._parameters == null) {
                return super.getParameterValues(string);
            }
            List list = this._parameters.getValues(string);
            if (list == null) {
                return null;
            }
            return list.toArray(new String[list.size()]);
        }

        public Map getParameterMap() {
            if (this._parameters == null) {
                return super.getParameterMap();
            }
            return this._parameters.toStringArrayMap();
        }

        public void setAttribute(String string, Object object) {
            if (__managedAttributes.containsKey(string)) {
                if (this._attributes == null) {
                    this._attributes = new HashMap(3);
                }
                this._attributes.put(string, object);
            } else {
                super.setAttribute(string, object);
            }
        }

        public Object getAttribute(String string) {
            if (this._attributes != null && this._attributes.containsKey(string)) {
                return this._attributes.get(string);
            }
            if (this._filterType == 4 && !Dispatcher.this.isNamed()) {
                if (string.equals(Dispatcher.__INCLUDE_PATH_INFO)) {
                    return this._pathInfo;
                }
                if (string.equals(Dispatcher.__INCLUDE_REQUEST_URI)) {
                    return URI.addPaths(this._contextPath, Dispatcher.this._uriInContext);
                }
                if (string.equals(Dispatcher.__INCLUDE_SERVLET_PATH)) {
                    return this._servletPath;
                }
                if (string.equals(Dispatcher.__INCLUDE_CONTEXT_PATH)) {
                    return this._contextPath;
                }
                if (string.equals(Dispatcher.__INCLUDE_QUERY_STRING)) {
                    return Dispatcher.this._query;
                }
            } else {
                if (string.equals(Dispatcher.__INCLUDE_PATH_INFO)) {
                    return null;
                }
                if (string.equals(Dispatcher.__INCLUDE_REQUEST_URI)) {
                    return null;
                }
                if (string.equals(Dispatcher.__INCLUDE_SERVLET_PATH)) {
                    return null;
                }
                if (string.equals(Dispatcher.__INCLUDE_CONTEXT_PATH)) {
                    return null;
                }
                if (string.equals(Dispatcher.__INCLUDE_QUERY_STRING)) {
                    return null;
                }
            }
            if (this._filterType != 4 && !Dispatcher.this.isNamed()) {
                if (string.equals(Dispatcher.__FORWARD_PATH_INFO)) {
                    return this._servletHttpRequest.getPathInfo();
                }
                if (string.equals(Dispatcher.__FORWARD_REQUEST_URI)) {
                    return this._servletHttpRequest.getRequestURI();
                }
                if (string.equals(Dispatcher.__FORWARD_SERVLET_PATH)) {
                    return this._servletHttpRequest.getServletPath();
                }
                if (string.equals(Dispatcher.__FORWARD_CONTEXT_PATH)) {
                    return this._servletHttpRequest.getContextPath();
                }
                if (string.equals(Dispatcher.__FORWARD_QUERY_STRING)) {
                    return this._servletHttpRequest.getQueryString();
                }
            }
            return super.getAttribute(string);
        }

        public Enumeration getAttributeNames() {
            HashSet<Object> hashSet = new HashSet<Object>();
            Enumeration enumeration = super.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                hashSet.add(enumeration.nextElement());
            }
            if (this._filterType == 4 && !Dispatcher.this.isNamed()) {
                if (this._pathInfo != null) {
                    hashSet.add(Dispatcher.__INCLUDE_PATH_INFO);
                } else {
                    hashSet.remove(Dispatcher.__INCLUDE_PATH_INFO);
                }
                hashSet.add(Dispatcher.__INCLUDE_REQUEST_URI);
                hashSet.add(Dispatcher.__INCLUDE_SERVLET_PATH);
                hashSet.add(Dispatcher.__INCLUDE_CONTEXT_PATH);
                if (Dispatcher.this._query != null) {
                    hashSet.add(Dispatcher.__INCLUDE_QUERY_STRING);
                } else {
                    hashSet.remove(Dispatcher.__INCLUDE_QUERY_STRING);
                }
            } else {
                hashSet.remove(Dispatcher.__INCLUDE_PATH_INFO);
                hashSet.remove(Dispatcher.__INCLUDE_REQUEST_URI);
                hashSet.remove(Dispatcher.__INCLUDE_SERVLET_PATH);
                hashSet.remove(Dispatcher.__INCLUDE_CONTEXT_PATH);
                hashSet.remove(Dispatcher.__INCLUDE_QUERY_STRING);
            }
            if (this._filterType != 4 && !Dispatcher.this.isNamed()) {
                if (this._servletHttpRequest.getPathInfo() != null) {
                    hashSet.add(Dispatcher.__FORWARD_PATH_INFO);
                } else {
                    hashSet.remove(Dispatcher.__FORWARD_PATH_INFO);
                }
                hashSet.add(Dispatcher.__FORWARD_REQUEST_URI);
                hashSet.add(Dispatcher.__FORWARD_SERVLET_PATH);
                hashSet.add(Dispatcher.__FORWARD_CONTEXT_PATH);
                if (this._servletHttpRequest.getQueryString() != null) {
                    hashSet.add(Dispatcher.__FORWARD_QUERY_STRING);
                } else {
                    hashSet.remove(Dispatcher.__FORWARD_QUERY_STRING);
                }
            }
            if (this._attributes != null) {
                hashSet.addAll(this._attributes.keySet());
            }
            return Collections.enumeration(hashSet);
        }

        public HttpSession getSession(boolean bl) {
            if (this._xContext) {
                if (this._xSession == null) {
                    if (this.getAttribute("org.mortbay.jetty.servlet.Dispatcher.shared_session") != null) {
                        this._xSession = super.getSession(bl);
                    } else {
                        HttpSession httpSession;
                        log.debug((Object)"Ctx dispatch session");
                        String string = this.getRequestedSessionId();
                        if (string == null && (httpSession = super.getSession(false)) != null) {
                            string = httpSession.getId();
                        }
                        this._xSession = Dispatcher.this._servletHandler.getHttpSession(string);
                        if (bl && this._xSession == null) {
                            this._xSession = Dispatcher.this._servletHandler.newHttpSession((HttpServletRequest)this);
                            httpSession = Dispatcher.this._servletHandler.getSessionManager().getSessionCookie(this._xSession, this.isSecure());
                            if (httpSession != null) {
                                this._servletHttpRequest.getHttpRequest().getHttpResponse().addSetCookie((Cookie)httpSession);
                            }
                        }
                    }
                }
                return this._xSession;
            }
            return super.getSession(bl);
        }

        public boolean isRequestedSessionIdValid() {
            if (this._xContext) {
                HttpSession httpSession;
                String string = super.getRequestedSessionId();
                if (string != null && (httpSession = this.getSession(false)) != null) {
                    return ((AbstractSessionManager.Session)httpSession).isValid() && string.equals(httpSession.getId());
                }
                return false;
            }
            return super.isRequestedSessionIdValid();
        }

        public HttpSession getSession() {
            return this.getSession(true);
        }

        public String getRealPath(String string) {
            return Dispatcher.this._servletHandler.getServletContext().getRealPath(string);
        }

        public RequestDispatcher getRequestDispatcher(String string) {
            if (string == null) {
                return null;
            }
            if (!string.startsWith("/")) {
                String string2 = URI.addPaths(this.getServletPath(), this.getPathInfo());
                int n = string2.lastIndexOf("/");
                string2 = n > 1 ? string2.substring(0, n + 1) : "/";
                string = URI.addPaths(string2, string);
            }
            return Dispatcher.this._servletHandler.getServletContext().getRequestDispatcher(string);
        }

        public String getMethod() {
            if (this._filterType == 8) {
                return "GET";
            }
            return super.getMethod();
        }
    }
}

