/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.nio;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LazyList;

public class ByteBufferInputStream
extends InputStream {
    private static Log log = LogFactory.getLog(ByteBufferInputStream.class);
    long _timeout = 30000L;
    int _bufferSize;
    ByteBuffer _buffer;
    Object _buffers;
    Object _recycle;
    boolean _closed = false;

    public ByteBufferInputStream(int n) {
        this._bufferSize = n;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long l) {
        this._timeout = l;
    }

    public synchronized int read() throws IOException {
        if (!this.waitForContent()) {
            return -1;
        }
        return this._buffer.get();
    }

    public synchronized int available() throws IOException {
        if (!this.waitForContent()) {
            return -1;
        }
        return this._buffer.remaining();
    }

    public synchronized void close() throws IOException {
        this._closed = true;
        this.notify();
    }

    public synchronized void mark(int n) {
    }

    public synchronized boolean markSupported() {
        return false;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.waitForContent()) {
            return -1;
        }
        if (n2 > this._buffer.remaining()) {
            n2 = this._buffer.remaining();
        }
        this._buffer.get(byArray, n, n2);
        return n2;
    }

    public synchronized int read(byte[] byArray) throws IOException {
        if (!this.waitForContent()) {
            return -1;
        }
        int n = byArray.length;
        if (n > this._buffer.remaining()) {
            n = this._buffer.remaining();
        }
        this._buffer.get(byArray, 0, n);
        return n;
    }

    public synchronized void reset() throws IOException {
        super.reset();
    }

    public long skip(long l) throws IOException {
        if (!this.waitForContent()) {
            return -1L;
        }
        if (l > (long)this._buffer.remaining()) {
            l = this._buffer.remaining();
        }
        this._buffer.position((int)((long)this._buffer.position() + l));
        return l;
    }

    public synchronized void write(ByteBuffer byteBuffer) {
        if (byteBuffer.hasRemaining()) {
            this._buffers = LazyList.add(this._buffers, byteBuffer);
            this.notify();
        } else {
            this.recycle(byteBuffer);
        }
    }

    private synchronized boolean waitForContent() throws InterruptedIOException {
        if (this._buffer != null) {
            if (this._buffer.hasRemaining()) {
                return true;
            }
            this.recycle(this._buffer);
            this._buffer = null;
        }
        while (!this._closed && LazyList.size(this._buffers) == 0) {
            try {
                this.wait(this._timeout);
            }
            catch (InterruptedException interruptedException) {
                log.debug((Object)interruptedException);
                throw new InterruptedIOException(interruptedException.toString());
            }
        }
        if (this._closed) {
            return false;
        }
        if (LazyList.size(this._buffers) == 0) {
            throw new SocketTimeoutException();
        }
        this._buffer = (ByteBuffer)LazyList.get(this._buffers, 0);
        this._buffers = LazyList.remove(this._buffers, 0);
        return true;
    }

    public synchronized ByteBuffer getBuffer() {
        ByteBuffer byteBuffer = null;
        int n = LazyList.size(this._recycle);
        if (n > 0) {
            byteBuffer = (ByteBuffer)LazyList.get(this._recycle, --n);
            this._recycle = LazyList.remove(this._recycle, n);
            byteBuffer.clear();
        } else {
            byteBuffer = ByteBuffer.allocateDirect(this._bufferSize);
        }
        return byteBuffer;
    }

    public synchronized void recycle(ByteBuffer byteBuffer) {
        this._recycle = LazyList.add(this._recycle, byteBuffer);
    }

    public void destroy() {
        this._buffer = null;
        this._buffers = null;
        this._recycle = null;
    }
}

