/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.InclusiveByteRange;
import org.mortbay.http.MultiPartResponse;
import org.mortbay.http.ResourceCache;
import org.mortbay.http.handler.AbstractHttpHandler;
import org.mortbay.log.LogFactory;
import org.mortbay.util.CachedResource;
import org.mortbay.util.IO;
import org.mortbay.util.LogSupport;
import org.mortbay.util.Resource;
import org.mortbay.util.StringMap;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.URI;

public class ResourceHandler
extends AbstractHttpHandler {
    private static Log log = LogFactory.getLog(ResourceHandler.class);
    private boolean _acceptRanges = true;
    private boolean _redirectWelcomeFiles;
    private String[] _methods = null;
    private String _allowed;
    private boolean _dirAllowed = true;
    private int _minGzipLength = -1;
    private StringMap _methodMap = new StringMap();

    public ResourceHandler() {
        this.setAllowedMethods(new String[]{"GET", "POST", "HEAD", "OPTIONS", "TRACE"});
    }

    public synchronized void start() throws Exception {
        super.start();
    }

    public void stop() throws InterruptedException {
        super.stop();
    }

    public String[] getAllowedMethods() {
        return this._methods;
    }

    public void setAllowedMethods(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        this._methods = stringArray;
        this._methodMap.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            this._methodMap.put(stringArray[i], (Object)stringArray[i]);
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(stringArray[i]);
        }
        this._allowed = stringBuffer.toString();
    }

    public boolean isMethodAllowed(String string) {
        return this._methodMap.get(string) != null;
    }

    public String getAllowedString() {
        return this._allowed;
    }

    public boolean isDirAllowed() {
        return this._dirAllowed;
    }

    public void setDirAllowed(boolean bl) {
        this._dirAllowed = bl;
    }

    public boolean isAcceptRanges() {
        return this._acceptRanges;
    }

    public boolean getRedirectWelcome() {
        return this._redirectWelcomeFiles;
    }

    public void setRedirectWelcome(boolean bl) {
        this._redirectWelcomeFiles = bl;
    }

    public void setAcceptRanges(boolean bl) {
        this._acceptRanges = bl;
    }

    public int getMinGzipLength() {
        return this._minGzipLength;
    }

    public void setMinGzipLength(int n) {
        this._minGzipLength = n;
    }

    protected Resource getResource(String string) throws IOException {
        return this.getHttpContext().getResource(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle(String string, String string2, HttpRequest httpRequest, HttpResponse httpResponse) throws HttpException, IOException {
        Resource resource = this.getResource(string);
        if (resource == null) {
            return;
        }
        if (!this.isMethodAllowed(httpRequest.getMethod())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Method not allowed: " + httpRequest.getMethod()));
            }
            if (!resource.exists()) return;
            this.setAllowHeader(httpResponse);
            httpResponse.sendError(405);
            return;
        }
        try {
            try {
                String string3;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("PATH=" + string + " RESOURCE=" + resource));
                }
                if ((string3 = httpRequest.getMethod()).equals("GET") || string3.equals("POST") || string3.equals("HEAD")) {
                    this.handleGet(httpRequest, httpResponse, string, string2, resource);
                } else if (string3.equals("PUT")) {
                    this.handlePut(httpRequest, httpResponse, string, resource);
                } else if (string3.equals("DELETE")) {
                    this.handleDelete(httpRequest, httpResponse, string, resource);
                } else if (string3.equals("OPTIONS")) {
                    this.handleOptions(httpResponse, string);
                } else if (string3.equals("MOVE")) {
                    this.handleMove(httpRequest, httpResponse, string, resource);
                } else if (string3.equals("TRACE")) {
                    this.handleTrace(httpRequest, httpResponse);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Unknown action:" + string3));
                    }
                    try {
                        if (resource.exists()) {
                            httpResponse.sendError(501);
                        }
                    }
                    catch (Exception exception) {
                        LogSupport.ignore(log, exception);
                    }
                }
                Object var9_9 = null;
                if (resource == null) return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LogSupport.ignore(log, illegalArgumentException);
                Object var9_10 = null;
                if (resource == null) return;
                if (resource instanceof CachedResource) return;
                resource.release();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (resource == null) throw throwable;
            if (resource instanceof CachedResource) throw throwable;
            resource.release();
            throw throwable;
        }
        if (resource instanceof CachedResource) return;
        resource.release();
    }

    public void handleGet(HttpRequest httpRequest, HttpResponse httpResponse, String string, String string2, Resource resource) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking for " + resource));
        }
        if (resource != null && resource.exists()) {
            if (resource.isDirectory()) {
                if (!string.endsWith("/") && !string.equals("/")) {
                    log.debug((Object)"Redirect to directory/");
                    String string3 = httpRequest.getQuery();
                    StringBuffer stringBuffer = httpRequest.getRequestURL();
                    if (string3 != null && string3.length() != 0) {
                        stringBuffer.append('?');
                        stringBuffer.append(string3);
                    }
                    httpResponse.setField("Location", URI.addPaths(stringBuffer.toString(), "/"));
                    httpResponse.setStatus(302);
                    httpRequest.setHandled(true);
                    return;
                }
                String string4 = this.getHttpContext().getWelcomeFile(resource);
                if (string4 != null) {
                    String string5 = URI.addPaths(string, string4);
                    if (this._redirectWelcomeFiles) {
                        string5 = URI.addPaths(this.getHttpContext().getContextPath(), string5);
                        httpResponse.setContentLength(0);
                        httpResponse.sendRedirect(string5);
                    } else {
                        URI uRI = httpRequest.getURI();
                        uRI.setPath(URI.addPaths(uRI.getPath(), string4));
                        this.getHttpContext().handle(string5, string2, httpRequest, httpResponse);
                    }
                    return;
                }
                if (!this.passConditionalHeaders(httpRequest, httpResponse, resource)) {
                    return;
                }
                this.sendDirectory(httpRequest, httpResponse, resource, string.length() > 1);
            } else if (resource.exists()) {
                if (!this.passConditionalHeaders(httpRequest, httpResponse, resource)) {
                    return;
                }
                this.sendData(httpRequest, httpResponse, string, resource, true);
            } else {
                log.warn((Object)"Unknown file type");
            }
        }
    }

    private boolean passConditionalHeaders(HttpRequest httpRequest, HttpResponse httpResponse, Resource resource) throws IOException {
        if (!httpRequest.getMethod().equals("HEAD")) {
            ResourceCache.ResourceMetaData resourceMetaData = (ResourceCache.ResourceMetaData)resource.getAssociate();
            if (resourceMetaData != null) {
                String string = httpRequest.getField("If-Modified-Since");
                String string2 = resourceMetaData.getLastModified();
                if (string != null && string2 != null && string.equals(string2)) {
                    httpResponse.setStatus(304);
                    httpRequest.setHandled(true);
                    return false;
                }
            }
            long l = 0L;
            l = httpRequest.getDateField("If-Unmodified-Since");
            if (l > 0L && resource.lastModified() / 1000L > l / 1000L) {
                httpResponse.sendError(412);
                return false;
            }
            l = httpRequest.getDateField("If-Modified-Since");
            if (l > 0L && resource.lastModified() / 1000L <= l / 1000L) {
                httpResponse.setStatus(304);
                httpRequest.setHandled(true);
                return false;
            }
        }
        return true;
    }

    void handlePut(HttpRequest httpRequest, HttpResponse httpResponse, String string, Resource resource) throws IOException {
        boolean bl;
        if (log.isDebugEnabled()) {
            log.debug((Object)("PUT " + string + " in " + resource));
        }
        boolean bl2 = bl = resource != null && resource.exists();
        if (bl && !this.passConditionalHeaders(httpRequest, httpResponse, resource)) {
            return;
        }
        if (string.endsWith("/")) {
            if (!bl) {
                if (!resource.getFile().mkdirs()) {
                    httpResponse.sendError(403, "Directories could not be created");
                } else {
                    httpRequest.setHandled(true);
                    httpResponse.setStatus(201);
                    httpResponse.commit();
                }
            } else {
                httpRequest.setHandled(true);
                httpResponse.setStatus(200);
                httpResponse.commit();
            }
        } else {
            try {
                int n = httpRequest.getContentLength();
                InputStream inputStream = httpRequest.getInputStream();
                OutputStream outputStream = resource.getOutputStream();
                if (n >= 0) {
                    IO.copy(inputStream, outputStream, (long)n);
                } else {
                    IO.copy(inputStream, outputStream);
                }
                outputStream.close();
                httpRequest.setHandled(true);
                httpResponse.setStatus(bl ? 200 : 201);
                httpResponse.commit();
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
                httpResponse.sendError(403, exception.getMessage());
            }
        }
    }

    void handleDelete(HttpRequest httpRequest, HttpResponse httpResponse, String string, Resource resource) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("DELETE " + string + " from " + resource));
        }
        if (!resource.exists() || !this.passConditionalHeaders(httpRequest, httpResponse, resource)) {
            return;
        }
        try {
            if (resource.delete()) {
                httpResponse.setStatus(204);
            } else {
                httpResponse.sendError(403);
            }
            httpRequest.setHandled(true);
        }
        catch (SecurityException securityException) {
            log.warn((Object)"EXCEPTION ", (Throwable)securityException);
            httpResponse.sendError(403, securityException.getMessage());
        }
    }

    void handleMove(HttpRequest httpRequest, HttpResponse httpResponse, String string, Resource resource) throws IOException {
        if (!resource.exists() || !this.passConditionalHeaders(httpRequest, httpResponse, resource)) {
            return;
        }
        String string2 = URI.canonicalPath(httpRequest.getField("New-uri"));
        if (string2 == null) {
            httpResponse.sendError(405, "Bad new uri");
            return;
        }
        String string3 = this.getHttpContext().getContextPath();
        if (string3 != null && !string2.startsWith(string3)) {
            httpResponse.sendError(405, "Not in context");
            return;
        }
        try {
            String string4 = string2;
            if (string3 != null) {
                string4 = string4.substring(string3.length());
            }
            Resource resource2 = this.getHttpContext().getBaseResource().addPath(string4);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Moving " + resource + " to " + resource2));
            }
            resource.renameTo(resource2);
            httpResponse.setStatus(204);
            httpRequest.setHandled(true);
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
            this.setAllowHeader(httpResponse);
            httpResponse.sendError(405, "Error:" + exception);
            return;
        }
    }

    void handleOptions(HttpResponse httpResponse, String string) throws IOException {
        if ("*".equals(string)) {
            return;
        }
        this.setAllowHeader(httpResponse);
        httpResponse.commit();
    }

    void setAllowHeader(HttpResponse httpResponse) {
        httpResponse.setField("Allow", this.getAllowedString());
    }

    public void writeHeaders(HttpResponse httpResponse, Resource resource, long l) throws IOException {
        ResourceCache.ResourceMetaData resourceMetaData = (ResourceCache.ResourceMetaData)resource.getAssociate();
        httpResponse.setContentType(resourceMetaData.getMimeType());
        if (l != -1L) {
            if (l == resource.length()) {
                httpResponse.setField("Content-Length", resourceMetaData.getLength());
            } else {
                httpResponse.setContentLength((int)l);
            }
        }
        httpResponse.setField("Last-Modified", resourceMetaData.getLastModified());
        if (this._acceptRanges && httpResponse.getHttpRequest().getDotVersion() > 0) {
            httpResponse.setField("Accept-Ranges", "bytes");
        }
    }

    public void sendData(HttpRequest httpRequest, HttpResponse httpResponse, String string, Resource resource, boolean bl) throws IOException {
        Enumeration enumeration;
        long l = resource.length();
        Enumeration enumeration2 = enumeration = httpRequest.getDotVersion() > 0 ? httpRequest.getFieldValues("Range") : null;
        if (!bl || enumeration == null || !enumeration.hasMoreElements()) {
            Resource resource2;
            Object object;
            Resource resource3 = resource;
            if (this._minGzipLength > 0 && (object = httpRequest.getField("Accept-Encoding")) != null && l > (long)this._minGzipLength && !string.endsWith(".gz") && (resource2 = this.getHttpContext().getResource(string + ".gz")).exists() && ((String)object).indexOf("gzip") >= 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("gzip=" + resource2));
                }
                httpResponse.setField("Content-Encoding", "gzip");
                resource3 = resource2;
                l = resource3.length();
            }
            this.writeHeaders(httpResponse, resource, l);
            httpRequest.setHandled(true);
            object = httpResponse.getOutputStream();
            resource3.writeTo((OutputStream)object, 0L, l);
            return;
        }
        List list = InclusiveByteRange.satisfiableRanges(enumeration, l);
        if (log.isDebugEnabled()) {
            log.debug((Object)("ranges: " + enumeration + " == " + list));
        }
        if (list == null || list.size() == 0) {
            log.debug((Object)"no satisfiable ranges");
            this.writeHeaders(httpResponse, resource, l);
            httpResponse.setStatus(416);
            httpResponse.setReason((String)HttpResponse.__statusMsg.get(TypeUtil.newInteger(416)));
            httpResponse.setField("Content-Range", InclusiveByteRange.to416HeaderRangeString(l));
            OutputStream outputStream = httpResponse.getOutputStream();
            resource.writeTo(outputStream, 0L, l);
            httpRequest.setHandled(true);
            return;
        }
        if (list.size() == 1) {
            InclusiveByteRange inclusiveByteRange = (InclusiveByteRange)list.get(0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("single satisfiable range: " + inclusiveByteRange));
            }
            long l2 = inclusiveByteRange.getSize(l);
            this.writeHeaders(httpResponse, resource, l2);
            httpResponse.setStatus(206);
            httpResponse.setReason((String)HttpResponse.__statusMsg.get(TypeUtil.newInteger(206)));
            httpResponse.setField("Content-Range", inclusiveByteRange.toHeaderRangeString(l));
            OutputStream outputStream = httpResponse.getOutputStream();
            resource.writeTo(outputStream, inclusiveByteRange.getFirst(l), l2);
            httpRequest.setHandled(true);
            return;
        }
        ResourceCache.ResourceMetaData resourceMetaData = (ResourceCache.ResourceMetaData)resource.getAssociate();
        String string2 = resourceMetaData.getMimeType();
        MultiPartResponse multiPartResponse = new MultiPartResponse(httpResponse);
        httpResponse.setStatus(206);
        httpResponse.setReason((String)HttpResponse.__statusMsg.get(TypeUtil.newInteger(206)));
        String string3 = httpRequest.containsField("Request-Range") ? "multipart/x-byteranges; boundary=" : "multipart/byteranges; boundary=";
        httpResponse.setContentType(string3 + multiPartResponse.getBoundary());
        InputStream inputStream = resource instanceof CachedResource ? null : resource.getInputStream();
        OutputStream outputStream = httpResponse.getOutputStream();
        long l3 = 0L;
        for (int i = 0; i < list.size(); ++i) {
            InclusiveByteRange inclusiveByteRange = (InclusiveByteRange)list.get(i);
            String string4 = "Content-Range: " + inclusiveByteRange.toHeaderRangeString(l);
            if (log.isDebugEnabled()) {
                log.debug((Object)("multi range: " + string2 + " " + string4));
            }
            multiPartResponse.startPart(string2, new String[]{string4});
            long l4 = inclusiveByteRange.getFirst(l);
            long l5 = inclusiveByteRange.getSize(l);
            if (inputStream != null) {
                if (l4 < l3) {
                    inputStream.close();
                    inputStream = resource.getInputStream();
                    l3 = 0L;
                }
                if (l3 < l4) {
                    inputStream.skip(l4 - l3);
                    l3 = l4;
                }
                IO.copy(inputStream, outputStream, l5);
                l3 += l5;
                continue;
            }
            resource.writeTo(outputStream, l4, l5);
        }
        if (inputStream != null) {
            inputStream.close();
        }
        multiPartResponse.close();
        httpRequest.setHandled(true);
    }

    void sendDirectory(HttpRequest httpRequest, HttpResponse httpResponse, Resource resource, boolean bl) throws IOException {
        if (!this._dirAllowed) {
            httpResponse.sendError(403);
            return;
        }
        httpRequest.setHandled(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sendDirectory: " + resource));
        }
        byte[] byArray = null;
        if (resource instanceof CachedResource) {
            byArray = ((CachedResource)resource).getCachedData();
        }
        if (byArray == null) {
            String string = URI.addPaths(httpRequest.getPath(), "/");
            String string2 = resource.getListHTML(URI.encodePath(string), bl);
            if (string2 == null) {
                httpResponse.sendError(403, "No directory");
                return;
            }
            byArray = string2.getBytes("UTF8");
            if (resource instanceof CachedResource) {
                ((CachedResource)resource).setCachedData(byArray);
            }
        }
        httpResponse.setContentType("text/html; charset=UTF8");
        httpResponse.setContentLength(byArray.length);
        if (httpRequest.getMethod().equals("HEAD")) {
            httpResponse.commit();
            return;
        }
        httpResponse.getOutputStream().write(byArray, 0, byArray.length);
        httpResponse.commit();
    }
}

