/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.handler;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.HttpTunnel;
import org.mortbay.http.handler.AbstractHttpHandler;
import org.mortbay.log.LogFactory;
import org.mortbay.util.IO;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.LineInput;
import org.mortbay.util.LogSupport;
import org.mortbay.util.StringMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URI;

public class ProxyHandler
extends AbstractHttpHandler {
    private static Log log = LogFactory.getLog(ProxyHandler.class);
    protected Set _proxyHostsWhiteList;
    protected Set _proxyHostsBlackList;
    protected int _tunnelTimeoutMs = 250;
    private boolean _anonymous = false;
    private transient boolean _chained = false;
    protected StringMap _DontProxyHeaders = new StringMap();
    protected StringMap _ProxyAuthHeaders;
    protected StringMap _ProxySchemes;
    protected HashSet _allowedConnectPorts;

    public ProxyHandler() {
        Object object = new Object();
        this._DontProxyHeaders.setIgnoreCase(true);
        this._DontProxyHeaders.put("Proxy-Connection", object);
        this._DontProxyHeaders.put("Connection", object);
        this._DontProxyHeaders.put("keep-alive", object);
        this._DontProxyHeaders.put("Transfer-Encoding", object);
        this._DontProxyHeaders.put("TE", object);
        this._DontProxyHeaders.put("Trailer", object);
        this._DontProxyHeaders.put("Upgrade", object);
        this._ProxyAuthHeaders = new StringMap();
        object = new Object();
        this._ProxyAuthHeaders.put("Proxy-Authorization", object);
        this._ProxyAuthHeaders.put("Proxy-Authenticate", object);
        this._ProxySchemes = new StringMap();
        object = new Object();
        this._ProxySchemes.setIgnoreCase(true);
        this._ProxySchemes.put("http", object);
        this._ProxySchemes.put("https", object);
        this._ProxySchemes.put("ftp", object);
        this._allowedConnectPorts = new HashSet();
        this._allowedConnectPorts.add(new Integer(80));
        this._allowedConnectPorts.add(new Integer(8000));
        this._allowedConnectPorts.add(new Integer(8080));
        this._allowedConnectPorts.add(new Integer(8888));
        this._allowedConnectPorts.add(new Integer(443));
        this._allowedConnectPorts.add(new Integer(8443));
    }

    public void start() throws Exception {
        this._chained = System.getProperty("http.proxyHost") != null;
        super.start();
    }

    public String[] getProxyHostsWhiteList() {
        if (this._proxyHostsWhiteList == null || this._proxyHostsWhiteList.size() == 0) {
            return new String[0];
        }
        String[] stringArray = new String[this._proxyHostsWhiteList.size()];
        stringArray = this._proxyHostsWhiteList.toArray(stringArray);
        return stringArray;
    }

    public void setProxyHostsWhiteList(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this._proxyHostsWhiteList = null;
        } else {
            this._proxyHostsWhiteList = new HashSet();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].trim().length() <= 0) continue;
                this._proxyHostsWhiteList.add(stringArray[i]);
            }
        }
    }

    public String[] getProxyHostsBlackList() {
        if (this._proxyHostsBlackList == null || this._proxyHostsBlackList.size() == 0) {
            return new String[0];
        }
        String[] stringArray = new String[this._proxyHostsBlackList.size()];
        stringArray = this._proxyHostsBlackList.toArray(stringArray);
        return stringArray;
    }

    public void setProxyHostsBlackList(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this._proxyHostsBlackList = null;
        } else {
            this._proxyHostsBlackList = new HashSet();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].trim().length() <= 0) continue;
                this._proxyHostsBlackList.add(stringArray[i]);
            }
        }
    }

    public int getTunnelTimeoutMs() {
        return this._tunnelTimeoutMs;
    }

    public void setTunnelTimeoutMs(int n) {
        this._tunnelTimeoutMs = n;
    }

    public void handle(String string, String string2, HttpRequest httpRequest, HttpResponse httpResponse) throws HttpException, IOException {
        block25: {
            URI uRI = httpRequest.getURI();
            if ("CONNECT".equalsIgnoreCase(httpRequest.getMethod())) {
                httpResponse.setField("Connection", "close");
                this.handleConnect(string, string2, httpRequest, httpResponse);
                return;
            }
            try {
                Object object;
                String string3;
                String string4;
                URL uRL = this.isProxied(uRI);
                if (uRL == null) {
                    if (this.isForbidden(uRI)) {
                        this.sendForbid(httpRequest, httpResponse, uRI);
                    }
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("PROXY URL=" + uRL));
                }
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setAllowUserInteraction(false);
                HttpURLConnection httpURLConnection = null;
                if (uRLConnection instanceof HttpURLConnection) {
                    httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setRequestMethod(httpRequest.getMethod());
                    httpURLConnection.setInstanceFollowRedirects(false);
                }
                if ((string4 = httpRequest.getField("Connection")) != null && (string4.equalsIgnoreCase("keep-alive") || string4.equalsIgnoreCase("close"))) {
                    string4 = null;
                }
                boolean bl = false;
                boolean bl2 = false;
                Enumeration enumeration = httpRequest.getFieldNames();
                while (enumeration.hasMoreElements()) {
                    string3 = (String)enumeration.nextElement();
                    if (this._DontProxyHeaders.containsKey(string3) || !this._chained && this._ProxyAuthHeaders.containsKey(string3) || string4 != null && string4.indexOf(string3) >= 0) continue;
                    if ("Content-Type".equals(string3)) {
                        bl2 = true;
                    }
                    object = httpRequest.getFieldValues(string3);
                    while (object.hasMoreElements()) {
                        String string5 = (String)object.nextElement();
                        if (string5 == null) continue;
                        uRLConnection.addRequestProperty(string3, string5);
                        bl |= "X-Forwarded-For".equalsIgnoreCase(string3);
                    }
                }
                if (!this._anonymous) {
                    uRLConnection.setRequestProperty("Via", "1.1 (jetty)");
                }
                if (!bl) {
                    uRLConnection.addRequestProperty("X-Forwarded-For", httpRequest.getRemoteAddr());
                }
                if ((string3 = httpRequest.getField("Cache-Control")) != null && (string3.indexOf("no-cache") >= 0 || string3.indexOf("no-store") >= 0)) {
                    uRLConnection.setUseCaches(false);
                }
                this.customizeConnection(string, string2, httpRequest, uRLConnection);
                try {
                    uRLConnection.setDoInput(true);
                    object = httpRequest.getInputStream();
                    if (bl2) {
                        uRLConnection.setDoOutput(true);
                        IO.copy((InputStream)object, uRLConnection.getOutputStream());
                    }
                    uRLConnection.connect();
                }
                catch (Exception exception) {
                    LogSupport.ignore(log, exception);
                }
                object = null;
                int n = 500;
                if (httpURLConnection != null) {
                    object = httpURLConnection.getErrorStream();
                    n = httpURLConnection.getResponseCode();
                    httpResponse.setStatus(n);
                    httpResponse.setReason(httpURLConnection.getResponseMessage());
                }
                if (object == null) {
                    try {
                        object = uRLConnection.getInputStream();
                    }
                    catch (Exception exception) {
                        LogSupport.ignore(log, exception);
                        object = httpURLConnection.getErrorStream();
                    }
                }
                httpResponse.removeField("Date");
                httpResponse.removeField("Server");
                int n2 = 0;
                String string6 = uRLConnection.getHeaderFieldKey(n2);
                String string7 = uRLConnection.getHeaderField(n2);
                while (string6 != null || string7 != null) {
                    if (!(string6 == null || string7 == null || this._DontProxyHeaders.containsKey(string6) || !this._chained && this._ProxyAuthHeaders.containsKey(string6))) {
                        httpResponse.addField(string6, string7);
                    }
                    string6 = uRLConnection.getHeaderFieldKey(++n2);
                    string7 = uRLConnection.getHeaderField(n2);
                }
                if (!this._anonymous) {
                    httpResponse.setField("Via", "1.1 (jetty)");
                }
                httpRequest.setHandled(true);
                if (object != null) {
                    IO.copy((InputStream)object, httpResponse.getOutputStream());
                }
            }
            catch (Exception exception) {
                log.warn((Object)exception.toString());
                LogSupport.ignore(log, exception);
                if (httpResponse.isCommitted()) break block25;
                httpResponse.sendError(400);
            }
        }
    }

    public void handleConnect(String string, String string2, HttpRequest httpRequest, HttpResponse httpResponse) throws HttpException, IOException {
        URI uRI = httpRequest.getURI();
        try {
            InetAddrPort inetAddrPort;
            if (log.isDebugEnabled()) {
                log.debug((Object)("CONNECT: " + uRI));
            }
            if (this.isForbidden("https", (inetAddrPort = new InetAddrPort(uRI.toString())).getHost(), inetAddrPort.getPort(), false)) {
                this.sendForbid(httpRequest, httpResponse, uRI);
            } else {
                Object object;
                HttpConnection httpConnection = httpRequest.getHttpConnection();
                httpConnection.forceClose();
                int n = 30000;
                Object object2 = httpConnection.getConnection();
                if (object2 instanceof Socket) {
                    object = (Socket)object2;
                    n = ((Socket)object).getSoTimeout();
                }
                if ((object = this.newHttpTunnel(httpRequest, httpResponse, inetAddrPort.getInetAddress(), inetAddrPort.getPort(), n)) != null) {
                    if (this._tunnelTimeoutMs > 0) {
                        ((HttpTunnel)object).getSocket().setSoTimeout(this._tunnelTimeoutMs);
                        if (object2 instanceof Socket) {
                            Socket socket = (Socket)object2;
                            socket.setSoTimeout(this._tunnelTimeoutMs);
                        }
                    }
                    ((HttpTunnel)object).setTimeoutMs(n);
                    this.customizeConnection(string, string2, httpRequest, ((HttpTunnel)object).getSocket());
                    httpRequest.getHttpConnection().setHttpTunnel((HttpTunnel)object);
                    httpResponse.setStatus(200);
                    httpResponse.setContentLength(0);
                }
                httpRequest.setHandled(true);
            }
        }
        catch (Exception exception) {
            LogSupport.ignore(log, exception);
            httpResponse.sendError(500);
        }
    }

    protected HttpTunnel newHttpTunnel(HttpRequest httpRequest, HttpResponse httpResponse, InetAddress inetAddress, int n, int n2) throws IOException {
        try {
            Socket socket = null;
            LineInput lineInput = null;
            String string = System.getProperty("http.proxyHost");
            if (string == null) {
                socket = new Socket(inetAddress, n);
                socket.setSoTimeout(n2);
                socket.setTcpNoDelay(true);
            } else {
                int n3;
                int n4 = Integer.getInteger("http.proxyPort", 8888);
                Socket socket2 = new Socket(string, n4);
                socket2.setSoTimeout(n2);
                socket2.setTcpNoDelay(true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("chain proxy socket=" + socket2));
                }
                LineInput lineInput2 = new LineInput(socket2.getInputStream());
                byte[] byArray = httpRequest.toString().getBytes(StringUtil.__ISO_8859_1);
                socket2.getOutputStream().write(byArray);
                String string2 = lineInput2.readLine();
                HttpFields httpFields = new HttpFields();
                httpFields.read(lineInput2);
                int n5 = string2.indexOf(32);
                if (n5 > 0 && n5 + 1 < string2.length() && (n3 = string2.indexOf(32, n5 + 1)) > n5) {
                    int n6 = Integer.parseInt(string2.substring(n5 + 1, n3));
                    if (n6 >= 200 && n6 < 300) {
                        socket = socket2;
                        lineInput = lineInput2;
                    } else {
                        Enumeration enumeration = httpFields.getFieldNames();
                        while (enumeration.hasMoreElements()) {
                            String string3 = (String)enumeration.nextElement();
                            if (this._DontProxyHeaders.containsKey(string3)) continue;
                            Enumeration enumeration2 = httpFields.getValues(string3);
                            while (enumeration2.hasMoreElements()) {
                                String string4 = (String)enumeration2.nextElement();
                                httpResponse.setField(string3, string4);
                            }
                        }
                        httpResponse.sendError(n6);
                        if (!socket2.isClosed()) {
                            socket2.close();
                        }
                    }
                }
            }
            if (socket == null) {
                return null;
            }
            HttpTunnel httpTunnel = new HttpTunnel(socket, lineInput, null);
            return httpTunnel;
        }
        catch (IOException iOException) {
            log.debug((Object)iOException);
            httpResponse.sendError(400);
            return null;
        }
    }

    protected void customizeConnection(String string, String string2, HttpRequest httpRequest, Socket socket) throws IOException {
    }

    protected void customizeConnection(String string, String string2, HttpRequest httpRequest, URLConnection uRLConnection) throws IOException {
    }

    protected URL isProxied(URI uRI) throws MalformedURLException {
        if (this.isForbidden(uRI)) {
            return null;
        }
        return new URL(uRI.toString());
    }

    protected boolean isForbidden(URI uRI) {
        String string = uRI.getScheme();
        String string2 = uRI.getHost();
        int n = uRI.getPort();
        return this.isForbidden(string, string2, n, true);
    }

    protected boolean isForbidden(String string, String string2, int n, boolean bl) {
        Integer n2 = new Integer(n);
        if (!(n <= 0 || this._allowedConnectPorts.contains(n2) || bl && n > 1024)) {
            return true;
        }
        if (string == null || !this._ProxySchemes.containsKey(string)) {
            return true;
        }
        if (this._proxyHostsWhiteList != null && !this._proxyHostsWhiteList.contains(string2)) {
            return true;
        }
        return this._proxyHostsBlackList != null && this._proxyHostsBlackList.contains(string2);
    }

    protected void sendForbid(HttpRequest httpRequest, HttpResponse httpResponse, URI uRI) throws IOException {
        httpResponse.sendError(403, "Forbidden for Proxy");
    }

    public boolean isAnonymous() {
        return this._anonymous;
    }

    public void setAnonymous(boolean bl) {
        this._anonymous = bl;
    }
}

