/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.ajp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpServer;
import org.mortbay.http.ajp.AJP13Connection;
import org.mortbay.log.LogFactory;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.ThreadedServer;

public class AJP13Listener
extends ThreadedServer
implements HttpListener {
    private static Log log = LogFactory.getLog(AJP13Listener.class);
    private HttpServer _server;
    private boolean _lastOut = false;
    private boolean _lastLow = false;
    private String _integralScheme = "https";
    private String _confidentialScheme = "https";
    private int _integralPort = 0;
    private int _confidentialPort = 0;
    private boolean _identifyListener = false;
    private int _bufferSize = 8192;
    private int _bufferReserve = 512;
    private String[] _remoteServers;
    private HttpHandler _handler;

    public AJP13Listener() {
    }

    public AJP13Listener(InetAddrPort inetAddrPort) {
        super(inetAddrPort);
    }

    public void setHttpServer(HttpServer httpServer) {
        this._server = httpServer;
    }

    public HttpServer getHttpServer() {
        return this._server;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int n) {
        this._bufferSize = n;
        if (this._bufferSize > 8192) {
            log.warn((Object)("AJP Data buffer > 8192: " + n));
        }
    }

    public int getBufferReserve() {
        return this._bufferReserve;
    }

    public void setBufferReserve(int n) {
        this._bufferReserve = n;
    }

    public boolean getIdentifyListener() {
        return this._identifyListener;
    }

    public void setIdentifyListener(boolean bl) {
        this._identifyListener = bl;
    }

    public String getDefaultScheme() {
        return "http";
    }

    public void start() throws Exception {
        super.start();
        log.info((Object)("Started AJP13Listener on " + this.getInetAddrPort()));
        log.info((Object)("NOTICE: AJP13 is not a secure protocol. Please protect the port " + this.getInetAddrPort()));
    }

    public void stop() throws InterruptedException {
        super.stop();
        log.info((Object)("Stopped AJP13Listener on " + this.getInetAddrPort()));
    }

    public String[] getRemoteServers() {
        return this._remoteServers;
    }

    public void setRemoteServers(String[] stringArray) {
        this._remoteServers = stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConnection(Socket socket) throws IOException {
        if (this._remoteServers != null && this._remoteServers.length > 0) {
            boolean bl = false;
            InetAddress inetAddress = socket.getInetAddress();
            String string = inetAddress.getHostAddress();
            String string2 = inetAddress.getHostName();
            for (int i = 0; i < this._remoteServers.length; ++i) {
                if (!string2.equals(this._remoteServers[i]) && !string.equals(this._remoteServers[i])) continue;
                bl = true;
                break;
            }
            if (!bl) {
                log.warn((Object)("AJP13 Connection from un-approved host: " + inetAddress));
                return;
            }
        }
        socket.setTcpNoDelay(true);
        socket.setSoTimeout(this.getMaxIdleTimeMs());
        AJP13Connection aJP13Connection = this.createConnection(socket);
        try {
            aJP13Connection.handle();
        }
        finally {
            aJP13Connection.destroy();
        }
    }

    protected AJP13Connection createConnection(Socket socket) throws IOException {
        return new AJP13Connection(this, socket.getInputStream(), socket.getOutputStream(), socket, this.getBufferSize());
    }

    public void customizeRequest(HttpConnection httpConnection, HttpRequest httpRequest) {
        if (this._identifyListener) {
            httpRequest.setAttribute("org.mortbay.http.HttpListener", this.getName());
        }
        Socket socket = (Socket)httpConnection.getConnection();
        this.customizeRequest(socket, httpRequest);
    }

    protected void customizeRequest(Socket socket, HttpRequest httpRequest) {
    }

    public void persistConnection(HttpConnection httpConnection) {
    }

    public boolean isLowOnResources() {
        boolean bl;
        boolean bl2 = bl = this.getThreads() == this.getMaxThreads() && this.getIdleThreads() < this.getMinThreads();
        if (bl && !this._lastLow) {
            log.info((Object)("LOW ON THREADS: " + this));
        } else if (!bl && this._lastLow) {
            log.info((Object)("OK on threads: " + this));
            this._lastOut = false;
        }
        this._lastLow = bl;
        return bl;
    }

    public boolean isOutOfResources() {
        boolean bl;
        boolean bl2 = bl = this.getThreads() == this.getMaxThreads() && this.getIdleThreads() == 0;
        if (bl && !this._lastOut) {
            log.warn((Object)("OUT OF THREADS: " + this));
        }
        this._lastOut = bl;
        return bl;
    }

    public boolean isIntegral(HttpConnection httpConnection) {
        return ((AJP13Connection)httpConnection).isSSL();
    }

    public boolean isConfidential(HttpConnection httpConnection) {
        return ((AJP13Connection)httpConnection).isSSL();
    }

    public String getIntegralScheme() {
        return this._integralScheme;
    }

    public void setIntegralScheme(String string) {
        this._integralScheme = string;
    }

    public int getIntegralPort() {
        return this._integralPort;
    }

    public void setIntegralPort(int n) {
        this._integralPort = n;
    }

    public String getConfidentialScheme() {
        return this._confidentialScheme;
    }

    public void setConfidentialScheme(String string) {
        this._confidentialScheme = string;
    }

    public int getConfidentialPort() {
        return this._confidentialPort;
    }

    public void setConfidentialPort(int n) {
        this._confidentialPort = n;
    }

    public HttpHandler getHttpHandler() {
        return this._handler;
    }

    public void setHttpHandler(HttpHandler httpHandler) {
        this._handler = httpHandler;
    }
}

