/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.ajp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.Version;
import org.mortbay.http.ajp.AJP13InputStream;
import org.mortbay.http.ajp.AJP13Listener;
import org.mortbay.http.ajp.AJP13OutputStream;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LineInput;
import org.mortbay.util.LogSupport;
import org.mortbay.util.URI;

public class AJP13Connection
extends HttpConnection {
    private static Log log = LogFactory.getLog(AJP13Connection.class);
    private AJP13Listener _listener;
    private AJP13InputStream _ajpIn;
    private AJP13OutputStream _ajpOut;
    private String _remoteHost;
    private String _remoteAddr;
    private String _serverName;
    private int _serverPort;
    private boolean _isSSL;

    public AJP13Connection(AJP13Listener aJP13Listener, InputStream inputStream, OutputStream outputStream, Socket socket, int n) throws IOException {
        super(aJP13Listener, null, new AJP13InputStream(inputStream, outputStream, n), outputStream, socket);
        LineInput lineInput = (LineInput)this.getInputStream().getInputStream();
        this._ajpIn = (AJP13InputStream)lineInput.getInputStream();
        this._ajpOut = new AJP13OutputStream(this.getOutputStream().getOutputStream(), n);
        this._ajpOut.setCommitObserver(this);
        this.getOutputStream().setBufferedOutputStream(this._ajpOut);
        this._listener = aJP13Listener;
    }

    public InetAddress getRemoteInetAddress() {
        return null;
    }

    public void destroy() {
        if (this._ajpIn != null) {
            this._ajpIn.destroy();
        }
        this._ajpIn = null;
        if (this._ajpOut != null) {
            this._ajpOut.destroy();
        }
        this._ajpOut = null;
        this._remoteHost = null;
        this._remoteAddr = null;
        this._serverName = null;
    }

    public String getRemoteAddr() {
        return this._remoteAddr;
    }

    public String getRemoteHost() {
        return this._remoteHost;
    }

    public String getServerName() {
        return this._serverName;
    }

    public int getServerPort() {
        return this._serverPort;
    }

    public String getDefaultScheme() {
        return this._isSSL ? "https" : super.getDefaultScheme();
    }

    public boolean isSSL() {
        return this._isSSL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleNext() {
        var1_1 = null;
        var2_2 = this.getRequest();
        var3_3 = this.getResponse();
        var4_4 = null;
        var5_5 = false;
        this._persistent = true;
        this._keepAlive = true;
        try {
            try {
                block71: {
                    try {
                        var1_1 = null;
                        var1_1 = this._ajpIn.nextPacket();
                        if (var1_1 != null) ** GOTO lbl-1000
                        var6_6 = false;
                        ** GOTO lbl54
                    }
                    catch (IOException var6_8) {
                        LogSupport.ignore(AJP13Connection.log, var6_8);
                        var7_54 = false;
                        var17_14 = null;
                        if (var1_1 == null) return false;
                        if (!var5_5) {
                            return false;
                        }
                        try {
                            try {
                                this.getOutputStream().close();
                                if (!this._persistent) {
                                    this._ajpOut.end();
                                }
                                this._ajpOut.close();
                                this.getOutputStream().resetStream();
                                this.getOutputStream().addObserver(this);
                                this.getInputStream().resetStream();
                                this._ajpIn.resetStream();
                                this._ajpOut.resetStream();
                            }
                            catch (Exception var18_42) {
                                AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)var18_42);
                                this._persistent = false;
                                var20_26 = null;
                                this.statsRequestEnd();
                                if (var4_4 == null) return var7_54;
                                var4_4.log(var2_2, var3_3, -1);
                                return var7_54;
                            }
                            var20_25 = null;
                        }
                        catch (Throwable var19_49) {
                            var20_27 = null;
                            this.statsRequestEnd();
                            if (var4_4 == null) throw var19_49;
                            var4_4.log(var2_2, var3_3, -1);
                            throw var19_49;
                        }
lbl54:
                        // 1 sources

                        var17_12 = null;
                        if (var1_1 == null) return false;
                        if (!var5_5) {
                            return false;
                        }
                        ** GOTO lbl-1000
lbl-1000:
                        // 1 sources

                        {
                            if (var1_1.getDataSize() != 0) break block71;
                            var6_7 = true;
                        }
                        ** GOTO lbl328
                        this.statsRequestEnd();
                        if (var4_4 == null) return var7_54;
                        var4_4.log(var2_2, var3_3, -1);
                        return var7_54;
                    }
                }
                var6_9 = var1_1.getByte();
                if (AJP13Connection.log.isDebugEnabled()) {
                    AJP13Connection.log.debug((Object)("AJP13 type=" + var6_9 + " size=" + var1_1.unconsumedData()));
                }
                switch (var6_9) {
                    case 2: {
                        var2_2.setTimeStamp(System.currentTimeMillis());
                        var2_2.setState(0);
                        var2_2.setMethod(var1_1.getMethod());
                        var2_2.setVersion(var1_1.getString());
                        var7_55 = var1_1.getString();
                        var8_57 = var7_55.lastIndexOf(";");
                        if (var8_57 < 0) {
                            var2_2.setPath(URI.encodePath(var7_55));
                        } else {
                            var2_2.setPath(URI.encodePath(var7_55.substring(0, var8_57)) + var7_55.substring(var8_57));
                        }
                        this._remoteAddr = var1_1.getString();
                        this._remoteHost = var1_1.getString();
                        this._serverName = var1_1.getString();
                        this._serverPort = var1_1.getInt();
                        this._isSSL = var1_1.getBoolean();
                        this._keepAlive = var2_2.getDotVersion() >= 1;
                        var9_58 = var1_1.getInt();
                        for (var10_59 = 0; var10_59 < var9_58; ++var10_59) {
                            var11_60 = var1_1.getHeader();
                            var12_61 = var1_1.getString();
                            var2_2.addField(var11_60, (String)var12_61);
                            if (this._keepAlive || !var11_60.equalsIgnoreCase("Connection") || !var12_61.equalsIgnoreCase("keep-alive")) continue;
                            this._keepAlive = true;
                        }
                        var10_59 = var1_1.getByte();
                        while ((255 & var10_59) != 255) {
                            var11_60 = var10_59 == 11 ? null : var1_1.getString();
                            switch (var10_59) {
                                case 11: {
                                    var2_2.setAttribute("javax.servlet.request.key_size", new Integer(var1_1.getInt()));
                                    break;
                                }
                                case 10: {
                                    var2_2.setAttribute(var11_60, var1_1.getString());
                                    break;
                                }
                                case 9: {
                                    var2_2.setAttribute("javax.servlet.request.ssl_session", var11_60);
                                    break;
                                }
                                case 8: {
                                    var2_2.setAttribute("javax.servlet.request.cipher_suite", var11_60);
                                    break;
                                }
                                case 7: {
                                    var12_61 = CertificateFactory.getInstance("X.509");
                                    var13_62 = new ByteArrayInputStream(var11_60.getBytes());
                                    var14_63 = (X509Certificate)var12_61.generateCertificate(var13_62);
                                    var15_64 = new X509Certificate[]{var14_63};
                                    var2_2.setAttribute("javax.servlet.request.X509Certificate", var15_64);
                                    break;
                                }
                                case 6: {
                                    var2_2.setAttribute("org.mortbay.http.ajp.JVMRoute", var11_60);
                                    break;
                                }
                                case 5: {
                                    var2_2.setQuery(var11_60);
                                    break;
                                }
                                case 4: {
                                    var2_2.setAuthType(var11_60);
                                    break;
                                }
                                case 3: {
                                    var2_2.setAuthUser(var11_60);
                                    break;
                                }
                                default: {
                                    AJP13Connection.log.warn((Object)("Unknown attr: " + var10_59 + "=" + var11_60));
                                }
                            }
                            var10_59 = var1_1.getByte();
                        }
                        this._listener.customizeRequest(this, var2_2);
                        var5_5 = true;
                        this.statsRequestStart();
                        var2_2.setState(2);
                        if (var2_2.getContentLength() == 0 && var2_2.getField("Transfer-Encoding") == null) {
                            this._ajpIn.close();
                        }
                        var3_3.setState(0);
                        var3_3.setVersion("HTTP/1.1");
                        var3_3.setDateField("Date", this._request.getTimeStamp());
                        if (!Version.isParanoid()) {
                            var3_3.setField("Server", Version.getDetail());
                        }
                        if (AJP13Connection.log.isDebugEnabled()) {
                            AJP13Connection.log.debug((Object)("REQUEST:\n" + var2_2));
                        }
                        var4_4 = this.service(var2_2, var3_3);
                        if (!AJP13Connection.log.isDebugEnabled()) break;
                        AJP13Connection.log.debug((Object)("RESPONSE:\n" + var3_3));
                        break;
                    }
                    default: {
                        if (AJP13Connection.log.isDebugEnabled()) {
                            AJP13Connection.log.debug((Object)("Ignored: " + var1_1));
                        }
                        this._persistent = false;
                        break;
                    }
                }
                ** GOTO lbl366
            }
            catch (SocketException var6_10) {
                LogSupport.ignore(AJP13Connection.log, var6_10);
                this._persistent = false;
                var17_16 = null;
                if (var1_1 == null) return false;
                if (!var5_5) {
                    return false;
                }
                try {}
                catch (Throwable var19_51) {
                    var20_33 = null;
                    this.statsRequestEnd();
                    if (var4_4 == null) throw var19_51;
                    var4_4.log(var2_2, var3_3, -1);
                    throw var19_51;
                }
                try {}
                catch (Exception var18_44) {
                    AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)var18_44);
                    this._persistent = false;
                    var20_32 = null;
                    this.statsRequestEnd();
                    if (var4_4 == null) return this._persistent;
                    var4_4.log(var2_2, var3_3, -1);
                    return this._persistent;
                }
                this.getOutputStream().close();
                if (!this._persistent) {
                    this._ajpOut.end();
                }
                this._ajpOut.close();
                this.getOutputStream().resetStream();
                this.getOutputStream().addObserver(this);
                this.getInputStream().resetStream();
                this._ajpIn.resetStream();
                this._ajpOut.resetStream();
                var20_31 = null;
                this.statsRequestEnd();
                if (var4_4 == null) return this._persistent;
                var4_4.log(var2_2, var3_3, -1);
                return this._persistent;
            }
            catch (Exception var6_11) {
                AJP13Connection.log.warn((Object)"EXCEPTION ", (Throwable)var6_11);
                this._persistent = false;
                try {
                    if (var5_5) {
                        this._ajpOut.close();
                    }
                }
                catch (IOException var7_56) {
                    LogSupport.ignore(AJP13Connection.log, var7_56);
                }
                var17_17 = null;
                if (var1_1 == null) return false;
                if (!var5_5) {
                    return false;
                }
                try {}
                catch (Throwable var19_52) {
                    var20_36 = null;
                    this.statsRequestEnd();
                    if (var4_4 == null) throw var19_52;
                    var4_4.log(var2_2, var3_3, -1);
                    throw var19_52;
                }
                try {}
                catch (Exception var18_45) {
                    AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)var18_45);
                    this._persistent = false;
                    var20_35 = null;
                    this.statsRequestEnd();
                    if (var4_4 == null) return this._persistent;
                    var4_4.log(var2_2, var3_3, -1);
                    return this._persistent;
                }
                this.getOutputStream().close();
                if (!this._persistent) {
                    this._ajpOut.end();
                }
                this._ajpOut.close();
                this.getOutputStream().resetStream();
                this.getOutputStream().addObserver(this);
                this.getInputStream().resetStream();
                this._ajpIn.resetStream();
                this._ajpOut.resetStream();
                var20_34 = null;
                this.statsRequestEnd();
                if (var4_4 == null) return this._persistent;
                var4_4.log(var2_2, var3_3, -1);
                return this._persistent;
            }
        }
        catch (Throwable var16_65) {
            block72: {
                var17_18 = null;
                if (var1_1 == null) return false;
                if (!var5_5) {
                    return false;
                }
                try {}
                catch (Throwable var19_53) {
                    var20_39 = null;
                    this.statsRequestEnd();
                    if (var4_4 == null) throw var19_53;
                    var4_4.log(var2_2, var3_3, -1);
                    throw var19_53;
                }
                try {}
                catch (Exception var18_46) {
                    AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)var18_46);
                    this._persistent = false;
                    var20_38 = null;
                    this.statsRequestEnd();
                    if (var4_4 == null) throw var16_65;
                    var4_4.log(var2_2, var3_3, -1);
                    throw var16_65;
                }
                this.getOutputStream().close();
                if (!this._persistent) {
                    this._ajpOut.end();
                }
                this._ajpOut.close();
                this.getOutputStream().resetStream();
                this.getOutputStream().addObserver(this);
                this.getInputStream().resetStream();
                this._ajpIn.resetStream();
                this._ajpOut.resetStream();
                break block72;
lbl-1000:
                // 1 sources

                try {}
                catch (Throwable var19_47) {
                    var20_21 = null;
                    this.statsRequestEnd();
                    if (var4_4 == null) throw var19_47;
                    var4_4.log(var2_2, var3_3, -1);
                    throw var19_47;
                }
                try {}
                catch (Exception var18_40) {
                    AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)var18_40);
                    this._persistent = false;
                    var20_20 = null;
                    this.statsRequestEnd();
                    if (var4_4 == null) return var6_6;
                    var4_4.log(var2_2, var3_3, -1);
                    return var6_6;
                }
                this.getOutputStream().close();
                if (!this._persistent) {
                    this._ajpOut.end();
                }
                this._ajpOut.close();
                this.getOutputStream().resetStream();
                this.getOutputStream().addObserver(this);
                this.getInputStream().resetStream();
                this._ajpIn.resetStream();
                this._ajpOut.resetStream();
                var20_19 = null;
                this.statsRequestEnd();
                if (var4_4 == null) return var6_6;
                var4_4.log(var2_2, var3_3, -1);
                return var6_6;
lbl328:
                // 1 sources

                var17_13 = null;
                if (var1_1 == null) return false;
                if (!var5_5) {
                    return false;
                }
                try {}
                catch (Throwable var19_48) {
                    var20_24 = null;
                    this.statsRequestEnd();
                    if (var4_4 == null) throw var19_48;
                    var4_4.log(var2_2, var3_3, -1);
                    throw var19_48;
                }
                try {}
                catch (Exception var18_41) {
                    AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)var18_41);
                    this._persistent = false;
                    var20_23 = null;
                    this.statsRequestEnd();
                    if (var4_4 == null) return var6_7;
                    var4_4.log(var2_2, var3_3, -1);
                    return var6_7;
                }
                this.getOutputStream().close();
                if (!this._persistent) {
                    this._ajpOut.end();
                }
                this._ajpOut.close();
                this.getOutputStream().resetStream();
                this.getOutputStream().addObserver(this);
                this.getInputStream().resetStream();
                this._ajpIn.resetStream();
                this._ajpOut.resetStream();
                var20_22 = null;
                this.statsRequestEnd();
                if (var4_4 == null) return var6_7;
                var4_4.log(var2_2, var3_3, -1);
                return var6_7;
lbl366:
                // 1 sources

                var17_15 = null;
                if (var1_1 == null) return false;
                if (!var5_5) {
                    return false;
                }
                try {}
                catch (Throwable var19_50) {
                    var20_30 = null;
                    this.statsRequestEnd();
                    if (var4_4 == null) throw var19_50;
                    var4_4.log(var2_2, var3_3, -1);
                    throw var19_50;
                }
                try {}
                catch (Exception var18_43) {
                    AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)var18_43);
                    this._persistent = false;
                    var20_29 = null;
                    this.statsRequestEnd();
                    if (var4_4 == null) return this._persistent;
                    var4_4.log(var2_2, var3_3, -1);
                    return this._persistent;
                }
                this.getOutputStream().close();
                if (!this._persistent) {
                    this._ajpOut.end();
                }
                this._ajpOut.close();
                this.getOutputStream().resetStream();
                this.getOutputStream().addObserver(this);
                this.getInputStream().resetStream();
                this._ajpIn.resetStream();
                this._ajpOut.resetStream();
                var20_28 = null;
                this.statsRequestEnd();
                if (var4_4 == null) return this._persistent;
                var4_4.log(var2_2, var3_3, -1);
                return this._persistent;
            }
            var20_37 = null;
            this.statsRequestEnd();
            if (var4_4 == null) throw var16_65;
            var4_4.log(var2_2, var3_3, -1);
            throw var16_65;
        }
    }

    protected void firstWrite() throws IOException {
        log.debug((Object)"ajp13 firstWrite()");
    }

    protected void commit() throws IOException {
        log.debug((Object)"ajp13 commit()");
        if (this._response.isCommitted()) {
            return;
        }
        this._request.setHandled(true);
        this.getOutputStream().writeHeader(this._response);
    }

    protected void setupOutputStream() throws IOException {
        if ("HEAD".equals(this.getRequest().getMethod())) {
            this.getOutputStream().nullOutput();
        }
    }
}

