/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.SocketListener;
import org.mortbay.jetty.servlet.ServletSSL;
import org.mortbay.log.LogFactory;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.Password;
import org.mortbay.util.Resource;

public class SslListener
extends SocketListener {
    private static Log log = LogFactory.getLog(SslListener.class);
    private String[] cipherSuites = null;
    public static final String DEFAULT_KEYSTORE = System.getProperty("user.home") + File.separator + ".keystore";
    public static final String PASSWORD_PROPERTY = "jetty.ssl.password";
    public static final String KEYPASSWORD_PROPERTY = "jetty.ssl.keypassword";
    static final String CACHED_INFO_ATTR = CachedInfo.class.getName();
    private String _keystore = DEFAULT_KEYSTORE;
    private transient Password _password;
    private transient Password _keypassword;
    private boolean _needClientAuth = false;
    private boolean _wantClientAuth = false;
    private String _protocol = "TLS";
    private String _algorithm = "SunX509";
    private String _keystoreType = "JKS";
    private String _provider = null;

    public SslListener() {
        this.setDefaultScheme("https");
    }

    public SslListener(InetAddrPort inetAddrPort) {
        super(inetAddrPort);
        if (inetAddrPort.getPort() == 0) {
            inetAddrPort.setPort(443);
            this.setPort(443);
        }
        this.setDefaultScheme("https");
    }

    public String[] getCipherSuites() {
        return this.cipherSuites;
    }

    public void setCipherSuites(String[] stringArray) {
        this.cipherSuites = stringArray;
    }

    public void setPassword(String string) {
        this._password = Password.getPassword(PASSWORD_PROPERTY, string, null);
    }

    public void setKeyPassword(String string) {
        this._keypassword = Password.getPassword(KEYPASSWORD_PROPERTY, string, null);
    }

    public String getAlgorithm() {
        return this._algorithm;
    }

    public void setAlgorithm(String string) {
        this._algorithm = string;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setProtocol(String string) {
        this._protocol = string;
    }

    public void setKeystore(String string) {
        this._keystore = string;
    }

    public String getKeystore() {
        return this._keystore;
    }

    public String getKeystoreType() {
        return this._keystoreType;
    }

    public void setKeystoreType(String string) {
        this._keystoreType = string;
    }

    public void setNeedClientAuth(boolean bl) {
        this._needClientAuth = bl;
    }

    public boolean getNeedClientAuth() {
        return this._needClientAuth;
    }

    public void setWantClientAuth(boolean bl) {
        this._wantClientAuth = bl;
    }

    public boolean getWantClientAuth() {
        return this._wantClientAuth;
    }

    public boolean isIntegral(HttpConnection httpConnection) {
        int n = this.getIntegralPort();
        return n == 0 || n == this.getPort();
    }

    public boolean isConfidential(HttpConnection httpConnection) {
        int n = this.getConfidentialPort();
        return n == 0 || n == this.getPort();
    }

    protected SSLServerSocketFactory createFactory() throws Exception {
        SSLContext sSLContext = this._provider == null ? SSLContext.getInstance(this._protocol) : SSLContext.getInstance(this._protocol, this._provider);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this._algorithm);
        KeyStore keyStore = KeyStore.getInstance(this._keystoreType);
        keyStore.load(Resource.newResource(this._keystore).getInputStream(), this._password.toString().toCharArray());
        keyManagerFactory.init(keyStore, this._keypassword.toString().toCharArray());
        sSLContext.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
        return sSLContext.getServerSocketFactory();
    }

    protected ServerSocket newServerSocket(InetAddrPort inetAddrPort, int n) throws IOException {
        SSLServerSocketFactory sSLServerSocketFactory = null;
        SSLServerSocket sSLServerSocket = null;
        try {
            sSLServerSocketFactory = this.createFactory();
            sSLServerSocket = inetAddrPort == null ? (SSLServerSocket)sSLServerSocketFactory.createServerSocket(0, n) : (SSLServerSocket)sSLServerSocketFactory.createServerSocket(inetAddrPort.getPort(), n, inetAddrPort.getInetAddress());
            if (this._needClientAuth) {
                sSLServerSocket.setNeedClientAuth(true);
            } else if (this._wantClientAuth) {
                sSLServerSocket.setWantClientAuth(true);
            }
            if (this.cipherSuites != null && this.cipherSuites.length > 0) {
                sSLServerSocket.setEnabledCipherSuites(this.cipherSuites);
                for (int i = 0; i < this.cipherSuites.length; ++i) {
                    log.debug((Object)("SslListener enabled ciphersuite: " + this.cipherSuites[i]));
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
            throw new IOException("Could not create JsseListener: " + exception.toString());
        }
        return sSLServerSocket;
    }

    protected Socket accept(ServerSocket serverSocket) throws IOException {
        try {
            SSLSocket sSLSocket = (SSLSocket)serverSocket.accept();
            if (this.getMaxIdleTimeMs() > 0) {
                sSLSocket.setSoTimeout(this.getMaxIdleTimeMs());
            }
            sSLSocket.startHandshake();
            return sSLSocket;
        }
        catch (SSLException sSLException) {
            log.warn((Object)"EXCEPTION ", (Throwable)sSLException);
            throw new IOException(sSLException.getMessage());
        }
    }

    protected void customizeRequest(Socket socket, HttpRequest httpRequest) {
        super.customizeRequest(socket, httpRequest);
        if (!(socket instanceof SSLSocket)) {
            return;
        }
        try {
            java.security.cert.X509Certificate[] x509CertificateArray;
            Integer n;
            SSLSocket sSLSocket = (SSLSocket)socket;
            SSLSession sSLSession = sSLSocket.getSession();
            String string = sSLSession.getCipherSuite();
            CachedInfo cachedInfo = (CachedInfo)sSLSession.getValue(CACHED_INFO_ATTR);
            if (cachedInfo != null) {
                n = cachedInfo.getKeySize();
                x509CertificateArray = cachedInfo.getCerts();
            } else {
                n = new Integer(ServletSSL.deduceKeyLength(string));
                x509CertificateArray = SslListener.getCertChain(sSLSession);
                cachedInfo = new CachedInfo(n, x509CertificateArray);
                sSLSession.putValue(CACHED_INFO_ATTR, cachedInfo);
            }
            if (x509CertificateArray != null) {
                httpRequest.setAttribute("javax.servlet.request.X509Certificate", x509CertificateArray);
            } else if (this._needClientAuth) {
                throw new HttpException(403);
            }
            httpRequest.setAttribute("javax.servlet.request.cipher_suite", string);
            httpRequest.setAttribute("javax.servlet.request.key_size", n);
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
        }
    }

    private static java.security.cert.X509Certificate[] getCertChain(SSLSession sSLSession) {
        try {
            X509Certificate[] x509CertificateArray = sSLSession.getPeerCertificateChain();
            if (x509CertificateArray == null || x509CertificateArray.length == 0) {
                return null;
            }
            int n = x509CertificateArray.length;
            java.security.cert.X509Certificate[] x509CertificateArray2 = new java.security.cert.X509Certificate[n];
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < n; ++i) {
                byte[] byArray = x509CertificateArray[i].getEncoded();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                x509CertificateArray2[i] = (java.security.cert.X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            }
            return x509CertificateArray2;
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return null;
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
            return null;
        }
    }

    public String getProvider() {
        return this._provider;
    }

    public void setProvider(String string) {
        this._provider = string;
    }

    private class CachedInfo {
        private Integer _keySize;
        private java.security.cert.X509Certificate[] _certs;

        CachedInfo(Integer n, java.security.cert.X509Certificate[] x509CertificateArray) {
            this._keySize = n;
            this._certs = x509CertificateArray;
        }

        Integer getKeySize() {
            return this._keySize;
        }

        java.security.cert.X509Certificate[] getCerts() {
            return this._certs;
        }
    }
}

