/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpFields;
import org.mortbay.log.LogFactory;
import org.mortbay.util.CachedResource;
import org.mortbay.util.LifeCycle;
import org.mortbay.util.Resource;
import org.mortbay.util.StringUtil;

public class ResourceCache
implements LifeCycle,
Serializable {
    private static Log log;
    private static final Map __dftMimeMap;
    private static final Map __encodings;
    private int _maxCachedFileSize = 1024;
    private int _maxCacheSize = 1024;
    private Resource _resourceBase;
    private Map _mimeMap;
    private Map _encodingMap;
    private transient boolean _started;
    protected transient Map _cache = new HashMap();
    protected transient int _cacheSize;
    protected transient CachedMetaData _mostRecentlyUsed;
    protected transient CachedMetaData _leastRecentlyUsed;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._cache = new HashMap();
    }

    public String getResourceBase() {
        if (this._resourceBase == null) {
            return null;
        }
        return this._resourceBase.toString();
    }

    public void setResourceBase(String string) {
        try {
            this._resourceBase = Resource.newResource(string);
            if (log.isDebugEnabled()) {
                log.debug((Object)("resourceBase=" + this._resourceBase + " for " + this));
            }
        }
        catch (IOException iOException) {
            log.debug((Object)"EXCEPTION ", (Throwable)iOException);
            throw new IllegalArgumentException(string + ":" + iOException.toString());
        }
    }

    public Resource getBaseResource() {
        return this._resourceBase;
    }

    public void setBaseResource(Resource resource) {
        this._resourceBase = resource;
    }

    public int getMaxCachedFileSize() {
        return this._maxCachedFileSize;
    }

    public void setMaxCachedFileSize(int n) {
        this._maxCachedFileSize = n;
        this._cache.clear();
    }

    public int getMaxCacheSize() {
        return this._maxCacheSize;
    }

    public void setMaxCacheSize(int n) {
        this._maxCacheSize = n;
        this._cache.clear();
    }

    public void flushCache() {
        this._cache.clear();
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getResource(String string) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("getResource " + string));
        }
        if (this._resourceBase == null) {
            return null;
        }
        Resource resource = null;
        Map map = this._cache;
        synchronized (map) {
            CachedResource cachedResource = (CachedResource)this._cache.get(string);
            if (cachedResource != null) {
                CachedMetaData cachedMetaData;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("CACHE HIT: " + cachedResource));
                }
                if ((cachedMetaData = (CachedMetaData)cachedResource.getAssociate()) != null && cachedMetaData.isValid()) {
                    return cachedResource;
                }
            }
            resource = this._resourceBase.addPath(this._resourceBase.encode(string));
            if (log.isTraceEnabled()) {
                log.trace((Object)("CACHE MISS: " + resource));
            }
            if (resource == null) {
                return null;
            }
            if (resource.getAlias() != null) {
                log.warn((Object)("Alias request of '" + resource.getAlias() + "' for '" + resource + "'"));
                return null;
            }
            long l = resource.length();
            if (resource.exists()) {
                if (!resource.isDirectory() && string.endsWith("/")) {
                    return null;
                }
                if (resource.isDirectory()) {
                    l = resource.list() != null ? (long)(resource.list().length * 100) : 0L;
                }
                if (l > 0L && l < (long)this._maxCachedFileSize && l < (long)this._maxCacheSize) {
                    int n = this._maxCacheSize - (int)l;
                    while (this._cacheSize > n) {
                        this._leastRecentlyUsed.invalidate();
                    }
                    cachedResource = resource.cache();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("CACHED: " + resource));
                    }
                    new CachedMetaData(cachedResource, string);
                    return cachedResource;
                }
            }
        }
        new ResourceMetaData(resource);
        return resource;
    }

    public synchronized Map getMimeMap() {
        return this._mimeMap;
    }

    public void setMimeMap(Map map) {
        this._mimeMap = map;
    }

    public String getMimeByExtension(String string) {
        String string2 = null;
        if (string != null) {
            int n = -1;
            while (string2 == null && (n = string.indexOf(".", n + 1)) >= 0 && n < string.length()) {
                String string3 = StringUtil.asciiToLowerCase(string.substring(n + 1));
                if (this._mimeMap != null) {
                    string2 = (String)this._mimeMap.get(string3);
                }
                if (string2 != null) continue;
                string2 = (String)__dftMimeMap.get(string3);
            }
        }
        if (string2 == null) {
            if (this._mimeMap != null) {
                string2 = (String)this._mimeMap.get("*");
            }
            if (string2 == null) {
                string2 = (String)__dftMimeMap.get("*");
            }
        }
        return string2;
    }

    public void setMimeMapping(String string, String string2) {
        if (this._mimeMap == null) {
            this._mimeMap = new HashMap();
        }
        this._mimeMap.put(StringUtil.asciiToLowerCase(string), string2);
    }

    public synchronized Map getEncodingMap() {
        if (this._encodingMap == null) {
            this._encodingMap = Collections.unmodifiableMap(__encodings);
        }
        return this._encodingMap;
    }

    public void setEncodingMap(Map map) {
        this._encodingMap = map;
    }

    public String getEncodingByMimeType(String string) {
        String string2 = null;
        if (string != null) {
            string2 = (String)this._encodingMap.get(string);
        }
        return string2;
    }

    public void setTypeEncoding(String string, String string2) {
        this.getEncodingMap().put(string, string2);
    }

    public synchronized void start() throws Exception {
        if (this.isStarted()) {
            return;
        }
        this.getMimeMap();
        this.getEncodingMap();
        this._started = true;
    }

    public boolean isStarted() {
        return this._started;
    }

    public void stop() throws InterruptedException {
        this._started = false;
        this._cache.clear();
    }

    public void destroy() {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this.setMimeMap(null);
        this._encodingMap = null;
    }

    public ResourceMetaData getResourceMetaData(Resource resource) {
        Object object = resource.getAssociate();
        if (object instanceof ResourceMetaData) {
            return (ResourceMetaData)object;
        }
        return new ResourceMetaData(resource);
    }

    static {
        Object object;
        log = LogFactory.getLog(ResourceCache.class);
        __dftMimeMap = new HashMap();
        __encodings = new HashMap();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/mortbay/http/mime");
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            __dftMimeMap.put(StringUtil.asciiToLowerCase((String)object), resourceBundle.getString((String)object));
        }
        object = ResourceBundle.getBundle("org/mortbay/http/encoding");
        enumeration = ((ResourceBundle)object).getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            __encodings.put(string, ((ResourceBundle)object).getString(string));
        }
    }

    private class CachedMetaData
    extends ResourceMetaData {
        String _lastModified;
        String _encoding;
        String _length;
        String _key;
        CachedResource _cached;
        CachedMetaData _prev;
        CachedMetaData _next;

        CachedMetaData(CachedResource cachedResource, String string) {
            super(cachedResource);
            this._cached = cachedResource;
            this._length = super.getLength();
            this._lastModified = super.getLastModified();
            this._encoding = super.getMimeType();
            this._key = string;
            this._next = ResourceCache.this._mostRecentlyUsed;
            ResourceCache.this._mostRecentlyUsed = this;
            if (this._next != null) {
                this._next._prev = this;
            }
            this._prev = null;
            if (ResourceCache.this._leastRecentlyUsed == null) {
                ResourceCache.this._leastRecentlyUsed = this;
            }
            ResourceCache.this._cache.put(this._key, cachedResource);
            ResourceCache.this._cacheSize = (int)((long)ResourceCache.this._cacheSize + this._cached.length());
        }

        public String getLength() {
            return this._length;
        }

        public String getLastModified() {
            return this._lastModified;
        }

        public String getMimeType() {
            return this._encoding;
        }

        boolean isValid() throws IOException {
            if (this._cached.isUptoDate()) {
                if (ResourceCache.this._mostRecentlyUsed != this) {
                    CachedMetaData cachedMetaData = this._prev;
                    CachedMetaData cachedMetaData2 = this._next;
                    this._next = ResourceCache.this._mostRecentlyUsed;
                    ResourceCache.this._mostRecentlyUsed = this;
                    if (this._next != null) {
                        this._next._prev = this;
                    }
                    this._prev = null;
                    if (cachedMetaData != null) {
                        cachedMetaData._next = cachedMetaData2;
                    }
                    if (cachedMetaData2 != null) {
                        cachedMetaData2._prev = cachedMetaData;
                    }
                    if (ResourceCache.this._leastRecentlyUsed == this && cachedMetaData != null) {
                        ResourceCache.this._leastRecentlyUsed = cachedMetaData;
                    }
                }
                return true;
            }
            this.invalidate();
            return false;
        }

        public void invalidate() {
            ResourceCache.this._cache.remove(this._key);
            ResourceCache.this._cacheSize -= (int)this._cached.length();
            if (ResourceCache.this._mostRecentlyUsed == this) {
                ResourceCache.this._mostRecentlyUsed = this._next;
            } else {
                this._prev._next = this._next;
            }
            if (ResourceCache.this._leastRecentlyUsed == this) {
                ResourceCache.this._leastRecentlyUsed = this._prev;
            } else {
                this._next._prev = this._prev;
            }
            this._prev = null;
            this._next = null;
        }
    }

    public class ResourceMetaData {
        protected String _name;
        protected Resource _resource;

        ResourceMetaData(Resource resource) {
            this._resource = resource;
            this._name = this._resource.toString();
            this._resource.setAssociate(this);
        }

        public String getLength() {
            return Long.toString(this._resource.length());
        }

        public String getLastModified() {
            return HttpFields.formatDate(this._resource.lastModified(), false);
        }

        public String getMimeType() {
            return ResourceCache.this.getMimeByExtension(this._name);
        }
    }
}

