/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.mortbay.http.HashUserRealm;
import org.mortbay.http.HttpRequest;
import org.mortbay.log.LogFactory;
import org.mortbay.util.Loader;
import org.mortbay.util.Resource;

public class JDBCUserRealm
extends HashUserRealm {
    private static Log log = LogFactory.getLog(JDBCUserRealm.class);
    private String _jdbcDriver;
    private String _url;
    private String _userName;
    private String _password;
    private String _userTable;
    private String _userTableKey;
    private String _userTableUserField;
    private String _userTablePasswordField;
    private String _roleTable;
    private String _roleTableKey;
    private String _roleTableRoleField;
    private String _userRoleTable;
    private String _userRoleTableUserKey;
    private String _userRoleTableRoleKey;
    private int _cacheTime;
    private long _lastHashPurge;
    private Connection _con;
    private String _userSql;
    private String _roleSql;

    public JDBCUserRealm(String string) {
        super(string);
    }

    public JDBCUserRealm(String string, String string2) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        super(string);
        this.loadConfig(string2);
        Loader.loadClass(this.getClass(), this._jdbcDriver).newInstance();
        this.connectDatabase();
    }

    public void loadConfig(String string) throws IOException {
        Properties properties = new Properties();
        Resource resource = Resource.newResource(string);
        properties.load(resource.getInputStream());
        this._jdbcDriver = properties.getProperty("jdbcdriver");
        this._url = properties.getProperty("url");
        this._userName = properties.getProperty("username");
        this._password = properties.getProperty("password");
        this._userTable = properties.getProperty("usertable");
        this._userTableKey = properties.getProperty("usertablekey");
        this._userTableUserField = properties.getProperty("usertableuserfield");
        this._userTablePasswordField = properties.getProperty("usertablepasswordfield");
        this._roleTable = properties.getProperty("roletable");
        this._roleTableKey = properties.getProperty("roletablekey");
        this._roleTableRoleField = properties.getProperty("roletablerolefield");
        this._userRoleTable = properties.getProperty("userroletable");
        this._userRoleTableUserKey = properties.getProperty("userroletableuserkey");
        this._userRoleTableRoleKey = properties.getProperty("userroletablerolekey");
        this._cacheTime = new Integer(properties.getProperty("cachetime"));
        if ((this._jdbcDriver == null || this._jdbcDriver.equals("") || this._url == null || this._url.equals("") || this._userName == null || this._userName.equals("") || this._password == null || this._cacheTime < 0) && log.isDebugEnabled()) {
            log.debug((Object)("UserRealm " + this.getName() + " has not been properly configured"));
        }
        this._cacheTime *= 1000;
        this._lastHashPurge = 0L;
        this._userSql = "select " + this._userTableKey + "," + this._userTablePasswordField + " from " + this._userTable + " where " + this._userTableUserField + " = ?";
        this._roleSql = "select r." + this._roleTableRoleField + " from " + this._roleTable + " r, " + this._userRoleTable + " u where u." + this._userRoleTableUserKey + " = ?" + " and r." + this._roleTableKey + " = u." + this._userRoleTableRoleKey;
    }

    public void logout(Principal principal) {
        this.remove(principal.getName());
    }

    public void connectDatabase() {
        try {
            this._con = DriverManager.getConnection(this._url, this._userName, this._password);
        }
        catch (SQLException sQLException) {
            log.warn((Object)("UserRealm " + this.getName() + " could not connect to database; will try later"), (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal authenticate(String string, Object object, HttpRequest httpRequest) {
        JDBCUserRealm jDBCUserRealm = this;
        synchronized (jDBCUserRealm) {
            Principal principal;
            long l = System.currentTimeMillis();
            if (l - this._lastHashPurge > (long)this._cacheTime || this._cacheTime == 0) {
                super.clear();
                this._roles.clear();
                this._lastHashPurge = l;
            }
            if ((principal = (Principal)super.get(string)) == null) {
                this.loadUser(string);
                principal = (Principal)super.get(string);
            }
        }
        return super.authenticate(string, object, httpRequest);
    }

    private void loadUser(String string) {
        try {
            if (null == this._con) {
                this.connectDatabase();
            }
            if (null == this._con) {
                throw new SQLException("Can't connect to database");
            }
            PreparedStatement preparedStatement = this._con.prepareStatement(this._userSql);
            preparedStatement.setObject(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                Object object = resultSet.getObject(this._userTableKey);
                this.put(string, resultSet.getString(this._userTablePasswordField));
                preparedStatement.close();
                preparedStatement = this._con.prepareStatement(this._roleSql);
                preparedStatement.setObject(1, object);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    this.addUserToRole(string, resultSet.getString(this._roleTableRoleField));
                }
                preparedStatement.close();
            }
        }
        catch (SQLException sQLException) {
            log.warn((Object)("UserRealm " + this.getName() + " could not load user information from database"), (Throwable)sQLException);
            this.connectDatabase();
        }
    }
}

