/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.PathMap;
import org.mortbay.http.RequestLog;
import org.mortbay.http.SocketListener;
import org.mortbay.http.UserRealm;
import org.mortbay.http.Version;
import org.mortbay.http.handler.DumpHandler;
import org.mortbay.http.handler.NotFoundHandler;
import org.mortbay.http.handler.ResourceHandler;
import org.mortbay.log.LogFactory;
import org.mortbay.util.Container;
import org.mortbay.util.EventProvider;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.LifeCycle;
import org.mortbay.util.MultiException;
import org.mortbay.util.Resource;
import org.mortbay.util.StringMap;
import org.mortbay.util.ThreadPool;
import org.mortbay.util.URI;

public class HttpServer
extends Container
implements LifeCycle,
EventProvider,
Serializable {
    private static Log log = LogFactory.getLog(HttpServer.class);
    private static WeakHashMap __servers = new WeakHashMap();
    private static Collection __roServers = Collections.unmodifiableCollection(__servers.keySet());
    private static String[] __noVirtualHost = new String[1];
    private List _listeners = new ArrayList(3);
    private HashMap _realmMap = new HashMap(3);
    private StringMap _virtualHostMap = new StringMap();
    private boolean _trace = false;
    private RequestLog _requestLog;
    private int _requestsPerGC;
    private boolean _resolveRemoteHost = false;
    private String[] _serverClasses;
    private String[] _systemClasses;
    private transient int _gcRequests;
    private transient HttpContext _notFoundContext = null;
    private transient boolean _gracefulStop;
    private boolean _statsOn = false;
    private transient Object _statsLock = new Object[0];
    private transient long _statsStartedAt = 0L;
    private transient int _connections;
    private transient int _connectionsOpen;
    private transient int _connectionsOpenMin;
    private transient int _connectionsOpenMax;
    private transient long _connectionsDurationMin;
    private transient long _connectionsDurationMax;
    private transient long _connectionsDurationTotal;
    private transient int _errors;
    private transient int _requests;
    private transient int _requestsActive;
    private transient int _requestsActiveMin;
    private transient int _requestsActiveMax;
    private transient int _connectionsRequestsMin;
    private transient int _connectionsRequestsMax;
    private transient long _requestsDurationMin;
    private transient long _requestsDurationMax;
    private transient long _requestsDurationTotal;

    public static Collection getHttpServers() {
        return __roServers;
    }

    public static List getHttpServerList() {
        return new ArrayList(__roServers);
    }

    public HttpServer() {
        this(false);
    }

    public HttpServer(boolean bl) {
        this.setAnonymous(bl);
        this._virtualHostMap.setIgnoreCase(true);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        HttpListener[] httpListenerArray = this.getListeners();
        HttpContext[] httpContextArray = this.getContexts();
        this._listeners.clear();
        this._virtualHostMap.clear();
        this.setContexts(httpContextArray);
        this.setListeners(httpListenerArray);
        this._statsLock = new Object[0];
    }

    public void setAnonymous(boolean bl) {
        if (bl) {
            __servers.remove(this);
        } else {
            __servers.put(this, __servers);
        }
    }

    public void setStopGracefully(boolean bl) {
        this._gracefulStop = bl;
    }

    public boolean getStopGracefully() {
        return this._gracefulStop;
    }

    public void setListeners(HttpListener[] httpListenerArray) {
        int n;
        ArrayList arrayList = new ArrayList(this._listeners);
        for (n = 0; n < httpListenerArray.length; ++n) {
            boolean bl = arrayList.remove(httpListenerArray[n]);
            if (bl) continue;
            this.addListener(httpListenerArray[n]);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            HttpListener httpListener = (HttpListener)arrayList.get(n);
            this.removeListener(httpListener);
        }
    }

    public HttpListener[] getListeners() {
        if (this._listeners == null) {
            return new HttpListener[0];
        }
        HttpListener[] httpListenerArray = new HttpListener[this._listeners.size()];
        return this._listeners.toArray(httpListenerArray);
    }

    public HttpListener addListener(String string) throws IOException {
        return this.addListener(new InetAddrPort(string));
    }

    public HttpListener addListener(InetAddrPort inetAddrPort) throws IOException {
        SocketListener socketListener = new SocketListener(inetAddrPort);
        socketListener.setHttpServer(this);
        this._listeners.add(socketListener);
        this.addComponent(socketListener);
        return socketListener;
    }

    public HttpListener addListener(HttpListener httpListener) throws IllegalArgumentException {
        httpListener.setHttpServer(this);
        this._listeners.add(httpListener);
        this.addComponent(httpListener);
        return httpListener;
    }

    public void removeListener(HttpListener httpListener) {
        if (httpListener == null) {
            return;
        }
        for (int i = 0; i < this._listeners.size(); ++i) {
            if (!httpListener.equals(this._listeners.get(i))) continue;
            this._listeners.remove(i);
            this.removeComponent(httpListener);
            if (httpListener.isStarted()) {
                try {
                    httpListener.stop();
                }
                catch (InterruptedException interruptedException) {
                    log.warn((Object)"EXCEPTION ", (Throwable)interruptedException);
                }
            }
            httpListener.setHttpServer(null);
        }
    }

    public synchronized void setContexts(HttpContext[] httpContextArray) {
        int n;
        List<HttpContext> list = Arrays.asList(this.getContexts());
        for (n = 0; n < httpContextArray.length; ++n) {
            boolean bl = list.remove(httpContextArray[n]);
            if (bl) continue;
            this.addContext(httpContextArray[n]);
        }
        for (n = 0; n < list.size(); ++n) {
            this.removeContext(list.get(n));
        }
    }

    public synchronized HttpContext[] getContexts() {
        if (this._virtualHostMap == null) {
            return new HttpContext[0];
        }
        ArrayList<HttpContext> arrayList = new ArrayList<HttpContext>(33);
        Iterator iterator = this._virtualHostMap.values().iterator();
        while (iterator.hasNext()) {
            PathMap pathMap = (PathMap)iterator.next();
            Iterator iterator2 = pathMap.values().iterator();
            while (iterator2.hasNext()) {
                List list = (List)iterator2.next();
                for (int i = 0; i < list.size(); ++i) {
                    HttpContext httpContext = (HttpContext)list.get(i);
                    if (arrayList.contains(httpContext)) continue;
                    arrayList.add(httpContext);
                }
            }
        }
        return arrayList.toArray(new HttpContext[arrayList.size()]);
    }

    public HttpContext addContext(HttpContext httpContext) {
        if (httpContext.getContextPath() == null || httpContext.getContextPath().length() == 0) {
            throw new IllegalArgumentException("No Context Path Set");
        }
        boolean bl = this.removeMappings(httpContext);
        if (!bl) {
            httpContext.setHttpServer(this);
            this.addComponent(httpContext);
        }
        this.addMappings(httpContext);
        return httpContext;
    }

    public boolean removeContext(HttpContext httpContext) throws IllegalStateException {
        if (this.removeMappings(httpContext)) {
            this.removeComponent(httpContext);
            if (httpContext.isStarted()) {
                try {
                    httpContext.stop();
                }
                catch (InterruptedException interruptedException) {
                    log.warn((Object)"EXCEPTION ", (Throwable)interruptedException);
                }
            }
            httpContext.setHttpServer(null);
            return true;
        }
        return false;
    }

    public HttpContext addContext(String string, HttpContext httpContext) {
        if (string != null) {
            httpContext.addVirtualHost(string);
        }
        this.addContext(httpContext);
        return httpContext;
    }

    public HttpContext addContext(String string) {
        HttpContext httpContext = this.newHttpContext();
        httpContext.setContextPath(string);
        this.addContext(httpContext);
        return httpContext;
    }

    public HttpContext addContext(String string, String string2) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        HttpContext httpContext = this.newHttpContext();
        httpContext.setContextPath(string2);
        if (string != null) {
            httpContext.addVirtualHost(string);
        }
        this.addContext(httpContext);
        return httpContext;
    }

    public HttpContext getContext(String string, String string2, int n) {
        List list;
        HttpContext httpContext = null;
        string2 = HttpContext.canonicalContextPathSpec(string2);
        PathMap pathMap = (PathMap)this._virtualHostMap.get(string);
        if (pathMap != null && (list = (List)pathMap.get(string2)) != null) {
            if (n >= list.size()) {
                return null;
            }
            httpContext = (HttpContext)list.get(n);
        }
        return httpContext;
    }

    public HttpContext getContext(String string, String string2) {
        List list;
        HttpContext httpContext = null;
        string2 = HttpContext.canonicalContextPathSpec(string2);
        PathMap pathMap = (PathMap)this._virtualHostMap.get(string);
        if (pathMap != null && (list = (List)pathMap.get(string2)) != null && list.size() > 0) {
            httpContext = (HttpContext)list.get(list.size() - 1);
        }
        if (httpContext == null) {
            httpContext = this.addContext(string, string2);
        }
        return httpContext;
    }

    public HttpContext getContext(String string) {
        return this.getContext(null, string);
    }

    protected HttpContext newHttpContext() {
        return new HttpContext();
    }

    synchronized void addMapping(String string, HttpContext httpContext) {
        String string2;
        ArrayList<HttpContext> arrayList;
        PathMap pathMap = (PathMap)this._virtualHostMap.get(string);
        if (pathMap == null) {
            pathMap = new PathMap(7);
            this._virtualHostMap.put(string, (Object)pathMap);
        }
        if ((arrayList = (ArrayList<HttpContext>)pathMap.get(string2 = HttpContext.canonicalContextPathSpec(httpContext.getContextPath()))) == null) {
            arrayList = new ArrayList<HttpContext>(1);
            pathMap.put(string2, arrayList);
        }
        arrayList.add(httpContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added " + httpContext + " for host " + (string == null ? "*" : string)));
        }
    }

    synchronized void addMappings(HttpContext httpContext) {
        if (httpContext == this._notFoundContext) {
            return;
        }
        String[] stringArray = httpContext.getVirtualHosts();
        if (stringArray == null || stringArray.length == 0) {
            stringArray = __noVirtualHost;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.addMapping(string, httpContext);
        }
    }

    synchronized boolean removeMapping(String string, HttpContext httpContext) {
        boolean bl = false;
        if (this._virtualHostMap != null) {
            PathMap pathMap = (PathMap)this._virtualHostMap.get(string);
            Iterator iterator = pathMap.values().iterator();
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                if (list.remove(httpContext)) {
                    bl = true;
                }
                if (list.size() != 0) continue;
                iterator.remove();
            }
        }
        return bl;
    }

    synchronized boolean removeMappings(HttpContext httpContext) {
        boolean bl = false;
        if (this._virtualHostMap != null) {
            Iterator iterator = this._virtualHostMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!this.removeMapping(string, httpContext)) continue;
                bl = true;
            }
        }
        return bl;
    }

    public boolean getTrace() {
        return this._trace;
    }

    public void setTrace(boolean bl) {
        this._trace = bl;
    }

    public int getRequestsPerGC() {
        return this._requestsPerGC;
    }

    public void setRequestsPerGC(int n) {
        this._requestsPerGC = n;
    }

    public void setSystemClasses(String[] stringArray) {
        this._systemClasses = stringArray;
    }

    public String[] getSystemClasses() {
        return this._systemClasses;
    }

    public void setServerClasses(String[] stringArray) {
        this._serverClasses = stringArray;
    }

    public String[] getServerClasses() {
        return this._serverClasses;
    }

    protected synchronized void doStart() throws Exception {
        LifeCycle lifeCycle;
        int n;
        log.info((Object)("Version " + Version.getImplVersion()));
        MultiException multiException = new MultiException();
        this.statsReset();
        if (log.isDebugEnabled()) {
            log.debug((Object)("LISTENERS: " + this._listeners));
            log.debug((Object)("HANDLER: " + this._virtualHostMap));
        }
        if (this._requestLog != null && !this._requestLog.isStarted()) {
            try {
                this._requestLog.start();
            }
            catch (Exception exception) {
                multiException.add(exception);
            }
        }
        HttpContext[] httpContextArray = this.getContexts();
        for (n = 0; n < httpContextArray.length; ++n) {
            lifeCycle = httpContextArray[n];
            try {
                ((Container)lifeCycle).start();
                continue;
            }
            catch (Exception exception) {
                multiException.add(exception);
            }
        }
        for (n = 0; n < this._listeners.size(); ++n) {
            lifeCycle = (HttpListener)this._listeners.get(n);
            lifeCycle.setHttpServer(this);
            if (lifeCycle.isStarted()) continue;
            try {
                lifeCycle.start();
                continue;
            }
            catch (Exception exception) {
                multiException.add(exception);
            }
        }
        multiException.ifExceptionThrowMulti();
    }

    protected synchronized void doStop() throws InterruptedException {
        for (int i = 0; i < this._listeners.size(); ++i) {
            HttpListener httpListener = (HttpListener)this._listeners.get(i);
            if (!httpListener.isStarted()) continue;
            try {
                httpListener.stop();
                continue;
            }
            catch (Exception exception) {
                if (log.isDebugEnabled()) {
                    log.warn((Object)"EXCEPTION ", (Throwable)exception);
                    continue;
                }
                log.warn((Object)exception.toString());
            }
        }
        HttpContext[] httpContextArray = this.getContexts();
        for (int i = 0; i < httpContextArray.length; ++i) {
            HttpContext httpContext = httpContextArray[i];
            httpContext.stop(this._gracefulStop);
        }
        if (this._notFoundContext != null) {
            this._notFoundContext.stop();
            this.removeComponent(this._notFoundContext);
        }
        this._notFoundContext = null;
        if (this._requestLog != null && this._requestLog.isStarted()) {
            this._requestLog.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(boolean bl) throws InterruptedException {
        boolean bl2 = this._gracefulStop;
        try {
            this._gracefulStop = bl;
            this.stop();
        }
        finally {
            this._gracefulStop = bl2;
        }
    }

    public void join() throws InterruptedException {
        for (int i = 0; i < this._listeners.size(); ++i) {
            HttpListener httpListener = (HttpListener)this._listeners.get(i);
            if (!httpListener.isStarted() || !(httpListener instanceof ThreadPool)) continue;
            ((ThreadPool)((Object)httpListener)).join();
        }
    }

    public void addHostAlias(String string, String string2) {
        log.warn((Object)"addHostAlias is deprecated. Use HttpContext.addVirtualHost");
        Object object = this._virtualHostMap.get(string);
        if (object == null) {
            throw new IllegalArgumentException("No Such Host: " + string);
        }
        this._virtualHostMap.put(string2, object);
    }

    public synchronized void setRequestLog(RequestLog requestLog) {
        if (this._requestLog != null) {
            this.removeComponent(this._requestLog);
        }
        this._requestLog = requestLog;
        if (this._requestLog != null) {
            this.addComponent(this._requestLog);
        }
    }

    public RequestLog getRequestLog() {
        return this._requestLog;
    }

    void log(HttpRequest httpRequest, HttpResponse httpResponse, int n) {
        if (this._requestLog != null && httpRequest != null && httpResponse != null) {
            this._requestLog.log(httpRequest, httpResponse, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpContext service(HttpRequest httpRequest, HttpResponse httpResponse) throws IOException, HttpException {
        Serializable serializable;
        String string = httpRequest.getHost();
        if (this._requestsPerGC > 0 && this._gcRequests++ > this._requestsPerGC) {
            this._gcRequests = 0;
            System.gc();
        }
        while (true) {
            List list;
            if ((serializable = (PathMap)this._virtualHostMap.get(string)) != null && (list = serializable.getMatches(httpRequest.getPath())) != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Contexts at " + httpRequest.getPath() + ": " + list));
                }
                for (int i = 0; i < list.size(); ++i) {
                    Map.Entry entry = (Map.Entry)list.get(i);
                    List list2 = (List)entry.getValue();
                    for (int j = 0; j < list2.size(); ++j) {
                        HttpContext httpContext = (HttpContext)list2.get(j);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Try " + httpContext + "," + j));
                        }
                        httpContext.handle(httpRequest, httpResponse);
                        if (!httpRequest.isHandled()) continue;
                        return httpContext;
                    }
                }
            }
            if (string == null) break;
            string = null;
        }
        serializable = this;
        synchronized (serializable) {
            if (this._notFoundContext == null) {
                this._notFoundContext = new HttpContext();
                this._notFoundContext.setContextPath("/");
                this._notFoundContext.setHttpServer(this);
                try {
                    this._notFoundContext.addHandler((NotFoundHandler)Class.forName("org.mortbay.http.handler.RootNotFoundHandler").newInstance());
                }
                catch (Exception exception) {
                    this._notFoundContext.addHandler(new NotFoundHandler());
                }
                this.addComponent(this._notFoundContext);
                try {
                    this._notFoundContext.start();
                }
                catch (Exception exception) {
                    log.warn((Object)"EXCEPTION ", (Throwable)exception);
                }
            }
            this._notFoundContext.handle(httpRequest, httpResponse);
            if (!httpRequest.isHandled()) {
                httpResponse.sendError(404);
            }
            return this._notFoundContext;
        }
    }

    public HttpHandler findHandler(Class clazz, String string, String[] stringArray) {
        string = URI.stripPath(string);
        if (stringArray == null || stringArray.length == 0) {
            stringArray = __noVirtualHost;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            List list;
            String string2 = stringArray[i];
            PathMap pathMap = (PathMap)this._virtualHostMap.get(string2);
            if (pathMap == null || (list = pathMap.getMatches(string)) == null) continue;
            for (int j = 0; j < list.size(); ++j) {
                Map.Entry entry = (Map.Entry)list.get(j);
                List list2 = (List)entry.getValue();
                for (int k = 0; k < list2.size(); ++k) {
                    HttpContext httpContext = (HttpContext)list2.get(k);
                    HttpHandler httpHandler = httpContext.getHandler(clazz);
                    if (httpHandler == null) continue;
                    return httpHandler;
                }
            }
        }
        return null;
    }

    public UserRealm addRealm(UserRealm userRealm) {
        return this._realmMap.put(userRealm.getName(), userRealm);
    }

    public UserRealm getRealm(String string) {
        if (string == null) {
            if (this._realmMap.size() == 1) {
                return (UserRealm)this._realmMap.values().iterator().next();
            }
            log.warn((Object)"Null realmName with multiple known realms");
        }
        return (UserRealm)this._realmMap.get(string);
    }

    public UserRealm removeRealm(String string) {
        return (UserRealm)this._realmMap.remove(string);
    }

    public Map getHostMap() {
        return this._virtualHostMap;
    }

    public boolean getResolveRemoteHost() {
        return this._resolveRemoteHost;
    }

    public void setResolveRemoteHost(boolean bl) {
        this._resolveRemoteHost = bl;
    }

    public void statsReset() {
        this._statsStartedAt = System.currentTimeMillis();
        this._connections = 0;
        this._connectionsOpenMin = this._connectionsOpen;
        this._connectionsOpenMax = this._connectionsOpen;
        this._connectionsOpen = 0;
        this._connectionsDurationMin = 0L;
        this._connectionsDurationMax = 0L;
        this._connectionsDurationTotal = 0L;
        this._errors = 0;
        this._requests = 0;
        this._requestsActiveMin = this._requestsActive;
        this._requestsActiveMax = this._requestsActive;
        this._requestsActive = 0;
        this._connectionsRequestsMin = 0;
        this._connectionsRequestsMax = 0;
        this._requestsDurationMin = 0L;
        this._requestsDurationMax = 0L;
        this._requestsDurationTotal = 0L;
    }

    public void setStatsOn(boolean bl) {
        log.info((Object)("Statistics on = " + bl + " for " + this));
        this._statsOn = bl;
    }

    public boolean getStatsOn() {
        return this._statsOn;
    }

    public long getStatsOnMs() {
        return this._statsOn ? System.currentTimeMillis() - this._statsStartedAt : 0L;
    }

    public long getConnectionsDurationMin() {
        return this._connectionsDurationMin;
    }

    public long getConnectionsDurationTotal() {
        return this._connectionsDurationTotal;
    }

    public int getConnectionsOpenMin() {
        return this._connectionsOpenMin;
    }

    public int getConnectionsRequestsMin() {
        return this._connectionsRequestsMin;
    }

    public int getRequestsActiveMin() {
        return this._requestsActiveMin;
    }

    public long getRequestsDurationMin() {
        return this._requestsDurationMin;
    }

    public long getRequestsDurationTotal() {
        return this._requestsDurationTotal;
    }

    public int getConnections() {
        return this._connections;
    }

    public int getConnectionsOpen() {
        return this._connectionsOpen;
    }

    public int getConnectionsOpenMax() {
        return this._connectionsOpenMax;
    }

    public long getConnectionsDurationAve() {
        return this._connections == 0 ? 0L : this._connectionsDurationTotal / (long)this._connections;
    }

    public long getConnectionsDurationMax() {
        return this._connectionsDurationMax;
    }

    public int getConnectionsRequestsAve() {
        return this._connections == 0 ? 0 : this._requests / this._connections;
    }

    public int getConnectionsRequestsMax() {
        return this._connectionsRequestsMax;
    }

    public int getErrors() {
        return this._errors;
    }

    public int getRequests() {
        return this._requests;
    }

    public int getRequestsActive() {
        return this._requestsActive;
    }

    public int getRequestsActiveMax() {
        return this._requestsActiveMax;
    }

    public long getRequestsDurationAve() {
        return this._requests == 0 ? 0L : this._requestsDurationTotal / (long)this._requests;
    }

    public long getRequestsDurationMax() {
        return this._requestsDurationMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void statsOpenConnection() {
        Object object = this._statsLock;
        synchronized (object) {
            ++this._connectionsOpen;
            if (this._connectionsOpen > this._connectionsOpenMax) {
                this._connectionsOpenMax = this._connectionsOpen;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void statsGotRequest() {
        Object object = this._statsLock;
        synchronized (object) {
            ++this._requestsActive;
            if (this._requestsActive > this._requestsActiveMax) {
                this._requestsActiveMax = this._requestsActive;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void statsEndRequest(long l, boolean bl) {
        Object object = this._statsLock;
        synchronized (object) {
            ++this._requests;
            --this._requestsActive;
            if (this._requestsActive < 0) {
                this._requestsActive = 0;
            }
            if (this._requestsActive < this._requestsActiveMin) {
                this._requestsActiveMin = this._requestsActive;
            }
            if (bl) {
                this._requestsDurationTotal += l;
                if (this._requestsDurationMin == 0L || l < this._requestsDurationMin) {
                    this._requestsDurationMin = l;
                }
                if (l > this._requestsDurationMax) {
                    this._requestsDurationMax = l;
                }
            } else {
                ++this._errors;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void statsCloseConnection(long l, int n) {
        Object object = this._statsLock;
        synchronized (object) {
            ++this._connections;
            --this._connectionsOpen;
            this._connectionsDurationTotal += l;
            if (this._connectionsOpen < 0) {
                this._connectionsOpen = 0;
            }
            if (this._connectionsOpen < this._connectionsOpenMin) {
                this._connectionsOpenMin = this._connectionsOpen;
            }
            if (this._connectionsDurationMin == 0L || l < this._connectionsDurationMin) {
                this._connectionsDurationMin = l;
            }
            if (l > this._connectionsDurationMax) {
                this._connectionsDurationMax = l;
            }
            if (this._connectionsRequestsMin == 0 || n < this._connectionsRequestsMin) {
                this._connectionsRequestsMin = n;
            }
            if (n > this._connectionsRequestsMax) {
                this._connectionsRequestsMax = n;
            }
        }
    }

    public void save(String string) throws MalformedURLException, IOException {
        Resource resource = Resource.newResource(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(resource.getOutputStream());
        objectOutputStream.writeObject(this);
        objectOutputStream.flush();
        objectOutputStream.close();
        log.info((Object)("Saved " + this + " to " + resource));
    }

    public void destroy() {
        __servers.remove(this);
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        if (this._listeners != null) {
            this._listeners.clear();
        }
        this._listeners = null;
        if (this._virtualHostMap != null) {
            this._virtualHostMap.clear();
        }
        this._virtualHostMap = null;
        this._notFoundContext = null;
        super.destroy();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0 || stringArray.length > 2) {
            System.err.println("\nUsage - java org.mortbay.http.HttpServer [<addr>:]<port>");
            System.err.println("\nUsage - java org.mortbay.http.HttpServer -r [savefile]");
            System.err.println("  Serves files from '.' directory");
            System.err.println("  Dump handler for not found requests");
            System.err.println("  Default port is 8080");
            System.exit(1);
        }
        try {
            if (stringArray.length == 1) {
                HttpServer httpServer = new HttpServer();
                String string = null;
                HttpContext httpContext = httpServer.getContext(string, "/");
                httpContext.setResourceBase(".");
                httpContext.addHandler(new ResourceHandler());
                httpContext.addHandler(new DumpHandler());
                httpContext.addHandler(new NotFoundHandler());
                InetAddrPort inetAddrPort = new InetAddrPort(stringArray[0]);
                httpServer.addListener(inetAddrPort);
                httpServer.start();
            } else {
                Resource resource = Resource.newResource(stringArray[1]);
                ObjectInputStream objectInputStream = new ObjectInputStream(resource.getInputStream());
                HttpServer httpServer = (HttpServer)objectInputStream.readObject();
                objectInputStream.close();
                httpServer.start();
            }
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
        }
    }
}

