/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpOutputStream;
import org.mortbay.log.LogFactory;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.TypeUtil;

public abstract class HttpMessage {
    private static Log log = LogFactory.getLog(HttpMessage.class);
    public static final String __SCHEME = "http";
    public static final String __SSL_SCHEME = "https";
    public static final String __HTTP_0_9 = "HTTP/0.9";
    public static final String __HTTP_1_0 = "HTTP/1.0";
    public static final String __HTTP_1_1 = "HTTP/1.1";
    public static final String __HTTP_1_X = "HTTP/1.";
    public static final int __MSG_EDITABLE = 0;
    public static final int __MSG_BAD = 1;
    public static final int __MSG_RECEIVED = 2;
    public static final int __MSG_SENDING = 3;
    public static final int __MSG_SENT = 4;
    public static final String[] __state = new String[]{"EDITABLE", "BAD", "RECEIVED", "SENDING", "SENT"};
    protected int _state = 0;
    protected String _version;
    protected int _dotVersion;
    protected HttpFields _header = new HttpFields();
    protected HttpConnection _connection;
    protected String _characterEncoding;
    protected String _mimeType;
    protected Object _wrapper;
    protected Map _attributes;

    protected HttpMessage() {
    }

    protected HttpMessage(HttpConnection httpConnection) {
        this._connection = httpConnection;
    }

    public void setWrapper(Object object) {
        this._wrapper = object;
    }

    public Object getWrapper() {
        return this._wrapper;
    }

    protected void reset() {
        this._state = 0;
        this._header.clear();
    }

    public HttpConnection getHttpConnection() {
        return this._connection;
    }

    public InputStream getInputStream() {
        if (this._connection == null) {
            return null;
        }
        return this._connection.getInputStream();
    }

    public OutputStream getOutputStream() {
        if (this._connection == null) {
            return null;
        }
        return this._connection.getOutputStream();
    }

    public int getState() {
        return this._state;
    }

    public int setState(int n) {
        int n2 = this._state;
        this._state = n;
        return n2;
    }

    public String getVersion() {
        return this._version;
    }

    public int getDotVersion() {
        return this._dotVersion;
    }

    public Enumeration getFieldNames() {
        return this._header.getFieldNames();
    }

    public boolean containsField(String string) {
        return this._header.containsKey(string);
    }

    public String getField(String string) {
        return this._header.get(string);
    }

    public Enumeration getFieldValues(String string) {
        return this._header.getValues(string);
    }

    public Enumeration getFieldValues(String string, String string2) {
        return this._header.getValues(string, string2);
    }

    public String setField(String string, String string2) {
        if (this._state != 0) {
            return null;
        }
        if ("Content-Type".equalsIgnoreCase(string)) {
            String string3 = this._header.get(string);
            this.setContentType(string2);
            return string3;
        }
        return this._header.put(string, string2);
    }

    public void setField(String string, List list) {
        if (this._state != 0) {
            return;
        }
        this._header.put(string, list);
    }

    public void addField(String string, String string2) throws IllegalStateException {
        if (this._state != 0) {
            return;
        }
        this._header.add(string, string2);
    }

    public int getIntField(String string) {
        return this._header.getIntField(string);
    }

    public void setIntField(String string, int n) {
        if (this._state != 0) {
            return;
        }
        this._header.put(string, TypeUtil.toString(n));
    }

    public void addIntField(String string, int n) {
        if (this._state != 0) {
            return;
        }
        this._header.add(string, TypeUtil.toString(n));
    }

    public long getDateField(String string) {
        return this._header.getDateField(string);
    }

    public void setDateField(String string, Date date) {
        if (this._state != 0) {
            return;
        }
        this._header.putDateField(string, date);
    }

    public void addDateField(String string, Date date) {
        if (this._state != 0) {
            return;
        }
        this._header.addDateField(string, date);
    }

    public void setDateField(String string, long l) {
        if (this._state != 0) {
            return;
        }
        this._header.putDateField(string, l);
    }

    public void addDateField(String string, long l) {
        if (this._state != 0) {
            return;
        }
        this._header.addDateField(string, l);
    }

    public String removeField(String string) throws IllegalStateException {
        if (this._state != 0) {
            return null;
        }
        return this._header.remove(string);
    }

    public void setVersion(String string) {
        if (this._state != 0) {
            throw new IllegalStateException("Not EDITABLE");
        }
        if (string.equalsIgnoreCase(__HTTP_1_1)) {
            this._dotVersion = 1;
            this._version = __HTTP_1_1;
        } else if (string.equalsIgnoreCase(__HTTP_1_0)) {
            this._dotVersion = 0;
            this._version = __HTTP_1_0;
        } else if (string.equalsIgnoreCase(__HTTP_0_9)) {
            this._dotVersion = -1;
            this._version = __HTTP_0_9;
        } else {
            throw new IllegalArgumentException("Unknown version");
        }
    }

    public HttpFields getHeader() {
        if (this._state != 0) {
            throw new IllegalStateException("Can't get header in " + __state[this._state]);
        }
        return this._header;
    }

    public int getContentLength() {
        return this.getIntField("Content-Length");
    }

    public void setContentLength(int n) {
        this.setIntField("Content-Length", n);
    }

    public String getCharacterEncoding() {
        return this._characterEncoding;
    }

    public void setCharacterEncoding(String string, boolean bl) {
        if (this.isCommitted()) {
            return;
        }
        if (string == null) {
            if (this._characterEncoding != null) {
                this._characterEncoding = null;
                if (bl) {
                    this._header.put("Content-Type", this._mimeType);
                }
            }
        } else {
            this._characterEncoding = string;
            if (bl && this._mimeType != null) {
                this._header.put("Content-Type", this._mimeType + ";charset=" + QuotedStringTokenizer.quote(this._characterEncoding, ";= "));
            }
        }
    }

    public String getContentType() {
        return this.getField("Content-Type");
    }

    public void setContentType(String string) {
        if (this.isCommitted()) {
            return;
        }
        if (string == null) {
            this._mimeType = null;
            this._header.remove("Content-Type");
        } else {
            int n = string.indexOf(59);
            if (n > 0) {
                this._mimeType = string.substring(0, n).trim();
                int n2 = string.indexOf("charset=", n);
                if (n2 >= 0) {
                    int n3 = string.indexOf(32, n2 += 8);
                    this._characterEncoding = 0 < n3 ? string.substring(n2, n3) : string.substring(n2);
                    this._characterEncoding = QuotedStringTokenizer.unquote(this._characterEncoding);
                } else if (this._characterEncoding != null) {
                    string = string + ";charset=" + QuotedStringTokenizer.quote(this._characterEncoding, ";= ");
                }
            } else {
                this._mimeType = string;
                if (this._characterEncoding != null) {
                    string = string + ";charset=" + QuotedStringTokenizer.quote(this._characterEncoding, ";= ");
                }
            }
            this._header.put("Content-Type", string);
        }
    }

    public void updateMimeType() {
        this._mimeType = null;
        this._characterEncoding = null;
        String string = this._header.get("Content-Type");
        if (string != null) {
            int n = string.indexOf(59);
            if (n > 0) {
                this._mimeType = string.substring(0, n).trim();
                int n2 = string.indexOf("charset=", n);
                if (n2 >= 0) {
                    int n3 = string.indexOf(32, n2 += 8);
                    this._characterEncoding = 0 < n3 ? string.substring(n2, n3) : string.substring(n2);
                    this._characterEncoding = QuotedStringTokenizer.unquote(this._characterEncoding);
                }
            } else {
                this._mimeType = string;
            }
        }
    }

    public String getMimeType() {
        return this._mimeType;
    }

    void recycle(HttpConnection httpConnection) {
        this._state = 0;
        this._version = __HTTP_1_1;
        this._dotVersion = 1;
        this._header.clear();
        this._connection = httpConnection;
        this._characterEncoding = null;
        this._mimeType = null;
        if (this._attributes != null) {
            this._attributes.clear();
        }
    }

    public void destroy() {
        this.recycle(null);
        if (this._header != null) {
            this._header.destroy();
        }
        this._header = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String toString() {
        StringWriter stringWriter = new StringWriter();
        int n = this._state;
        try {
            this._state = 0;
            this.writeHeader(stringWriter);
        }
        catch (IOException iOException) {
            log.warn((Object)"EXCEPTION ", (Throwable)iOException);
        }
        finally {
            this._state = n;
        }
        return stringWriter.toString();
    }

    abstract void writeHeader(Writer var1) throws IOException;

    public boolean isCommitted() {
        return this._state == 3 || this._state == 4;
    }

    public boolean isDirty() {
        HttpOutputStream httpOutputStream = (HttpOutputStream)this.getOutputStream();
        return this._state != 0 || httpOutputStream != null && httpOutputStream.isWritten();
    }

    public Object getAttribute(String string) {
        if (this._attributes == null) {
            return null;
        }
        return this._attributes.get(string);
    }

    public Object setAttribute(String string, Object object) {
        if (this._attributes == null) {
            this._attributes = new HashMap(11);
        }
        return this._attributes.put(string, object);
    }

    public Enumeration getAttributeNames() {
        if (this._attributes == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return Collections.enumeration(this._attributes.keySet());
    }

    public void removeAttribute(String string) {
        if (this._attributes != null) {
            this._attributes.remove(string);
        }
    }

    public static interface HeaderWriter {
        public void writeHeader(HttpMessage var1) throws IOException;
    }
}

