/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.security.Principal;
import org.apache.commons.logging.Log;
import org.mortbay.http.Authenticator;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.UserRealm;
import org.mortbay.log.LogFactory;
import org.mortbay.util.B64Code;
import org.mortbay.util.LogSupport;
import org.mortbay.util.StringUtil;

public class BasicAuthenticator
implements Authenticator {
    private static Log log = LogFactory.getLog(BasicAuthenticator.class);

    public Principal authenticate(UserRealm userRealm, String string, HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        Principal principal = null;
        String string2 = httpRequest.getField("Authorization");
        if (string2 != null) {
            try {
                String string3;
                int n;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Credentials: " + string2));
                }
                string2 = string2.substring(string2.indexOf(32) + 1);
                String string4 = (string2 = B64Code.decode(string2, StringUtil.__ISO_8859_1)).substring(0, n = string2.indexOf(58));
                principal = userRealm.authenticate(string4, string3 = string2.substring(n + 1), httpRequest);
                if (principal == null) {
                    log.warn((Object)("AUTH FAILURE: user " + string4));
                } else {
                    httpRequest.setAuthType("BASIC");
                    httpRequest.setAuthUser(string4);
                    httpRequest.setUserPrincipal(principal);
                }
            }
            catch (Exception exception) {
                log.warn((Object)("AUTH FAILURE: " + exception.toString()));
                LogSupport.ignore(log, exception);
            }
        }
        if (principal == null && httpResponse != null) {
            this.sendChallenge(userRealm, httpResponse);
        }
        return principal;
    }

    public String getAuthMethod() {
        return "BASIC";
    }

    public void sendChallenge(UserRealm userRealm, HttpResponse httpResponse) throws IOException {
        httpResponse.setField("WWW-Authenticate", "basic realm=\"" + userRealm.getName() + '\"');
        httpResponse.sendError(401);
    }
}

