/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.html;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LogSupport;

public abstract class Element {
    private static Log log = LogFactory.getLog(Element.class);
    public static final String noAttributes = "";
    public static final String ALIGN = "align";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String CENTER = "center";
    public static final String VALIGN = "valign";
    public static final String TOP = "top";
    public static final String BOTTOM = "bottom";
    public static final String MIDDLE = "middle";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String SIZE = "size";
    public static final String COLOR = "color";
    public static final String BGCOLOR = "bgcolor";
    public static final String STYLE = "style";
    public static final String CLASS = "class";
    public static final String ID = "id";
    private int width = -1;
    private int height = -1;
    private int size = -1;
    private String attributes = null;
    protected Hashtable attributeMap = null;

    public Element() {
    }

    public Element(String string) {
        this.attribute(string);
    }

    public abstract void write(Writer var1) throws IOException;

    public void write(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        this.write(outputStreamWriter);
        ((Writer)outputStreamWriter).flush();
    }

    public void write(OutputStream outputStream, String string) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.write(outputStreamWriter);
        ((Writer)outputStreamWriter).flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String attributes() {
        StringBuffer stringBuffer;
        if (this.attributes == null && this.attributeMap == null) {
            return noAttributes;
        }
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(128);
        synchronized (stringBuffer2) {
            if (this.attributeMap != null) {
                Enumeration enumeration = this.attributeMap.keys();
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append(' ');
                    String string = (String)enumeration.nextElement();
                    stringBuffer.append(string);
                    stringBuffer.append('=');
                    stringBuffer.append(this.attributeMap.get(string).toString());
                }
            }
            if (this.attributes != null && this.attributes.length() > 0) {
                if (!this.attributes.startsWith(" ")) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(this.attributes);
            }
        }
        return stringBuffer.toString();
    }

    public Element attributes(String string) {
        if (log.isDebugEnabled() && string != null && string.indexOf(61) >= 0) {
            log.debug((Object)("Set attribute with old method: " + string + " on " + this.getClass().getName()));
        }
        if (string == null) {
            this.attributes = null;
            return this;
        }
        if (string == noAttributes) {
            return this;
        }
        this.attributes = this.attributes == null ? string : this.attributes + ' ' + string;
        return this;
    }

    public Element setAttributesFrom(Element element) {
        this.attributes = element.attributes;
        this.attributeMap = (Hashtable)element.attributeMap.clone();
        return this;
    }

    public Element attribute(String string) {
        if (log.isDebugEnabled() && string != null && string.indexOf(61) >= 0) {
            log.warn((Object)("Set attribute with old method: " + string + " on " + this.getClass().getName()));
        }
        this.attributes = string == null || this.attributes == null || this.attributes == noAttributes || this.attributes.length() == 0 ? string : this.attributes + ' ' + string;
        return this;
    }

    public Element attribute(String string, Object object) {
        if (this.attributeMap == null) {
            this.attributeMap = new Hashtable(10);
        }
        if (object != null) {
            if (object instanceof String && ((String)object).indexOf(34) != -1) {
                String string2 = (String)object;
                int n = 0;
                while ((n = string2.indexOf(34, n)) >= 0) {
                    string2 = string2.substring(0, n) + "&quot;" + string2.substring(++n);
                    n += 6;
                }
                object = string2;
            }
            this.attributeMap.put(string, "\"" + object + '\"');
        }
        return this;
    }

    public Element attribute(String string, long l) {
        if (this.attributeMap == null) {
            this.attributeMap = new Hashtable(10);
        }
        this.attributeMap.put(string, Long.toString(l));
        return this;
    }

    public String toString() {
        try {
            StringWriter stringWriter = new StringWriter();
            this.write(stringWriter);
            stringWriter.flush();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            LogSupport.ignore(log, iOException);
            return null;
        }
    }

    public Element left() {
        return this.attribute(ALIGN, LEFT);
    }

    public Element right() {
        return this.attribute(ALIGN, RIGHT);
    }

    public Element center() {
        return this.attribute(ALIGN, CENTER);
    }

    public Element top() {
        return this.attribute(VALIGN, TOP);
    }

    public Element bottom() {
        return this.attribute(VALIGN, BOTTOM);
    }

    public Element middle() {
        return this.attribute(VALIGN, MIDDLE);
    }

    public Element width(int n) {
        this.width = n;
        return this.attribute(WIDTH, n);
    }

    public Element width(String string) {
        this.width = -1;
        return this.attribute(WIDTH, string);
    }

    public int width() {
        return this.width;
    }

    public Element height(int n) {
        this.height = n;
        return this.attribute(HEIGHT, n);
    }

    public Element height(String string) {
        this.height = -1;
        return this.attribute(HEIGHT, string);
    }

    public int height() {
        return this.height;
    }

    public Element size(int n) {
        this.size = n;
        return this.attribute(SIZE, n);
    }

    public Element size(String string) {
        this.size = -1;
        return this.attribute(SIZE, string);
    }

    public int size() {
        return this.size;
    }

    public Element color(String string) {
        return this.attribute(COLOR, string);
    }

    public Element bgColor(String string) {
        return this.attribute(BGCOLOR, string);
    }

    public Element cssClass(String string) {
        return this.attribute(CLASS, string);
    }

    public Element cssID(String string) {
        return this.attribute(ID, string);
    }

    public Element style(String string) {
        return this.attribute(STYLE, string);
    }
}

