/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.html;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.mortbay.html.Element;
import org.mortbay.html.Page;

public class Composite
extends Element {
    protected ArrayList elements = new ArrayList(8);
    protected Composite nest = null;

    public Composite() {
    }

    public Composite(String string) {
        super(string);
    }

    public Composite add(Object object) {
        if (this.nest != null) {
            this.nest.add(object);
        } else if (object != null) {
            if (object instanceof Element) {
                if (object instanceof Page) {
                    throw new IllegalArgumentException("Can't insert Page in Composite");
                }
                this.elements.add(object);
            } else if (object instanceof String) {
                this.elements.add(object);
            } else {
                this.elements.add(object.toString());
            }
        }
        return this;
    }

    public Composite nest(Composite composite) {
        if (this.nest != null) {
            return this.nest.nest(composite);
        }
        this.add(composite);
        this.nest = composite;
        return this;
    }

    public Composite setNest(Composite composite) {
        if (this.nest != null) {
            this.nest.setNest(composite);
        } else {
            this.nest = composite;
        }
        return this;
    }

    public Composite unnest() {
        if (this.nest != null) {
            this.nest.unnest();
        }
        this.nest = null;
        return this;
    }

    public int size() {
        return this.elements.size();
    }

    public void write(Writer writer) throws IOException {
        for (int i = 0; i < this.elements.size(); ++i) {
            Object e = this.elements.get(i);
            if (e instanceof Element) {
                ((Element)e).write(writer);
                continue;
            }
            if (e == null) {
                writer.write("null");
                continue;
            }
            writer.write(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String contents() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer();
        synchronized (stringBuffer2) {
            for (int i = 0; i < this.elements.size(); ++i) {
                Object e = this.elements.get(i);
                if (e == null) {
                    stringBuffer.append("null");
                    continue;
                }
                stringBuffer.append(e.toString());
            }
        }
        return stringBuffer.toString();
    }

    public Composite reset() {
        this.elements.clear();
        return this.unnest();
    }

    void flush(Writer writer) throws IOException {
        if (this.nest != null) {
            this.nest.flush(writer);
        } else {
            this.write(writer);
            this.elements.clear();
        }
    }

    void flush(OutputStream outputStream) throws IOException {
        this.flush(new OutputStreamWriter(outputStream));
    }

    void flush(OutputStream outputStream, String string) throws IOException {
        this.flush(new OutputStreamWriter(outputStream, string));
    }

    public boolean replace(Object object, Object object2) {
        if (this.nest != null) {
            return this.nest.replace(object, object2);
        }
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            if (this.elements.get(i) != object) continue;
            this.elements.set(i, object2);
            return true;
        }
        return false;
    }
}

