<%@ Page Language="c#" AutoEventWireup="true"%>
<%@import namespace="System.IO" %>
<%@import namespace="System.Web.UI.HtmlControls" %>
<%@import namespace="System.Drawing" %>
<%@import namespace="System.Drawing.Imaging" %>
<%@import namespace="System.Text" %>

<%
    /*================== The GNU General Public License ================

    ImageIsle - An Image Management Web Application created by
    White Pacific Software. Copyright (C) 2005 White Pacific Software

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation using version 2 of the License
    or any later version.

    This license must remain intact inside all distributions and/or
    copies of this application.

    ===================================================================*/
%>

<script language="C#" runat="server">

// +++++++++++ IMAGE THUMBNAIL GENERATOR ++++++++++++++++
public void Page_Load(Object s, EventArgs e)
{

	// Set maximum pixel size for thumbnails created here. Thumbs can be this size or smaller, or will be reduced in pixel dimension to fit
	int MAX_THUMBNAIL_SIZE = 80;

	string theMessage = "Success! All images were uploaded! Image thumbnails were created successfully (unless listed below).";
	string theImagePath = "";
	string theError = "";
	string theImageNameOriginal = "";
	string theImageNameSmall = "";
	string theQueryString = "";
	int theImageID = 0;
	int aThumbnailCreationErrorOccurred = 0;
	int num1 = 0;
	int theHeight = 0;
	int theWidth = 0;

	// The Stringbuilder will build a list of all image id's that successfully had thumbnails created for them.
	System.Text.StringBuilder theIDString = new System.Text.StringBuilder();
	theIDString.Append("");

	try
	{
		if (Request.Form != null)
		{
			// Loop through all form fields submitted on the post...
			foreach (string item in Request.Form)
			{
				// RESET ALL IMAGE VALUES AFTER IMAGEID
				if (theImageNameOriginal != "" && theImageNameSmall != "")
				{
					theImagePath = "";
					theImageNameOriginal = "";
					theImageNameSmall = "";
					theImageID = 0;
					num1 = 0;
				}


				// Get Image Path to full size image on the server for this item in the collection
				if (item.IndexOf("imagepath") >= 0)
				{
					// PROCESS IMAGE PATH...
					if(Request.Form[item] != null)
					{
						if(Convert.ToString(Request.Form[item]) != String.Empty)
						{
							// Get the web virtual path for the image
							theImagePath = Convert.ToString(Request.Form[item]);
							// Response.Write("<br />theImagePath1: " + theImagePath);
							// Convert the virtual image into a physical server path
							theImagePath = Server.MapPath(theImagePath);
							// Response.Write("<br />theImagePath2: " + theImagePath);
						}
						else
						{
							// IMAGE PATH ERROR: If there is an error and the path is missing or incorrect, you can use a default error path
							// This ASP.NET path is the web virtual path to the folder holding the current web page from the web root
							theImagePath = this.TemplateSourceDirectory + "/Temp/";
							// Response.Write("<br />theImagePath1: " + theImagePath);
							// Convert the virtual image into a physical server path
							theImagePath = Server.MapPath(theImagePath);
							//Response.Write("<br />theImagePath2: " + theImagePath);
						}
					}
				}



				// Get Image Name to full size image on the server for this item in the collection
				if (item.IndexOf("imagename") >= 0)
				{
					// PROCESS IMAGE NAME...
					if(Request.Form[item] != null)
					{
						if(Convert.ToString(Request.Form[item]) != String.Empty)
						{
							theImageNameOriginal = Convert.ToString(Request.Form[item]);
							// Response.Write("<br />theImageNameOriginal: " + theImageNameOriginal);

							if (theImageNameOriginal.IndexOf(".") > 0)
							{
								// If the total number of characters in the image file name exceeds 240, then file name may be too big so truncate here
								num1 = theImageNameOriginal.IndexOf(".");
								if(num1 <= 240)
								{
									theImageNameSmall = theImageNameOriginal.Substring(0,num1) + "_small.jpg";
									//theImageNameSmall = theImageNameOriginal.Substring(0,num1) + "_small." + theImageNameOriginal.Substring(num1+1,(theImageNameOriginal.Length-(num1+1)));
									// Response.Write("<br />theImageNameSmall: " + theImageNameSmall);
								}
								else
								{
									// For files with really long file names, strip out extra characters before adding "_small" name change
									num1 = 240;
									theImageNameSmall = theImageNameOriginal.Substring(0,num1) + "_small.jpg";
									//theImageNameSmall = theImageNameOriginal.Substring(0,num1) + "_small." + theImageNameOriginal.Substring(num1+1,(theImageNameOriginal.Length-(num1+1)));
									// Response.Write("<br />theImageNameSmall: " + theImageNameSmall);
								}
							}
							else
							{
								theImageNameSmall = theImageNameOriginal + "_small";
								// Response.Write("<br />theImageNameSmall: " + theImageNameOriginal + "_small");
							}
						}
					}
				}



				// ++++++++++++++++++++ ASP.NET THUMBNAIL GENERATOR ++++++++++++++++++++
				// Note: For Loop goes through each form control. There are three form values per image that will be processed (path, name and id)
				// After the file name is cleaned up and processed, then the thumbnail needs to be created.
				// If the thumbnail creation fails for any reason, then DONT pass back image id, so it will
				// not be stored in the database in the calling ASP page!
				// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
				try
				{
					if (theImageNameOriginal != "" && theImageNameSmall != "" && theImagePath != "")
					{

						aThumbnailCreationErrorOccurred = 0;
						// Response.Write("<br />BUILD THUMBNAIL: " + theImagePath + theImageNameOriginal);

						// Create Image Object from existing image file saved to the server

						// Optional image cleanup script
						//System.Drawing.Imaging.ImageAttributes attr = new System.Drawing.Imaging.ImageAttributes();
						//attr.SetWrapMode(System.Drawing.Drawing2D.WrapMode.TileFlipXY);
						//attr.Dispose();

						System.Drawing.Image theImage = System.Drawing.Image.FromFile(theImagePath + theImageNameOriginal);

						// Set the thumbnail size based on max size
						// Currently its set to MAX_THUMBNAIL_SIZE
						if ((int)theImage.Height > (int)theImage.Width)
						{
							if ((int)theImage.Height > MAX_THUMBNAIL_SIZE)
							{
								theWidth = Convert.ToInt32((double)theImage.Width * (MAX_THUMBNAIL_SIZE/(double)theImage.Height));
								theHeight = MAX_THUMBNAIL_SIZE;
							}
							else
							{
								theWidth = (int)theImage.Width;
								theHeight = (int)theImage.Height;
							}
						}
						else if ((int)theImage.Width > (int)theImage.Height)
						{
							if ((int)theImage.Width > MAX_THUMBNAIL_SIZE)
							{
								theHeight = Convert.ToInt32((double)theImage.Height * (MAX_THUMBNAIL_SIZE/(double)theImage.Width));
								theWidth = MAX_THUMBNAIL_SIZE;
							}
							else
							{
								theHeight = (int)theImage.Height;
								theWidth = (int)theImage.Width;
							}
						}
						else
						{
							if ((int)theImage.Width > MAX_THUMBNAIL_SIZE || (int)theImage.Height > MAX_THUMBNAIL_SIZE)
							{
								theHeight = Convert.ToInt32((double)theImage.Height * MAX_THUMBNAIL_SIZE/(double)theImage.Height);
								theWidth = Convert.ToInt32((double)theImage.Width * MAX_THUMBNAIL_SIZE/(double)theImage.Width);
							}
							else
							{
								theHeight = (int)theImage.Height;
								theWidth = (int)theImage.Width;
							}
						}


						//Response.Write("<br />BUILD THUMBNAIL: " + theImage.PhysicalDimension);
						//Response.Write("<br />BUILD THUMBNAIL: " + theImage.Size);

						// Response.Write("<br />(int)theImage.Height: " + (int)theImage.Height);
						// Response.Write("<br />(int)theImage.Width: " + (int)theImage.Width);
						// Response.Write("<br />theHeight: " + theHeight);
						// Response.Write("<br />theWidth: " + theWidth);

						// Rotate Image test...
						// theImage.RotateFlip(RotateFlipType.Rotate180FlipNone);

						// Create the actual thumbnail image using a Bitmap Object, which is a placeholder for the Graphics Object below
						System.Drawing.Bitmap theBitmap = new System.Drawing.Bitmap(theWidth,theHeight);

						// The GDI+ or Graphics Object system offers superior redraws of the image
						// when resizing and is very efficient in creating cleaner custom thumbnails
						System.Drawing.Graphics theGraphic = System.Drawing.Graphics.FromImage(theBitmap);

						// Using the Graphics Object, smooth and interpolate the image before drawing it back to the Image Object 
						theGraphic.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.HighQuality;
						theGraphic.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.HighQualityBicubic;
						theGraphic.DrawImage(theImage,0,0,theBitmap.Width,theBitmap.Height);

						theImage.Dispose();

						// Save thumbnail images to the server...
						theBitmap.Save(theImagePath + theImageNameSmall, System.Drawing.Imaging.ImageFormat.Jpeg);

						// Use open-source png's as well for thumbs, if needed...
						// System.Drawing.Imaging.ImageFormat.Png);

						// Always close these object instances on the server!
						theBitmap.Dispose();
						theGraphic.Dispose();    
						
					}
				}
				catch (Exception exc)
				{
					theError = theError + "<br />" + exc.ToString();
					Response.Write(theError);
					aThumbnailCreationErrorOccurred = 1;
					theMessage = "Alert! It was not possible to create a thumbnail for one or more of these images. The originals were still uploaded successfully.";
				}
				// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++





				// Get Image ID (database id) of the full size image on the server for this item in the collection
				// Note: If there were any errors creating the thumbnail (for example, so images use indexed values so will error when tralsating to theBitmaps and jpegs), then do not pass id, as thumbnail failed.
				if (item.IndexOf("imageid") >= 0 && aThumbnailCreationErrorOccurred != 1)
				{
					// Response.Write("<br />Get form imageid value...");
					// PROCESS IMAGEID...
					if(Request.Form[item] != null)
					{
						if(Convert.ToInt32(Request.Form[item]) > 0)
						{
							theImageID = Convert.ToInt32(Request.Form[item]);
							// Response.Write("<br />theImageID: " + theImageID);

							// Now add to list of id's that will be sent back to the calling page,
							// indicating that those database records may be saved with image thumbnails.

							theIDString.Append(theImageID + "_");
						}
					}
				}
			}
			// End Loop
			// Response.Write("<br />ID STRING (images that created thumbs): " + theIDString.ToString());
		}
		else
		{
			theMessage = theMessage + "Sorry, no images were uploaded or processed.";
		}
	}
	catch (Exception exc)
	{
		theError = theError + "<br />" + exc.ToString();
		Response.Write(theError);
		theMessage = "Alert! It was not possible to create a thumbnail for one or more of these images. The originals were still uploaded successfully.";
	}

	// WRITE OUT ALL MESSAGES HERE IF NEEDED FOR TESTING...(comment out redirect below as well to test errors in this page)
	// Response.Write("<hr /><strong>MESSAGES:</strong> " + theMessage);

	// WRITE OUT ALL ERRORS HERE IF NEEDED FOR TESTING...(comment out redirect below as well to test errors in this page)
	// Response.Write("<hr /><strong>PAGE ERRORS:</strong> " + theError);

	// WRITE OUT THE QUERYSTRING...(comment out redirect below as well to test errors in this page)
	theQueryString = "?ids=" + theIDString.ToString() + "&status=2&message=" + theMessage;
	// Response.Write("<hr /><strong>THE QUERYSTRING:</strong> " + theQueryString);

	// Redirect back to the "add.asp" page...
	Response.Redirect("add.asp" + theQueryString,true);

}
// +++++++++++++++++++++++++++++++++++++++++++++++

</script>

