<?php

class PhotoUpload {
	
	var $file_vars;
	var $base_dir;
	var $report;
	var $image_directory;
	
	// Instantiate
	function PhotoUpload($file_vars) {
		$this->file_vars = $file_vars;
	}
	
	// Check for errors
	function checkErrors() {
		if ($this->file_vars['name'] == '') {
			$this->errors = 'Please choose a file and try again';
			return '1';
		}
		if ($this->file_vars['size'] == 0) {
			$this->errors = 'The file you chose has no size. Are you sure you chose a real file?';
			return '1';
		}
	}
	
	// Upload photo
	function uploadImage($dir) {
		$this->image_directory = $dir;
		$this->original_image_location = $this->image_directory . $this->file_vars['name'];
		if ($this->errors == '') {
			if ( @!copy($this->file_vars['tmp_name'], $this->original_image_location)) {
				$this->errors = 'ERROR: Could not move file into directory "' . $dir . '", please make sure you have write permissions in the directory';
			} else {
				$this->report .= '<p>The file was uploaded successfully:<br /><img src="' . $this->original_image_location . '" alt="" /></p>';
			}
		}
	}
	
	// Get Image Variables (size and extension)
	function getImageVariables() {
		$this->image_name_array = explode('.',$this->file_vars['name']);
		$this->image_name = $this->image_name_array[0];
		$this->image_extension = $this->image_name_array[1];
		$this->image_size_array = @GetImageSize($this->original_image_location);
		$this->image_width = $this->image_size_array[0];
		$this->image_height = $this->image_size_array[1];
		if ($this->image_width > $this->image_height) {
			$this->longest_side = $this->image_width;
		} else {
			$this->longest_side = $this->image_height;
		}
	}
	
	// Create resized version (to replace with new version, just set the $value to '' and type_of_renaming to 1)
	
	// For $type_of_renaming, 1 = $value added to beginning of name, 2 = $value added to end of name, 3 = $value replaces name

	function resizeImage($max_dimention,$value,$type_of_renaming,$new_dir) {
		$this->getImageVariables();
		if ($new_dir == '') {
			$new_dir = $this->image_directory;
		}
		// 1 = Same name, basically resizing the original
		// 2 = The $value is added to the name and a new image is created in addition to the original
		// 3 = The $value is used as the new name
		if ($type_of_renaming == 1) {
			$this->new_image_name = $value . $this->image_name . '.' . $this->image_extension;
		} elseif ($type_of_renaming == 2) {
			$this->new_image_name = $this->image_name . $value . '.' . $this->image_extension;
		} elseif ($type_of_renaming == 3) {
			$this->new_image_name = $value . '.' . $this->image_extension;
		}
		if ($this->longest_side > $max_dimention) {
			$new_percent = $max_dimention / $this->longest_side;
			$new_width = ceil($this->image_width*$new_percent);
			$new_height = ceil($this->image_height*$new_percent);
		} else {
			$new_percent = 100;
			$new_width = $this->image_width;
			$new_height = $this->image_height;
		}
		$src = ImageCreateFromJpeg($this->original_image_location);
		$new_image = imagecreatetruecolor($new_width,$new_height);
		imagecopyresampled($new_image,$src,0,0,0,0,$new_width,$new_height,$this->image_width,$this->image_height);
		if ($this->errors == '') {
			if (ImageJPEG($new_image,$new_dir . $this->new_image_name)) {
				$this->report .= '<p>Successfully resized image:<br /><img src="' . $this->image_directory . $new_image_name . '" alt="Resized Image" /><br />' . $new_dir . $this->new_image_name . '</p>';
			}
		}
	}
	
	function removeOriginal() {
		unlink($this->original_image_location);
	}
}

?>