unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  xsdins, StdCtrls, strs, xmls, ExtCtrls, xsdedit;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    SchemeC: TComboBox;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    Schema: TXMLNode;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var XE: TXSDEditor; SN, ResXML: TXMLNode;
begin
 // Create an editor with XMLInspector
 XE := TXSDEditor.Create(Self);
 XE.Caption := 'Edit an XML object';
 try
  // Open a selected XSD scheme
  SN := TXMLNode.Create(FileToStr(ExtractFilePath(ParamStr(0)) + SchemeC.Items[SchemeC.ItemIndex]));

  // Try to open stored XML-object or create an empty one 
  if FileExists(SchemeC.Items[SchemeC.ItemIndex] + '.xml') then
    ResXML := TXMLNode.CreateFromFile(SchemeC.Items[SchemeC.ItemIndex] + '.xml')
  else
    ResXML := CreateXMLTemplate(SN[0], True);

  // Run a dialog form with XMLInspector and store (or cancel) changes
  try
    XE.Run(SN[0], ResXML, nil);
    if XE.ModalResult = mrOk then StrtoFile(ResXML.FormattedCode(' ') ,
      SchemeC.Items[SchemeC.ItemIndex] + '.xml');
  except
    raise;
  end;
 finally
  XE.Free;
  SN.Free;
  ResXML.Free;
 end;

end;

end.
