/*

 * Copyright (c) 1998-2006 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */

function q_LongRangeValidator(minimum, maximum, rangeSummary, rangeDetail, typeSummary, typeDetail) {

  var min = q_getLong(minimum);

  if (min != null) {
    this.minimum = min;
    this.testLowerBundle = true;
  } else {
    this.testLowerBundle = false;
  }


  var max = q_getLong(maximum);
  if (max != null) {
    this.maximum = max;
    this.testUpperBundle = true;
  } else {
    this.testUpperBundle = false;
  }

  this.rangeSummary = rangeSummary;
  this.rangeDetail = rangeDetail;
  this.typeSummary = typeSummary;
  this.typeDetail = typeDetail;
}

q_LongRangeValidator.prototype.validate = function(input) {
  var value = q__trim(q_getValue(input));

  if (q_notEmpty(value)) {

    if (!q_isLong(value)) {
      q_addMessage(input, this.typeSummary, this.typeDetail);
      return false;
    }
    if (this.testUpperBundle) {
      if (value > this.maximum) {
        q_addMessage(input, this.rangeSummary, this.rangeDetail);
        return false;
      }
    }

    if (this.testLowerBundle) {
      if (value < this.minimum) {
        q_addMessage(input, this.rangeSummary, this.rangeDetail);
        return false;
      }
    }
  }
  return true;
}
