/*
 * Copyright (c) 1998-2006 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */

function q_DoubleRangeValidator(minimum, maximum, rangeSummary, rangeDetail, typeSummary, typeDetail) {
  this.minimum = minimum;
  this.maximum = maximum;
  this.rangeSummary = rangeSummary;
  this.rangeDetail = rangeDetail;
  this.typeSummary = typeSummary;
  this.typeDetail = typeDetail;
}

q_DoubleRangeValidator.prototype.validate = function(input) {
  var value = q__trim(q_getValue(input));
  if (q_notEmpty(value)) {
    if (!q_isDouble(value)) {
      q_addMessage(input, this.typeSummary, this.typeDetail);
      return false;
    }
    if (this.maximum) {
      if (value > this.maximum) {
        q_addMessage(input, this.rangeSummary, this.rangeDetail);
        return false;
      }
    }
    if (this.minimum) {
      if (value < this.minimum) {
        q_addMessage(input, this.rangeSummary, this.rangeDetail);
        return false;
      }
    }
  }
  return true;
}
