/*
 * Copyright (c) 1998-2007 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */

// ----------------- DEBUG ---------------------------------------------------
var Q__DEBUG = true;

function q__logError(message) {
  if (Q__DEBUG)
    alert("ERROR: " + message);
}

function q__assert(value, message) {
  if (value != null)
    return;
  q__logError(message);
}


function q__log(text) {
  if (!window._logger)
    window._logger = new q__Logger();
  window._logger.log(text);
}

function q__Logger() {
  this._win = window.open("about:blank", "q__logger");
  this.log = function (text) {
    var date = new Date();
    this._win.document.write(date + " : " + text + "<br>");
  }
}

function q__Profiler() {
  this._timeStamps = new Array();
  this._timeAccumulators = new Array();

  this.logTimeStamp = function(name) {
    this._timeStamps.push({time: new Date(), name: name});
  }

  this.startMeasuring = function(name) {
    var timeAccumulator = this._timeAccumulators[name];
    if (timeAccumulator == null) {
      timeAccumulator = {name: name, secondsElapsed: 0.0, lastPeriodStartDate: null};
      this._timeAccumulators[name] = timeAccumulator;
      this._timeAccumulators.push(timeAccumulator);
    }
    q__assert(!timeAccumulator.lastPeriodStartDate, "q__Profiler.startMeasuring cannot be called twice for the same name without endMeasuring being called: " + name);
    timeAccumulator.lastPeriodStartDate = new Date();
  }

  this.endMeasuring = function(name) {
    var dateAfter = new Date();
    var timeAccumulator = this._timeAccumulators[name];
    q__assert(timeAccumulator, "q__Profiler.endMeasuring: startMeasuring wasn't called for name: " + name);
    q__assert(timeAccumulator.lastPeriodStartDate, "q__Profiler.endMeasuring: startMeasuring wasn't called for name: " + name);
    var dateBefore = timeAccumulator.lastPeriodStartDate;
    timeAccumulator.lastPeriodStartDate = null;
    var secondsElapsed = (dateAfter.getTime() - dateBefore.getTime()) / 1000;
    timeAccumulator.secondsElapsed += secondsElapsed;
  }

  this.showTimeStamps = function() {
    for (var i = 0, count = this._timeStamps.length - 1; i < count; i++) {
      var stampBefore = this._timeStamps[i];
      var stampAfter = this._timeStamps[i + 1];
      var elapsed = (stampAfter.time.getTime() - stampBefore.time.getTime()) / 1000;
      alert(stampBefore.name + " - " + stampAfter.name + " : " + elapsed)
    }
  }

  this.showTimeMeasurements = function() {
    for (var i = 0, count = this._timeAccumulators.length; i < count; i++) {
      var accumulator = this._timeAccumulators[i];
      var name = accumulator.name;
      var elapsed = accumulator.secondsElapsed;
      alert(name + " : " + elapsed);
    }
  }


}

// ----------------- STRING, ARRAYS, OTHER LANGUAGE UTILITIES ---------------------------------------------------

function q__nullToEmptyStr(txt) {
  return txt == null ? "" : txt;
}

function q__StringBuffer() {
  this._strings = [];
  this.append = function(value) {
    this._strings.push(value);
    return this;
  }
  this.toString = function() {
    return this._strings.join("");
  }
  this.getNextIndex = function() {
    return this._strings.length;
  }
  this.setValueAtIndex = function(index, value) {
    this._strings[index] = value;
  }
}

function q__stringEndsWith(str, ending) {
  if (!str || !ending)
    return false;
  var endingLength = ending.length;
  var length = str.length;
  if (length < endingLength)
    return false;
  var actualEnding = str.substring(length - endingLength, length);
  return actualEnding == ending;
}

function q__findValueInArray(value, arr) {
  for (var i = 0, count = arr.length; i < count; i++) {
    var obj = arr[i];
    if (obj == value)
      return i;
  }
  return -1;
}

function q__getArrayFromString(str, delimiter) {
  var idx = str.indexOf(delimiter);
  var arr = new Array();
  var arrIdx = 0;
  while (idx != -1) {
    arr[arrIdx++] = str.substring(0, idx);
    str = str.substring(idx + 1);
    idx = str.indexOf(delimiter);
  }
  arr[arrIdx] = str;
  return arr;
}

function q__arrayContainsValue(array, value) {
  var idx = q__findValueInArray(value, array);
  return idx != -1;
}

// ----------------- BROWSER DETECTION ---------------------------------------------------

function q__checkBrowser(browserName) {
  return navigator.userAgent.toLowerCase().indexOf(browserName.toLowerCase()) > -1;
}

function q__isMozilla() {
  return q__checkBrowser("mozilla");
}

function q__isExplorer() {
  return q__checkBrowser("msie") && !q__checkBrowser("opera");
}

function q__isOpera() {
  return q__checkBrowser("opera");
}

function q__isSafari() {
  return q__checkBrowser("safari");
}

// ----------------- DOM FUNCTIONS ---------------------------------------------------

function q__getControl(id) {
  return document.getElementById(id);
}

function q__findParentNode(element, tagName) {
  tagName = tagName.toUpperCase();
  while (element) {
    var elementNodeName = element.nodeName;
    if (elementNodeName)
      elementNodeName = elementNodeName.toUpperCase();
    if (elementNodeName == tagName)
      break;
    element = element.parentNode;
  }
  if (element != null)
    return element;
  else
    return null;
}

function q__findAnyParentNode(element, tagNames) {
  for (var i = 0, count = tagNames.length; i < count; i++)
    tagNames[i] = tagNames[i].toUpperCase();
  while (element && q__findValueInArray(element.nodeName.toUpperCase(), tagNames) == -1)
    element = element.parentNode;
  if (element != null)
    return element;
  else
    return null;
}

function q__getElement(identifier) {
  var element = document.getElementById(identifier);
  if (element)
    return element;

  var elementCollection = document.getElementsByName(identifier);
  if (elementCollection)
    return elementCollection[0];

  return null;
}

function q__isChild(parent, child) {
  if (parent.id && child.id && parent.id == child.id) return true;
  if (child.parentNode && child.parentNode.nodeName && child.parentNode.nodeName.toLowerCase() != "body") {
    return q__isChild(parent, child.parentNode);
  }
  return false;
}

function q__findChildNodesByClass(node, className, searchTopLevelOnly) {
  var result = new Array();
  var children = node.childNodes;
  for (var i = 0, count = children.length; i < count; i++) {
    var child = children[i];
    if (child.className == className)
      result.push(child);
    //    var childClass = child.className;
    //    var childClassNames = childClass ? childClass.split(" ") : new Array();
    //    if (childClassNames.q__indexOf(className))
    var subResult = !searchTopLevelOnly && q__findChildNodesByClass(child, className);
    for (var childIndex = 0, subResultCount = subResult.length; childIndex < subResultCount; childIndex++) {
      var innerResult = subResult[childIndex];
      result.push(innerResult);
    }
  }
  return result;
}

function q__getChildNodesWithNames(node, tagNames) {
  var selectedChildren = new Array();
  var children = node.childNodes;
  for (var i = 0, count = children.length; i < count; i++) {
    var child = children[i];
    var childTagName = child.tagName;
    if (childTagName)
      childTagName = childTagName.toUpperCase();
    for (var j = 0, jcount = tagNames.length; j < jcount; j++) {
      var tagName = tagNames[j];
      tagName = tagName.toUpperCase();
      if (childTagName == tagName)
        selectedChildren[selectedChildren.length] = child;
    }
  }
  return selectedChildren;
}

// ----------------- FORM, FORM ELEMENTS MANIPULATION ---------------------------------------------------

function q__submitEnclosingForm(element) {
  q__assert(element, "element should be passed to q__submitEnclosingForm");
  var frm = q__findParentNode(element, "FORM");
  q__assert(frm, "q__submitEnclosingForm: Enclosing form not found for element with id: " + element.id + "; element tag name: " + element.tagName);
  if (frm.onsubmit)
    if (!frm.onsubmit())
      return;

  frm.submit();
}

function q__submitFormWithAdditionalParam(element, paramName, paramValue) {
  q__assert(element, "element should be passed to q__submitFormWithAdditionalParam");
  q__assert(paramName, "paramName should be passed to q__submitFormWithAdditionalParam");
  q__addHiddenField(element, paramName, paramValue);
  var frm = q__findParentNode(element, "FORM");
  frm.submit();
}

function q__addHiddenField(element, fieldName, fieldValue) {
  var frm;
  if (!element) {
    frm = document.forms[0];
    q__assert(frm, "q__addHiddenField: There must be a form in the document");
  } else {
    frm = q__findParentNode(element, "FORM");
    q__assert(frm, "q__addHiddenField: Enclosing form not found for element with id: " + element.id + "; element tag name: " + element.tagName);
  }
  var existingField = document.getElementById(fieldName);
  var newParamField = existingField ? existingField : document.createElement("input");
  if (!existingField) {
    newParamField.type = "hidden";
    newParamField.id = fieldName;
    newParamField.name = fieldName;
    frm.appendChild(newParamField);
  }
  if (fieldValue == null)
    fieldValue = "";
  newParamField.value = fieldValue;
  return newParamField;
}

function q__submitById(elementId) {
  var element = document.getElementById(elementId);
  q__assert(element, "correct element id should be passed to q__submitById");
  q__submitEnclosingForm(element);
}

function q__setValue(elementId, value) {
  var field = document.getElementById(elementId);
  q__assert(field, "Correct element id should be passed to q__setValue; elementId = " + elementId);
  if (field) {
    field.value = value;
  }
}

q__addLoadEvent(function() {
  var forms = document.forms;
  for (var i = 0, count = document.forms.length; i < count; i++) {
    var frm = document.forms[i];
    q__addEventHandler(frm, "submit", function() {
      document._q_formSubmissionStarted = true;
    });
    if (frm._q_prevSubmit) continue;
    frm._q_prevSubmit = frm.submit;
    frm.submit = function() {
      document._q_formSubmissionStarted = true;
      this._q_prevSubmit();
    }
  }

});

//{
//  var submitElement = null;
//  submitElement = document.getElementById("submit");
//  if (submitElement == null) {
//    for (var i = 0, count = document.forms.length; i < count; i++) {
//      submitElement = document.forms.getElementsByName("submit");
//      if (submitElement)
//        break;
//    }
//  }
//  if (submitElement) {
//    q__logError("The document contains an element with id or name equal to \"submit\". Please use different id/name in order to avoid collision with form.submit() method");
//  }
//}
//
function q__isFormSubmissionStated() {
  return document._q_formSubmissionStarted;
}

// ----------------- EVENT UTILITIES ---------------------------------------------------

function q__getEventHandlerFunction(handlerName, handlerArgs, mainObj) {
  var handlerFunction;

  if (!q__getEventHandlerFunction.apply) {
    eval('handlerFunction = function() { return arguments.callee.prototype._ownObj.' + handlerName + '(' + (handlerArgs ? handlerArgs : '') + '); }');
  } else {
    var argString = handlerArgs ? ('[' + handlerArgs + ']') : 'arguments';
    eval('handlerFunction = function() { return arguments.callee.prototype._ownObj.' + handlerName + '.apply(arguments.callee.prototype._ownObj,' + argString + '); }');
  }
  handlerFunction.prototype._ownObj = mainObj;
  return handlerFunction;
}

function q__addEventHandler(elt, evtName, evtScript) {
  if (elt.addEventListener) {
    elt.addEventListener(evtName, evtScript, false);
  } else if (elt.attachEvent) {
    elt.attachEvent("on" + evtName, evtScript);
  }
}

function q__removeEventHandler(elt, evtName, evtScript) {
  if (elt.addEventListener) {
    elt.removeEventListener(evtName, evtScript, false);
  } else if (elt.attachEvent) {
    elt.attachEvent("on" + evtName, evtScript);
  }
}

q__invokeOnce(q__initDocumentMouseClickListeners, "q__initDocumentMouseClickListeners");

function q__initDocumentMouseClickListeners() {
  if (document._q__initDocumentMouseClickListeners_called) {
    return;
  }

  if (!document._mouseClickListeners) {
    document._mouseClickListeners = new Array();
  }
  document._addClickListener = function (listener) {
    if (listener) {
      this._mouseClickListeners[this._mouseClickListeners.length] = listener;
    }
  };
  document._addClickListener(document.onmousedown);
  document.onmousedown = function (event) {
    for (var i = 0; i < this._mouseClickListeners.length; i++) {
      this._mouseClickListeners[i](event);
    }
  };

  document._q__initDocumentMouseClickListeners_called = true;
}

/*
 * The last "receiverThisRef" parameter can be omitted if it's acceptable that "this" variable in the
 * event handler refer to eventSource.
 */
function q__addEventHandlerSimple(eventSource, eventName, handlerFunctionName, receiverThisRef) {
  var handler = q__getEventHandlerFunction(handlerFunctionName, null, receiverThisRef ? receiverThisRef : eventSource);
  q__addEventHandler(eventSource, eventName, handler);
}

/*
 * eventName should be without the "on" prefix, for example: "change", "click", etc.
 */
function q__createEvent(eventName) {
  var e = document.createEvent ? document.createEvent("Events") : document.createEventObject();

  if (document.createEvent)
    e.initEvent(eventName, true, true);
  else
    e.name = "on" + eventName;

  return e;
}


/*
 * eventName should be without the "on" prefix, for example: "change", "click", etc.
 */
function q__sendEvent(object, eventName) {
  var safari = q__isSafari();
  var e = safari ? {} :
          document.createEvent ? document.createEvent("Event") :
          document.createEventObject();
  if (document.createEvent && !safari) {
    e.initEvent(eventName, true, true);
    e._qk_event = true;
    object.dispatchEvent(e);
  } else {
    e.name = "on" + eventName;
    e._qk_event = true;
    var handler = object[e.name];
    if (!handler)
      return;
    return object[e.name](e);
    //    object.fireEvent(e.name, e); // - didn't work for firing "onchange" for <table>
  }

}


function q__cancelBubble(evt) {
  var e = evt ? evt : window.event;
  e.cancelBubble = true;
}

function q__isAltPressed(event) {
  if (event == null || event.altKey == null)
    return false;
  return event.altKey;
}
//

function q__isCtrlPressed(event) {
  if (event == null || event.ctrlKey == null)
    return false;
  return event.ctrlKey;
}
//

function q__isShiftPressed(event) {
  if (event == null || event.shiftKey == null)
    return false;
  return event.shiftKey;
}

function q__getEvent(e) {
  var evt = (e != undefined) ? e : event;
  return evt;
}

function q__breakEvent(e) {
  var evt = q__getEvent(e);

  if (evt.preventDefault) {
    evt.preventDefault();
  }
  evt.cancelBubble = true;
  evt.returnValue = false;
}

function q__addLoadEvent(func) {
  var invokeOnLoadHandlersFunction = function() {
    for (var i = 0, count = window._q_onLoadEvents.length; i < count; i++) {
      var onLoadHandler = window._q_onLoadEvents[i];
      onLoadHandler();
    }
  }

  if (!window._q_onLoadEvents) {
    window._q_onLoadEvents = new Array();

    var oldonload = window.onload;
    if (typeof window.onload != 'function') {
      window.onload = function() {
        invokeOnLoadHandlersFunction();
        document._q_onLoadEventsProcessed = true;
      }
    } else {
      window.onload = function() {
        oldonload();
        invokeOnLoadHandlersFunction();
        document._q_onLoadEventsProcessed = true;
      }
    }
  }
  if (document._q_onLoadEventsProcessed)
  {
    func();
  }
  _q_onLoadEvents.push(func);
}

function q__createHiddenFocusElement() {
  var focusControl = document.createElement(q__isOpera() ? "input" : "a");
  focusControl.style.position = "absolute";
  focusControl.style.display = "block";
  focusControl.style.width = "0px";
  focusControl.style.height = "0px";
  focusControl.style.fontSize = "0px";
  focusControl.style.padding = "0px";
  focusControl.style.margin = "0px";
  focusControl.type = "button";
  focusControl.href = "javascript: ;";
  return focusControl;
}

function q__initDefaultScrollPosition(trackerFieldId, scrollPos) {
  q__addHiddenField(null, trackerFieldId, scrollPos);
  q__initScrollPosition_(trackerFieldId, true, 1);
}

function q__initScrollPosition(scrollPosFieldId, autoSaveScrollPos) {
  q__initScrollPosition_(scrollPosFieldId, autoSaveScrollPos, 2);
}

function q__initScrollPosition_(scrollPosFieldId, autoSaveScrollPos, priority) {
  if (window.q__scrollPosTrackingParams)
    if (window.q__scrollPosTrackingParams.priority > priority)
      return;
  window.q__scrollPosTrackingParams = {fieldId: scrollPosFieldId, autoSave: autoSaveScrollPos, priority: priority};
  q__addLoadEvent(function() {
    if (!window.q__scrollPosTrackingParams)
      return;
    var scrollPosFieldId = window.q__scrollPosTrackingParams.fieldId;
    var autoSaveScrollPos = window.q__scrollPosTrackingParams.autoSave;
    window.q__scrollPosTrackingParams = null;
    var fld = document.getElementById(scrollPosFieldId)
    document.q__scrollPositionField = fld;
    var scrollPos = fld.value;

    if (window.scrollTo && scrollPos && scrollPos != "") {
      scrollPos = scrollPos.substring(1, scrollPos.length - 1);
      var separatorIndex = scrollPos.indexOf(",");
      var x = scrollPos.substring(0, separatorIndex);
      var y = scrollPos.substring(separatorIndex + 1, scrollPos.length);
      window.scrollTo(x, y);
      if (q__isExplorer()) {
        setTimeout(function() {
          window.scrollTo(x, y)
        }, 10);
      }
    }
    q__addEventHandler(window, "scroll", function() {
      var scrollPos = q__getPageScrollPos();
      document.q__scrollPositionField.value = "[" + scrollPos.x + "," + scrollPos.y + "]";
    });
  });
}

function q__initDefaultFocus(trackerFieldId, focusedComponentId) {
  q__addHiddenField(null, trackerFieldId, focusedComponentId);
  q__initFocus_(trackerFieldId, true, 1);
}

function q__initFocus(trackerFieldId, autoSaveFocus) {
  q__initFocus_(trackerFieldId, autoSaveFocus, 2);
}

function q__initFocus_(trackerFieldId, autoSaveFocus, priority) {
  q__addLoadEvent(function() {
    if (!document.q__focusPriority || priority > document.q__focusPriority) {
      document.q__focusPriority = priority;
      var trackerField = document.getElementById(trackerFieldId);
      document.q__focusField = trackerField;
      var componentId = trackerField.value;
      var focused = false;
      if (componentId) {
        var c = document.getElementById(componentId);
        if (c && c.focus) {
          try {
            c.focus();
            var rect = q__ElementRectangle(c);
            q__scrollRectIntoView(rect);
          } catch(ex) {
          }
          document.q__activeElement = c;
          focused = true;
        }
      }
      if (!focused && document.q__activeElement && document.q__activeElement.blur) {
        document.q__activeElement.blur();
        //        q__setPageScrollPos({x: 0, y: 0});
      }
    }

    if (!autoSaveFocus)
      return;

    if (document.q__autoSavingFocusInitialized)
      return;
    document.q__autoSavingFocusInitialized = true;

    var bodyElement = document.getElementsByTagName("body")[0];
    if (bodyElement == null)
      return;
    q__setupFocusOnTags(bodyElement, "input");
    q__setupFocusOnTags(bodyElement, "a");
    q__setupFocusOnTags(bodyElement, "button");
    q__setupFocusOnTags(bodyElement, "textarea");
    q__setupFocusOnTags(bodyElement, "select");
  });
}

function q__setupFocusOnTags(parent, tagName) {
  var elements = parent.getElementsByTagName(tagName);
  for (i = 0; i < elements.length; i++) {
    var element = elements[i];
    element.q__prevOnFocusHandler = element.onfocus;
    element.onfocus = function (e) {
      document.q__activeElement = this;
      document.q__focusField.value = this.id;
      if (this.q__prevOnFocusHandler)
        this.q__prevOnFocusHandler(e);
    }
    element.q__prevOnBlurHandler = element.onblur;
    element.onblur = function (e) {
      if (document.q__activeElement == this) {
        document.q__activeElement = null;
        document.q__focusField.value = "";
      }
      if (this.q__prevOnBlurHandler)
        this.q__prevOnBlurHandler(e);
    }
  }

}


// ----------------- STYLE UTILITIES ---------------------------------------------------

function q__addCssRules(ruleArray) {
  for (var i = 0, count = ruleArray.length; i < count; i++) {
    var rule = ruleArray[i];
    q__addRule(rule);
  }
}

function q__addRule(strRule) {
  var styleSheets = document.styleSheets;
  if (!styleSheets)
    return;
  if (styleSheets.length == 0) {
    document.createStyleSheet("");
  }
  var styleSheet = styleSheets[styleSheets.length - 1];
  if (styleSheet.addRule) { //IE only
    var idx = strRule.indexOf("{");
    var selector = strRule.substring(0, idx);
    var idx2 = strRule.indexOf("}");
    var declaration = strRule.substring(idx + 1, idx2);
    styleSheet.addRule(selector, declaration);
  } else { //all others
    styleSheet.insertRule(strRule, styleSheet.cssRules.length);
  }
}

function q__findRule(selector) {
  var head = document.getElementsByTagName("head")[0];
  var styleSheets;
  if (q__isOpera()) {
    return undefined;
    //currently opera doesn't support css maintenance from JS
  } else {
    styleSheets = document.styleSheets;
  }
  for (var i = 0; i < styleSheets.length; i ++) {
    var ss = styleSheets[i];
    var rules;
    if (ss.cssRules) {
      rules = ss.cssRules;
    } else if (ss.rules) {
      rules = ss.rules;
    }
    if (!rules) return undefined;
    for (var j = 0; j < rules.length; j ++) {
      var selectorName = rules[j].selectorText;
      if (selectorName == selector) {
        return rules[j];
      }
    }
  }
  return undefined;
}
//

function q__combineClassNames(classNames) {
  var nonNullClassNames = new Array();
  for (var i = 0, count = classNames.length; i < count; i++) {
    var className = classNames[i];
    if (className)
      nonNullClassNames.push(className);
  }
  var result = nonNullClassNames.join(" ");
  return result;
}


function q__appendClassNames(element, classesToAppend) {
  var oldClassName = element.className;
  for (var i = 0, count = classesToAppend.length; i < count; i++) {
    var cls = classesToAppend[i];
    if (cls)
      element.className = q__combineClassNames([element.className, cls]);
  }
  return oldClassName;
}

function q__excludeClassNames(element, classesToExclude) {
  var newClassesToExclude = new Array();
  for (var i = 0, count = classesToExclude.length; i < count; i++) {
    var clsToExclude = classesToExclude[i];
    if (!clsToExclude)
      continue;
    var subClassesToExclude = clsToExclude.split(" ");
    for (var j = 0, jcount = subClassesToExclude.length; j < jcount; j++) {
      var subClassToExclude = subClassesToExclude[j];
      newClassesToExclude.push(subClassToExclude);
    }
  }

  var someClassesExcluded = false;
  var clsName = element.className;
  var clsNames = clsName ? clsName.split(" ") : new Array();
  var newNames = new Array();
  for (var nameIndex = 0, nameCount = clsNames.length; nameIndex < nameCount; nameIndex++) {
    var currName = clsNames[nameIndex];
    if (currName) {
      if (q__findValueInArray(currName, newClassesToExclude) == -1)
        newNames.push(currName);
      else
        someClassesExcluded = true;
    }
  }
  var newClsName = newNames.join(" ");
  if (element.className != newClsName)
    element.className = newClsName;
  return someClassesExcluded;
}

function q__calculateStyleProperty(element, propertyName) {
  var result;
  if (element.currentStyle) {
    var capitalizedProperty = q__capitalizeCssPropertyName(propertyName);
    result = element.currentStyle[capitalizedProperty];
  } else {
    var computedStyle = document.defaultView.getComputedStyle(element, "");
    if (computedStyle != null) {
      result = computedStyle.getPropertyValue(propertyName);
    }
  }
  if (!result)
    result = "";
  return result;
}

function q__capitalizeCssPropertyName(propertyName) {
  while (true) {
    var idx = propertyName.indexOf("-");
    if (idx == -1)
      return propertyName;
    var firstPart = propertyName.substring(0, idx);
    var secondPart = propertyName.substring(idx + 1);
    if (secondPart.length > 0) {
      var firstChar = secondPart.substring(0, 1);
      firstChar = firstChar.toUpperCase();
      var otherChars = secondPart.substring(1);
      secondPart = firstChar + otherChars;
    }
    propertyName = firstPart + secondPart;
  }
  return propertyName;
}

function q__repaintAreaForOpera(element, deferredRepainting) {
  if (!element)
    return;
  if (!q__isOpera())
    return;
  if (deferredRepainting) {
    setTimeout(function() {
      q__repaintAreaForOpera(element, false);
    }, 1);
    return;
  }
  // using backgroundColor instead of just background is important here for cases when image is set as background
  // NOTE: setting the calculated border is an erroneous pattern because any further background changes through
  // element's className will be overriden by this in-place style declaration. However it must be uesd for document.body
  // because this element behaves differently when assigned old background - assigning a non-specified old background
  // makes the background white disregarding the appropriate stylesheets (JSFC-2346, JSFC-2275)
  var oldBackgroundColor = element != document.body
          ? element.style.backgroundColor
          : q__calculateStyleProperty(element, "background-color");
  element.style.backgroundColor = "white";
  element.style.backgroundColor = "#fefefe";
  element.style.backgroundColor = oldBackgroundColor;
}

function q__preloadImage(imageUrl) {
  var image = new Image();
  image.src = imageUrl;
}

function q__preloadImages(imageUrls) {
  for (var i = 0, count = imageUrls.length; i < count; i++) {
    var imageUrl = imageUrls[i];
    q__preloadImage(imageUrl);
  }
}

// ----------------- DATE/TIME UTILITIES ---------------------------------------------------

function q__initDateTimeFormatObject(months, shortMonths, days, shortDays, localeStr) {
  if (!this._dateTimeFormatMap) {
    this._dateTimeFormatMap = new Array();
  }
  if (!this._dateTimeFormatMap[localeStr]) {
    this._dateTimeFormatMap[localeStr] = new DateTimeFormat(months, shortMonths, days, shortDays);
  }
  //  this._dateTimeFormat = new DateTimeFormat(months, shortMonths, days, shortDays);
}

function q__getDateTimeFormatObject(locale) {
  return this._dateTimeFormatMap[locale];
  //  return this._dateTimeFormat;
}

// ----------------- ABSOLUTE POSITIONING / METRICS UTILITIES ---------------------------------------------------

function q__getElementLeft(elt, ignoreAbsolutePosition, stopAtContainingBlocks) {
  var left = 0;
  //  left = elt.clientLeft;
  var checkAbsoluteOffsetParent = (q__calculateStyleProperty(elt, "position") != "absolute" || ignoreAbsolutePosition);
  // quirk for FireFox - JSFC-1183
  var checkAbsolutePositionedTable = q__isMozilla() && elt.tagName.toLowerCase() == 'table';
  if (elt != null && (checkAbsoluteOffsetParent || checkAbsolutePositionedTable)) {
    if (elt._popupComponent) {
      left = elt.offsetParent.offsetLeft;
    } else {
      left = elt.offsetLeft;
    }
    if (q__isExplorer() || q__isOpera()) {
      var lowerCaseTagName = elt.tagName.toLowerCase();
      if (lowerCaseTagName == 'table' && q__isOpera()) {
        if (elt.border > 0) {
          left ++;
        }
      } else if (lowerCaseTagName == 'div' || lowerCaseTagName == 'td') {
        if (elt._popupComponent) {
          left += elt.offsetParent.clientLeft;
        } else {
          left += elt.clientLeft;
        }
      }
    }

    var offsetParent = elt.offsetParent;
    if (offsetParent && !(stopAtContainingBlocks && q__isContainingBlock(offsetParent))) {
      var parentLeft = 0;
      if (elt._popupComponent) {
        parentLeft = q__getElementLeft(elt.offsetParent.offsetParent, ignoreAbsolutePosition, stopAtContainingBlocks);
      } else {
        parentLeft = q__getElementLeft(elt.offsetParent, ignoreAbsolutePosition, stopAtContainingBlocks);
      }
      left += parentLeft;
    }
  }
  return left;
}

/**
 * Introduced according to CSS spec http://www.w3.org/TR/REC-CSS2/visudet.html#containing-block-details
 * See JSFC-2045 Popups displayed incorrectly under JBoss Portal
 */
function q__isContainingBlock(elt) {
  q__assert(elt, "elt is null");
  var position = q__calculateStyleProperty(elt, "position");
  if (!position) return false;
  return position != "static";
}

function q__getElementTop(elt, ignoreAbsolutePosition, stopAtContainingBlocks) {
  var top = 0;
  //  top = elt.offsetTop;
  var checkAbsoluteOffsetParent = (q__calculateStyleProperty(elt, "position") != "absolute" || ignoreAbsolutePosition);
  // quirk for FireFox - JSFC-1183
  var checkAbsolutePositionedTable = q__isMozilla() && elt.tagName.toLowerCase() == 'table';
  if (elt != null && (checkAbsoluteOffsetParent || checkAbsolutePositionedTable)) {
    if (elt._popupComponent) {
      top = elt.offsetParent.offsetTop;
    } else {
      top = elt.offsetTop;
    }
    if (q__isExplorer() || q__isOpera()) {
      var lowerCaseTagName = elt.tagName.toLowerCase();
      if (lowerCaseTagName == 'table' && q__isOpera()) {
        if (elt.border > 0) {
          top ++;
        }
      } else if (lowerCaseTagName == 'div' || lowerCaseTagName == 'td') {
        if (elt._popupComponent) {
          top += elt.offsetParent.clientTop;
        } else {
          top += elt.clientTop;
        }
      }
    }
    var offsetParent = elt.offsetParent;
    if (offsetParent && !(stopAtContainingBlocks && q__isContainingBlock(offsetParent))) {
      var parentTop = 0;
      if (elt._popupComponent) {
        parentTop = q__getElementTop(elt.offsetParent.offsetParent, ignoreAbsolutePosition, stopAtContainingBlocks);
      } else {
        parentTop = q__getElementTop(elt.offsetParent, ignoreAbsolutePosition, stopAtContainingBlocks);
      }
      top += parentTop;
    }
  }
  return top;
}

function q__ElementRectangle(element) {
  var x = q__getElementLeft(element);
  var y = q__getElementTop(element);
  return new q__Rectangle(x, y, element.offsetWidth, element.offsetHeight);
}

function q__Rectangle(x, y, width, height) {
  this.x = x;
  this.y = y;
  this.width = width;
  this.height = height;

  this.getMinX = function() {
    return this.x;
  }
  this.getMinY = function() {
    return this.y;
  }
  this.getMaxX = function() {
    var result = this.x + this.width;
    return result;
  }
  this.getMaxY = function() {
    var result = this.y + this.height;
    return result;
  }
  this.addRectangle = function(rect) {
    q__assert(rect, "rect parameter should be passed");
    var x1 = this.getMinX();
    if (rect.getMinX() < x1)
      x1 = rect.getMinX();
    var y1 = this.getMinY();
    if (rect.getMinY() < y1)
      y1 = rect.getMinY();
    var x2 = this.getMaxX();
    if (rect.getMaxX() > x2)
      x2 = rect.getMaxX();
    var y2 = this.getMaxY();
    if (rect.getMaxY() > y2)
      y2 = rect.getMaxY();
    this.x = x1;
    this.y = y1
    this.width = x2 - x1;
    this.height = y2 - y1;
  }

  this.isIntersects = function(rect) {
    var x1 = this.getMinX();
    var x2 = this.getMaxX();
    var rectX1 = rect.getMinX();
    var rectX2 = rect.getMaxX();
    var y1 = this.getMinY();
    var y2 = this.getMaxY();
    var rectY1 = rect.getMinY();
    var rectY2 = rect.getMaxY();

    return (rectX2 > x1 && rectY2 > y1 && rectX1 < x2 && rectY1 < y2);
  }
}

function q__getVisibleRectangle() {
  var pageScrollPos = q__getPageScrollPos();
  var x = pageScrollPos.x;
  var y = pageScrollPos.y;
  var width = document.body.clientWidth;
  var height = document.body.clientHeight;
  return new q__Rectangle(x, y, width, height);
}

function q__scrollRectIntoView(rect) {
  var visibleRect = q__getVisibleRectangle();
  var dx = 0;
  if (rect.getMinX() < visibleRect.getMinX())
    dx = rect.getMinX() - visibleRect.getMinX();
  if (rect.getMaxX() > visibleRect.getMaxX())
    dx = rect.getMaxX() - visibleRect.getMaxX();
  var dy = 0;
  if (rect.getMinY() < visibleRect.getMinY())
    dy = rect.getMinY() - visibleRect.getMinY();
  if (rect.getMaxY() > visibleRect.getMaxY())
    dy = rect.getMaxY() - visibleRect.getMaxY();
  window.scrollBy(dx, dy);
}

function q__getPageScrollPos() {
  var x = 0;
  var y = 0;
  if (typeof( window.pageYOffset ) == 'number') {
    //Netscape compliant
    y = window.pageYOffset;
    x = window.pageXOffset;
  } else if (document.body && ( document.body.scrollLeft || document.body.scrollTop )) {
    //DOM compliant
    y = document.body.scrollTop;
    x = document.body.scrollLeft;
  } else if (document.documentElement && ( document.documentElement.scrollLeft || document.documentElement.scrollTop )) {
    //IE6 standards compliant mode
    y = document.documentElement.scrollTop;
    x = document.documentElement.scrollLeft;
  }
  return {x: x, y: y};
}

function q__setPageScrollPos(scrollPos) {
  window.scrollTo(scrollPos.x, scrollPos.y);
}

function q__getLeftBodyMargin() {
  var leftMarginStr = q__calculateStyleProperty(document.body, "margin-left");
  var leftMargin = 0;
  if (leftMarginStr.length > 2) {
    leftMargin = leftMarginStr.substring(0, leftMarginStr.length - 2) * 1;
  }
  return leftMargin;
}

function q__getTopBodyMargin() {
  var topMarginStr = q__calculateStyleProperty(document.body, "margin-top");
  var topMargin = 0;
  if (topMarginStr.length > 2) {
    topMargin = topMarginStr.substring(0, topMarginStr.length - 2) * 1;
  }
  return topMargin;
}

// ----------------- HIDE <SELECT> CONTROLS UNDER POPUP IN IE ---------------------------------------------------

var q__controlsToHide = q__isExplorer() ? new Array('select-one', 'select-multiple') : null;
var q__controlsHiddenControlsMap = new Object();

function q__walkControlsToHide(popup, runFunction) {
  if (popup._coveredControls) {
    for (var i = 0; i < popup._coveredControls.length; i++) {
      var control = popup._coveredControls[i];
      runFunction.call(this, control);
    }
  }
}

function q__hideControlsUnderPopup(popup) {
  if (q__isExplorer() && q__controlsToHide && q__controlsToHide.length > 0) {
    var runFunction = function(control) {
      var controlData = new Object();
      controlData.id = popup.id;
      controlData.visibility = control.style.visibility;
      q__controlsHiddenControlsMap[control.id] = controlData;
      control.style.visibility = 'hidden';
    }

    var rectangle = new q__Rectangle(popup.offsetLeft, popup.offsetTop, popup.offsetWidth, popup.offsetHeight);
    popup._coveredControls = new Array();
    var frm = q__findParentNode(popup, "FORM");
    var controls = frm.elements;
    var index = 0;
    for (var i = 0; i < controls.length; i++) {
      var control = controls[i];
      if (control.type && q__arrayContainsValue(q__controlsToHide, control.type)) {
        if (! q__isChild(popup, control)) {
          var examRectangle = q__ElementRectangle(control);
          if (rectangle.isIntersects(examRectangle)) {
            popup._coveredControls[index++] = control;
          }
        }
      }
    }


    q__walkControlsToHide(popup, runFunction);
  }
}

function q__unhideControlsUnderPopup(popup) {
  if (q__isExplorer() && q__controlsToHide && q__controlsToHide.length > 0) {
    var runFunction = function(control) {
      var controlData = q__controlsHiddenControlsMap[control.id];
      if (controlData && (controlData.id == popup.id)) {
        control.style.visibility = controlData.visibility;
      }
    }
    q__walkControlsToHide(popup, runFunction);
    popup._coveredControls = null;
  }
}

function q__createIEDragControl(popup) {
  if (popup._outerIEDiv) return;
  var outerDivID = popup.id + "::outerDivIE";
  var outerDiv = document.getElementById(outerDivID);
  if (!outerDiv) {
    outerDiv = document.createElement("div");
    outerDiv.id = outerDivID;
    outerDiv.style.position = "absolute";
    outerDiv.style.width = popup.offsetWidth;
    outerDiv.style.height = popup.offsetHeight;
    if (popup.draggable) {
      if (popup.startX && popup.startX != 'null') {
        outerDiv.style.left = popup.startX + "px";
      } else {
        if (popup.left && popup.left != 'null') {
          outerDiv.style.left = popup.left + "px";
        }
      }
      if (popup.startY && popup.startY != 'null') {
        outerDiv.style.top = popup.startY + "px";
      } else {
        if (popup.top && popup.top != 'null') {
          outerDiv.style.top = popup.top + "px";
        }
      }
    } else {

      if (popup.left && popup.left != 'null') {
        outerDiv.style.left = popup.left + "px";
      } else {
        outerDiv.style.left = popup.offsetLeft + "px";
      }
      if (popup.top && popup.top != 'null') {
        outerDiv.style.top = popup.top + "px";
      } else {
        outerDiv.style.top = popup.offsetTop + "px";
      }
    }

    outerDiv.style.zIndex = 400;
  }

  var frameID = popup.id + "::iframeIE";
  var frame = document.getElementById(frameID);
  if (!frame) {
    frame = document.createElement("iframe");
    frame.id = frameID;
    frame.scrolling = "No";
    frame.frameBorder = "0";
    frame.style.position = "absolute";
    frame.style.width = "100%";
    frame.style.height = "100%";
    frame.style.zIndex = 405;
    frame.style.left = "0px";
    frame.style.top = "0px";
  }

  popup.style.zIndex = 410;

  var popupParent = popup.parentNode;
  popupParent.replaceChild(outerDiv, popup);
  if (popup.draggable) {
    outerDiv.dragX = popup.dragX;
    outerDiv.dragY = popup.dragY;
    outerDiv.startX = popup.startX;
    outerDiv.startY = popup.startY;
  }

  outerDiv.appendChild(frame);
  outerDiv.appendChild(popup);

  popup.q_prevLeft = popup.style.left;
  popup.q_prevTop = popup.style.top;
  popup.style.left = "0px";
  popup.style.top = "0px";

  outerDiv._originalPopupElementId = popup.id;
  popup._outerIEDiv = outerDiv;
  return outerDiv;
}


function q__removeIEDragControl(popup) {
  var outerDiv = popup.parentNode;
  var parent = outerDiv.parentNode;
  parent.replaceChild(popup, outerDiv);
  popup.style.left = popup.q_prevLeft;
  popup.style.top = popup.q_prevTop;

  if (popup.draggable) {
    popup.dragX = outerDiv.dragX;
    popup.dragY = outerDiv.dragY;
    popup.startX = outerDiv.startX;
    popup.startY = outerDiv.startY;
  }

  var top = outerDiv.top;
  var left = outerDiv.left;

  if (popup.draggable) {
    popup.left = left;
    if (!(left == null || left == undefined || isNaN(left))){
    popup.setLeft(left);                                     }
    popup.top = top;
    if (!(top == null || top == undefined || isNaN(top))){
    popup.setTop(top);                                       }
  }

  popup._outerIEDiv = undefined;
}

function q__invokeOnce(func, funcId) {
  if (!q__isInvoked(funcId)) {
    func();
    q__getInvokedFunctions().push(funcId);
  }
}

function q__isInvoked(funcId) {
  var invokedFunctions = q__getInvokedFunctions();
  return q__contains(invokedFunctions, funcId);
}

function q__getInvokedFunctions() {
  var invokedFunctions = document.q__invokedFunctions;
  if (!invokedFunctions) {
    invokedFunctions = new Array();
    document.q__invokedFunctions = invokedFunctions;
  }
  return invokedFunctions;
}

function q__contains(array, object) {
  for (var i = 0; i < array.length; i++) {
    if (object == array[i]) {
      return true;
    }
  }
  return false;
}

function q__isInvisible(element) {
  if (!element.style) {
    return false;
  }
  return element.style.display == "none" || element.style.visibility == "hidden";
}

function q__isVisibleRecursive(element) {
  if (q__isInvisible(element)) {
    return false;
  }
  var parentNode = element.parentNode;
  if (!parentNode) {
    return true;
  }
  return q__isVisibleRecursive(parentNode);
}