/*
 * Copyright (c) 1998-2006 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */

// ================================== PUBLIC API METHODS
function q_runConfirmedFunction(confirmationId, func) {
  if (!confirmationId)
    throw "q_runConfirmedFunction: confirmations's clientId must be passed as a parameter";
  var confirmation = q__getControl(confirmationId);
  if (!confirmation)
    throw "q_runConfirmedFunction: Invalid clientId passed - no such component was found: " + confirmationId;
  return confirmation.runConfirmedFunction(func);
}

function q_runConfirmedFunctionByName(confirmationId, funcName, parameters) {
  if (!confirmationId)
    throw "q_runConfirmedFunctionByName: confirmations's clientId must be passed as a parameter";
  var confirmation = q__getControl(confirmationId);
  if (!confirmation)
    throw "q_runConfirmedFunctionByName: Invalid clientId passed - no such component was found: " + confirmationId;
  return confirmation.runConfirmedFunctionByName(funcName, parameters);
}

function q_setConfirmationTexts(confirmationId, headerText, detailsText, yesButtonText, noButtonText) {
  if (!confirmationId)
    throw "q_setConfirmationTexts: confirmations's clientId must be passed as a parameter";
  var confirmation = q__getControl(confirmationId);
  if (!confirmation)
    throw "q_setConfirmationTexts: Invalid clientId passed - no such component was found: " + confirmationId;
  confirmation.setTexts(headerText, detailsText, yesButtonText, noButtonText);
}

// ================================== END OF PUBLIC API METHODS


function q__initConfirmation(
        confirmationId,
        invokerId,
        eventHandlerName,
        defaultButton,
        bindToInvoker,
        closeOnOuterClick) {
  var confirmation = q__getControl(confirmationId);
  if (q__isExplorer()) {
    confirmation._popupComponent = true;
  }
  confirmation._invokerId = invokerId;
  confirmation._eventHandlerName = eventHandlerName;
  confirmation._defaultButton = defaultButton;
  confirmation._bindToInvoker = bindToInvoker;
  confirmation.closeOnOuterClick = closeOnOuterClick;

  confirmation._content = q__getControl(confirmationId + "::content");
  confirmation._buttonArea = q__getControl(confirmationId + "::buttonArea");
  confirmation._caption = q__getControl(confirmationId + "::caption");
  confirmation._closeButton = q__getControl(confirmationId + "::closeButton");

  confirmation._preAnchor = q__getControl(confirmationId + "::preAnchor");
  confirmation._postAnchor = q__getControl(confirmationId + "::postAnchor");

  confirmation._listenerMode = 0;

  confirmation._icon = q__getControl(confirmationId + "::icon");
  confirmation._headerText = q__getControl(confirmationId + "::headerText");
  confirmation._detailsText = q__getControl(confirmationId + "::detailsText");
  confirmation._yesButton = q__getControl(confirmationId + "::yes_button");
  confirmation._noButton = q__getControl(confirmationId + "::no_button");

  confirmation._yesButton.onclick = function (event) {
    confirmation._confirmationHide();
    if (confirmation._listenerMode == 0) { // listen to event with eventHandlerName of element with invokerId
      var eventHandler = window.q__confirmationEventHandlers[confirmation.id];
      if (eventHandler) {
        var invoker = q__getControl(confirmation._invokerId);
        if (!invoker)
          invoker = confirmation;

        // invoke eventHandler with "this" variable pointing to invoker...
        invoker.q_temp_Event = event;
        invoker.q_invokeYesHandler = eventHandler;
        invoker.q_fnc = q__getEventHandlerFunction("q_invokeYesHandler", null, invoker);
        var result = invoker.q_fnc(event);
        // end

        if (invoker.type == "submit") {
          result = result === false ? false : true;
          if (result) {
            invoker.onclick = null;
            invoker.click();
          }
        }
      }
      return;
    }

    if (confirmation._listenerMode == 1) { // runConfirmedFunction
      confirmation._listenerMode = 0;
      if (confirmation._evaluatedFunction) {
        confirmation._evaluatedFunction();
      }
      return;
    }

    // runConfirmedFunctionByName
    confirmation._listenerMode = 0;
    var evalString = confirmation._evaluatedFunctionName + "("

    if (confirmation._evaluatedFunctionParameters) {
      for (var i = 0; i < confirmation._evaluatedFunctionParameters.length; i++) {
        if (i > 0) {
          evalString += ", ";
        }
        evalString += "confirmation._evaluatedFunctionParameters[" + i + "]";
      }
    }
    evalString += ");"

    eval(evalString);
  }

  confirmation._noButton.onclick = function (event) {
    confirmation._confirmationHide();
    return false;
  }

  if (confirmation._closeButton) {
    confirmation._closeButton.style.position = "absolute";
    confirmation._closeButton.style.left = (confirmation.clientWidth - confirmation._closeButton.clientWidth) + "px";
    confirmation._closeButton.onclick = function () {
      confirmation._confirmationHide();
      return false;
    }
  }

  // Set listener on element
  if (confirmation._invokerId != null && confirmation._eventHandlerName != null) {
    var attachConfirmation = function () {
      var invoker = document.getElementById(confirmation._invokerId);
      if (!invoker)
        throw "Invalid invokerId for confirmation. Couldn't find component with clientId: " + confirmation._invokerId;
      if (invoker.q__confirmationIds && q__arrayContainsValue(invoker.q__confirmationIds, confirmation.id))
        return;
      if (!window.q__confirmationEventHandlers)
        window.q__confirmationEventHandlers = new Array();
      window.q__confirmationEventHandlers[confirmation.id] = invoker[confirmation._eventHandlerName];

      invoker[confirmation._eventHandlerName] = function (event) {
        confirmation._showForEvent(event);
        return false;
      };

      if (!invoker.q__confirmationIds)
        invoker.q__confirmationIds = new Array();
      // we save ids of all registered confirmations to support use-case when confirmation is reloaded with a4j
      invoker.q__confirmationIds.push(confirmation.id);
    }
    var invoker = q__getControl(confirmation._invokerId);
    if (invoker) { // this branch is to support loading confirmation through ajax/a4j
      attachConfirmation();
    } else {
      q__addLoadEvent(function () {
        attachConfirmation();
      });
    }
  }

  confirmation._showForEvent = function (e) {
    var evt = (e != undefined) ? e : (event ? event : null);
    confirmation.invokerEvent = evt;
    confirmation._confirmationShow();
    return false;
  }


  confirmation._confirmationShow = function () {
    confirmation.show();

    // if not left-top set, move it to the center
    q__layoutConfirmation(confirmation);

    // IE fixes for modality
    /*
        if(document.body.leftMargin) {
          confirmation.blockingLayer.style.left = (confirmation.blockingLayer.offsetLeft*1 + document.body.leftMargin*1) + "px";
        }
    */

    confirmation._yesButton.onfocus = function () {
      confirmation._currentFocus = 0;
    }

    confirmation._noButton.onfocus = function () {
      confirmation._currentFocus = 1;
    }

    if (q__isOpera()) {
      confirmation._oldDocumentOnMouseDown = document.onmousedown;
      document.onmousedown = function (e) {
        if (confirmation._currentFocus == 0) {
          confirmation._yesButton.focus();
        } else {
          confirmation._noButton.focus();
        }
      }
    } else {
      confirmation._oldDocumentOnClick = document.onclick;
      document.onclick = function (e) {
        if (confirmation.isVisible()) { // need for IE for cases when closeOnOuterClick=true
          if (confirmation._currentFocus == 0) {
            confirmation._yesButton.focus();
          } else {
            confirmation._noButton.focus();
          }
        }
      }
    }

    // Fix for FF, when caption has a border
    if (confirmation._caption) {
      //      confirmation.caption.style.top = q__getElementTop(confirmation) + "px";
      //      confirmation.caption.style.left = q__getElementLeft(confirmation) + "px";
      confirmation._caption.style.top = "0px";
      confirmation._caption.style.left = "0px";
      if (q__isMozilla()) {
        if (!confirmation._caption.style.width || confirmation._caption.style.width == "") {
          confirmation._caption.style.width = confirmation.clientWidth - (confirmation._caption.clientWidth - confirmation.clientWidth) + "px";
        }
      }
    }


    // set close button position
    if (confirmation._closeButton) {
      confirmation._closeButton.style.position = "absolute";
      confirmation._closeButton.style.left = (confirmation.clientWidth - confirmation._closeButton.clientWidth) + "px";
      confirmation._closeButton.style.top = "0px";
    }

    confirmation._preAnchor.onfocus = function () {
      confirmation._noButton.focus();
    }
    confirmation._postAnchor.onfocus = function () {
      confirmation._yesButton.focus();
    }

    // set focus on button
    if (confirmation._defaultButton == 'ok') {
      confirmation._currentFocus = 0;
      confirmation._yesButton.focus();
    } else {
      confirmation._currentFocus = 1;
      confirmation._noButton.focus();
    }
  }

  confirmation._confirmationHide = function () {
    if (!this.isVisible()) return;

    if (q__isOpera()) {
      document.onmousedown = confirmation._oldDocumentOnMouseDown;
    } else {
      document.onclick = confirmation._oldDocumentOnClick;
    }
    confirmation._preAnchor.onfocus = function () {
    }
    confirmation._postAnchor.onfocus = function () {
    }

    confirmation.hide();
  }

  // set escape behavior
  confirmation._yesButton.onkeydown = function (e) {
    var evt = (e != undefined) ? e : (event ? event : null);
    if (!evt) return;
    var keyCode = evt.keyCode;
    if (keyCode == 27) {
      confirmation._confirmationHide();
    }
  }

  confirmation._noButton.onkeydown = confirmation._yesButton.onkeydown;

  confirmation.setTexts = function (headerText, detailsText, yesButtonText, noButtonText) {
    if (headerText || headerText == '') {
      confirmation._headerText.innerHTML = headerText;
    }
    if (detailsText || detailsText == '') {
      confirmation._detailsText.innerHTML = detailsText;
    }
    if (yesButtonText || yesButtonText == '') {
      confirmation._yesButton.value = yesButtonText;
    }
    if (noButtonText || noButtonText == '') {
      confirmation._noButton.value = noButtonText;
    }
  }

  confirmation.runConfirmedFunctionByName = function (funcName, parameters) {
    confirmation._listenerMode = 2;
    confirmation._evaluatedFunctionName = funcName;
    confirmation._evaluatedFunctionParameters = parameters;
    confirmation._confirmationShow();
    return false;
  }

  confirmation.runConfirmedFunction = function (func) {
    confirmation._listenerMode = 1;
    confirmation._evaluatedFunction = func;
    confirmation._confirmationShow();
    return false;
  }
}

function q__initConfirmationInnerStyles(confirmationId, style, rolloverStyle, iconAreaStyle, rolloverIconAreaStyle, contentStyle, rolloverContentStyle, headerTextStyle, rolloverHeaderTextStyle, detailsTextStyle, rolloverDetailsTextStyle, buttonAreaStyle, rolloverButtonAreaStyle, yesButtonStyle, rolloverYesButtonStyle, noButtonStyle, rolloverNoButtonStyle) {
  var confirmation = q__getControl(confirmationId);

  confirmation.styleName = style;
  confirmation.rolloverStyle = rolloverStyle;
  confirmation.iconAreaStyle = iconAreaStyle;
  confirmation.rolloverIconAreaStyle = rolloverIconAreaStyle;
  confirmation.contentStyle = contentStyle;
  confirmation.rolloverContentStyle = rolloverContentStyle;
  confirmation.headerTextStyle = headerTextStyle;
  confirmation.rolloverHeaderTextStyle = rolloverHeaderTextStyle;
  confirmation.detailsTextStyle = detailsTextStyle;
  confirmation.rolloverDetailsTextStyle = rolloverDetailsTextStyle;
  confirmation.yesButtonStyle = yesButtonStyle;
  confirmation.rolloverYesButtonStyle = rolloverYesButtonStyle;
  confirmation.buttonAreaStyle = buttonAreaStyle;
  confirmation.rolloverButtonAreaStyle = rolloverButtonAreaStyle;
  confirmation.noButtonStyle = noButtonStyle;
  confirmation.rolloverNoButtonStyle = rolloverNoButtonStyle;

  confirmation.className = confirmation.styleName;

  if (confirmation._icon) {
    confirmation._icon.className = confirmation.iconAreaStyle;
  }
  confirmation._content.className = confirmation.contentStyle;
  confirmation._buttonArea.className = confirmation.buttonAreaStyle;
  if (confirmation._headerText) {
    confirmation._headerText.className = confirmation.headerTextStyle;
  }
  if (confirmation._detailsText) {
    confirmation._detailsText.className = confirmation.detailsTextStyle;
  }
  confirmation._yesButton.className = confirmation.yesButtonStyle;
  confirmation._noButton.className = confirmation.noButtonStyle;

  //  if (rolloverStyle != 'null') {
  confirmation.oldOnMouseOver = confirmation.onmouseover;
  confirmation.onmouseover = function (e) {
    if (confirmation.oldOnMouseOver) {
      confirmation.oldOnMouseOver(e);
    }
    if (confirmation._onmouseover) {
      confirmation._onmouseover(e);
    }
    if (confirmation._icon) {
      confirmation._icon.className = confirmation.rolloverIconAreaStyle;
    }
    confirmation.className = confirmation.rolloverStyle;
    confirmation._content.className = confirmation.rolloverContentStyle;
    confirmation._buttonArea.className = confirmation.rolloverButtonAreaStyle;
    if (confirmation._headerText) {
      confirmation._headerText.className = confirmation.rolloverHeaderTextStyle;
    }
    if (confirmation._detailsText) {
      confirmation._detailsText.className = confirmation.rolloverDetailsTextStyle;
    }
  }

  confirmation.oldOnMouseOut = confirmation.onmouseout;
  confirmation.onmouseout = function (e) {
    if (confirmation.oldOnMouseOut) {
      confirmation.oldOnMouseOut(e);
    }
    if (confirmation._onmouseout) {
      confirmation._onmouseout(e);
    }
    if (confirmation._icon) {
      confirmation._icon.className = confirmation.iconAreaStyle;
    }
    confirmation.className = confirmation.styleName;
    confirmation._content.className = confirmation.contentStyle;
    confirmation._buttonArea.className = confirmation.buttonAreaStyle;
    if (confirmation._headerText) {
      confirmation._headerText.className = confirmation.headerTextStyle;
    }
    if (confirmation._detailsText) {
      confirmation._detailsText.className = confirmation.detailsTextStyle;
    }
  }
  //  }

  confirmation._yesButton.onmouseover = function () {
    confirmation._yesButton.className = confirmation.rolloverYesButtonStyle;
  }

  confirmation._yesButton.onmouseout = function () {
    confirmation._yesButton.className = confirmation.yesButtonStyle;
  }

  confirmation._noButton.onmouseover = function () {
    confirmation._noButton.className = confirmation.rolloverNoButtonStyle;
  }

  confirmation._noButton.onmouseout = function () {
    confirmation._noButton.className = confirmation.noButtonStyle;
  }
}

function q__layoutConfirmation(confirmation) {
  if (confirmation._invokerId != undefined && confirmation._bindToInvoker) {
    var invoker = q__getControl(confirmation._invokerId);
    if (invoker != undefined) {
      var x = q__getElementLeft(invoker);
      confirmation.setLeft(x);
      var y = q__getElementTop(invoker) + invoker.offsetHeight;
      confirmation.setTop(y);
    }
  } else {
    q__centerPopup(confirmation);
  }
}