/*
 * Copyright (c) 1998-2006 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */

function q__initHintLabel(id, hintTimeout) {
  var label = q__getControl(id);
  label._hint = q__getControl(id + "::hint");
  label._hintTimeout = hintTimeout * 1;

  label._oldMouseOver = label.onmouseover;
  label.onmouseover = function (e) {
    if (label._oldMouseOver) {
      label._oldMouseOver(e);
    }
    if (label.innerHTML == label._hint.innerHTML) { // idea is: do not show hint if hint text the same as label text and label is not cutted
      if (!label._fullWidth) {
        label._fullWidth = q__hintLabel_getElementWidth("div", label) * 1;
      }
      if (label._fullWidth <= label.offsetWidth && label._fullWidth <= label.parentNode.offsetWidth) return;
    }
    if (!label._hintFullWidth) {
      label._hintFullWidth = q__hintLabel_getElementWidth("div", label._hint) * 1;
    }
    q__hintLabel_prepareHint(label);
    label._hintTimer = setTimeout(function() {
      if (document.__tc_visible_hint) {
        document.__tc_visible_hint.style.visibility = 'hidden';
      }
      document.__tc_visible_hint = label._hint;
      label._hint.style.visibility = 'visible';
      label._hint.style.display = 'block';
      q__repaintAreaForOpera(label._hint, true);
      label._parentVisibilityChecker = setInterval(function() {
        var parent = label._hint.parentNode;
        while (parent) {
          if (parent.style && parent.style.visibility && (parent.style.visibility == 'hidden' || parent.style.display == 'none')) {
            label._hint.style.visibility = 'hidden';
            clearInterval(label._parentVisibilityChecker);
            return;
          }
          parent = parent.parentNode;
        }
      }, 200);
    }, label._hintTimeout);

    //    label._hintTimer = setTimeout("q__getControl('" + label._hint.id + "').style.visibility = 'visible';q__getControl('" + label._hint.id + "').style.display = 'block';", label._hintTimeout);
  }

  label._oldMouseOut = label.onmouseout;
  label.onmouseout = function (e) {
    if (label._oldMouseOut) {
      label._oldMouseOut(e);
    }
    if (label._hintTimer) {
      clearTimeout(label._hintTimer);
      //      label._hint.style.visibility = 'hidden';
    }

    //    if (label._hint.style.visibility == 'hidden') {
    //      label._hint.style.visibility = 'hidden';
    //    }
  }

  label._hint.onmouseout = function (e) {
    label._hint.style.visibility = 'hidden';
    if (label._parentVisibilityChecker) {
      clearInterval(label._parentVisibilityChecker);
    }
  }

  label._hint.onmousemove = function (e) {
    var evt = (e != undefined) ? e : (event ? event : null);
    if (!evt) return;
    var x = evt.clientX;
    var y = evt.clientY;
    var scrollY = 0;
    if (document.body && document.body.scrollTop) {
      scrollY = document.body.scrollTop;
    } else if (window.pageYOffset) {
      scrollY = window.pageYOffset;
    }
    if (x > label._realRight || (y + scrollY) > label._realBottom) {
      this.style.visibility = 'hidden';
    }
  }
}

function q__hintLabel_getElementWidth(tag, elt) {
  var stubElt = document.createElement(tag);
  stubElt.innerHTML = elt.innerHTML;
  stubElt.style.marginLeft = q__calculateStyleProperty(elt, "margin-left");
  stubElt.style.marginRight = q__calculateStyleProperty(elt, "margin-right");
  stubElt.style.paddingLeft = q__calculateStyleProperty(elt, "padding-left");
  stubElt.style.paddingRight = q__calculateStyleProperty(elt, "padding-right");
  stubElt.style.borderLeftWidth = q__calculateStyleProperty(elt, "border-left-width");
  stubElt.style.borderRightWidth = q__calculateStyleProperty(elt, "border-right-width");
  stubElt.style.fontFamily = q__calculateStyleProperty(elt, "font-family");
  stubElt.style.fontSize = q__calculateStyleProperty(elt, "font-size");
  stubElt.style.fontWeight = q__calculateStyleProperty(elt, "font-weight");

  stubElt.style.position = 'absolute';
  stubElt.style.visibility = 'hidden';
  stubElt.style.left = '0px';
  stubElt.style.top = '0px';

  document.body.appendChild(stubElt);

  var calculatedWidth = stubElt.offsetWidth;

  document.body.removeChild(stubElt);

  return calculatedWidth;
}

function q__hintLabel_prepareHint(label) {
  label._realLeft = q__getElementLeft(label, true);
  label._realTop = q__getElementTop(label, true);
  label._left = q__getElementLeft(label);
  label._top = q__getElementTop(label);
  label._realRight = label._realLeft + label.offsetWidth;
  label._realBottom = label._realTop + label.offsetHeight;

  label._hint.style.left = (label._left - 1) + "px";
  label._hint.style.top = (label._top - 1) + "px";
  label._hint.style.width = null;

  if (label.style.zIndex) {
    label._hint.style.zIndex = label.style.zIndex + 1;
  }

  var scrollX = q__getPageScrollPos().x;
  var margins = 10;
  if (q__isExplorer() && !q__isOpera()) {
    margins = document.body.leftMargin * 1 + document.body.rightMargin * 1;
  }
  if ((label._realLeft + label._hintFullWidth) > (document.body.offsetWidth + scrollX)) {
    label._hint.style.whiteSpace = 'normal';
    label._hint.style.width = (document.body.offsetWidth - label._realLeft - margins + scrollX) + "px";
  } else {
    label._hint.style.whiteSpace = 'nowrap';
    //      if (label._hint.offsetHeight < label.offsetHeight) {
    //        label._hint.style.height = label.offsetHeight + "px";
    //      }
    label._hint.style.width = label._hintFullWidth + "px";
  }
}