/*
 * Copyright (c) 1998-2007 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */

function q_MessageRenderer(clientId, forClientId, title, tooltip, showSummary, showDetail, style, css, styles, params) {
  this.clientId = clientId;
  this.forId = forClientId;
  this.tooltip = tooltip;
  this.title = title;
  this.showSummary = showSummary;
  this.showDetail = showDetail;
  this.style = style;
  this.css = css;
  this.styles = styles;
  this.params = params;

}

q_MessageRenderer.prototype.update = function() {
  var spanElement = document.getElementById(this.clientId);
  while (spanElement.firstChild) {
    spanElement.removeChild(spanElement.firstChild);
    spanElement.title = null;
  }
  var forElement = q__getElement(this.forId);
  if (forElement) {
    var message = q_getMessages(forElement)[0];
    if (message) {
      var summary = message.summary;
      var detail = message.detail;

      var severetyStyle = this.getSeverityStyle(message.severity);
      var severetyClass = this.getSeverityClass(message.severity);

      var title = this.title;
      var showSummaryAsTooltip = !title && this.tooltip;
      var showSummary = this.showSummary && summary;
      var showDetail = this.showDetail && detail;
      var summaryRenderedAsTitle = showSummaryAsTooltip && showSummary && showDetail;
      if (summaryRenderedAsTitle) {
        title = summary;
      }
      if (title) {
        spanElement.title = title;
      }
      var text = "";
      if (showSummary && !summaryRenderedAsTitle) {
        text = summary;
        if (showDetail) {
          text = text + " ";
        }
      }
      if (showDetail) {
        text = text + detail;
      }

      var textNode = document.createTextNode(text);

      spanElement.appendChild(textNode);
      if (spanElement.style.display == "none") {
        spanElement.style.display = "block";
      }
      if (severetyStyle && severetyStyle.length > 0)
      {
        spanElement.setAttribute('style', severetyStyle);
      }
      if (severetyClass && severetyClass.length > 0) {
        spanElement.className = severetyClass;
      }
      if (this.params)
      {
        for (var attr in this.params)
        {
          spanElement.setAttribute(attr, this.params[attr]);
        }
      }
    }
    else {
      if (spanElement.style.display == "block") {
        spanElement.style.display = "none";
      }
    }
  }
}
q_MessageRenderer.prototype.getSeverityStyle = function(severity) {

  if (!severity)
    return this.style;
  if (!this.styles)
    return this.style;

  var s = severity + 'Style';

  for (var attr in this.styles)
  {
    if (attr.toLowerCase() == s.toLowerCase())
      return this.styles[attr];
  }
  return this.style;

}
q_MessageRenderer.prototype.getSeverityClass = function(severity) {

  if (!severity)
    return this.css;
  if (!this.styles)
    return this.css;

  var s = severity + 'Class';

  for (var attr in this.styles)
  {
    if (attr.toLowerCase() == s.toLowerCase())
      return this.styles[attr];
  }
  return this.css;

}

