/*
 * Copyright (c) 1998-2006 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */
function q__initFoldingPanel(controlId, collapsed, direction) {
  var fp = document.getElementById(controlId);

  fp._stateHolderId = controlId + "::state";
  fp._contentHolderId = controlId + "::content";
  fp._captionContentId = controlId + "::caption_content";
  fp._switcherId = controlId + "--switcher";

  fp._foldingPanelStateChangeListener = function(state) {
    q__setCollapsedState(controlId, state);
  }
  var switcher = document.getElementById(fp._switcherId);
  if (switcher) {
    switcher._addToggleStateChangeListener(fp._foldingPanelStateChangeListener);
  }

  fp._collapsed = collapsed;
  fp._direction = direction;
}

function q__setCollapsedState(controlId, state) {
  var control = document.getElementById(controlId);
  control._collapsed = !state;
  var stateHolder = document.getElementById(control._stateHolderId);
  stateHolder.value = (!state) ? "true" : "false";
  q__updateFoldignPanel(controlId);
}

function q__getCollapsedState(controlId) {
  var control = document.getElementById(controlId);
  return control._collapsed;
}

function q__updateFoldignPanel(controlId) {
  var control = document.getElementById(controlId);
  var contentHolder = document.getElementById(control._contentHolderId);
  contentHolder.style.display = control._collapsed ? "none" : "block";
  if (control._direction == 'left' || control._direction == 'right') {
    var captionContent = document.getElementById(control._captionContentId);
    captionContent.style.display = control._collapsed ? "none" : "block";
  }
  if (q__isOpera()) {
    var body = document.getElementsByTagName("body")[0];
    body.style.visibility = "hidden";
    body.style.visibility = "visible";
  }
}

function q__foldingPanelAjaxResponseProcessor(fp, portionName, portionHTML, portionScripts) {

  if (portionName == "--switcher") {
    var oldComponent = document.getElementById(fp._switcherId);
    var prnt = oldComponent.parentNode;
    prnt.innerHTML = portionHTML;
  } else if (portionName == "::state") {
    var oldComponent = document.getElementById(fp._stateHolderId);
    var prnt = oldComponent.parentNode;
    var tempDiv = document.createElement("div");
    tempDiv.innerHTML = portionHTML;
    var newControl = tempDiv.childNodes[0];
    var oldId = oldComponent.id;
    prnt.replaceChild(newControl, oldComponent);
    newControl.id = oldId;
  } else if (portionName == "::content") {
    var oldComponent = document.getElementById(fp._contentHolderId);
    var prnt = oldComponent.parentNode;
    var tempDiv = document.createElement("div");
    tempDiv.innerHTML = portionHTML;
    var newControl = tempDiv.childNodes[0];
    var oldId = oldComponent.id;
    prnt.replaceChild(newControl, oldComponent);
    newControl.id = oldId;
  }
  q__executeScripts(portionScripts);
}