/*
 * Copyright (c) 1998-2006 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */

function q__initToggleImage(controlId,
                            toggled,
                            url,
                            rolloverUrl,
                            pressedUrl,
                            toggledUrl,
                            toggledRolloverUrl,
                            toggledPressedUrl) {

  var toggleImage = document.getElementById(controlId);
  toggleImage._stateHolderId = controlId + "::toggle_state";
  toggleImage._collapsed = toggled;
  
  toggleImage._url = url;
  toggleImage._rolloverUrl = rolloverUrl;
  toggleImage._pressedUrl = pressedUrl;
  toggleImage._toggleUrl = toggledUrl;
  toggleImage._toggleRolloverUrl = toggledRolloverUrl;
  toggleImage._togglePressedUrl = toggledPressedUrl;
  toggleImage._stateChange_listeners = null;
  toggleImage.src = (toggleImage._collapsed ? toggleImage._toggleUrl : toggleImage._url);

  q__preloadImage(url);
  q__preloadImage(rolloverUrl);
  q__preloadImage(pressedUrl);
  q__preloadImage(toggledUrl);
  q__preloadImage(toggledRolloverUrl);
  q__preloadImage(toggledPressedUrl);

  q__addEventHandler(toggleImage, 'mouseover', function() {
    toggleImage.src = (toggleImage._collapsed ? toggleImage._toggleRolloverUrl : toggleImage._rolloverUrl);
  });

  q__addEventHandler(toggleImage, 'mouseout', function() {
    toggleImage.src = (toggleImage._collapsed ? toggleImage._toggleUrl : toggleImage._url);
  });

  q__addEventHandler(toggleImage, 'mousedown', function() {
    toggleImage.src = (toggleImage._collapsed ? toggleImage._togglePressedUrl : toggleImage._pressedUrl);
  });

  q__addEventHandler(toggleImage, 'mouseup', function() {
    toggleImage.src = (toggleImage._collapsed ? toggleImage._toggleRolloverUrl : toggleImage._rolloverUrl);
  });

  var oldToggleImageClickHandler = toggleImage.onclick;
  toggleImage.onclick = function() {
    q__setToggleState(controlId, !q__getToggleState(controlId));
    if (oldToggleImageClickHandler)
      oldToggleImageClickHandler();
  }
  toggleImage.ondblclick = toggleImage.onclick;

  toggleImage._addToggleStateChangeListener = function(listenerObjectFunction) {
    var listeners = this._stateChangeListeners;
    if (!listeners) {
      listeners = new Array();
    }
    listeners[listeners.length] = listenerObjectFunction;

    this._stateChangeListeners = listeners;
  }

}

function q__setToggleState(controlId, state) {
  var control = document.getElementById(controlId);
  control._collapsed = state;
  var stateHolder = document.getElementById(control._stateHolderId);
  stateHolder.value = state ? "true" : "false";
  q__updateToggleImage(controlId);
  q__notifyToggleStateChange(controlId);
}

function q__getToggleState(controlId) {
  var control = document.getElementById(controlId);
  return control._collapsed;
}

function q__updateToggleImage(controlId) {
  var control = document.getElementById(controlId);
  control.src = control._collapsed ? control._toggleUrl : control._url;
}

function q__notifyToggleStateChange(controlId) {
  var control = document.getElementById(controlId);
  var listeners = control._stateChangeListeners;
  if (listeners && listeners != null && listeners.length > 0) {
    for (var i = 0; i < listeners.length; i ++) {
      listeners[i](control._collapsed);
    }
  }
}

