/*
 * Copyright (c) 1998-2006 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */

// ================================== PUBLIC API METHODS

function q_getDropDownValue(dropDownId) {
  if (!dropDownId)
    throw "q_getDropDownValue: dropDowns's clientId must be passed as a parameter";
  var dropDown = document.getElementById(dropDownId);
  if (!dropDown)
    throw "q_getDropDownValue: Invalid clientId passed - no such component was found: " + dropDownId;
  return dropDown.getValue();
}

function q_setDropDownValue(dropDownId, value, isListItem) {
  if (!dropDownId)
    throw "q_setDropDownValue: dropDowns's clientId must be passed as a parameter";
  var dropDown = document.getElementById(dropDownId);
  if (!dropDown)
    throw "q_setDropDownValue: Invalid clientId passed - no such component was found: " + dropDownId;
  return dropDown.setValue(value, isListItem);
}

function q_dropDown(dropDownId) {
  if (!dropDownId)
    throw "q_dropDown: dropDowns's clientId must be passed as a parameter";
  var dropDown = document.getElementById(dropDownId);
  if (!dropDown)
    throw "q_dropDown: Invalid clientId passed - no such component was found: " + dropDownId;
  return dropDown.dropDown();
}

function q_closeUp(dropDownId) {
  if (!dropDownId)
    throw "q_closeUp: dropDowns's clientId must be passed as a parameter";
  var dropDown = document.getElementById(dropDownId);
  if (!dropDown)
    throw "q_closeUp: Invalid clientId passed - no such component was found: " + dropDownId;
  return dropDown.closeUp();
}

function q_isDropDownOpened(dropDownId) {
  if (!dropDownId)
    throw "q_isDropDownOpened: dropDowns's clientId must be passed as a parameter";
  var dropDown = document.getElementById(dropDownId);
  if (!dropDown)
    throw "q_isDropDownOpened: Invalid clientId passed - no such component was found: " + dropDownId;
  return dropDown.isOpened();
}

// ================================== END OF PUBLIC API METHODS

// DropDown object definition ---------------- start
function q__initDropDownField(dropDownId,
                              popupTimeout,
                              listAlignment,
                              popupItemClass,
                              rolloverPopupItemClass) {
  var dropDown = q__getControl(dropDownId);

  dropDown._listAlignment = listAlignment;

  var field = q__getControl(dropDown._fieldId);
  var button = q__getControl(dropDown._buttonId);
  var popup = q__getControl(dropDown._popupId);

  dropDown.value = field.value;

  dropDown._popupItemClass = q__dropdown_getClassName(popupItemClass);
  dropDown._rolloverPopupItemClass = dropDown._popupItemClass + " " + q__dropdown_getClassName(rolloverPopupItemClass);

  // todo
  dropDown._popupInitialized = false;
  dropDown._keyNavigationStarted = false;
  dropDown._popupTimeout = popupTimeout;
  dropDown._index = -1;

  dropDown.focus = function() {
    try {
      field.focus();
    }
    catch(e) {
    }
  }

  q__prepareListElements(dropDownId);

  if (dropDown._items) {
    for (var i = 0; i < dropDown._items.length; i++) {
      var listItem = dropDown._items[i];
      listItem.className = dropDown._popupItemClass;
      listItem.onmouseover = function() {
        if (dropDown._index != -1) {
          var item = dropDown._items[dropDown._index];
          item.className = dropDown._popupItemClass;
          q__repaintAreaForOpera(item, true);
        }
        dropDown._index = this._index;
        this.className = dropDown._rolloverPopupItemClass;
        q__repaintAreaForOpera(this, true);
      }
      //      listItem.onmouseout = function(){
      //        this.className = dropDown._popupItemClass;
      //      }
      listItem.onclick = function() {
        q__dropDowmItemClicked(dropDown, this._itemValue);
      }
    }
  }

  //  q__dropDownField_onLoadHandler(dropDown.id);

  // Add close on timeout behavior
  if (dropDown._popupTimeout > 0) {
    dropDown._timeOutClose = q__dropDownCloseOnTimeout;
    var closeOnTimeout = q__getEventHandlerFunction('_timeOutClose', "'" + dropDownId + "'", dropDown);
    q__addEventHandler(dropDown, "mouseout", closeOnTimeout);
    q__addEventHandler(popup, "mouseout", closeOnTimeout);
  }

  // Set handler that closes popup list on click out of popup
  dropDown.onLoadHandler = q__dropDownField_onLoadHandler;
  var bodyOnLoadHandler = q__getEventHandlerFunction('onLoadHandler', "'" + dropDownId + "'", dropDown);
  q__addEventHandler(window, "load", bodyOnLoadHandler);

  // Maintain value property
  field.onchange = function (event) {
    dropDown.setValue(field.value);
    dropDown._currentValue = dropDown.value;
  }

  // Close on focus lost
  //  field.onblur = function () {
  //    dropDown._popupOpened = false;
  //
  //    setTimeout("q__getControl('" + popup.id + "').hide();", 500);
  //  }
  // Keyboard navigation
  field.onkeypress = q__dropDownKeyboardNavigation;

  // IE doesn't react on arrows in onKeyPress
  field.onkeydown = q__dropDownKeyDownHandler;

  dropDown.getValue = function () {
    return dropDown.value;
  }

  dropDown.setValue = function (value, isListItem) {
    if (dropDown.value == value) return;

    var firstLine = value;
    if (value != null) {
      var idx = value.indexOf("\n");
      // retain only the first line because user can't enter new-line anyway
      if (idx == -1)
        firstLine = value;
      else
        firstLine = value.substring(0, idx);
    }
    dropDown.value = firstLine;
    if (dropDown.onchange) {
      dropDown.onchange(null, isListItem);
    } else {
      field.value = dropDown.value;
    }
  }

  dropDown.dropDown = function () {
    if (!dropDown.isOpened()) {
      dropDown._showHidePopup();
      return true;
    } else {
      return false;
    }
  }

  dropDown.closeUp = function () {
    if (dropDown.isOpened()) {
      dropDown._showHidePopup();
      return true;
    } else {
      return false;
    }
  }

  dropDown.isOpened = function () {
    var _popup = q__getControl(dropDown._popupId);
    return (_popup.style.visibility == 'visible');
  }

  dropDown._showHidePopup = function () {
    q__changeDropDownVisibility(dropDown.id);
    dropDown._keyNavigationStarted = false;
    try {
      field.focus();
    }
    catch(e) {
    }
  }

  dropDown._visibilityChangeListener = function() {
    var popup = q__getControl(dropDown._popupId);
    if (popup.style.visibility == 'visible') {
      if (dropDown.ondropdown)
        dropDown.ondropdown();
      q__repaintAreaForOpera(popup, true);
    } else {
      if (dropDown.oncloseup)
        dropDown.oncloseup();
      q__repaintAreaForOpera(document.body, true);
    }
  }
  popup._addVisibilityChangeListener(dropDown._visibilityChangeListener);
  dropDown.q_clientValueFunctionExist = true;
  dropDown.q_clientValueFunction = function() {
    return dropDown.value;
  }

  dropDown.initValue = function (value) {
    field.value = value;
    dropDown.value = value;
  }

}
// DropDown object definition ---------------- end


// Util functions ------------- start

function q__dropDownField_onLoadHandler(controlId) {
  var dropDown = q__getControl(controlId);
  var field = q__getControl(dropDown._fieldId);
  var button = q__getControl(dropDown._buttonId);
  var tdCell = field.parentNode;

  // Workaround for IE (dropdown field expands when field width is 100% and styles are aplied by js on mouseover/mouseout)
  if (q__isExplorer() && (dropDown._fieldClass != dropDown._rolloverFieldClass || dropDown._containerClass != dropDown._rolloverContainerClass)) {
    setTimeout(function() {
      q__dropDownFixSize(controlId)
    }, 100);
  }

  if (button.clientHeight < field.clientHeight) {
    button.style.height = field.clientHeight + "px";
    q__repaintAreaForOpera(dropDown.parentNode, true);
    // JSFC-2224
  }

}

// todo check is it still needed
function q__dropDownFixSize(controlId) {
  var dropDown = q__getControl(controlId);
  var field = q__getControl(dropDown._fieldId);
  if (field.clientWidth > 0) {
    var tdCell = field.parentNode;
    field.style.width = tdCell.offsetWidth + "px";
    q__repaintAreaForOpera(dropDown, true);
  } else {
    setTimeout(function() {
      q__dropDownFixSize(controlId)
    }, 200);
  }
}

function q__dropDownKeyboardNavigation(e) {
  var evt = q__getEvent(e);
  var needCancelBuble = false;
  var keyCode = evt.keyCode;
  var dropDown = q__getControl(this._dropDownId);
  var popup = q__getControl(dropDown._popupId);
  var field = q__getControl(dropDown._fieldId);

  if (dropDown._popupOpened && (keyCode == 13 || keyCode == 32 || keyCode == 27)) { // enter || space || esc
    needCancelBuble = true;
    dropDown._keyNavigationStarted = false;
    dropDown._popupOpened = false;
    popup.hide();
    if (keyCode != 27) {
      dropDown.setValue(dropDown._items[dropDown._index]._itemValue, true);
    }
  } else if (dropDown.client_onkeypress) {
    return dropDown.client_onkeypress(evt);
  }

  if (keyCode == 40 || keyCode == 38) { // up-down
    needCancelBuble = true;
  }

  if (needCancelBuble) {
    evt.cancelBubble = true;
    return false;
  }
}

function q__dropDownKeyDownHandler(e) {
  var evt = q__getEvent(e);
  var keyCode = evt.keyCode;
  var dropDown = q__getControl(this._dropDownId);
  var popup = q__getControl(dropDown._popupId);
  var needCancelBuble = false;
  if (keyCode == 40) { // down
    needCancelBuble = true;
    var needFireDropDown = !dropDown._popupOpened;
    if (dropDown._popupCloseTimer) {
      clearTimeout(dropDown._popupCloseTimer);
    }
    dropDown._keyNavigationStarted = true;

    q__dropDown_initPopup(this._dropDownId);

    // Change selected index
    if (dropDown._index < dropDown._items.length - 1) {
      dropDown._index++;
    }
    dropDown._popupOpened = true;
    popup.show();
    // Rollover list item
    if (dropDown._index > 0) {
      q__cleanRolloverItemStyle(this._dropDownId, dropDown._items[dropDown._index - 1]);
    }
    q__rolloverItemStyle(this._dropDownId, dropDown._items[dropDown._index]);
  } else if (keyCode == 38) { // up
    needCancelBuble = true;
    dropDown._keyNavigationStarted = true;
    if (dropDown._index > 0) {
      dropDown._index--;
      // Rollover list item
      if (dropDown._index < dropDown._items.length - 1) {
        q__cleanRolloverItemStyle(this._dropDownId, dropDown._items[dropDown._index + 1]);
      }
      q__rolloverItemStyle(this._dropDownId, dropDown._items[dropDown._index]);
    }
  } else if (keyCode == 9) { // tab
    dropDown._popupOpened = false;
    popup.hide();
  }
  if (needCancelBuble) {
    evt.cancelBubble = true;
    return false;
  }
}

function q__dropDowmItemClicked(dropDown, value) {
  var popup = q__getControl(dropDown._popupId);
  var field = q__getControl(dropDown._fieldId);

  popup.hide();
  try {
    field.focus();
  }
  catch(e) {
  }
  dropDown._popupOpened = false;
  dropDown.dropDown_mouseout(dropDown.id);
  setTimeout(function() {
    dropDown.setValue(value, true);
  }, 1);
  // for JSFC-1624 to work under IE (focus-tracker doesn't save focus if submit is going from onchange and change is made with mouse)
}

function q__dropDownCloseOnTimeout(controlId) {
  var dropDown = q__getControl(controlId);
  if (dropDown._popupCloseTimer) {
    clearTimeout(dropDown._popupCloseTimer);
  }
  if (!dropDown._keyNavigationStarted) {
    dropDown._popupCloseTimer = setTimeout(function() {
      var popup = q__getControl(dropDown._popupId);
      popup.hide();
      popup._popupOpened = false;
    }, dropDown._popupTimeout);
  }
}

function q__prepareListElements(controlId) {
  var itemList = new Array();
  var dropDown = q__getControl(controlId);
  var index = 0;
  var item = q__getControl(dropDown.id + "--popup::popupItem" + index);
  while (item) {
    item._index = index;
    itemList[index++] = item;
    item = q__getControl(dropDown.id + "--popup::popupItem" + index);
  }
  dropDown._items = itemList;
}

function q__rolloverItemStyle(controlId, itemDiv) {
  var dropDown = q__getControl(controlId);
  var itemClass = dropDown._rolloverPopupItemClass;
  itemDiv.className = itemClass;
  q__repaintAreaForOpera(dropDown, true);
}

function q__cleanRolloverItemStyle(controlId, itemDiv) {
  var dropDown = q__getControl(controlId);
  var itemClass = dropDown._popupItemClass;
  itemDiv.className = itemClass;
  q__repaintAreaForOpera(dropDown, true);
}

function q__setFieldOnChange(controlId, func) {
  var dropDown = q__getControl(controlId);
  var field = q__getControl(dropDown._fieldId);
  dropDown.onchange = function(event, predefinedValueChoosen) {
    if (dropDown._currentValue != dropDown.value) {
      dropDown._currentValue = dropDown.value;
      field.value = dropDown.value;
      func(event, predefinedValueChoosen);
    }
  }
}

function q__setDropDownOnKeyPress(controlId, func) {
  var dropDown = q__getControl(controlId);
  dropDown.client_onkeypress = func;
}

function q__setDropDownOnDropDown(controlId, func) {
  var dropDown = q__getControl(controlId);
  dropDown.ondropdown = func;
}

function q__setDropDownOnCloseUp(controlId, func) {
  var dropDown = q__getControl(controlId);
  dropDown.oncloseup = func;
}

function q__setDropDownItemsValues(controlId, values) {
  var dropDown = q__getControl(controlId);
  if (!dropDown._items)
    return;
  for (var i = 0; i < dropDown._items.length; i++) {
    dropDown._items[i]._itemValue = values[i];
  }

}

function q__changeDropDownVisibility(controlId) {
  var dropDown = q__getControl(controlId);
  var popup = q__getControl(dropDown._popupId);
  q__dropDown_initPopup(controlId);
  dropDown._popupOpened = (popup.style.visibility != 'hidden');

  dropDown._popupOpened ? popup.hide() : popup.show();
  dropDown._popupOpened = !dropDown._popupOpened;
}

// Util functions ------------- end
